/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres.psi;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTrigger;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbCustomUsageSearcher;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbRoutine;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTrigger;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.postgres.psi.PgCreateTriggerStatementImpl;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlCreateFunctionStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateTriggerStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.sql.psi.stubs.SqlNamedElementStub;
import com.intellij.util.ObjectUtils;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PgCreateFunctionStatementImpl
extends SqlCreateFunctionStatementImpl {
    public PgCreateFunctionStatementImpl(@NotNull ASTNode node) {
        if (node == null) {
            PgCreateFunctionStatementImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public PgCreateFunctionStatementImpl(SqlNamedElementStub<?> stub) {
        super(stub);
    }

    @Override
    public boolean processImplicitContextDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        if (!SqlImplUtil.isProcessingOneOf(processor, ObjectKind.TABLE, ObjectKind.COLUMN)) {
            return true;
        }
        if (lastParent.getParent() == this && lastParent instanceof LazyParseablePsiElement && PgCreateFunctionStatementImpl.isTriggerFunction(this) && !this.processTriggerDeclarations(processor, state, lastParent, place)) {
            return false;
        }
        return super.processImplicitContextDeclarations(processor, state, lastParent, place);
    }

    private boolean processTriggerDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        SqlCreateTriggerStatementImpl.FakeTablesHandler handler = this.getFakeHandler();
        if (handler != null && (handler.getProvider() instanceof PgCreateTriggerStatementImpl ? !handler.getProvider().processDeclarations(processor, state, handler.getProvider().getLastChild(), place) : !handler.processSimple(processor, state))) {
            return false;
        }
        SqlScopeProcessor sqlProcessor = (SqlScopeProcessor)((Object)ObjectUtils.tryCast((Object)processor, SqlScopeProcessor.class));
        if (sqlProcessor != null) {
            for (DasObject entity : LazyData.TRIGGER_STRING_IMPLICITS.values()) {
                if (sqlProcessor.executeTarget(entity, place, SqlTypeFactory.defaultType(SqlType.Category.STRING, SqlImplUtil.getSqlDialectSafe((PsiElement)this)), false, state)) continue;
                return false;
            }
            if (!sqlProcessor.executeTarget(LazyData.RE_TG_NARGS, place, SqlTypeFactory.defaultType(SqlType.Category.INTEGER, SqlImplUtil.getSqlDialectSafe((PsiElement)this)), false, state) || !sqlProcessor.executeTarget(LazyData.RE_TG_ARGV, place, SqlTypeFactory.defaultType(SqlType.Category.ARRAY, SqlImplUtil.getSqlDialectSafe((PsiElement)this)), false, state)) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    private SqlCreateTriggerStatementImpl.FakeTablesHandler getFakeHandler() {
        return (SqlCreateTriggerStatementImpl.FakeTablesHandler)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)this.findOrCreateHandler(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Nullable
    private SqlCreateTriggerStatementImpl.FakeTablesHandler findOrCreateHandler() {
        DbTable table;
        PgCreateTriggerStatementImpl sqlTrigger = this.findSqlTrigger();
        if (sqlTrigger != null) {
            return sqlTrigger.getHandler();
        }
        DbTrigger trigger2 = this.findDbTrigger();
        DbTable dbTable = table = trigger2 == null ? null : (DbTable)ObjectUtils.tryCast((Object)trigger2.getTable(), DbTable.class);
        if (table == null) {
            return null;
        }
        return PgCreateTriggerStatementImpl.createHandler((PsiElement)this, (PsiElement)table);
    }

    @Nullable
    private DbTrigger findDbTrigger() {
        SqlReferenceExpression ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)this.getNameElement(), SqlReferenceExpression.class);
        if (ref == null) {
            return null;
        }
        SqlReferenceExpression unboundedRef = SqlPsiElementFactory.createReferenceFromText(ref.getText(), SqlImplUtil.getSqlDialectSafe((PsiElement)ref), ref.getReferenceElementType(), (PsiElement)this);
        if (unboundedRef == null) {
            return null;
        }
        for (ResolveResult result2 : unboundedRef.multiResolve(false)) {
            DbDataSource dataSource;
            DasTrigger trigger2;
            DasObject routine2;
            PsiElement resolved = result2.getElement();
            if (!(resolved instanceof DbRoutine) || (routine2 = DbUtil.getDasObject((Object)resolved)) == null || (trigger2 = (DasTrigger)(dataSource = ((DbRoutine)resolved).getDataSource()).getDelegate().getModel().traverser().filter(DasTrigger.class).filter(o -> DbCustomUsageSearcher.referencesTarget((DasObject)o, routine2, ObjectKind.ROUTINE)).first()) == null) continue;
            return (DbTrigger)DbImplUtil.findElement(dataSource, (DasObject)trigger2);
        }
        return null;
    }

    @Nullable
    private PgCreateTriggerStatementImpl findSqlTrigger() {
        PgCreateTriggerStatementImpl statement = null;
        SqlFile file = (SqlFile)ObjectUtils.tryCast((Object)this.getContainingFile(), SqlFile.class);
        if (file != null) {
            SqlCreateFunctionStatementImpl target = (SqlCreateFunctionStatementImpl)CompletionUtil.getOriginalOrSelf((PsiElement)this);
            statement = (PgCreateTriggerStatementImpl)PsiTreeUtil.getParentOfType((PsiElement)target, PgCreateTriggerStatementImpl.class);
            if (statement != null) {
                return statement;
            }
            for (SqlElement element : file.getDdl()) {
                SqlFunctionCallExpression call;
                SqlReferenceExpression ref;
                PgCreateTriggerStatementImpl trigger2 = (PgCreateTriggerStatementImpl)((Object)ObjectUtils.tryCast((Object)element, PgCreateTriggerStatementImpl.class));
                if (trigger2 == null || (ref = (call = (SqlFunctionCallExpression)ObjectUtils.tryCast((Object)trigger2.getTriggerProcedure(), SqlFunctionCallExpression.class)) == null ? null : call.getNameElement()) == null || !ref.getReference().isReferenceTo((PsiElement)target)) continue;
                statement = trigger2;
                break;
            }
        }
        return statement;
    }

    public static boolean isTriggerFunction(DasRoutine r) {
        DasArgument ret = r == null ? null : r.getReturnArgument();
        return ret != null && StringUtil.containsIgnoreCase((String)ret.getDataType().typeName, (String)"trigger");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/dialects/postgres/psi/PgCreateFunctionStatementImpl", "<init>"));
    }

    private static class LazyData {
        static final Map<String, DasObject> TRIGGER_STRING_IMPLICITS = SqlDialectImplUtil.buildEntities(ObjectKind.COLUMN, "tg_name", "tg_when", "tg_level", "tg_op", "tg_relid", "tg_relname", "tg_table_name", "tg_table_schema", "tg_tag", "tg_event");
        static final ReservedEntity RE_TG_NARGS = new ReservedEntity("tg_nargs", ObjectKind.COLUMN);
        static final ReservedEntity RE_TG_ARGV = new ReservedEntity("tg_argv", ObjectKind.COLUMN);

        private LazyData() {
        }
    }
}

