/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="SqlEditorOptions", storages={@Storage(value="editor.xml")})
public class SqlEditorOptions
implements PersistentStateComponent<State> {
    private boolean myConcatenateStringsOnEnter = true;
    private QualificationType myQualificationType = QualificationTypeImpl.SMART;

    @Nullable
    public State getState() {
        State state = new State();
        state.setConcatenateStringsOnEnter(this.isConcatenateStringsOnEnter());
        state.setQualificationType(this.myQualificationType.toString());
        return state;
    }

    public void loadState(State state) {
        if (state != null) {
            state.load(this);
        }
    }

    public boolean isConcatenateStringsOnEnter() {
        return this.myConcatenateStringsOnEnter;
    }

    public void setConcatenateStringsOnEnter(boolean concatenateStringsOnEnter) {
        this.myConcatenateStringsOnEnter = concatenateStringsOnEnter;
    }

    @NotNull
    public QualificationType getQualificationType() {
        QualificationType qualificationType = this.myQualificationType;
        if (qualificationType == null) {
            SqlEditorOptions.$$$reportNull$$$0(0);
        }
        return qualificationType;
    }

    public void setQualificationType(QualificationType qualificationType) {
        this.myQualificationType = qualificationType;
    }

    @NotNull
    public static SqlEditorOptions getInstance() {
        SqlEditorOptions sqlEditorOptions = (SqlEditorOptions)ServiceManager.getService(SqlEditorOptions.class);
        if (sqlEditorOptions == null) {
            SqlEditorOptions.$$$reportNull$$$0(1);
        }
        return sqlEditorOptions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/sql/editor/SqlEditorOptions";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualificationType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class State {
        private boolean myConcatenateStringsOnEnter = true;
        private String myQualificationType = QualificationTypeImpl.SMART.toString();

        void load(@NotNull SqlEditorOptions options) {
            if (options == null) {
                State.$$$reportNull$$$0(0);
            }
            options.setConcatenateStringsOnEnter(this.isConcatenateStringsOnEnter());
            if (this.getQualificationType() != null) {
                options.setQualificationType(QualificationTypeImpl.of(this.myQualificationType));
            }
        }

        public void setConcatenateStringsOnEnter(boolean concatenateOnEnter) {
            this.myConcatenateStringsOnEnter = concatenateOnEnter;
        }

        public void setQualificationType(@NotNull String qualificationType) {
            if (qualificationType == null) {
                State.$$$reportNull$$$0(1);
            }
            this.myQualificationType = qualificationType;
        }

        public String getQualificationType() {
            return this.myQualificationType;
        }

        public boolean isConcatenateStringsOnEnter() {
            return this.myConcatenateStringsOnEnter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualificationType";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/sql/editor/SqlEditorOptions$State";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "load";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setQualificationType";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static enum QualificationTypeImpl implements QualificationType
    {
        ALWAYS{

            @Override
            public boolean shouldQualify(int conflictedObjectsCount) {
                return true;
            }

            public String toString() {
                return "Always";
            }
        }
        ,
        SMART{

            @Override
            public boolean shouldQualify(int conflictedObjectsCount) {
                return conflictedObjectsCount > 1;
            }

            public String toString() {
                return "On collisions";
            }
        }
        ,
        NOT_QUALIFY{

            @Override
            public boolean shouldQualify(int conflictedObjectsCount) {
                return false;
            }

            public String toString() {
                return "Never";
            }
        };


        @NotNull
        static QualificationType of(@NotNull String string) {
            if (string == null) {
                QualificationTypeImpl.$$$reportNull$$$0(0);
            }
            for (QualificationTypeImpl type : QualificationTypeImpl.values()) {
                if (!StringUtil.equals((CharSequence)string, (CharSequence)type.toString())) continue;
                QualificationTypeImpl qualificationTypeImpl = type;
                if (qualificationTypeImpl == null) {
                    QualificationTypeImpl.$$$reportNull$$$0(1);
                }
                return qualificationTypeImpl;
            }
            QualificationTypeImpl qualificationTypeImpl = SMART;
            if (qualificationTypeImpl == null) {
                QualificationTypeImpl.$$$reportNull$$$0(2);
            }
            return qualificationTypeImpl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "string";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/editor/SqlEditorOptions$QualificationTypeImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/editor/SqlEditorOptions$QualificationTypeImpl";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "of";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "of";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface QualificationType {
        public boolean shouldQualify(int var1);
    }
}

