/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.formatting.alignment.AlignmentStrategy;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.WrappingUtil;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.common.SettingsAwareBlock;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.formatter.SqlFormattingModelBuilder;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.IsExternal;
import com.intellij.sql.psi.SqlAlterInstruction;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlCreateTypeStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlDmlStatement;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlLazyElementType;
import com.intellij.sql.psi.SqlNAryExpression;
import com.intellij.sql.psi.SqlOperatorExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSelectStatement;
import com.intellij.sql.psi.SqlSetClause;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlUnaryExpression;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.sql.psi.impl.SqlParameterListImpl;
import com.intellij.sql.psi.impl.SqlProcedureDefinitionImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlFormattingBlock
extends AbstractBlock
implements SettingsAwareBlock {
    public static final TokenSet CLAUSES_WITH_PERSONAL_SETTINGS = TokenSet.create((IElementType[])new IElementType[]{SqlElementTypes.SQL_FROM_CLAUSE, SqlElementTypes.SQL_WHERE_CLAUSE, SqlElementTypes.SQL_HAVING_CLAUSE, SqlElementTypes.SQL_SELECT_CLAUSE, SqlElementTypes.SQL_ORDER_BY_CLAUSE, SqlElementTypes.SQL_GROUP_BY_CLAUSE, SqlElementTypes.SQL_JOIN_CONDITION_CLAUSE, SqlElementTypes.SQL_COLUMN_GENERATED_CLAUSE, SqlElementTypes.SQL_COLUMN_GENERATED_AS_IDENTITY_CLAUSE, SqlElementTypes.SQL_ELSE_CLAUSE, SqlElementTypes.SQL_THEN_CLAUSE, SqlElementTypes.SQL_AS_QUERY_CLAUSE});
    private static final TokenSet PROCEDURE_LIKE_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{SqlElementTypes.SQL_CREATE_FUNCTION_STATEMENT, SqlElementTypes.SQL_FUNCTION_DEFINITION, SqlElementTypes.SQL_CREATE_PROCEDURE_STATEMENT, SqlElementTypes.SQL_PROCEDURE_DEFINITION});
    @NotNull
    private final TextRange myTextRange;
    @NotNull
    protected final SqlFormattingModelBuilder.Context myContext;
    @Nullable
    private final Indent myIndent;
    @Nullable
    private final AlignmentStrategy myAlignmentStrategy;

    public SqlFormattingBlock(@NotNull ASTNode node, @Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable AlignmentStrategy strategy, @Nullable TextRange textRange, @Nullable Indent indent, @NotNull SqlFormattingModelBuilder.Context context) {
        if (node == null) {
            SqlFormattingBlock.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SqlFormattingBlock.$$$reportNull$$$0(1);
        }
        super(node, wrap, alignment);
        this.myAlignmentStrategy = strategy;
        this.myContext = context;
        this.myTextRange = textRange != null ? textRange : super.getTextRange();
        this.myIndent = indent;
    }

    @NotNull
    public CodeStyleSettings getSettings() {
        CodeStyleSettings codeStyleSettings = this.myContext.codeStyleSettings;
        if (codeStyleSettings == null) {
            SqlFormattingBlock.$$$reportNull$$$0(2);
        }
        return codeStyleSettings;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myTextRange;
        if (textRange == null) {
            SqlFormattingBlock.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    @Nullable
    public Indent getIndent() {
        return this.myIndent;
    }

    @NotNull
    protected List<Block> buildChildren() {
        List<Block> list = this.buildBlocks(this.myNode);
        if (list == null) {
            SqlFormattingBlock.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    private List<Block> buildBlocks(@NotNull ASTNode node) {
        if (node == null) {
            SqlFormattingBlock.$$$reportNull$$$0(5);
        }
        boolean indentsOnly = false;
        Alignment baseAlignment = Alignment.createAlignment();
        AlignmentStrategy strategy = this.createOrGetAlignmentStrategy();
        Wrap chopDownIfLongWrap = null;
        if (node.getFirstChildNode() != null) {
            ArrayList result2 = ContainerUtil.newArrayList();
            ASTNode child = node.getFirstChildNode();
            while (child != null) {
                AbstractBlock formattingBlock;
                boolean isWhitespace;
                boolean bl = isWhitespace = !(child.getPsi() instanceof PsiWhiteSpace) && child.getElementType() != SqlElementTypes.ORAP_DELIMITER_TOKEN;
                if (child.getElementType() == SqlElementTypes.SQL_DUMMY_BLOCK) {
                    result2.addAll(this.buildBlocks(child));
                    child = child.getTreeNext();
                    continue;
                }
                if (isWhitespace && child.getTextLength() > 0) {
                    if (child.getPsi() instanceof IsExternal) {
                        formattingBlock = new ReadOnlyBlock(child);
                    } else {
                        WrapType wrapType;
                        Alignment alignment = indentsOnly ? null : this.calculateAlignment(child, baseAlignment);
                        WrapType wrapType2 = wrapType = indentsOnly ? null : this.calculateWrapType(child);
                        Wrap wrap = wrapType == WrapType.CHOP_DOWN_IF_LONG ? (chopDownIfLongWrap = chopDownIfLongWrap == null ? Wrap.createWrap((WrapType)wrapType, (boolean)true) : chopDownIfLongWrap) : (wrapType == null ? null : Wrap.createWrap((WrapType)wrapType, (boolean)true));
                        TextRange textRange = child.getTextRange();
                        Indent indent = this.getChildIndent(child);
                        formattingBlock = new SqlFormattingBlock(child, wrap, alignment, strategy, textRange, indent, this.myContext);
                    }
                } else {
                    child = child.getTreeNext();
                    continue;
                }
                result2.add(formattingBlock);
                ASTNode newChild = child.getTreeNext();
                child = newChild;
            }
            ArrayList arrayList = result2;
            if (arrayList == null) {
                SqlFormattingBlock.$$$reportNull$$$0(6);
            }
            return arrayList;
        }
        List list = EMPTY;
        if (list == null) {
            SqlFormattingBlock.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Nullable
    private AlignmentStrategy createOrGetAlignmentStrategy() {
        PsiElement psi = this.getNode().getPsi();
        if (psi instanceof SqlSelectClause && this.myContext.customSettings.ALIGN_AS_IN_SELECT_STATEMENT) {
            return AlignmentStrategy.createAlignmentPerTypeStrategy((Collection)ContainerUtil.list((Object[])new IElementType[]{SqlElementTypes.SQL_EXPRESSION, SqlElementTypes.SQL_AS, SqlElementTypes.SQL_IDENTIFIER}), (IElementType)SqlElementTypes.SQL_AS_EXPRESSION, (boolean)true);
        }
        if ((psi instanceof SqlCreateTableStatement || psi instanceof SqlCreateTypeStatement || psi instanceof SqlTypeElement) && this.myContext.customSettings.ALIGN_TYPE_IN_CREATE_STATEMENT) {
            List list = ContainerUtil.list((Object[])new IElementType[]{SqlElementTypes.SQL_IDENTIFIER, SqlElementTypes.SQL_TYPE_ELEMENT, SqlElementTypes.SQL_NOT_NULL_CONSTRAINT_DEFINITION, SqlElementTypes.SQL_DEFAULT_CONSTRAINT_DEFINITION});
            return AlignmentStrategy.createAlignmentPerTypeStrategy((Collection)list, (IElementType)(psi instanceof SqlCreateTypeStatement ? SqlElementTypes.SQL_ATTRIBUTE_DEFINITION : SqlElementTypes.SQL_COLUMN_DEFINITION), (boolean)true);
        }
        if (psi instanceof SqlBlockStatementImpl && this.myContext.customSettings.ALIGN_TYPE_IN_BLOCK_STATEMENT) {
            return AlignmentStrategy.createAlignmentPerTypeStrategy((Collection)ContainerUtil.list((Object[])new IElementType[]{SqlElementTypes.SQL_IDENTIFIER, SqlElementTypes.SQL_TYPE_ELEMENT}), (IElementType)SqlElementTypes.SQL_VARIABLE_DEFINITION, (boolean)true);
        }
        if (psi instanceof SqlProcedureDefinitionImpl && this.myContext.customSettings.ALIGN_TYPE_IN_ARGUMENT_DEFINITION) {
            return AlignmentStrategy.createAlignmentPerTypeStrategy((Collection)ContainerUtil.list((Object[])new IElementType[]{SqlElementTypes.SQL_IDENTIFIER, SqlElementTypes.SQL_IN, SqlElementTypes.SQL_TYPE_ELEMENT}), (IElementType)SqlElementTypes.SQL_VARIABLE_DEFINITION, (boolean)true);
        }
        if (psi instanceof SqlParameterListImpl && this.myContext.customSettings.ALIGN_TYPE_IN_ARGUMENT_DEFINITION) {
            return AlignmentStrategy.createAlignmentPerTypeStrategy((Collection)ContainerUtil.list((Object[])new IElementType[]{SqlElementTypes.SQL_IDENTIFIER, SqlElementTypes.SQL_IN, SqlElementTypes.SQL_TYPE_ELEMENT}), (IElementType)SqlElementTypes.SQL_PARAMETER_DEFINITION, (boolean)true);
        }
        if (psi instanceof SqlSetClause && this.myContext.customSettings.ALIGN_EQ_INSIDE_SET_CLAUSE) {
            return AlignmentStrategy.createAlignmentPerTypeStrategy((Collection)ContainerUtil.list((Object[])new IElementType[]{SqlTokens.SQL_OP_EQ}), (IElementType)SqlElementTypes.SQL_SET_ASSIGNMENT, (boolean)true);
        }
        return null;
    }

    @Nullable
    private Alignment calculateAlignmentFromStrategy(@NotNull ASTNode child, @NotNull IElementType parentType, @NotNull IElementType childType) {
        if (child == null) {
            SqlFormattingBlock.$$$reportNull$$$0(8);
        }
        if (parentType == null) {
            SqlFormattingBlock.$$$reportNull$$$0(9);
        }
        if (childType == null) {
            SqlFormattingBlock.$$$reportNull$$$0(10);
        }
        if (this.myAlignmentStrategy != null) {
            Object childTypeReplacement = childType;
            IElementType parentTypeReplacement = parentType;
            if (childType == SqlElementTypes.SQL_NULLABLE_CONSTRAINT_DEFINITION) {
                childTypeReplacement = SqlElementTypes.SQL_NOT_NULL_CONSTRAINT_DEFINITION;
            } else if (childType == SqlElementTypes.SQL_COLUMN_GENERATED_CLAUSE || childType == SqlElementTypes.SQL_COLUMN_GENERATED_AS_IDENTITY_CLAUSE) {
                childTypeReplacement = SqlElementTypes.SQL_DEFAULT_CONSTRAINT_DEFINITION;
            } else if (parentType == SqlElementTypes.SQL_AS_EXPRESSION && child.equals(this.getNode().getFirstChildNode())) {
                childTypeReplacement = SqlElementTypes.SQL_EXPRESSION;
            } else if (parentType == SqlElementTypes.SQL_SELECT_CLAUSE && child.getPsi() instanceof SqlExpression) {
                childTypeReplacement = SqlElementTypes.SQL_EXPRESSION;
                parentTypeReplacement = SqlElementTypes.SQL_AS_EXPRESSION;
            } else if (childType == SqlCommonKeywords.SQL_OUT) {
                childTypeReplacement = SqlElementTypes.SQL_IN;
            } else if (childType == SqlElementTypes.SQL_OP_ASSIGN) {
                childTypeReplacement = SqlElementTypes.SQL_OP_EQ;
            }
            if (childTypeReplacement == SqlElementTypes.SQL_DEFAULT_CONSTRAINT_DEFINITION && (FormatterUtil.isFollowedBy((ASTNode)child, (IElementType)SqlElementTypes.SQL_NOT_NULL_CONSTRAINT_DEFINITION) || FormatterUtil.isFollowedBy((ASTNode)child, (IElementType)SqlElementTypes.SQL_NULLABLE_CONSTRAINT_DEFINITION))) {
                return null;
            }
            return this.myAlignmentStrategy.getAlignment(parentTypeReplacement, childTypeReplacement);
        }
        return null;
    }

    @Nullable
    private WrapType calculateWrapType(@NotNull ASTNode child) {
        if (child == null) {
            SqlFormattingBlock.$$$reportNull$$$0(11);
        }
        IElementType childType = child.getElementType();
        ASTNode node = SqlFormattingBlock.getEffectiveNode(this.getNode());
        IElementType parentType = node.getElementType();
        ASTNode grandpa = node.getTreeParent();
        IElementType grandpaType = grandpa == null ? null : grandpa.getElementType();
        WrapType none = WrapType.NONE;
        if (parentType == SqlElementTypes.SQL_PARAMETER_LIST && childType == SqlElementTypes.SQL_PARAMETER_DEFINITION) {
            return WrappingUtil.getWrapType((int)this.myContext.customSettings.WRAP_INSIDE_ARGUMENT_DEFINITION);
        }
        if (parentType == SqlElementTypes.SQL_EXPRESSION_LIST && grandpaType == SqlElementTypes.SQL_FUNCTION_CALL && SqlFormattingBlock.notComma(childType)) {
            return WrappingUtil.getWrapType((int)this.myContext.customSettings.WRAP_INSIDE_CALL_EXPRESSION);
        }
        if (parentType == SqlElementTypes.SQL_CREATE_TABLE_STATEMENT) {
            WrapType wrapType = WrappingUtil.getWrapType((int)this.myContext.customSettings.WRAP_INSIDE_CREATE_TABLE);
            if (SqlFormattingBlock.notComma(childType) && child.getPsi() instanceof SqlDefinition || childType == SqlElementTypes.SQL_RIGHT_PAREN && wrapType == WrapType.ALWAYS) {
                return wrapType;
            }
        }
        if (parentType == SqlElementTypes.SQL_BINARY_EXPRESSION) {
            return WrappingUtil.getWrapType((int)this.myContext.customSettings.WRAP_INSIDE_BINARY_EXPRESSION);
        }
        if (parentType == SqlElementTypes.SQL_SELECT_CLAUSE && childType != SqlElementTypes.SQL_SELECT && SqlFormattingBlock.notComma(childType)) {
            return WrappingUtil.getWrapType((int)this.myContext.customSettings.WRAP_INSIDE_SELECT);
        }
        if ((parentType == SqlElementTypes.SQL_JOIN_EXPRESSION || parentType == SqlElementTypes.SQL_FROM_CLAUSE) && SqlFormattingBlock.notKeyword(childType)) {
            return WrappingUtil.getWrapType((int)this.myContext.customSettings.WRAP_INSIDE_JOIN_EXPRESSION);
        }
        if (parentType == SqlElementTypes.SQL_ORDER_BY_CLAUSE && SqlFormattingBlock.notKeyword(childType)) {
            return WrappingUtil.getWrapType((int)this.myContext.customSettings.WRAP_INSIDE_ORDER_BY);
        }
        if (parentType == SqlElementTypes.SQL_GROUP_BY_CLAUSE && SqlFormattingBlock.notKeyword(childType)) {
            return WrappingUtil.getWrapType((int)this.myContext.customSettings.WRAP_INSIDE_GROUP_BY);
        }
        if (parentType == SqlElementTypes.SQL_WHERE_CLAUSE && SqlFormattingBlock.notKeyword(childType)) {
            return WrappingUtil.getWrapType((int)this.myContext.customSettings.WRAP_INSIDE_WHERE);
        }
        if (parentType == SqlElementTypes.SQL_VALUES_EXPRESSION && SqlElementTypes.SQL_PARENTHESIZED_EXPRESSIONS.contains(childType)) {
            return WrappingUtil.getWrapType((int)this.myContext.customSettings.WRAP_PARENTHESIZED_EXPRESSION_INSIDE_VALUES);
        }
        if (parentType == SqlElementTypes.SQL_SET_CLAUSE && childType == SqlElementTypes.SQL_SET_ASSIGNMENT) {
            return WrappingUtil.getWrapType((int)this.myContext.customSettings.WRAP_INSIDE_SET);
        }
        if (childType == SqlElementTypes.SQL_VALUES_EXPRESSION) {
            return WrappingUtil.getWrapType((int)this.myContext.customSettings.WRAP_VALUES_EXPRESSION);
        }
        if (SqlElementTypes.SQL_PARENTHESIZED_EXPRESSIONS.contains(parentType) && grandpaType == SqlElementTypes.SQL_VALUES_EXPRESSION && childType != SqlElementTypes.SQL_LEFT_PAREN && childType != SqlElementTypes.SQL_RIGHT_PAREN && childType != SqlElementTypes.SQL_COMMA) {
            return WrappingUtil.getWrapType((int)this.myContext.customSettings.WRAP_INSIDE_VALUES_EXPRESSION);
        }
        if (childType instanceof SqlReferenceElementType || childType == SqlElementTypes.SQL_PERIOD || child.getElementType() == SqlElementTypes.SQL_IDENTIFIER || child.getTreeParent().getElementType() == SqlElementTypes.SQL_IDENTIFIER) {
            return none;
        }
        return null;
    }

    private static boolean notKeyword(@NotNull IElementType childType) {
        if (childType == null) {
            SqlFormattingBlock.$$$reportNull$$$0(12);
        }
        return !(childType instanceof SqlKeywordTokenType) && SqlFormattingBlock.notComma(childType);
    }

    private static boolean notComma(@NotNull IElementType childType) {
        if (childType == null) {
            SqlFormattingBlock.$$$reportNull$$$0(13);
        }
        return childType != SqlElementTypes.SQL_COMMA;
    }

    @Nullable
    private Alignment calculateAlignment(@NotNull ASTNode child, Alignment baseAlignment) {
        IElementType childType;
        IElementType parentType;
        Alignment alignment;
        if (child == null) {
            SqlFormattingBlock.$$$reportNull$$$0(14);
        }
        if ((alignment = this.calculateAlignmentFromStrategy(child, parentType = this.getNode().getElementType(), childType = child.getElementType())) != null) {
            return alignment;
        }
        if ((SqlElementTypes.SQL_PARENTHESIZED_EXPRESSIONS.contains(parentType) || parentType == SqlElementTypes.SQL_REFERENCE_LIST) && childType != SqlElementTypes.SQL_LEFT_PAREN && childType != SqlElementTypes.SQL_RIGHT_PAREN && SqlFormattingBlock.notComma(childType)) {
            return this.getNode().getPsi().getChildren().length > 1 ? baseAlignment : null;
        }
        if (parentType == SqlElementTypes.SQL_UNION_EXPRESSION || parentType == SqlElementTypes.SQL_CASE_EXPRESSION) {
            return baseAlignment;
        }
        if (parentType == SqlElementTypes.SQL_AS_EXPRESSION && childType != SqlElementTypes.SQL_AS) {
            return baseAlignment;
        }
        if (parentType == SqlElementTypes.SQL_JOIN_EXPRESSION) {
            return null;
        }
        if (parentType == SqlElementTypes.SQL_EXPRESSION_LIST && SqlFormattingBlock.notComma(childType)) {
            return baseAlignment;
        }
        if (parentType == SqlElementTypes.SQL_QUERY_EXPRESSION && this.myContext.customSettings.ALIGN_INSIDE_QUERY_EXPRESSION && SqlFormattingBlock.notComma(childType)) {
            return baseAlignment;
        }
        if (parentType == SqlElementTypes.SQL_BINARY_EXPRESSION && this.myContext.customSettings.ALIGN_INSIDE_BINARY_EXPRESSION) {
            return baseAlignment;
        }
        return null;
    }

    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            SqlFormattingBlock.$$$reportNull$$$0(15);
        }
        return child1 instanceof SqlFormattingBlock && child2 instanceof SqlFormattingBlock ? this.getSpacingInner(child1, child2) : null;
    }

    public boolean isLeaf() {
        return this.myNode.getFirstChildNode() == null;
    }

    public boolean isIncomplete() {
        if (super.isIncomplete()) {
            return true;
        }
        if (this.getNode().getTreeParent() == null) {
            for (ASTNode element = this.getNode().getLastChildNode(); element != null; element = element.getTreePrev()) {
                if (element.getElementType() != SqlElementTypes.SQL_SEMICOLON) continue;
                return true;
            }
            return false;
        }
        if (this.getNode().getFirstChildNode() != null && this.getNode().getFirstChildNode().getElementType() == SqlElementTypes.SQL_BEGIN) {
            return this.getNode().getLastChildNode().getElementType() != SqlElementTypes.SQL_END;
        }
        return false;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        Indent indent;
        boolean beforeComma;
        List subBlocks = this.getSubBlocks();
        Block prevBlock = newChildIndex > 0 && newChildIndex <= subBlocks.size() ? (Block)subBlocks.get(newChildIndex - 1) : null;
        Block nextBlock = newChildIndex < subBlocks.size() ? (Block)subBlocks.get(newChildIndex) : null;
        ASTNode prevNode = prevBlock instanceof SqlFormattingBlock ? ((SqlFormattingBlock)prevBlock).getNode() : null;
        ASTNode nextNode = nextBlock instanceof SqlFormattingBlock ? ((SqlFormattingBlock)nextBlock).getNode() : null;
        ASTNode astNode = this.getNode();
        IElementType nodeType = astNode.getElementType();
        PsiElement nodePsi = astNode.getPsi();
        PsiElement basePsi = prevNode != null ? prevNode.getPsi() : nodePsi;
        PsiElement deepestLast = basePsi == null ? null : PsiTreeUtil.getDeepestLast((PsiElement)basePsi);
        SqlBinaryExpression binaryExpression = (SqlBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)basePsi, SqlBinaryExpression.class, (boolean)false);
        ASTNode opSignNode = binaryExpression != null ? binaryExpression.getOpSignElement().getNode() : null;
        boolean afterComma = prevNode != null && prevNode.getElementType() == SqlElementTypes.SQL_COMMA;
        boolean bl = beforeComma = nextNode != null && nextNode.getElementType() == SqlElementTypes.SQL_COMMA;
        if (prevNode != null && TreeUtil.getLastChild((ASTNode)prevNode) instanceof PsiErrorElement) {
            indent = Indent.getContinuationWithoutFirstIndent();
        } else if (nodeType == SqlElementTypes.SQL_SELECT_CLAUSE && (afterComma || beforeComma)) {
            indent = Indent.getNormalIndent();
        } else if (nodeType == SqlElementTypes.SQL_VALUES_EXPRESSION) {
            indent = Indent.getNormalIndent();
        } else if (nodeType == SqlElementTypes.SQL_SET_CLAUSE || basePsi instanceof SqlSetClause) {
            indent = Indent.getNormalIndent();
        } else if (opSignNode != null && (opSignNode == prevNode || opSignNode == nextNode) || !(basePsi instanceof SqlDefinition) && (nodePsi == basePsi || !(nodePsi instanceof SqlDefinition)) && afterComma || beforeComma) {
            indent = Indent.getNormalIndent();
        } else if ((nodePsi instanceof SqlFile || nodePsi instanceof SqlQueryExpression || nodeType == SqlElementTypes.SQL_DUMMY_BLOCK || nodeType == SqlElementTypes.SQL_BATCH_BLOCK) && (basePsi instanceof SqlSelectStatement || basePsi instanceof SqlSelectClause) && PsiTreeUtil.getParentOfType((PsiElement)deepestLast, SqlSelectClause.class) != null) {
            IElementType deepestElementType = deepestLast == null ? null : deepestLast.getNode().getElementType();
            indent = deepestElementType == SqlElementTypes.SQL_SELECT ? Indent.getNormalIndent() : Indent.getNoneIndent();
        } else {
            indent = nodeType == SqlElementTypes.SQL_WITH_CLAUSE ? Indent.getNoneIndent() : (PsiTreeUtil.getParentOfType((PsiElement)basePsi, SqlQueryExpression.class, (boolean)false) != null ? Indent.getNormalIndent() : (PsiTreeUtil.getParentOfType((PsiElement)basePsi, SqlBlockStatementImpl.class, (boolean)false) != null && PsiTreeUtil.getParentOfType((PsiElement)nodePsi, SqlBlockStatementImpl.class, (boolean)false) != null ? Indent.getNormalIndent() : (basePsi instanceof SqlDefinition || nodePsi != basePsi && nodePsi instanceof SqlDefinition ? Indent.getNormalIndent() : (basePsi instanceof SqlExpression || nodePsi != basePsi && nodePsi instanceof SqlExpression ? Indent.getContinuationWithoutFirstIndent() : Indent.getNoneIndent()))));
        }
        ChildAttributes childAttributes = new ChildAttributes(indent, null);
        if (childAttributes == null) {
            SqlFormattingBlock.$$$reportNull$$$0(16);
        }
        return childAttributes;
    }

    @Nullable
    private Spacing getSpacingInner(@NotNull Block child1, @NotNull Block child2) {
        if (child1 == null) {
            SqlFormattingBlock.$$$reportNull$$$0(17);
        }
        if (child2 == null) {
            SqlFormattingBlock.$$$reportNull$$$0(18);
        }
        ASTNode node1 = ((SqlFormattingBlock)child1).getNode();
        ASTNode node2 = ((SqlFormattingBlock)child2).getNode();
        IElementType type1 = node1.getElementType();
        IElementType type2 = node2.getElementType();
        PsiElement psi1 = node1.getPsi();
        PsiElement psi2 = node2.getPsi();
        if (type1 instanceof SqlKeywordTokenType && type2 == SqlElementTypes.SQL_LEFT_PAREN && !(psi1.getParent() instanceof SqlTypeElement) && node1.getTreeParent() != SqlElementTypes.SQL_SPECIAL_LITERAL) {
            return this.createSpaces(1);
        }
        if (psi1 instanceof SqlStatement && type2 == SqlElementTypes.SQL_SEMICOLON) {
            if (this.myContext.customSettings.NEW_LINE_AROUND_SEMICOLON) {
                return this.createLineBreak();
            }
            return SqlFormattingBlock.createHardSpace(0);
        }
        ASTNode parent = node2.getTreeParent();
        IElementType parentType = parent.getElementType();
        int newLineAfterSelect = this.myContext.customSettings.NEW_LINE_AFTER_SELECT_2;
        if (parentType == SqlElementTypes.SQL_SELECT_CLAUSE && (psi2 instanceof SqlExpression || psi2 instanceof PsiComment)) {
            boolean nullOrBlockPrevComment;
            SqlExpression prev = (SqlExpression)PsiTreeUtil.getPrevSiblingOfType((PsiElement)psi2, SqlExpression.class);
            PsiComment prevComment = (PsiComment)PsiTreeUtil.getPrevSiblingOfType((PsiElement)psi2, PsiComment.class);
            SqlExpression next = (SqlExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)psi2, SqlExpression.class);
            boolean alone = prev == null && next == null;
            boolean bl = nullOrBlockPrevComment = prevComment == null || prevComment.getTokenType() == SqlElementTypes.SQL_BLOCK_COMMENT;
            if (nullOrBlockPrevComment && (alone && newLineAfterSelect == 1 || newLineAfterSelect == 2)) {
                return SqlFormattingBlock.createHardSpace(1);
            }
            if ((newLineAfterSelect == 0 || !alone && newLineAfterSelect == 1) && prev == null && parent.findChildByType((IElementType)SqlElementTypes.SQL_PERFORM) == null) {
                return this.createLineBreak();
            }
        }
        if (psi2 instanceof SqlAlterInstruction) {
            return this.createLineBreak();
        }
        Spacing spacing = this.myContext.spacingBuilder.getSpacing((Block)this, child1, child2);
        if (spacing != null) {
            return spacing;
        }
        if (type2 == SqlElementTypes.SQL_PARAMETER_LIST && PROCEDURE_LIKE_TOKEN_SET.contains(parentType)) {
            ASTNode first = node2.getFirstChildNode();
            IElementType firstType = first == null ? null : first.getElementType();
            return firstType == SqlElementTypes.SQL_LEFT_PAREN ? this.createSpaces(0) : this.createSpaces(1);
        }
        if (SqlTokens.COMMENT_TOKENS.contains(type1)) {
            return null;
        }
        if (type1 == SqlElementTypes.ORAP_SLASH_DELIMITER_TOKEN) {
            return null;
        }
        if (type1 == SqlElementTypes.SQL_GENERIC_ELEMENT && psi1.getParent() instanceof SqlNAryExpression || type2 == SqlElementTypes.SQL_GENERIC_ELEMENT && psi2.getParent() instanceof SqlNAryExpression) {
            return this.createSpaces(1);
        }
        if (!(!(type1 instanceof SqlKeywordTokenType) && !(type2 instanceof SqlKeywordTokenType) || psi1.getParent() instanceof SqlTypeElement && psi2 instanceof SqlTypeElement || psi1.getParent().getNode().getElementType() == SqlElementTypes.SQL_SPECIAL_LITERAL)) {
            return this.createSpaces(1);
        }
        if (psi2 instanceof SqlStatement) {
            return this.createSpaces(1);
        }
        if (SqlFormattingBlock.isOperator(node1) && SqlFormattingBlock.inExpressionOrStatementOrDefinition(psi1)) {
            if (psi1.getParent() instanceof SqlUnaryExpression) {
                return this.createSpaces(0);
            }
            return this.createSpaces(this.myContext.customSettings.SPACES_AROUND_OPERATORS ? 1 : 0);
        }
        if (SqlFormattingBlock.isOperator(node2) && SqlFormattingBlock.inExpressionOrStatementOrDefinition(psi2)) {
            return this.createSpaces(this.myContext.customSettings.SPACES_AROUND_OPERATORS ? 1 : 0);
        }
        if (this.myContext.customSettings.NEW_LINE_BEFORE_QUERY_INSIDE_DML && type2 == SqlElementTypes.SQL_QUERY_EXPRESSION && (psi2.getParent() instanceof SqlDmlInstruction || psi2.getParent() instanceof SqlDmlStatement)) {
            return this.createLineBreak();
        }
        if (SqlFormattingBlock.isIdentifierOrExpression(psi1) && SqlFormattingBlock.isIdentifierOrExpression(psi2)) {
            return this.createSpaces(1);
        }
        if (psi2 instanceof SqlClause && !CLAUSES_WITH_PERSONAL_SETTINGS.contains(type2)) {
            return this.myContext.customSettings.NEW_LINE_BEFORE_OTHER_CLAUSES ? this.createLineBreak() : this.createSpaces(1);
        }
        if (psi1 instanceof SqlClause) {
            return this.createSpaces(1);
        }
        return null;
    }

    private static Spacing createHardSpace(int spaces) {
        return Spacing.createSpacing((int)spaces, (int)0, (int)0, (boolean)false, (int)0);
    }

    private static boolean inExpressionOrStatementOrDefinition(@NotNull PsiElement psiElement) {
        PsiElement parent;
        if (psiElement == null) {
            SqlFormattingBlock.$$$reportNull$$$0(19);
        }
        return (parent = psiElement.getParent()) instanceof SqlExpression || parent instanceof SqlStatement || parent instanceof SqlDefinition || parent instanceof SqlClause && parent.getNode().getElementType() == SqlElementTypes.SQL_GENERIC_SETTINGS_CLAUSE;
    }

    private static boolean isIdentifierOrExpression(@Nullable PsiElement psiElement) {
        return psiElement instanceof SqlExpression || psiElement instanceof SqlIdentifier;
    }

    private Spacing createLineBreak() {
        return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.myContext.codeStyleSettings.KEEP_LINE_BREAKS, (int)this.myContext.codeStyleSettings.KEEP_BLANK_LINES_IN_CODE);
    }

    private static boolean isOperator(@NotNull ASTNode node) {
        if (node == null) {
            SqlFormattingBlock.$$$reportNull$$$0(20);
        }
        PsiElement psi = node.getPsi();
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe(psi);
        PsiElement parent = psi.getParent();
        PsiElement op = dialect.getFamilyId().isPostgres() && parent instanceof SqlOperatorExpression ? ((SqlOperatorExpression)parent).getOpSignElement() : null;
        return dialect.isOperatorSupported(node.getElementType()) || op == psi;
    }

    private Spacing createSpaces(int spaces) {
        return Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)this.myContext.codeStyleSettings.KEEP_LINE_BREAKS, (int)this.myContext.codeStyleSettings.KEEP_BLANK_LINES_IN_CODE);
    }

    @NotNull
    private static ASTNode getEffectiveNode(@NotNull ASTNode node) {
        if (node == null) {
            SqlFormattingBlock.$$$reportNull$$$0(21);
        }
        while (node.getElementType() == SqlElementTypes.SQL_DUMMY_BLOCK) {
            node = node.getTreeParent();
        }
        ASTNode aSTNode = node;
        if (aSTNode == null) {
            SqlFormattingBlock.$$$reportNull$$$0(22);
        }
        return aSTNode;
    }

    private Indent getChildIndent(@NotNull ASTNode node) {
        IElementType grandpaType;
        if (node == null) {
            SqlFormattingBlock.$$$reportNull$$$0(23);
        }
        IElementType elementType = node.getElementType();
        ASTNode parent = SqlFormattingBlock.getEffectiveNode(node.getTreeParent());
        IElementType parentType = parent != null ? parent.getElementType() : null;
        PsiElement elementPsi = node.getPsi();
        PsiElement parentPsi = parent != null ? parent.getPsi() : null;
        ASTNode grandpa = parent == null ? null : parent.getTreeParent();
        IElementType iElementType = grandpaType = grandpa == null ? null : grandpa.getElementType();
        if (parent == null || grandpa == null) {
            return Indent.getNoneIndent();
        }
        SqlCodeStyleSettings sql = this.myContext.customSettings;
        if (this.myContext.commonSettings.KEEP_FIRST_COLUMN_COMMENT && SqlTokens.COMMENT_TOKENS.contains(elementType)) {
            return Indent.getAbsoluteNoneIndent();
        }
        if (SqlElementTypes.SQL_PARENTHESIZED_EXPRESSIONS.contains(parentType) || parentType == SqlElementTypes.SQL_REFERENCE_LIST || parentType == SqlElementTypes.SQL_PARAMETER_LIST || parentType == SqlElementTypes.SQL_CLAUSE && (elementType == SqlElementTypes.SQL_LEFT_PAREN || elementType == SqlElementTypes.SQL_RIGHT_PAREN)) {
            if (elementType == SqlElementTypes.SQL_LEFT_PAREN) {
                return Indent.getNoneIndent();
            }
            if (elementType == SqlElementTypes.SQL_RIGHT_PAREN) {
                boolean inJoin = grandpaType == SqlElementTypes.SQL_JOIN_EXPRESSION || grandpaType == SqlElementTypes.SQL_JOIN_CONDITION_CLAUSE;
                return inJoin ? Indent.getNormalIndent() : Indent.getNoneIndent();
            }
            return Indent.getNormalIndent();
        }
        if (parentType == SqlElementTypes.SQL_QUERY_EXPRESSION) {
            return sql.INDENT_SELECT_INTO_CLAUSE && elementType == SqlElementTypes.SQL_SELECT_INTO_CLAUSE ? Indent.getNormalIndent() : Indent.getNoneIndent();
        }
        if (sql.INDENT_SELECT_INTO_CLAUSE && parentType == SqlElementTypes.SQL_SELECT_STATEMENT && elementType == SqlElementTypes.SQL_SELECT_INTO_CLAUSE) {
            return Indent.getNormalIndent();
        }
        if (parentType == SqlElementTypes.SQL_NAMED_QUERY_DEFINITION && elementType == SqlElementTypes.SQL_QUERY_EXPRESSION) {
            return Indent.getContinuationIndent();
        }
        if (parentPsi instanceof SqlDefinition && (elementPsi instanceof SqlDefinition || elementPsi instanceof PsiComment)) {
            if (elementPsi instanceof PsiComment) {
                for (PsiElement e = elementPsi; e == null || e instanceof PsiWhiteSpace || e instanceof PsiComment; e = e.getPrevSibling()) {
                    if (e != null) continue;
                    return Indent.getNoneIndent();
                }
            }
            return Indent.getNormalIndent();
        }
        if (elementType == SqlElementTypes.SQL_CUSTOM_LQUOTE || elementType == SqlElementTypes.SQL_CUSTOM_RQUOTE || elementType instanceof SqlLazyElementType) {
            return Indent.getNoneIndent();
        }
        if (parentType == SqlElementTypes.SQL_BLOCK_STATEMENT) {
            if (elementType == SqlElementTypes.SQL_BEGIN || elementType == SqlElementTypes.SQL_END || elementType instanceof SqlKeywordTokenType && elementPsi.equals(parentPsi.getFirstChild())) {
                return Indent.getNoneIndent();
            }
            return Indent.getNormalIndent();
        }
        if ((parentType == SqlElementTypes.SQL_LOOP_STATEMENT || parentType == SqlElementTypes.SQL_FOR_LOOP_STATEMENT) && (elementPsi instanceof SqlStatement || !this.myContext.commonSettings.KEEP_FIRST_COLUMN_COMMENT && SqlTokens.COMMENT_TOKENS.contains(elementType))) {
            return Indent.getNormalIndent();
        }
        if (parentType == SqlElementTypes.SQL_SELECT_CLAUSE) {
            if (elementType == SqlElementTypes.SQL_SELECT || elementType == SqlElementTypes.SQL_PERFORM) {
                return Indent.getNoneIndent();
            }
            return Indent.getNormalIndent();
        }
        if (parentType == SqlElementTypes.SQL_FROM_CLAUSE) {
            if (elementType == SqlElementTypes.SQL_FROM || elementType == SqlElementTypes.SQL_JOIN_EXPRESSION) {
                return Indent.getNoneIndent();
            }
            return Indent.getNormalIndent();
        }
        if (parentType == SqlElementTypes.SQL_JOIN_EXPRESSION) {
            if (elementType == SqlElementTypes.SQL_JOIN_EXPRESSION) {
                return Indent.getNoneIndent();
            }
            return sql.INDENT_JOIN ? Indent.getNormalIndent() : Indent.getNoneIndent();
        }
        if (parentType == SqlElementTypes.SQL_JOIN_CONDITION_CLAUSE) {
            return sql.INDENT_JOIN_CONDITION ? Indent.getNormalIndent((boolean)true) : Indent.getNoneIndent();
        }
        if (parentType == SqlElementTypes.SQL_FUNCTION_CALL && elementType == SqlElementTypes.SQL_EXPRESSION_LIST) {
            return Indent.getContinuationIndent();
        }
        if (parentType == SqlElementTypes.SQL_AS_EXPRESSION && (elementType == SqlElementTypes.SQL_AS || elementType == SqlElementTypes.SQL_IDENTIFIER)) {
            return Indent.getNormalIndent();
        }
        if (parentType == SqlElementTypes.SQL_BINARY_EXPRESSION) {
            return Indent.getContinuationWithoutFirstIndent();
        }
        if (parentType == SqlElementTypes.SQL_VALUES_EXPRESSION) {
            return elementType == SqlElementTypes.SQL_VALUES ? Indent.getNoneIndent() : Indent.getNormalIndent();
        }
        if (parentType == SqlElementTypes.SQL_TYPE_ELEMENT && elementType == SqlElementTypes.SQL_COLUMN_DEFINITION) {
            return Indent.getNormalIndent();
        }
        if (parentPsi instanceof SqlDefinition && parentType != SqlElementTypes.SQL_AS_EXPRESSION && parentType != SqlElementTypes.SQL_COLUMN_DEFINITION && parentType != SqlElementTypes.SQL_ATTRIBUTE_DEFINITION && parentType != SqlElementTypes.SQL_VARIABLE_DEFINITION && parentType != SqlElementTypes.SQL_VARIABLE_DEFINITION && parentType != SqlElementTypes.SQL_PARAMETER_DEFINITION && parentType != SqlElementTypes.SQL_LABEL_DEFINITION && !(elementType instanceof SqlKeywordTokenType) && elementType != SqlElementTypes.SQL_RIGHT_PAREN && elementType != SqlElementTypes.SQL_LEFT_PAREN) {
            return Indent.getNormalIndent();
        }
        if (elementPsi instanceof SqlTypeElement) {
            return Indent.getNormalIndent();
        }
        if (parentType == SqlElementTypes.SQL_SET_ASSIGNMENT) {
            return Indent.getNoneIndent();
        }
        if (parentPsi instanceof SqlClause && !(elementType instanceof SqlKeywordTokenType)) {
            return Indent.getNormalIndent();
        }
        if (parentPsi instanceof SqlDmlInstruction) {
            if (elementPsi instanceof SqlValuesExpression) {
                return Indent.getNoneIndent();
            }
            if (elementPsi instanceof SqlExpression) {
                return Indent.getNormalIndent();
            }
        } else if (parentPsi instanceof SqlAlterInstruction) {
            return Indent.getNormalIndent();
        }
        return Indent.getNoneIndent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 16: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 16: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/formatter/SqlFormattingBlock";
                break;
            }
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentType";
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childType";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child1";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/formatter/SqlFormattingBlock";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildChildren";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildBlocks";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildAttributes";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 16: 
            case 22: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildBlocks";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "calculateAlignmentFromStrategy";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "calculateWrapType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "notKeyword";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "notComma";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "calculateAlignment";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getSpacingInner";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "inExpressionOrStatementOrDefinition";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isOperator";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveNode";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getChildIndent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 16: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ReadOnlyBlock
    extends AbstractBlock {
        public ReadOnlyBlock(@NotNull ASTNode node) {
            if (node == null) {
                ReadOnlyBlock.$$$reportNull$$$0(0);
            }
            super(node, null, null);
        }

        @Nullable
        public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
            if (child2 == null) {
                ReadOnlyBlock.$$$reportNull$$$0(1);
            }
            return null;
        }

        public Indent getIndent() {
            return Indent.getNoneIndent();
        }

        public boolean isLeaf() {
            return true;
        }

        @NotNull
        protected List<Block> buildChildren() {
            List<Block> list = Collections.emptyList();
            if (list == null) {
                ReadOnlyBlock.$$$reportNull$$$0(2);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child2";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/formatter/SqlFormattingBlock$ReadOnlyBlock";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/formatter/SqlFormattingBlock$ReadOnlyBlock";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getSpacing";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

