/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.QNameUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlOrderByClause;
import com.intellij.sql.psi.SqlQueryClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlUsingClause;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPartitionByClauseImpl;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlAmbiguousColumnInspection
extends SqlInspectionBase {
    @NotNull
    public String getDisplayName() {
        String string = SqlMessages.message("inspection.name.ambiguous.column", new Object[0]);
        if (string == null) {
            SqlAmbiguousColumnInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, final boolean onTheFly) {
        if (dialect == null) {
            SqlAmbiguousColumnInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            SqlAmbiguousColumnInspection.$$$reportNull$$$0(2);
        }
        if (result2 == null) {
            SqlAmbiguousColumnInspection.$$$reportNull$$$0(3);
        }
        SqlInspectionBase.SqlAnnotationVisitor sqlAnnotationVisitor = new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2){

            @Override
            protected boolean shouldNotCheckElement(@NotNull SqlElement o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (o.getParent() instanceof SqlPartitionByClauseImpl) {
                    return true;
                }
                return super.shouldNotCheckElement(o);
            }

            public void visitSqlReferenceExpression(@NotNull SqlReferenceExpression o) {
                if (o == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (this.shouldNotCheckElement((SqlElement)o)) {
                    return;
                }
                ObjectKind type = o.getReferenceElementType().getTargetKind();
                if ((type == SqlDbElementType.ANY || type == ObjectKind.COLUMN) && o.getQualifierExpression() == null) {
                    SqlJoinExpression joinExpression;
                    SqlFromClause fromClause;
                    SqlClause clause = (SqlClause)PsiTreeUtil.getParentOfType((PsiElement)o, (Class[])new Class[]{SqlQueryClause.class, SqlUsingClause.class});
                    if (clause instanceof SqlUsingClause) {
                        return;
                    }
                    SqlQueryExpression queryExpression = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)o, SqlQueryExpression.class, (boolean)true);
                    SqlTableExpression tableExpression = queryExpression == null ? null : queryExpression.getTableExpression();
                    SqlType queryExpressionType = queryExpression != null ? queryExpression.getSqlType() : null;
                    SqlFromClause sqlFromClause = fromClause = tableExpression == null ? null : tableExpression.getFromClause();
                    if (fromClause == null) {
                        return;
                    }
                    DatabaseFamilyId familyId = this.myDialect.getDatabaseDialect().getFamilyId();
                    SqlTableType tableType = clause instanceof SqlFromClause ? ((joinExpression = (SqlJoinExpression)PsiTreeUtil.getParentOfType((PsiElement)o, SqlJoinExpression.class, (boolean)true)) == null ? tableExpression.getSqlType() : joinExpression.getSqlType()) : (clause instanceof SqlOrderByClause || clause instanceof SqlGroupByClause && familyId.isMysql() ? (queryExpressionType instanceof SqlTableType ? (SqlTableType)queryExpressionType : SqlTableTypeBase.EMPTY_TABLE) : tableExpression.getSqlType());
                    String columnName = o.getName();
                    int matchedAliases = 0;
                    int matchedColumns = 0;
                    int count2 = tableType.getColumnCount();
                    for (int i2 = 0; i2 < count2; ++i2) {
                        if (!Comparing.strEqual((String)columnName, (String)tableType.getColumnName(i2), (boolean)false)) continue;
                        if (tableType.getColumnElement(i2) instanceof SqlAsExpression) {
                            ++matchedAliases;
                            continue;
                        }
                        ++matchedColumns;
                    }
                    if (matchedAliases + matchedColumns <= 1) {
                        return;
                    }
                    if (clause instanceof SqlOrderByClause) {
                        if (familyId.isDb2() && matchedColumns == 1 && matchedAliases == 1) {
                            return;
                        }
                        if (familyId.isSybase() && matchedAliases == 0) {
                            return;
                        }
                    }
                    ArrayList names = ContainerUtil.newArrayListWithCapacity((int)(matchedAliases + matchedColumns));
                    int count3 = tableType.getColumnCount();
                    for (int i3 = 0; i3 < count3; ++i3) {
                        if (!Comparing.strEqual((String)columnName, (String)tableType.getColumnName(i3), (boolean)false)) continue;
                        String tableAlias = tableType.getColumnTypeAlias(i3);
                        if (tableAlias != null) {
                            names.add(tableAlias + "." + columnName);
                            continue;
                        }
                        PsiElement c = tableType.getSourceColumnElement(i3);
                        names.add(c == null ? columnName : SqlAmbiguousColumnInspection.getQualifiedName(c));
                    }
                    Collections.sort(names);
                    for (SqlUsingClause usingClause : SqlAmbiguousColumnInspection.getAllUsingClauses(tableExpression)) {
                        List<SqlReferenceExpression> referenceList = SqlImplUtil.getReferenceList(usingClause.getReferenceList());
                        if (referenceList.isEmpty()) continue;
                        if (names.isEmpty()) break;
                        for (SqlAsExpression expression : PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)usingClause.getParent(), SqlAsExpression.class)) {
                            names.remove(expression.getName() + "." + columnName);
                        }
                        for (SqlReferenceExpression reference : referenceList) {
                            for (ResolveResult resolveResult : reference.multiResolve(false)) {
                                names.remove(SqlAmbiguousColumnInspection.getQualifiedName(resolveResult.getElement()));
                            }
                        }
                    }
                    if (names.size() > 1) {
                        this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)o, SqlMessages.message("ambiguous.column.short.reference", StringUtil.join((String[])ArrayUtil.toStringArray((Collection)names), (String)",\n")), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "o";
                objectArray2[1] = "com/intellij/sql/inspections/SqlAmbiguousColumnInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "shouldNotCheckElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitSqlReferenceExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (sqlAnnotationVisitor == null) {
            SqlAmbiguousColumnInspection.$$$reportNull$$$0(4);
        }
        return sqlAnnotationVisitor;
    }

    @NotNull
    private static Collection<SqlUsingClause> getAllUsingClauses(@NotNull SqlTableExpression tableExpression) {
        SqlFromClause fromClause;
        if (tableExpression == null) {
            SqlAmbiguousColumnInspection.$$$reportNull$$$0(5);
        }
        if ((fromClause = tableExpression.getFromClause()) == null) {
            List<SqlUsingClause> list = Collections.emptyList();
            if (list == null) {
                SqlAmbiguousColumnInspection.$$$reportNull$$$0(6);
            }
            return list;
        }
        final ArrayList result2 = ContainerUtil.newArrayList();
        fromClause.acceptChildren(new SqlVisitor(){

            public void visitSqlJoinExpression(@NotNull SqlJoinExpression o) {
                if (o == null) {
                    2.$$$reportNull$$$0(0);
                }
                o.acceptChildren((SqlVisitor)this);
            }

            public void visitSqlUsingClause(SqlUsingClause o) {
                result2.add(o);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/inspections/SqlAmbiguousColumnInspection$2", "visitSqlJoinExpression"));
            }
        });
        ArrayList arrayList = result2;
        if (arrayList == null) {
            SqlAmbiguousColumnInspection.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    public static String getQualifiedName(@Nullable PsiElement element) {
        if (element == null) {
            if ("" == null) {
                SqlAmbiguousColumnInspection.$$$reportNull$$$0(8);
            }
            return "";
        }
        if (element instanceof DbElement) {
            String string = QNameUtil.getQualifiedName((DbElement)element);
            if (string == null) {
                SqlAmbiguousColumnInspection.$$$reportNull$$$0(9);
            }
            return string;
        }
        if (element instanceof SqlDefinition) {
            String string = QNameUtil.getQualifiedName((DasObject)((SqlDefinition)element));
            if (string == null) {
                SqlAmbiguousColumnInspection.$$$reportNull$$$0(10);
            }
            return string;
        }
        if (element instanceof PsiNamedElement) {
            String string = StringUtil.notNullize((String)((PsiNamedElement)element).getName());
            if (string == null) {
                SqlAmbiguousColumnInspection.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = StringUtil.notNullize((String)element.getText());
        if (string == null) {
            SqlAmbiguousColumnInspection.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/inspections/SqlAmbiguousColumnInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/inspections/SqlAmbiguousColumnInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnnotationVisitor";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllUsingClauses";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAllUsingClauses";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

