/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SqlExpandColumnListIntention
implements IntentionAction {
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            SqlExpandColumnListIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Expand column list" == null) {
            SqlExpandColumnListIntention.$$$reportNull$$$0(1);
        }
        return "Expand column list";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            SqlExpandColumnListIntention.$$$reportNull$$$0(2);
        }
        if (file == null || editor == null || !(file instanceof SqlFile)) {
            return false;
        }
        SqlReferenceImpl referenceAt = SqlExpandColumnListIntention.getSqlReference(editor, file);
        if (referenceAt == null) {
            return false;
        }
        String text2 = referenceAt.getCanonicalText();
        if (!"*".equals(text2) && !text2.endsWith(".*")) {
            return false;
        }
        PsiElement element = referenceAt.getElement();
        SqlElement parent = (SqlElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{SqlClause.class, SqlExpression.class, SqlStatement.class});
        if (!(parent instanceof SqlSelectClause)) {
            return false;
        }
        SqlType type = referenceAt.getSqlType();
        return type instanceof SqlTableType && ((SqlTableType)type).getColumnCount() > 0;
    }

    private static SqlReferenceImpl getSqlReference(Editor editor, PsiFile file) {
        int offset = editor.getCaretModel().getOffset();
        CharSequence sequence = editor.getDocument().getCharsSequence();
        int adjustedOffset = offset > 0 && (offset >= sequence.length() || StringUtil.isWhiteSpace((char)sequence.charAt(offset)) && !StringUtil.isWhiteSpace((char)sequence.charAt(offset - 1))) ? offset - 1 : offset;
        PsiReference ref = file.findReferenceAt(adjustedOffset);
        return ref instanceof SqlReferenceImpl ? (SqlReferenceImpl)ref : null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        SqlReferenceImpl referenceAt;
        SqlPrimitiveType type;
        if (project == null) {
            SqlExpandColumnListIntention.$$$reportNull$$$0(3);
        }
        Object object = type = (referenceAt = SqlExpandColumnListIntention.getSqlReference(editor, file)) == null ? SqlType.UNKNOWN : referenceAt.getSqlType();
        if (!(type instanceof SqlTableType) || ((SqlTableType)type).getColumnCount() == 0) {
            return;
        }
        SqlTableType tableType = (SqlTableType)type;
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
        SqlQueryExpression queryExpression = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)referenceAt.getElement(), SqlQueryExpression.class, (boolean)true);
        SqlTableExpression tableExpression = queryExpression == null ? null : queryExpression.getTableExpression();
        SqlTableType asteriskType = tableExpression == null ? null : tableExpression.getSqlType();
        List<String> columnNames = asteriskType == null ? DbSqlUtil.getUnambiguousColumnNames(project, dialect.getDatabaseDialect(), tableType) : DbSqlUtil.getUnambiguousColumnNames(project, dialect.getDatabaseDialect(), tableType, asteriskType);
        DdlBuilder builder = new DdlBuilder().applyCodeStyle(project).withDialect(dialect.getDatabaseDialect());
        int len = tableType.getColumnCount();
        for (int i2 = 0; i2 < len; ++i2) {
            if (i2 > 0) {
                builder.symbol(",").space();
            }
            builder.plain(columnNames.get(i2));
        }
        String columnListText = builder.getStatement();
        if (StringUtil.isEmptyOrSpaces((String)columnListText)) {
            return;
        }
        String templateText = "select " + columnListText + " from t";
        SqlExpression expr = SqlPsiElementFactory.createQueryExpressionFromText(templateText, dialect, (PsiElement)file);
        if (!(expr instanceof SqlQueryExpression)) {
            throw new IncorrectOperationException("Not a  query expression " + dialect.getDisplayName() + ": " + templateText);
        }
        List expressions = ((SqlQueryExpression)expr).getSelectClause().getExpressions();
        PsiElement element = referenceAt.getElement();
        element.getParent().addRangeBefore((PsiElement)expressions.get(0), (PsiElement)expressions.get(expressions.size() - 1), element);
        element.delete();
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/intentions/SqlExpandColumnListIntention";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/intentions/SqlExpandColumnListIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

