/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.intentions.SqlIntentionUtil;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlUnqualifyIdentifierIntention
extends BaseElementAtCaretIntentionAction {
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            SqlUnqualifyIdentifierIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Unqualify identifier" == null) {
            SqlUnqualifyIdentifierIntention.$$$reportNull$$$0(1);
        }
        return "Unqualify identifier";
    }

    @Nullable
    private static SqlReferenceExpression getTopmostQualifiedRef(@NotNull PsiElement element) {
        SqlReferenceExpression next;
        SqlIdentifier identifier;
        if (element == null) {
            SqlUnqualifyIdentifierIntention.$$$reportNull$$$0(2);
        }
        if ((identifier = SqlIntentionUtil.getIdentifier(element)) == null) {
            return null;
        }
        SqlReferenceExpression ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)identifier.getParent(), SqlReferenceExpression.class);
        if (ref == null) {
            return null;
        }
        if (ref.getQualifierExpression() == null) {
            return (SqlReferenceExpression)ObjectUtils.tryCast((Object)ref.getParent(), SqlReferenceExpression.class);
        }
        while (ref.getQualifierExpression() != null && (next = (SqlReferenceExpression)ObjectUtils.tryCast((Object)ref.getQualifierExpression(), SqlReferenceExpression.class)) != null && next.getQualifierExpression() != null) {
            ref = next;
        }
        return ref.getQualifierExpression() == null ? null : ref;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            SqlUnqualifyIdentifierIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            SqlUnqualifyIdentifierIntention.$$$reportNull$$$0(4);
        }
        return SqlUnqualifyIdentifierIntention.getTopmostQualifiedRef(element) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        SqlReferenceExpression ref;
        if (project == null) {
            SqlUnqualifyIdentifierIntention.$$$reportNull$$$0(5);
        }
        if (element == null) {
            SqlUnqualifyIdentifierIntention.$$$reportNull$$$0(6);
        }
        if ((ref = SqlUnqualifyIdentifierIntention.getTopmostQualifiedRef(element)) == null || ref.getQualifierExpression() == null || ref.getIdentifier() == null) {
            return;
        }
        this.unqualifyReference(ref);
    }

    private void unqualifyReference(@NotNull SqlReferenceExpression ref) {
        if (ref == null) {
            SqlUnqualifyIdentifierIntention.$$$reportNull$$$0(7);
        }
        PsiFile file = ref.getContainingFile();
        SqlIdentifier identifier = ref.getIdentifier();
        if (file == null || identifier == null) {
            return;
        }
        Document document = PsiDocumentManager.getInstance((Project)ref.getProject()).getDocument(file);
        if (document == null) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)ref.getProject(), (String)this.getText(), null, () -> {
            if (ref == null) {
                SqlUnqualifyIdentifierIntention.$$$reportNull$$$0(8);
            }
            document.replaceString(ref.getTextRange().getStartOffset(), identifier.getTextRange().getStartOffset(), (CharSequence)"");
        }, (PsiFile[])new PsiFile[]{file});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/intentions/SqlUnqualifyIdentifierIntention";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/intentions/SqlUnqualifyIdentifierIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTopmostQualifiedRef";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "unqualifyReference";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$unqualifyReference$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

