/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlAltNamesProvider;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NameChecker {
    public final String sourceText;
    public final boolean sourcePlain;
    public final SqlLanguageDialectEx dialect;
    public final CasingProvider casingProvider;
    public final String[] actualCache;

    public NameChecker(@NotNull SqlReferenceExpression ref, SqlLanguageDialectEx dialect, CasingProvider provider) {
        if (ref == null) {
            NameChecker.$$$reportNull$$$0(0);
        }
        this.actualCache = new String[2];
        this.dialect = dialect;
        this.sourcePlain = !DbSqlUtil.isQuoted((SqlNameElement)ref);
        this.sourceText = ref.getName();
        this.casingProvider = provider;
    }

    NameChecker(@NotNull SqlReferenceImpl ref, SqlLanguageDialectEx dialect, CasingProvider provider) {
        if (ref == null) {
            NameChecker.$$$reportNull$$$0(1);
        }
        this.actualCache = new String[2];
        this.dialect = dialect;
        this.sourceText = ref.getReferenceName();
        this.sourcePlain = !DbSqlUtil.isQuoted((SqlNameElement)ObjectUtils.tryCast((Object)ref.getElement(), SqlNameElement.class));
        this.casingProvider = provider;
    }

    private static Casing getCasing(@NotNull SqlReferenceExpression ref, CasingProvider provider) {
        if (ref == null) {
            NameChecker.$$$reportNull$$$0(2);
        }
        ObjectKind kind = ref.getReferenceElementType().getTargetKind();
        DasObject context = NameChecker.getDasContext(ref.getQualifierExpression());
        return provider.getCasing(kind, context);
    }

    @Nullable
    private static DasObject getDasContext(@Nullable SqlExpression qualifier) {
        PsiReference reference = qualifier == null ? null : qualifier.getReference();
        PsiElement target = reference == null ? null : reference.resolve();
        return target instanceof DasObject ? (DasObject)target : null;
    }

    public boolean checkName(@Nullable Object target, @Nullable Boolean forcedCaseSens) {
        boolean caseSensitive;
        String[] altNames;
        if (target == null) {
            return false;
        }
        SqlElement targetSql = target instanceof DbElement ? DbSqlUtil.getSqlElement((DbElement)target) : null;
        DasObject targetObject = (DasObject)ObjectUtils.tryCast((Object)(targetSql instanceof DasObject ? targetSql : target), DasObject.class);
        SqlReferenceExpression targetRef = (SqlReferenceExpression)ObjectUtils.tryCast((Object)target, SqlReferenceExpression.class);
        if (targetObject == null && targetRef == null) {
            throw new IllegalArgumentException(target.getClass().getName());
        }
        String name = targetObject != null ? targetObject.getName() : targetRef.getName();
        String[] stringArray = altNames = targetObject instanceof SqlAltNamesProvider ? ((SqlAltNamesProvider)targetObject).getAltNames() : ArrayUtil.EMPTY_STRING_ARRAY;
        if (!Comparing.strEqual((String)name, (String)this.sourceText, (boolean)false)) {
            String alt = null;
            for (String text2 : altNames) {
                if (!Comparing.strEqual((String)text2, (String)this.sourceText, (boolean)false)) continue;
                alt = text2;
                break;
            }
            if (alt == null) {
                return false;
            }
            name = alt;
        }
        DatabaseDialectEx databaseDialect = this.dialect.getDatabaseDialect();
        boolean isBuiltInFunction = target instanceof BuiltinFunction;
        if (isBuiltInFunction && databaseDialect.getFamilyId().isSybase()) {
            return true;
        }
        if (isBuiltInFunction && databaseDialect.getFamilyId().isTransactSql() && ((BuiltinFunction)target).getPostfixType() == null) {
            return this.sourcePlain;
        }
        boolean targetIsPlain = targetObject != null ? !DbSqlUtil.isQuoted(targetObject) : !DbSqlUtil.isQuoted((SqlNameElement)targetRef);
        Casing inPlaceCasing = targetObject != null ? this.casingProvider.getCasing(targetObject.getKind(), targetObject) : NameChecker.getCasing(targetRef, this.casingProvider);
        Case targetCase = inPlaceCasing.choose(targetIsPlain);
        Case sourceCase = inPlaceCasing.choose(this.sourcePlain);
        String targetActual = SqlImplUtil.getActualName(target, name, targetIsPlain, this.casingProvider);
        if (forcedCaseSens != null) {
            return this.compareWithSource(targetActual, sourceCase, forcedCaseSens == Boolean.TRUE);
        }
        if (isBuiltInFunction) {
            return this.compareWithSource(targetActual, sourceCase, sourceCase == Case.EXACT && !this.sourcePlain);
        }
        boolean targetCaseSensitive = targetCase != Case.MIXED;
        boolean sourceCaseSensitive = sourceCase != Case.MIXED;
        boolean bl = caseSensitive = sourceCaseSensitive && targetCaseSensitive;
        return this.compareWithSource(targetActual, sourceCase, caseSensitive);
    }

    private boolean compareWithSource(String targetActual, Case sourceCase, boolean caseSensitive) {
        if (!caseSensitive) {
            return Comparing.strEqual((String)targetActual, (String)this.sourceText, (boolean)false);
        }
        return Comparing.strEqual((String)targetActual, (String)this.getSourceActual(sourceCase), (boolean)true);
    }

    private String getSourceActual(Case sourceCase) {
        if (sourceCase == Case.EXACT || sourceCase == Case.MIXED) {
            return this.sourceText;
        }
        int i2 = sourceCase == Case.LOWER ? 0 : 1;
        return this.actualCache[i2] == null ? sourceCase.apply(this.sourceText) : this.actualCache[i2];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "ref";
        objectArray2[1] = "com/intellij/sql/psi/impl/NameChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getCasing";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

