/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.util.DasUtil;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlColumnAliasDefinition;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlColumnAliasOwner;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.stubs.SqlStubbedDefinitionImpl;
import com.intellij.sql.psi.stubs.SqlTableStub;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCreateViewStatementImpl
extends SqlStubbedDefinitionImpl<SqlTableStub>
implements SqlCreateViewStatement,
SqlColumnAliasOwner {
    public SqlCreateViewStatementImpl(@NotNull ASTNode node) {
        if (node == null) {
            SqlCreateViewStatementImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public SqlCreateViewStatementImpl(SqlTableStub stub) {
        super(stub, stub.getStubType());
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlCreateViewStatement((SqlCreateViewStatement)this);
    }

    public SqlReferenceExpression getNameElement() {
        return (SqlReferenceExpression)super.getNameElement();
    }

    @Override
    protected SqlReferenceElementType getExpectedNameReferenceElementType() {
        return SqlCompositeElementTypes.SQL_VIEW_REFERENCE;
    }

    public DatabaseSystem getDataSource() {
        return null;
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.VIEW;
        if (objectKind == null) {
            SqlCreateViewStatementImpl.$$$reportNull$$$0(1);
        }
        return objectKind;
    }

    @Override
    @NotNull
    public <C extends DasObject> JBIterable<C> getDbChildren(@NotNull Class<C> clazz, @NotNull ObjectKind kind) {
        if (clazz == null) {
            SqlCreateViewStatementImpl.$$$reportNull$$$0(2);
        }
        if (kind == null) {
            SqlCreateViewStatementImpl.$$$reportNull$$$0(3);
        }
        JBIterable result2 = JBIterable.empty();
        if (kind == ObjectKind.COLUMN || kind == ObjectKind.NONE) {
            result2 = result2.append(this.getColumns());
        }
        JBIterable jBIterable = result2.filter(clazz);
        if (jBIterable == null) {
            SqlCreateViewStatementImpl.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    @NotNull
    public SqlColumnAliasDefinition[] getColumnAliases() {
        SqlColumnAliasDefinition[] sqlColumnAliasDefinitionArray = (SqlColumnAliasDefinition[])this.getStubOrPsiChildren(SqlCompositeElementTypes.SQL_COLUMN_ALIAS_DEFINITION, SqlColumnAliasDefinition.ARRAY_FACTORY);
        if (sqlColumnAliasDefinitionArray == null) {
            SqlCreateViewStatementImpl.$$$reportNull$$$0(5);
        }
        return sqlColumnAliasDefinitionArray;
    }

    @NotNull
    public List<PsiColumn> getColumns() {
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create(this.calcColumns(), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT}));
        if (list == null) {
            SqlCreateViewStatementImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private List<PsiColumn> calcColumns() {
        SqlType type;
        SqlExpression expression = this.getQueryExpression();
        SqlType sqlType = type = expression == null ? null : expression.getSqlType();
        if (!(type instanceof SqlTableType)) {
            List<PsiColumn> list = Collections.emptyList();
            if (list == null) {
                SqlCreateViewStatementImpl.$$$reportNull$$$0(7);
            }
            return list;
        }
        SqlTableType tableType = (SqlTableType)type;
        SqlColumnAliasDefinition[] aliases = this.getColumnAliases();
        List<SqlColumnAliasDefinition> columns2 = Arrays.asList(aliases);
        if (SqlImplUtil.getSqlDialectSafe((PsiElement)this).getFamilyId().isPostgres()) {
            columns2 = SqlTableTypeBase.expand(columns2, tableType.getColumnCount());
        }
        List<PsiColumn> list = SqlImplUtil.createColumnInfos((DasTable)this, tableType.alias(this.getName(), (PsiElement)this, columns2));
        if (list == null) {
            SqlCreateViewStatementImpl.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Nullable
    public SqlExpression getQueryExpression() {
        SqlTableStub stub = (SqlTableStub)this.getStub();
        if (stub != null) {
            return stub.getQueryExpression();
        }
        return (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_AS_QUERY_CLAUSE), SqlExpression.class);
    }

    @Override
    public Icon getIcon() {
        return DatabaseIcons.View;
    }

    public boolean isSystem() {
        return false;
    }

    public boolean isTemporary() {
        return false;
    }

    @NotNull
    public Set<DasColumn.Attribute> getColumnAttrs(@Nullable DasColumn columnInfo) {
        Set set = DasUtil.NO_ATTRS;
        if (set == null) {
            SqlCreateViewStatementImpl.$$$reportNull$$$0(9);
        }
        return set;
    }

    @Override
    @NotNull
    public SqlType getAliasedSqlType(@NotNull SqlColumnAliasDefinition alias) {
        int index;
        if (alias == null) {
            SqlCreateViewStatementImpl.$$$reportNull$$$0(10);
        }
        if ((index = ArrayUtil.indexOf((Object[])this.getColumnAliases(), (Object)alias)) == -1) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
            if (sqlPrimitiveType == null) {
                SqlCreateViewStatementImpl.$$$reportNull$$$0(11);
            }
            return sqlPrimitiveType;
        }
        SqlExpression expression = this.getQueryExpression();
        if (expression == null) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
            if (sqlPrimitiveType == null) {
                SqlCreateViewStatementImpl.$$$reportNull$$$0(12);
            }
            return sqlPrimitiveType;
        }
        SqlType type = expression.getSqlType();
        SqlTableType tableType = (SqlTableType)ObjectUtils.tryCast((Object)type, SqlTableType.class);
        if (tableType != null) {
            Object object = index < tableType.getColumnCount() ? tableType.getColumnType(index) : SqlType.UNKNOWN;
            if (object == null) {
                SqlCreateViewStatementImpl.$$$reportNull$$$0(13);
            }
            return object;
        }
        Object object = index == 0 ? type : SqlType.UNKNOWN;
        if (object == null) {
            SqlCreateViewStatementImpl.$$$reportNull$$$0(14);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlCreateViewStatementImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlCreateViewStatementImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbChildren";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnAliases";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumns";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "calcColumns";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnAttrs";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAliasedSqlType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDbChildren";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAliasedSqlType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

