/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.google.common.collect.Iterables;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.Case;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCompositeElement;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateTypeStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlParameterDefinition;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlCursorDefinitionImpl;
import com.intellij.sql.psi.impl.SqlExpressionImpl;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlFunctionCallTableExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlNamedParameterValueExpression;
import com.intellij.sql.psi.impl.SqlProcedureDefinitionImpl;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.sql.psi.impl.TableBasedSqlTableTypeImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlFunctionCallExpressionImpl
extends SqlExpressionImpl
implements SqlFunctionCallExpression,
NavigationItem {
    public SqlFunctionCallExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlFunctionCallExpression((SqlFunctionCallExpression)this);
    }

    @Nullable
    public SqlReferenceExpression getNameElement() {
        return (SqlReferenceExpression)ObjectUtils.tryCast((Object)this.getCallableExpression(), SqlReferenceExpression.class);
    }

    @NotNull
    public SqlExpression getCallableExpression() {
        SqlExpression sqlExpression = (SqlExpression)this.findNotNullChildByClass(SqlExpression.class);
        if (sqlExpression == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(1);
        }
        return sqlExpression;
    }

    public SqlExpressionList getParameterList() {
        return (SqlExpressionList)this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_EXPRESSION_LIST);
    }

    @Override
    @NotNull
    public SqlType getSqlType() {
        SqlTableType type;
        boolean ensureTable;
        SqlReferenceExpression nameElement;
        SqlFunctionDefinition.Prototype prototype = SqlFunctionsUtil.chooseTheBestPrototype(this, true);
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)this);
        if (prototype != null) {
            DataType dataType;
            SqlFunctionDefinition.Type returnType = prototype.getReturnType();
            if (returnType == SqlFunctionDefinition.UNNEST) {
                SqlExpressionList list = this.getParameterList();
                List cols = list == null ? null : list.getExpressionList();
                SqlReferenceExpression nameElement2 = this.getNameElement();
                if (nameElement2 == null || ContainerUtil.isEmpty((Collection)cols)) {
                    SqlTableType sqlTableType = SqlTableTypeBase.EMPTY_TABLE;
                    if (sqlTableType == null) {
                        SqlFunctionCallExpressionImpl.$$$reportNull$$$0(2);
                    }
                    return sqlTableType;
                }
                StringBuilder builder = new StringBuilder("table(");
                for (SqlExpression col : cols) {
                    if (builder.charAt(builder.length() - 1) != '(') {
                        builder.append(", ");
                    }
                    builder.append(prototype.getFunction().getName()).append(" ").append(SqlImplUtil.getArrayElement(col.getSqlType().getDataType()).getSpecification());
                }
                builder.append(")");
                SqlType sqlType = SqlFunctionCallExpressionImpl.getSqlType((PsiElement)this, DataTypeFactory.of(builder.toString()));
                if (sqlType == null) {
                    SqlFunctionCallExpressionImpl.$$$reportNull$$$0(3);
                }
                return sqlType;
            }
            DataType dataType2 = dataType = returnType == null ? null : returnType.getDataType();
            if (dataType != null) {
                List<SqlColumnDefinition> columns2 = this.detectColumns();
                if (!columns2.isEmpty()) {
                    TableBasedSqlTableTypeImpl<SqlColumnDefinition> tableBasedSqlTableTypeImpl = new TableBasedSqlTableTypeImpl<SqlColumnDefinition>(columns2, (PsiElement)ObjectUtils.chooseNotNull((Object)this.getNameElement(), (Object)((Object)this)));
                    if (tableBasedSqlTableTypeImpl == null) {
                        SqlFunctionCallExpressionImpl.$$$reportNull$$$0(4);
                    }
                    return tableBasedSqlTableTypeImpl;
                }
                if ("table".equalsIgnoreCase(dataType.typeName)) {
                    if (dataType.vagueArg == null) {
                        dataType = DataTypeFactory.of("table(" + prototype.getFunction().getName() + " record)");
                    }
                    SqlType sqlType = SqlImplUtil.getSqlType(this.getProject(), dataType, dialect, (PsiElement)this);
                    if (sqlType == null) {
                        SqlFunctionCallExpressionImpl.$$$reportNull$$$0(5);
                    }
                    return sqlType;
                }
                SqlType sqlType = SqlTypeFactory.of(dataType, dialect);
                if (sqlType == null) {
                    SqlFunctionCallExpressionImpl.$$$reportNull$$$0(6);
                }
                return sqlType;
            }
            if (returnType instanceof SqlFunctionDefinition.ParamType) {
                int index = ((SqlFunctionDefinition.ParamType)returnType).getIndex();
                SqlExpressionList parameterList = this.getParameterList();
                List params2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)parameterList, SqlCompositeElement.class);
                if (index > 0 && index <= params2.size()) {
                    SqlCompositeElement element = (SqlCompositeElement)params2.get(index - 1);
                    SqlType sqlType = SqlFunctionCallExpressionImpl.getParamType((SqlElement)element);
                    if (sqlType == null) {
                        SqlFunctionCallExpressionImpl.$$$reportNull$$$0(7);
                    }
                    return sqlType;
                }
                if (index == 0) {
                    SqlPrimitiveType curType = SqlType.UNKNOWN;
                    for (SqlCompositeElement param : params2) {
                        SqlType type2 = SqlFunctionCallExpressionImpl.getParamType((SqlElement)param);
                        if (curType == SqlType.UNKNOWN || SqlType.Category.REAL.is(type2)) {
                            curType = type2;
                            continue;
                        }
                        if (!SqlType.Category.INTEGER.is((SqlType)curType)) continue;
                        curType = SqlTypeFactory.defaultType(SqlType.Category.REAL, dialect);
                    }
                    SqlPrimitiveType sqlPrimitiveType = curType;
                    if (sqlPrimitiveType == null) {
                        SqlFunctionCallExpressionImpl.$$$reportNull$$$0(8);
                    }
                    return sqlPrimitiveType;
                }
            }
        }
        PsiElement resolve = (nameElement = this.getNameElement()) == null ? null : nameElement.getReference().resolve();
        Object target = resolve instanceof DbElement ? ((DbElement)resolve).getDelegate() : resolve;
        boolean bl = ensureTable = this.getParent() instanceof SqlFromClause || this.getParent() instanceof SqlAsExpression && this.getParent().getParent() instanceof SqlFromClause;
        if (target instanceof SqlFileImpl.FakeDefinition) {
            target = ((SqlFileImpl.FakeDefinition)((Object)target)).delegates().first();
        }
        if (target instanceof DasRoutine) {
            SqlType sqlType = SqlFunctionCallExpressionImpl.createRoutineType(resolve, (DasRoutine)target, ensureTable, (PsiElement)this);
            if (sqlType == null) {
                SqlFunctionCallExpressionImpl.$$$reportNull$$$0(9);
            }
            return sqlType;
        }
        if (target instanceof SqlCreateTypeStatement && (type = ((SqlCreateTypeStatement)target).getSqlType()) != null) {
            SqlTableType sqlTableType = ensureTable ? SqlTableTypeBase.ensureTableType((SqlType)type, (SqlElement)this, (PsiElement)this) : type;
            if (sqlTableType == null) {
                SqlFunctionCallExpressionImpl.$$$reportNull$$$0(10);
            }
            return sqlTableType;
        }
        if (target instanceof SqlTypedDefinition) {
            SqlTypedDefinition definition = (SqlTypedDefinition)target;
            SqlType sqlType = SqlImplUtil.getSqlType(definition, dialect, (PsiElement)nameElement);
            if (sqlType == null) {
                SqlFunctionCallExpressionImpl.$$$reportNull$$$0(11);
            }
            return sqlType;
        }
        SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
        if (sqlPrimitiveType == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(12);
        }
        return sqlPrimitiveType;
    }

    @NotNull
    private List<SqlColumnDefinition> detectColumns() {
        SqlExpressionList parameterList;
        ArrayList columns2 = ContainerUtil.newArrayList();
        if (!SqlFunctionCallExpressionImpl.collectColumnDefs(columns2, (PsiElement)(parameterList = this.getParameterList()))) {
            SqlFunctionCallExpressionImpl.collectColumnDefs(columns2, (PsiElement)this);
        }
        ArrayList arrayList = columns2;
        if (arrayList == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    private static boolean collectColumnDefs(List<SqlColumnDefinition> columns2, PsiElement container) {
        for (PsiElement element : SqlImplUtil.sqlChildren(container)) {
            if (element instanceof SqlColumnDefinition) {
                columns2.add((SqlColumnDefinition)element);
                continue;
            }
            if (!(element instanceof SqlClause) || !columns2.isEmpty()) continue;
            SqlImplUtil.sqlChildren(element).filter(SqlColumnDefinition.class).addAllTo(columns2);
            if (columns2.isEmpty()) continue;
            break;
        }
        return !columns2.isEmpty();
    }

    public static SqlType createRoutineType(@NotNull PsiElement resolve, @NotNull DasRoutine target, boolean ensureTable, @NotNull PsiElement qualifier) {
        if (resolve == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(14);
        }
        if (target == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(15);
        }
        if (qualifier == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(16);
        }
        DasArgument retArg = target.getReturnArgument();
        JBIterable outArgs = JBIterable.from((Iterable)target.getArguments()).filter(DasUtil.OUTPUT_ARGUMENT).append((Iterable)ContainerUtil.createMaybeSingletonList((Object)retArg));
        return SqlFunctionCallExpressionImpl.createType(resolve, (Iterable<? extends DasArgument>)outArgs, ensureTable, qualifier);
    }

    @NotNull
    private static SqlType getParamType(SqlElement element) {
        Object object = element instanceof SqlTypeElement ? ((SqlTypeElement)element).findSqlType() : (element instanceof SqlExpression ? ((SqlExpression)element).getSqlType() : SqlType.UNKNOWN);
        if (object == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(17);
        }
        return object;
    }

    private static SqlType createType(@NotNull PsiElement routine2, @NotNull Iterable<? extends DasArgument> args, boolean ensureTable, @NotNull PsiElement qualifier) {
        if (routine2 == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(18);
        }
        if (args == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(19);
        }
        if (qualifier == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(20);
        }
        int size = Iterables.size(args);
        ArrayList columns2 = ContainerUtil.newArrayListWithCapacity((int)size);
        for (DasArgument dasArgument : args) {
            SqlType sqlType;
            SqlType sqlType2 = sqlType = dasArgument instanceof SqlTypedDefinition ? ((SqlTypedDefinition)dasArgument).getSqlType() : SqlFunctionCallExpressionImpl.getSqlType(routine2, dasArgument.getDataType());
            if (size == 1 && sqlType != SqlType.UNKNOWN && dasArgument instanceof SqlElement) {
                SqlType res;
                Object object = res = ensureTable ? SqlTableTypeBase.ensureTableType(sqlType, (SqlElement)dasArgument, qualifier) : sqlType;
                if (sqlType instanceof SqlTableType) {
                    SqlReferenceExpression element = ((SqlFunctionCallExpression)qualifier).getNameElement();
                    res = ((SqlTableType)res).alias(element != null ? element.getName() : null, qualifier, Collections.emptyList());
                }
                return res;
            }
            columns2.add(new SqlImplUtil.Column(dasArgument.getName(), sqlType, (PsiElement)(dasArgument instanceof PsiElement ? (PsiElement)dasArgument : new FakeParameter(qualifier, dasArgument)), null));
        }
        if (!ensureTable && columns2.size() == 1) {
            return ((SqlImplUtil.Column)columns2.get((int)0)).type;
        }
        return SqlImplUtil.createType(columns2, qualifier);
    }

    private static SqlType getSqlType(@NotNull PsiElement routine2, @NotNull DataType dataType) {
        if (routine2 == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(21);
        }
        if (dataType == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(22);
        }
        if (dataType == DataType.UNKNOWN) {
            return SqlType.UNKNOWN;
        }
        return SqlImplUtil.getSqlType(routine2.getProject(), dataType, SqlImplUtil.getSqlDialectSafe(routine2), routine2);
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            @Nullable
            public String getPresentableText() {
                SqlReferenceExpression nameElement = SqlFunctionCallExpressionImpl.this.getNameElement();
                return nameElement == null ? null : nameElement.getName();
            }

            @Nullable
            public String getLocationString() {
                return null;
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                return null;
            }
        };
    }

    @Nullable
    public SqlFunctionDefinition getFunctionDefinition() {
        SqlReferenceExpression nameElement = this.getNameElement();
        if (nameElement == null) {
            return null;
        }
        String functionName = nameElement.getName();
        SqlFunctionDefinition definition = SqlImplUtil.getSqlDialectSafe((PsiElement)this).getSupportedFunctions().get(functionName);
        return definition == null || !definition.isTableQueryOnly() || this.getParent() instanceof SqlFunctionCallTableExpressionImpl ? definition : null;
    }

    @Override
    public ObjectKind getExpectedReferenceTargetType(SqlElement referenceElement) {
        return referenceElement == this.getNameElement() && this.getFirstChild() != this.getLastChild() ? ObjectKind.ROUTINE : super.getExpectedReferenceTargetType(referenceElement);
    }

    @Override
    public boolean processImplicitContextDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        if (!SqlImplUtil.isProcessingOneOf(processor, ObjectKind.ARGUMENT)) {
            return true;
        }
        if (!SqlFunctionCallExpressionImpl.processNamedArgument((Processor<PsiElement>)((Processor)e -> processor.execute(e, state)), this.getNameElement(), place)) {
            return false;
        }
        return super.processImplicitContextDeclarations(processor, state, lastParent, place);
    }

    public static boolean processNamedArgument(Processor<PsiElement> processor, SqlReferenceExpression ref, PsiElement place) {
        SqlNamedParameterValueExpression expr = (SqlNamedParameterValueExpression)((Object)ObjectUtils.tryCast((Object)(place == null ? null : place.getParent()), SqlNamedParameterValueExpression.class));
        if (expr != null && place == expr.getLOperand()) {
            SqlFunctionCallExpressionImpl.processParameters(ref, processor, place);
            return false;
        }
        return true;
    }

    public static boolean processParameters(@Nullable SqlReferenceExpression fooRef, Processor<PsiElement> processor, final PsiElement place) {
        if (fooRef == null) {
            return true;
        }
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)fooRef);
        Case casing = dialect.getCasing((ObjectKind)ObjectKind.ARGUMENT, null).plain;
        SqlFunctionDefinition definition = dialect.getSupportedFunctions().get(fooRef.getName());
        if (definition != null) {
            JBIterable names = ((JBTreeTraverser)JBTreeTraverser.from(SqlFunctionCallExpressionImpl::getParameters).withRoots((Iterable)JBIterable.of((Object[])definition.getPrototypes()))).filter(SqlFunctionDefinition.SimpleParameter.class).transform(p -> p.getName());
            for (String name : names) {
                if (processor.process((Object)new FakeParameter((PsiElement)fooRef, casing.apply(name), null){

                    @Override
                    @NotNull
                    public PsiElement getNavigationElement() {
                        PsiElement psiElement = place;
                        if (psiElement == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        return psiElement;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl$2", "getNavigationElement"));
                    }
                })) continue;
                return false;
            }
        }
        for (ResolveResult res : fooRef.multiResolve(false)) {
            PsiElement origin = res.getElement();
            PsiElement resolve = origin instanceof DbElement ? ((DbElement)origin).getDelegate() : origin;
            DasRoutine routine2 = (DasRoutine)ObjectUtils.tryCast((Object)resolve, DasRoutine.class);
            SqlCursorDefinitionImpl curs = (SqlCursorDefinitionImpl)((Object)ObjectUtils.tryCast((Object)resolve, SqlCursorDefinitionImpl.class));
            if (dialect.getFamilyId().isOracle() && curs != null) {
                for (SqlParameterDefinition parameter : SqlImplUtil.childrenIt((PsiElement)curs).filter(SqlParameterDefinition.class)) {
                    if (processor.process((Object)parameter)) continue;
                    return false;
                }
            }
            if (routine2 == null || dialect.getFamilyId().isTransactSql() && routine2.getRoutineKind() == DasRoutine.Kind.FUNCTION) continue;
            if (resolve instanceof SqlProcedureDefinitionImpl) {
                SqlProcedureDefinitionImpl procedure = (SqlProcedureDefinitionImpl)resolve;
                Iterable<SqlParameterDefinition> parameters = procedure.getArguments();
                for (SqlParameterDefinition parameter : parameters) {
                    if (processor.process((Object)parameter)) continue;
                    return false;
                }
                continue;
            }
            for (SqlParameterDefinition parameter : DasUtil.getParameters((DasRoutine)routine2)) {
                if (processor.process((Object)new FakeParameter((PsiElement)fooRef, casing.apply(parameter.getName()), (DasArgument)parameter){

                    @Override
                    @NotNull
                    public PsiElement getNavigationElement() {
                        PsiElement psiElement = place;
                        if (psiElement == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        return psiElement;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl$3", "getNavigationElement"));
                    }
                })) continue;
                return false;
            }
        }
        return true;
    }

    private static Iterable<? extends SqlFunctionDefinition.Parameter> getParameters(SqlFunctionDefinition.Parameter p) {
        return p instanceof SqlFunctionDefinition.ParameterBlock ? JBIterable.of((Object[])((SqlFunctionDefinition.ParameterBlock)p).getParams()) : JBIterable.empty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolve";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallableExpression";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "detectColumns";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getParamType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: {
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createRoutineType";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getSqlType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class FakeParameter
    extends SqlFileImpl.FakeDefinition {
        private final PsiElement myParent;
        private final DasArgument myDelegate;

        public FakeParameter(@NotNull PsiElement parent, @NotNull DasArgument parameter) {
            if (parent == null) {
                FakeParameter.$$$reportNull$$$0(0);
            }
            if (parameter == null) {
                FakeParameter.$$$reportNull$$$0(1);
            }
            this(parent, StringUtil.notNullize((String)parameter.getName()), parameter);
        }

        public FakeParameter(@NotNull PsiElement parent, @NotNull String name, @Nullable DasArgument delegate) {
            if (parent == null) {
                FakeParameter.$$$reportNull$$$0(2);
            }
            if (name == null) {
                FakeParameter.$$$reportNull$$$0(3);
            }
            super(parent, name, null);
            this.myParent = parent;
            this.myDelegate = delegate;
        }

        public boolean isNameQuoted() {
            return DbSqlUtil.isQuoted((DasObject)this.myDelegate);
        }

        public int getTextOffset() {
            return this.myParent.getTextOffset();
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.ARGUMENT;
            if (objectKind == null) {
                FakeParameter.$$$reportNull$$$0(4);
            }
            return objectKind;
        }

        @Override
        public String getTypeName() {
            if (this.myDelegate != null) {
                DatabaseDialectEx dialect = SqlImplUtil.getSqlDialectSafe(this.getParent()).getDatabaseDialect();
                return new DdlBuilder().applyCodeStyle(this.getProject()).withDialect(dialect).type((DasTypedObject)this.myDelegate).getStatement();
            }
            return super.getTypeName();
        }

        @Override
        public Icon getIcon() {
            return DatabaseIcons.Col;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl$FakeParameter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl$FakeParameter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

