/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl.lexer;

import com.intellij.lang.Language;
import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.lexer.LookAheadLexer;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlTokenType;
import com.intellij.sql.psi.impl.lexer._SqlLexer;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlLexer
extends LookAheadLexer {
    private final NullableFunction<String, IElementType> myTokenProvider;
    private final Class myTokenClass;

    public static void initTokensAndFunctions(IFileElementType fileElementType, Class tokensClass, Class reservedKeywordsClass, Class optionalKeywordsClass) {
        Language l = fileElementType.getLanguage();
        SqlTokenRegistry.initTypeMap((Class)tokensClass, null);
        SqlTokenRegistry.initTypeMap((Class)reservedKeywordsClass, null);
        Set reservedNames = SqlTokenRegistry.getTokens((Class)reservedKeywordsClass);
        SqlTokenRegistry.initTypeMap((Class)optionalKeywordsClass, (Set)reservedNames);
        Set<String> fromDefinitions = SqlDialectImplUtil.getAllKeywordsFromDefinition(l instanceof SqlLanguageDialectEx ? ((SqlLanguageDialectEx)l).getSupportedFunctions().values() : Collections.emptyList(), (Set<String>)new THashSet());
        fromDefinitions.removeAll(reservedNames);
        SqlTokenRegistry.addTokensToClassMap((Class)optionalKeywordsClass, fromDefinitions);
        SqlTokenRegistry.addTokensToClassMap((Class)tokensClass, fromDefinitions);
    }

    public SqlLexer() {
        this(SqlTokens.class, new _SqlLexer());
    }

    public SqlLexer(Class tokenClass, FlexLexer flexLexer) {
        super((Lexer)new MergingLexerAdapter((Lexer)new FlexAdapter(flexLexer), SqlTokens.COMMENT_TOKENS));
        this.myTokenProvider = SqlTokenRegistry.getTokenProvider((Class)tokenClass);
        this.myTokenClass = tokenClass;
    }

    @Nullable
    public IElementType mergeMultilineComments(@Nullable IElementType firstTokenType, @NotNull Lexer baseLexer) {
        if (baseLexer == null) {
            SqlLexer.$$$reportNull$$$0(0);
        }
        if (firstTokenType == SqlTokens.MULTI_LINE_COMMENT_START) {
            block3: {
                IElementType nextTokenType;
                while (true) {
                    baseLexer.advance();
                    nextTokenType = baseLexer.getTokenType();
                    if (nextTokenType == null || nextTokenType == SqlTokens.MULTI_LINE_COMMENT_END) break block3;
                    assert (nextTokenType == SqlTokens.MULTI_LINE_COMMENT_BODY) : nextTokenType;
                }
            }
            return SqlTokens.SQL_BLOCK_COMMENT;
        }
        return firstTokenType;
    }

    public NullableFunction<String, IElementType> getTokenProvider() {
        return this.myTokenProvider;
    }

    public Class getTokenClass() {
        return this.myTokenClass;
    }

    protected void lookAhead(Lexer baseLexer) {
        this.lookSqlKeyword(baseLexer);
    }

    protected void lookSqlKeyword(Lexer baseLexer) {
        this.advanceAs(baseLexer, this.getSqlTokenType(baseLexer));
    }

    @Nullable
    protected IElementType getSqlTokenType(@NotNull Lexer lexer) {
        IElementType keyword;
        IElementType type;
        IElementType tokenType;
        if (lexer == null) {
            SqlLexer.$$$reportNull$$$0(1);
        }
        if ((tokenType = this.mergeMultilineComments(type = lexer.getTokenType(), lexer)) == SqlTokens.SQL_IDENT && lexer.getState() != 4 && (keyword = (IElementType)this.myTokenProvider.fun((Object)lexer.getTokenText())) != null) {
            return keyword;
        }
        return tokenType;
    }

    protected boolean processCustomQuotation(Lexer baseLexer, String ident, int stringStart, boolean rollbackOnError, SqlTokenType lquoteType, SqlTokenType rquoteType, SqlTokenType contentType) {
        LexerPosition position = rollbackOnError ? baseLexer.getCurrentPosition() : null;
        int identLen = ident.length();
        while (baseLexer.getTokenType() != null) {
            int textStart;
            int tokenEnd = baseLexer.getTokenEnd();
            String text2 = tokenEnd > (textStart = Math.max(stringStart, baseLexer.getTokenStart() - identLen + 1)) ? baseLexer.getBufferSequence().subSequence(textStart, tokenEnd).toString() : "";
            int idx = text2.indexOf(ident);
            if (idx > -1) {
                this.addToken(stringStart, (IElementType)lquoteType);
                int stringTokenEnd = textStart + idx;
                if (stringTokenEnd != stringStart) {
                    this.addToken(stringTokenEnd, (IElementType)contentType);
                }
                this.addToken(stringTokenEnd + identLen, (IElementType)rquoteType);
                baseLexer.start(baseLexer.getBufferSequence(), stringTokenEnd + identLen, baseLexer.getBufferEnd(), 0);
                return true;
            }
            if (text2.indexOf(10) > -1 && rollbackOnError) break;
            baseLexer.advance();
        }
        if (rollbackOnError) {
            baseLexer.restore(position);
            return false;
        }
        this.addToken(SqlTokens.BAD_CHARACTER);
        return true;
    }

    public boolean lookAheadRangeOperator(Lexer baseLexer) {
        if (baseLexer.getTokenType() == SqlTokens.SQL_INTEGER_TOKEN) {
            IElementType type;
            this.advanceLexer(baseLexer);
            while ((type = baseLexer.getTokenType()) != null && (SqlTokens.WHITE_SPACE_TOKENS.contains(type) || SqlTokens.COMMENT_TOKENS.contains(type))) {
                this.advanceLexer(baseLexer);
            }
            if (type == SqlTokens.SQL_PERIOD) {
                baseLexer.advance();
                if (baseLexer.getTokenType() == SqlTokens.SQL_PERIOD) {
                    this.advanceAs(baseLexer, (IElementType)SqlTokens.SQL_OP_RANGE);
                } else {
                    this.addToken(baseLexer.getTokenStart(), (IElementType)SqlTokens.SQL_PERIOD);
                }
            }
            return true;
        }
        int tokenStart = baseLexer.getTokenStart();
        int state = baseLexer.getState();
        int pos = this.getFirstDotPosition(baseLexer);
        if (pos > -1) {
            int bufferEnd = baseLexer.getBufferEnd();
            CharSequence bufferSequence = baseLexer.getBufferSequence();
            baseLexer.start(bufferSequence, tokenStart, tokenStart + pos, state);
            this.lookAhead(baseLexer);
            this.addToken(tokenStart + pos + 2, (IElementType)SqlTokens.SQL_OP_RANGE);
            baseLexer.start(bufferSequence, tokenStart + pos + 2, bufferEnd, state);
            this.lookAhead(baseLexer);
            return true;
        }
        return false;
    }

    protected int getFirstDotPosition(Lexer baseLexer) {
        IElementType tokenType = baseLexer.getTokenType();
        if (tokenType == SqlTokens.BAD_CHARACTER) {
            return baseLexer.getTokenText().indexOf("..");
        }
        if (tokenType == SqlTokens.SQL_FLOAT_TOKEN && baseLexer.getTokenText().endsWith(".")) {
            int tokenEnd = baseLexer.getTokenEnd();
            int pos = tokenEnd - baseLexer.getTokenStart() - 1;
            baseLexer.advance();
            if (baseLexer.getTokenType() == SqlTokens.SQL_PERIOD) {
                return pos;
            }
            this.addToken(tokenEnd, (IElementType)SqlTokens.SQL_FLOAT_TOKEN);
            return -1;
        }
        return -1;
    }

    static {
        SqlTokenRegistry.initTypeMap(SqlTokens.class, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseLexer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/psi/impl/lexer/SqlLexer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "mergeMultilineComments";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getSqlTokenType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

