/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.completion.JavaClassNameCompletionContributor;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.model.common.ejb.EjbCommonModelUtil;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.EnterpriseBeanSet;
import com.intellij.javaee.module.view.ejb.nodes.EjbNodeDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GenerateEJBReferenceHandler
implements CodeInsightActionHandler {
    @NonNls
    private static final String FIELD_VAR_NAME = "field";

    public void invoke(final @NotNull Project project, final @NotNull Editor editor, final @NotNull PsiFile file) {
        if (project == null) {
            GenerateEJBReferenceHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            GenerateEJBReferenceHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            GenerateEJBReferenceHandler.$$$reportNull$$$0(2);
        }
        if (!FileDocumentManager.getInstance().requestWriting(editor.getDocument(), project)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        while ((element = PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class)) instanceof PsiTypeParameter) {
        }
        PsiClass aClass = (PsiClass)element;
        if (aClass == null || aClass.isInterface()) {
            return;
        }
        assert (aClass.isValid());
        assert (aClass.getContainingFile() != null);
        assert (aClass.getContainingFile() == file);
        TemplateManager manager = TemplateManager.getInstance((Project)project);
        Template template = manager.createTemplate("", "");
        template.setToReformat(true);
        LinkedHashSet ejbLookupSet = new LinkedHashSet();
        final EjbFacet ejbFacet = EjbUtil.getEjbFacet((PsiElement)file);
        EnterpriseBeanSet beanSet = ejbFacet.getMergedRoot().getEnterpriseBeans();
        Function mapper = ejb -> LookupElementBuilder.create((String)((String)ejb.getEjbName().getValue())).withIcon(EjbNodeDescriptor.getEjbIcon(ejb));
        ejbLookupSet.addAll(ContainerUtil.map2Set((Collection)beanSet.getSessions(), (Function)mapper));
        ejbLookupSet.addAll(ContainerUtil.map2Set((Collection)beanSet.getEntities(), (Function)mapper));
        final LookupElement[] ejbLookupItems = ejbLookupSet.toArray(new LookupElement[ejbLookupSet.size()]);
        Expression ejbNameExpression = new Expression(){

            public Result calculateResult(ExpressionContext context) {
                return new TextResult(ejbLookupItems[0].getLookupString());
            }

            public Result calculateQuickResult(ExpressionContext context) {
                return this.calculateResult(context);
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                return ejbLookupItems;
            }
        };
        Expression ejbInterfaceExpression = new Expression(){

            public Result calculateResult(ExpressionContext context) {
                return new TextResult("java.lang.Object");
            }

            public Result calculateQuickResult(ExpressionContext context) {
                return this.calculateResult(context);
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                PsiClass objectClass = JavaPsiFacade.getInstance((Project)context.getProject()).findClass("java.lang.Object", GlobalSearchScope.allScope((Project)context.getProject()));
                TextResult ejbNameResult = TemplateManagerImpl.getTemplateState((Editor)editor).getVariableValue("beanName");
                List<EnterpriseBean> list = EjbUtil.findEjbsByLink((JavaeeFacet)ejbFacet, null, ejbNameResult.getText());
                if (list.isEmpty()) {
                    return null;
                }
                LinkedHashSet<JavaPsiClassReferenceElement> items = new LinkedHashSet<JavaPsiClassReferenceElement>();
                items.add(JavaClassNameCompletionContributor.createClassLookupItem((PsiClass)objectClass, (boolean)true));
                for (EnterpriseBean ejb : list) {
                    for (PsiClass psiClass : EjbCommonModelUtil.getEjbClasses((EnterpriseBean)ejb, (boolean)false, (boolean)false, (boolean)true)) {
                        items.add(JavaClassNameCompletionContributor.createClassLookupItem((PsiClass)psiClass, (boolean)true));
                    }
                }
                return items.toArray(new LookupElement[items.size()]);
            }
        };
        Expression fieldNameExpression = new Expression(){

            public Result calculateResult(ExpressionContext context) {
                TextResult ejbNameResult = TemplateManagerImpl.getTemplateState((Editor)editor).getVariableValue("beanName");
                return new TextResult(StringUtil.decapitalize((String)(ejbNameResult.getText() + "Ref")));
            }

            public Result calculateQuickResult(ExpressionContext context) {
                return this.calculateResult(context);
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                TextResult ejbNameResult = TemplateManagerImpl.getTemplateState((Editor)editor).getVariableValue("beanName");
                TextRange textRange = TemplateManagerImpl.getTemplateState((Editor)editor).getVariableRange("beanInterface");
                PsiElement psiElement = file.findElementAt(textRange.getStartOffset());
                if (psiElement == null || !(psiElement.getParent() instanceof PsiJavaCodeReferenceElement)) {
                    return null;
                }
                PsiClassType classType = JavaPsiFacade.getInstance((Project)psiElement.getProject()).getElementFactory().createType((PsiJavaCodeReferenceElement)psiElement.getParent());
                JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
                SuggestedNameInfo suggestedNameInfo = codeStyleManager.suggestVariableName(VariableKind.FIELD, ejbNameResult.getText(), null, (PsiType)classType);
                SuggestedNameInfo suggestedNameInfo2 = codeStyleManager.suggestUniqueVariableName(suggestedNameInfo, psiElement, true);
                LookupElement[] items = new LookupElement[suggestedNameInfo2.names.length + 1];
                int i = 0;
                String defaultName = StringUtil.decapitalize((String)(ejbNameResult.getText() + "Ref"));
                items[i++] = LookupElementBuilder.create((String)defaultName);
                for (String name : suggestedNameInfo2.names) {
                    items[i++] = LookupElementBuilder.create((String)name);
                }
                return items;
            }
        };
        template.addTextSegment("\n@javax.ejb.EJB(beanName=\"");
        template.addVariable("beanName", ejbNameExpression, ejbNameExpression, true);
        template.addTextSegment("\", beanInterface=");
        template.addVariable("beanInterface", ejbInterfaceExpression, ejbInterfaceExpression, true);
        template.addTextSegment(".class)\nprivate ");
        template.addVariableSegment("beanInterface");
        template.addTextSegment(" ");
        template.addVariable(FIELD_VAR_NAME, fieldNameExpression, fieldNameExpression, true);
        template.addTextSegment(";\n");
        template.addEndVariable();
        editor.getCaretModel().moveToOffset(GenerateEJBReferenceHandler.getInsertOffset(editor, file));
        manager.startTemplate(editor, template);
    }

    static int getInsertOffset(Editor editor, PsiFile psiFile) {
        int offset = editor.getCaretModel().getOffset();
        Object element = psiFile.findElementAt(offset);
        if (element instanceof PsiWhiteSpace) {
            element = element.getPrevSibling();
        }
        if (!(element instanceof PsiField)) {
            PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            PsiField[] psiFields = psiClass.getFields();
            element = psiFields.length > 0 ? psiFields[0] : psiClass.getLBrace();
        }
        return element.getTextRange().getEndOffset();
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/generation/GenerateEJBReferenceHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

