/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.converting.artifacts;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConversionProcessor;
import com.intellij.conversion.ModuleSettings;
import com.intellij.facet.pointers.FacetPointersManager;
import com.intellij.ide.impl.convert.JDomConvertingUtil;
import com.intellij.javaee.converting.artifacts.ContainerElementProcessor;
import com.intellij.javaee.converting.artifacts.ContainerElementProcessorBase;
import com.intellij.javaee.converting.artifacts.JavaeePackagingConverter;
import com.intellij.javaee.converting.artifacts.PackagingConversionUtil;
import com.intellij.javaee.converting.artifacts.PackagingMethod;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.artifact.ArtifactState;

public class JavaeeFacetConversionProcessor
extends ConversionProcessor<ModuleSettings> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.javaee.converting.artifacts.JavaeeFacetConversionProcessor");
    private final JavaeePackagingConverter myConverter;
    @NonNls
    public static final String CUSTOM_DESCRIPTOR_ELEMENT_NAME = "deploymentDescriptor";
    @NonNls
    public static final String DESCRIPTOR_URL_ATTRIBUTE = "url";
    @NonNls
    public static final String DEFAULT_DIR_OPTION = "DEFAULT_DIR";

    public JavaeeFacetConversionProcessor(JavaeePackagingConverter converter) {
        this.myConverter = converter;
    }

    public boolean isConversionNeeded(ModuleSettings moduleSettings) {
        List<Element> facetElements = JavaeeFacetConversionProcessor.getJavaeeFacetElements(moduleSettings);
        for (Element facetElement : facetElements) {
            Element configuration = facetElement.getChild("configuration");
            if (configuration == null) continue;
            Element building = configuration.getChild("building");
            Element packaging = configuration.getChild("packaging");
            if (building == null && packaging == null) continue;
            return true;
        }
        return false;
    }

    public void preProcess(ModuleSettings moduleSettings) throws CannotConvertException {
        for (Element facetElement : JavaeeFacetConversionProcessor.getJavaeeFacetElements(moduleSettings)) {
            Element packaging;
            final String facetPointer = PackagingConversionUtil.getFacetPointer(moduleSettings, facetElement);
            Element configuration = facetElement.getChild("configuration");
            Element building = configuration.getChild("building");
            if (building != null) {
                boolean excludeExploded;
                boolean explodedEnabled;
                String jarPath = VfsUtilCore.urlToPath((String)JDOMExternalizer.readString((Element)building, (String)"JAR_URL"));
                boolean jarEnabled = JDOMExternalizer.readBoolean((Element)building, (String)"JAR_ENABLED") && !StringUtil.isEmpty((String)jarPath);
                String explodedPath = VfsUtilCore.urlToPath((String)JDOMExternalizer.readString((Element)building, (String)"EXPLODED_URL"));
                boolean bl = explodedEnabled = JDOMExternalizer.readBoolean((Element)building, (String)"EXPLODED_ENABLED") && !StringUtil.isEmpty((String)explodedPath);
                if (explodedEnabled || jarEnabled) {
                    LOG.debug("exploded artifact will be created for " + facetPointer);
                    this.myConverter.registerExplodedArtifact(facetPointer, explodedEnabled ? this.myConverter.expandModuleMacros(explodedPath, moduleSettings) : null);
                } else {
                    this.myConverter.registerFacetWithoutOutput(facetPointer);
                }
                if (jarEnabled) {
                    LOG.debug("archive artifact will be created for " + facetPointer);
                    this.myConverter.registerArchiveArtifact(facetPointer, this.myConverter.expandModuleMacros(jarPath, moduleSettings));
                }
                if ((excludeExploded = JDOMExternalizer.readBoolean((Element)building, (String)"EXCLUDE_EXPLODED_DIRECTORY")) && !StringUtil.isEmpty((String)explodedPath)) {
                    File explodedDirectory = new File(FileUtil.toSystemDependentName((String)moduleSettings.expandPath(explodedPath)));
                    moduleSettings.addExcludedFolder(explodedDirectory);
                }
            }
            if ((packaging = configuration.getChild("packaging")) == null) continue;
            PackagingConversionUtil.processPackagingElements(packaging, moduleSettings, this.myConverter.getContext(), new ContainerElementProcessor(){

                @Override
                public void processFacetLink(@NotNull String facetId, @Nullable String outputPath, @NotNull PackagingMethod packagingMethod) {
                    if (facetId == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (packagingMethod == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    JavaeeFacetConversionProcessor.this.myConverter.registerIncludedFacet(facetPointer, facetId);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "facetId";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "packagingMethod";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/javaee/converting/artifacts/JavaeeFacetConversionProcessor$1";
                    objectArray[2] = "processFacetLink";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    private static List<Element> getJavaeeFacetElements(ModuleSettings moduleSettings) {
        ArrayList<Element> result = new ArrayList<Element>();
        result.addAll(moduleSettings.getFacetElements("web"));
        result.addAll(moduleSettings.getFacetElements("ejb"));
        result.addAll(moduleSettings.getFacetElements("javaeeApplication"));
        return result;
    }

    public void process(ModuleSettings moduleSettings) throws CannotConvertException {
        Element configuration;
        Element settingElement;
        Element configuration2;
        Element settingsElement;
        String targetFacetForJpa = null;
        String jpaPointer = null;
        Element jpaFacet = moduleSettings.getFacetElement("jpa");
        if (jpaFacet != null && (settingsElement = JDomConvertingUtil.getSettingsElement((Element)(configuration2 = jpaFacet.getChild("configuration")), (String)"targe-facet")) != null) {
            targetFacetForJpa = JDomConvertingUtil.getSettingsValue((Element)settingsElement);
            jpaPointer = PackagingConversionUtil.getFacetPointer(moduleSettings, jpaFacet);
            configuration2.removeContent((Content)settingsElement);
        }
        String gwtFacetPointer = null;
        String targetFacetForGwt = null;
        Element gwtFacet = moduleSettings.getFacetElement("gwt");
        if (gwtFacet != null && (settingElement = JDomConvertingUtil.getSettingsElement((Element)(configuration = gwtFacet.getChild("configuration")), (String)"webFacet")) != null) {
            targetFacetForGwt = JDomConvertingUtil.getSettingsValue((Element)settingElement);
            gwtFacetPointer = PackagingConversionUtil.getFacetPointer(moduleSettings, gwtFacet);
        }
        for (Element facetElement : JavaeeFacetConversionProcessor.getJavaeeFacetElements(moduleSettings)) {
            Element element;
            String facetPointer = PackagingConversionUtil.getFacetPointer(moduleSettings, facetElement);
            Element configuration3 = facetElement.getChild("configuration");
            Element root = this.myConverter.getOrCreateRootElement(facetPointer);
            Element external = this.myConverter.getOrCreateExternalElement(facetPointer);
            PackagingConversionUtil.addFacetResources(root, facetPointer);
            if ("ejb".equals(FacetPointersManager.getFacetType((String)facetPointer))) {
                if (JavaeeFacetConversionProcessor.isFacetHasSpecificSourceRoots(moduleSettings, configuration3, "ejbRoots")) {
                    PackagingConversionUtil.addFacetClasses(root, facetPointer);
                } else {
                    PackagingConversionUtil.addModuleOutput(root, moduleSettings.getModuleName());
                }
            }
            Element descriptorsElement = configuration3.getChild("descriptors");
            this.convertCustomDescriptors(descriptorsElement, moduleSettings, root);
            Element packaging = configuration3.getChild("packaging");
            if (packaging != null) {
                PackagingConversionUtil.processPackagingElements(packaging, moduleSettings, this.myConverter.getContext(), new MyContainerElementProcessor(root, external, facetPointer, moduleSettings, this.myConverter, configuration3));
            }
            String facetName = FacetPointersManager.getFacetName((String)facetPointer);
            if (targetFacetForJpa != null && targetFacetForJpa.equals(facetName)) {
                element = PackagingConversionUtil.createPackagingElement("jpa-descriptors");
                element.setAttribute("facet", jpaPointer);
                Element parent = "web".equals(FacetPointersManager.getFacetType((String)facetPointer)) ? PackagingConversionUtil.getOrCreateDirectory(root, "WEB-INF/classes") : root;
                parent.addContent(element);
            }
            if (targetFacetForGwt != null && targetFacetForGwt.equals(facetName)) {
                element = PackagingConversionUtil.createPackagingElement("gwt-compiler-output");
                element.setAttribute("facet", gwtFacetPointer);
                root.addContent(element);
            }
            configuration3.removeChild("packaging");
            configuration3.removeChild("building");
        }
    }

    private void convertCustomDescriptors(@Nullable Element descriptorsElement, ModuleSettings moduleSettings, Element root) {
        if (descriptorsElement == null) {
            return;
        }
        ArrayList descriptors = new ArrayList(JDOMUtil.getChildren((Element)descriptorsElement, (String)CUSTOM_DESCRIPTOR_ELEMENT_NAME));
        for (Element descriptor : descriptors) {
            String url = descriptor.getAttributeValue(DESCRIPTOR_URL_ATTRIBUTE);
            String directory = JDomConvertingUtil.getOptionValue((Element)descriptor, (String)DEFAULT_DIR_OPTION);
            if (directory == null || url == null) continue;
            String path = VfsUtilCore.urlToPath((String)url);
            File file = new File(FileUtil.toSystemDependentName((String)moduleSettings.expandPath(path)));
            Element parent = PackagingConversionUtil.getOrCreateDirectory(root, directory);
            String collapsedPath = this.myConverter.expandModuleMacros(path, moduleSettings);
            if (file.isDirectory()) {
                PackagingConversionUtil.addDirectoryCopy(PackagingConversionUtil.getOrCreateDirectory(parent, file.getName()), collapsedPath);
            } else {
                PackagingConversionUtil.addFileCopy(parent, collapsedPath, null);
            }
            descriptorsElement.removeContent((Content)descriptor);
        }
    }

    private static boolean isFacetHasSpecificSourceRoots(ModuleSettings moduleSettings, Element configuration, String sourceRootsElementName) {
        Element sourceRootsElement = configuration.getChild(sourceRootsElementName);
        if (sourceRootsElement == null) {
            return false;
        }
        Collection moduleSourceRoots = moduleSettings.getSourceRoots(false);
        List roots = JDOMUtil.getChildren((Element)sourceRootsElement, (String)"root");
        HashSet<String> paths = new HashSet<String>();
        for (Element rootElement : roots) {
            String url = moduleSettings.expandPath(rootElement.getAttributeValue(DESCRIPTOR_URL_ATTRIBUTE));
            paths.add(FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)url)));
        }
        for (File moduleRoot : moduleSourceRoots) {
            if (paths.contains(moduleRoot.getAbsolutePath())) continue;
            return true;
        }
        return false;
    }

    public void postProcess(ModuleSettings moduleSettings) throws CannotConvertException {
        for (Element element : JavaeeFacetConversionProcessor.getJavaeeFacetElements(moduleSettings)) {
            String facetPointer = PackagingConversionUtil.getFacetPointer(moduleSettings, element);
            List<String> classpath = this.myConverter.getClasspath(facetPointer);
            if (classpath == null || classpath.isEmpty()) continue;
            JavaeeFacetConversionProcessor.createManifestFile(moduleSettings, facetPointer, element, classpath);
        }
    }

    private static void createManifestFile(ModuleSettings moduleSettings, String facetPointer, Element facetElement, List<String> classpath) {
        File directory = JavaeeFacetConversionProcessor.getDirectoryForManifest(facetPointer, moduleSettings, facetElement);
        if (directory == null) {
            LOG.info("directory for manifest file not found for facet '" + facetPointer + "'");
            return;
        }
        LOG.debug("creating manifest.mf file in " + directory.getAbsolutePath() + ", classpath = " + classpath);
        PackagingConversionUtil.updateManifestFile(directory, classpath, null);
    }

    @Nullable
    private static File getDirectoryForManifest(String facetPointer, ModuleSettings moduleSettings, Element facetElement) {
        Element configurationElement = facetElement.getChild("configuration");
        if (configurationElement == null) {
            return null;
        }
        if ("ejb".equals(FacetPointersManager.getFacetType((String)facetPointer))) {
            Element root;
            Element roots = configurationElement.getChild("ejbRoots");
            if (roots != null && (root = roots.getChild("root")) != null) {
                String url = root.getAttributeValue(DESCRIPTOR_URL_ATTRIBUTE);
                return new File(FileUtil.toSystemDependentName((String)moduleSettings.expandPath(VfsUtilCore.urlToPath((String)url))));
            }
            return (File)ContainerUtil.getFirstItem((Collection)moduleSettings.getSourceRoots(false), null);
        }
        if ("web".equals(FacetPointersManager.getFacetType((String)facetPointer))) {
            Element webRoots = configurationElement.getChild("webroots");
            for (Element rootElement : JDOMUtil.getChildren((Element)webRoots, (String)"root")) {
                String relativePath = rootElement.getAttributeValue("relative");
                if (PathUtil.getFileName((String)relativePath).length() != 0) continue;
                String path = VfsUtilCore.urlToPath((String)rootElement.getAttributeValue(DESCRIPTOR_URL_ATTRIBUTE));
                return new File(FileUtil.toSystemDependentName((String)moduleSettings.expandPath(path)));
            }
        }
        return null;
    }

    private static class MyContainerElementProcessor
    extends ContainerElementProcessorBase<JavaeePackagingConverter> {
        private final String myFacetPointer;
        private final Element myFacetConfiguration;

        public MyContainerElementProcessor(Element root, Element external, String facetPointer, ModuleSettings moduleSettings, JavaeePackagingConverter converter, Element configuration) {
            super(root, external, moduleSettings, converter);
            this.myFacetPointer = facetPointer;
            this.myFacetConfiguration = configuration;
        }

        @Override
        protected List<String> getOrCreateClasspath() {
            return ((JavaeePackagingConverter)this.myConverter).getOrCreateClasspath(this.myFacetPointer);
        }

        @Override
        public void processFacetLink(@NotNull String facetId, @Nullable String outputPath, @NotNull PackagingMethod packagingMethod) {
            if (facetId == null) {
                MyContainerElementProcessor.$$$reportNull$$$0(0);
            }
            if (packagingMethod == null) {
                MyContainerElementProcessor.$$$reportNull$$$0(1);
            }
            if (outputPath == null || FacetPointersManager.getFacetType((String)facetId).equals(FacetPointersManager.getFacetType((String)this.myFacetPointer)) && packagingMethod == PackagingMethod.INCLUDE_MODULE_IN_BUILD) {
                outputPath = "";
            }
            this.addToClasspath(packagingMethod, outputPath);
            Element parent = PackagingConversionUtil.getOrCreateParent(this.myRoot, this.myExternal, outputPath, packagingMethod);
            ArtifactState state = ((JavaeePackagingConverter)this.myConverter).getExplodedArtifact(facetId);
            if (state != null) {
                PackagingConversionUtil.addArtifact(parent, state.getName());
            } else {
                ((JavaeePackagingConverter)this.myConverter).include(parent, ((JavaeePackagingConverter)this.myConverter).getOrCreateRootElement(facetId));
            }
            Element external = ((JavaeePackagingConverter)this.myConverter).getOrCreateExternalElement(facetId);
            Element externalPlace = PackagingConversionUtil.getParentPlace(this.myRoot, external, outputPath);
            ((JavaeePackagingConverter)this.myConverter).include(externalPlace, external);
        }

        @Override
        public void processModuleLink(@NotNull String moduleName, @NotNull String outputPath, @NotNull PackagingMethod packagingMethod) {
            if (moduleName == null) {
                MyContainerElementProcessor.$$$reportNull$$$0(2);
            }
            if (outputPath == null) {
                MyContainerElementProcessor.$$$reportNull$$$0(3);
            }
            if (packagingMethod == null) {
                MyContainerElementProcessor.$$$reportNull$$$0(4);
            }
            this.addToClasspath(packagingMethod, outputPath);
            Element parent = PackagingConversionUtil.getOrCreateParent(this.myRoot, this.myExternal, outputPath, packagingMethod);
            if ("web".equals(FacetPointersManager.getFacetType((String)this.myFacetPointer)) && FacetPointersManager.getModuleName((String)this.myFacetPointer).equals(moduleName) && JavaeeFacetConversionProcessor.isFacetHasSpecificSourceRoots(this.myModuleSettings, this.myFacetConfiguration, "sourceRoots")) {
                PackagingConversionUtil.addFacetClasses(parent, this.myFacetPointer);
            } else {
                PackagingConversionUtil.addModuleOutput(parent, moduleName);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "facetId";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packagingMethod";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputPath";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/javaee/converting/artifacts/JavaeeFacetConversionProcessor$MyContainerElementProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processFacetLink";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processModuleLink";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

