/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.toolwindow.view.panels;

import com.intellij.javaee.toolwindow.view.JavaeeViewFrameworkProvider;
import com.intellij.javaee.toolwindow.view.panels.FrameworksFinderRecursivePanel;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesAlphaComparator;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.ui.FinderRecursivePanel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModulesPanel
extends FinderRecursivePanel<Module> {
    @NotNull
    private final DefaultActionGroup myActions;
    private JavaeeViewFrameworkProvider myProvider;

    public ModulesPanel(Project project, @NotNull DefaultActionGroup actions) {
        if (actions == null) {
            ModulesPanel.$$$reportNull$$$0(0);
        }
        super(project, "JavaeeViewModulesPanel");
        this.myActions = actions;
    }

    public ModulesPanel(FinderRecursivePanel panel, JavaeeViewFrameworkProvider provider, @NotNull DefaultActionGroup actions) {
        if (actions == null) {
            ModulesPanel.$$$reportNull$$$0(1);
        }
        super(panel);
        this.myProvider = provider;
        this.myActions = actions;
    }

    @NotNull
    protected List<Module> getListItems() {
        Module[] modules;
        ArrayList<Module> items = new ArrayList<Module>();
        for (Module module : modules = ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            if (!this.isRootPanel() && (this.myProvider == null || !this.myProvider.isAvailable(module))) continue;
            items.add(module);
        }
        Collections.sort(items, ModulesAlphaComparator.INSTANCE);
        ArrayList<Module> arrayList = items;
        if (arrayList == null) {
            ModulesPanel.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    protected String getItemText(Module module) {
        String string = module.getName();
        if (string == null) {
            ModulesPanel.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    protected Icon getItemIcon(Module module) {
        return ModuleType.get((Module)module).getIcon();
    }

    protected boolean performEditAction() {
        Module module = (Module)this.getSelectedValue();
        assert (module != null);
        ModulesConfigurator.showDialog((Project)this.getProject(), (String)module.getName(), null);
        return true;
    }

    @Nullable
    protected JComponent createRightComponent(Module module) {
        return this.isRootPanel() ? new FrameworksFinderRecursivePanel(this, module, this.myActions) : this.myProvider.createModuleView(this, module, this.myActions);
    }

    protected boolean hasChildren(Module module) {
        if (this.isRootPanel()) {
            for (JavaeeViewFrameworkProvider frameworkProvider : (JavaeeViewFrameworkProvider[])Extensions.getExtensions(JavaeeViewFrameworkProvider.EXTENSION_POINT_NAME)) {
                if (!frameworkProvider.isAvailable(module)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/toolwindow/view/panels/ModulesPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/toolwindow/view/panels/ModulesPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getListItems";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

