/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web;

import com.intellij.ide.util.frameworkSupport.FrameworkVersion;
import com.intellij.ide.util.projectWizard.ProjectTemplateParameterFactory;
import com.intellij.ide.util.projectWizard.WizardInputField;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.facet.WebFacetFrameworkSupportProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class WebXmlVersionParameterFactory
extends ProjectTemplateParameterFactory {
    public static final String NO_DESCRIPTOR = "<no descriptor>";
    public static final String WEB_XML_VERSION = "WEB_XML_VERSION";
    static final String WEB_XML_VERSION_FILE = "WEB_XML_VERSION_FILE";

    public String getParameterId() {
        return WEB_XML_VERSION;
    }

    @Nullable
    public WizardInputField createField(String defaultValue) {
        return new WizardInputField(this.getParameterId(), defaultValue){
            final ComboBox myComboBox;
            {
                this.myComboBox = new ComboBox();
                List<FrameworkVersion> versions = new WebFacetFrameworkSupportProvider().getVersions();
                String defaultVersion = null;
                for (FrameworkVersion version : versions) {
                    this.myComboBox.addItem((Object)version.getVersionName());
                    if (!version.isDefault()) continue;
                    defaultVersion = version.getVersionName();
                }
                this.myComboBox.addItem((Object)WebXmlVersionParameterFactory.NO_DESCRIPTOR);
                this.myComboBox.setSelectedItem(defaultVersion);
            }

            public String getLabel() {
                return "Descriptor \u001bVersion";
            }

            public JComponent getComponent() {
                JPanel panel = new JPanel(new BorderLayout());
                panel.add((Component)this.myComboBox, "West");
                return panel;
            }

            public String getValue() {
                return (String)this.myComboBox.getSelectedItem();
            }

            public Map<String, String> getValues() {
                HashMap<String, String> map = new HashMap<String, String>(super.getValues());
                map.put(WebXmlVersionParameterFactory.WEB_XML_VERSION_FILE, this.getValue().replace('.', '_'));
                return map;
            }

            public boolean acceptFile(File file) {
                return !"web.xml".equals(file.getName()) || !WebXmlVersionParameterFactory.NO_DESCRIPTOR.equals(this.getValue());
            }

            public void setValue(String value) {
                this.myComboBox.setSelectedItem((Object)value);
            }
        };
    }

    @Nullable
    public String detectParameterValue(Project project) {
        WebApp root;
        Module module = ModuleManager.getInstance((Project)project).getModules()[0];
        Collection instances = WebFacet.getInstances((Module)module);
        if (!instances.isEmpty() && (root = ((WebFacet)instances.iterator().next()).getRoot()) != null) {
            return root.getVersion().getStringValue();
        }
        return null;
    }
}

