/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.run.localRun;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.javaee.run.localRun.ExecutableObject;
import com.intellij.javaee.run.localRun.ScriptUtil;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CommandLineExecutableObject
implements ExecutableObject {
    private final String[] myParameters;
    @NonNls
    private static final String CLASSPATH_VAR_NAME = "CLASSPATH";

    public CommandLineExecutableObject(@NonNls String[] parameters, @NonNls String programParameters) {
        this.myParameters = CommandLineExecutableObject.getParameters(parameters, programParameters);
    }

    @Override
    public String getDisplayString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.myParameters.length; ++i) {
            if (i > 0) {
                result.append(" ");
            }
            String parameter = this.myParameters[i];
            result.append(parameter);
        }
        return result.toString();
    }

    protected GeneralCommandLine createCommandLine(String[] parameters, Map<String, String> envVariables) {
        return ScriptUtil.createCommandLine(parameters);
    }

    @Override
    public OSProcessHandler createProcessHandler(String workingDirectory, Map<String, String> envVariables) throws ExecutionException {
        File parentFile;
        GeneralCommandLine commandLine = this.createCommandLine(this.myParameters, envVariables);
        if (workingDirectory == null && this.myParameters.length > 0 && (parentFile = new File(this.myParameters[0]).getParentFile()) != null) {
            workingDirectory = parentFile.getAbsolutePath();
        }
        commandLine.withWorkDirectory(workingDirectory);
        commandLine.withEnvironment(CLASSPATH_VAR_NAME, "");
        commandLine.withEnvironment(envVariables);
        return this.createProcessHandler(commandLine);
    }

    @NotNull
    protected OSProcessHandler createProcessHandler(GeneralCommandLine commandLine) throws ExecutionException {
        OSProcessHandler oSProcessHandler = new OSProcessHandler(commandLine);
        if (oSProcessHandler == null) {
            CommandLineExecutableObject.$$$reportNull$$$0(0);
        }
        return oSProcessHandler;
    }

    public String[] getParameters() {
        return this.myParameters;
    }

    private static String[] getParameters(String[] parameters, String programParameters) {
        ArrayList<String> result = new ArrayList<String>();
        for (String parameter : parameters) {
            if (parameter == null || parameter.trim().length() <= 0) continue;
            result.add(parameter.trim());
        }
        if (programParameters != null && programParameters.trim().length() > 0) {
            String[] programParametersArray;
            for (String s : programParametersArray = ParametersList.parse((String)programParameters)) {
                if (s == null || s.trim().length() <= 0) continue;
                result.add(s.trim());
            }
        }
        return ArrayUtil.toStringArray(result);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/run/localRun/CommandLineExecutableObject", "createProcessHandler"));
    }
}

