/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling;

import java.io.File;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorMessageBuilder {
    public static final String GROUP_TAG = "<ij_msg_gr>";
    public static final String NAV_TAG = "<ij_nav>";
    public static final String EOL_TAG = "<eol>";
    @NotNull
    private final Project myProject;
    @Nullable
    private final Exception myException;
    @NotNull
    private final String myGroup;
    @Nullable
    private String myDescription;

    private ErrorMessageBuilder(@NotNull Project project, @Nullable Exception exception, @NotNull String group) {
        if (project == null) {
            ErrorMessageBuilder.$$$reportNull$$$0(0);
        }
        if (group == null) {
            ErrorMessageBuilder.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myException = exception;
        this.myGroup = group;
    }

    public static ErrorMessageBuilder create(@NotNull Project project, @NotNull String group) {
        if (project == null) {
            ErrorMessageBuilder.$$$reportNull$$$0(2);
        }
        if (group == null) {
            ErrorMessageBuilder.$$$reportNull$$$0(3);
        }
        return new ErrorMessageBuilder(project, null, group);
    }

    public static ErrorMessageBuilder create(@NotNull Project project, @Nullable Exception exception, @NotNull String group) {
        if (project == null) {
            ErrorMessageBuilder.$$$reportNull$$$0(4);
        }
        if (group == null) {
            ErrorMessageBuilder.$$$reportNull$$$0(5);
        }
        return new ErrorMessageBuilder(project, exception, group);
    }

    public ErrorMessageBuilder withDescription(@NotNull String description) {
        if (description == null) {
            ErrorMessageBuilder.$$$reportNull$$$0(6);
        }
        this.myDescription = description;
        return this;
    }

    public String build() {
        String group = this.myGroup.replaceAll("\r\n|\n\r|\n|\r", " ");
        File projectBuildFile = this.myProject.getBuildFile();
        return GROUP_TAG + group + GROUP_TAG + (projectBuildFile != null ? NAV_TAG + projectBuildFile.getPath() + NAV_TAG : "") + ("<i><b>" + this.myProject + (this.myDescription != null ? ": " + this.myDescription : "") + "</b>" + (this.myException != null ? "\nDetails: " + ErrorMessageBuilder.getErrorMessage(this.myException) : "") + "</i>").replaceAll("\r\n|\n\r|\n|\r", EOL_TAG);
    }

    private static String getErrorMessage(@NotNull Throwable e) {
        if (e == null) {
            ErrorMessageBuilder.$$$reportNull$$$0(7);
        }
        StringBuilder buf = new StringBuilder();
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            if (buf.length() != 0) {
                buf.append("\nCaused by: ");
            }
            buf.append(cause.getClass().getName()).append(": ").append(cause.getMessage());
        }
        return buf.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/gradle/tooling/ErrorMessageBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "withDescription";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getErrorMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

