/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleUrlProvider
implements SMTestLocator {
    public static final String PROTOCOL_ID = "gradle";
    public static final String METHOD_PREF = "methodName";
    public static final String CLASS_PREF = "className";
    public static final GradleUrlProvider INSTANCE = new GradleUrlProvider();

    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (protocol == null) {
            GradleUrlProvider.$$$reportNull$$$0(0);
        }
        if (path == null) {
            GradleUrlProvider.$$$reportNull$$$0(1);
        }
        if (project == null) {
            GradleUrlProvider.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            GradleUrlProvider.$$$reportNull$$$0(3);
        }
        if (!PROTOCOL_ID.equals(protocol)) {
            List<Location> list = Collections.emptyList();
            if (list == null) {
                GradleUrlProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        String className = GradleUrlProvider.extractFullClassName(path);
        if (className == null) {
            List<Location> list = Collections.emptyList();
            if (list == null) {
                GradleUrlProvider.$$$reportNull$$$0(5);
            }
            return list;
        }
        PsiClass testClass = JavaPsiFacade.getInstance((Project)project).findClass(className.replace('$', '.'), GlobalSearchScope.allScope((Project)project));
        if (testClass == null) {
            List<Location> list = Collections.emptyList();
            if (list == null) {
                GradleUrlProvider.$$$reportNull$$$0(6);
            }
            return list;
        }
        String methodName = GradleUrlProvider.extractMethodName(path);
        if (methodName == null) {
            List<PsiLocation> list = Collections.singletonList(new PsiLocation(project, (PsiElement)testClass));
            if (list == null) {
                GradleUrlProvider.$$$reportNull$$$0(7);
            }
            return list;
        }
        PsiMethod[] methods = testClass.findMethodsByName(methodName, true);
        ArrayList<Location> list = new ArrayList<Location>(methods.length);
        for (PsiMethod method : methods) {
            list.add((Location)new PsiLocation(project, (PsiElement)method));
        }
        ArrayList<Location> arrayList = list;
        if (arrayList == null) {
            GradleUrlProvider.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @Nullable
    private static String extractFullClassName(String locationData) {
        int i = locationData.indexOf("::");
        String pref = locationData.substring(0, i);
        String qualifiedName = locationData.substring(i + 2);
        if (METHOD_PREF.equals(pref)) {
            int dot = qualifiedName.indexOf("::");
            return dot == -1 ? null : qualifiedName.substring(0, dot);
        }
        if (CLASS_PREF.equals(pref)) {
            return qualifiedName;
        }
        return null;
    }

    @Nullable
    private static String extractMethodName(String locationData) {
        int i = locationData.indexOf("::");
        String pref = locationData.substring(0, i);
        String qualifiedName = locationData.substring(i + 2);
        if (METHOD_PREF.equals(pref)) {
            int dot = qualifiedName.indexOf("::");
            return dot == -1 ? null : qualifiedName.substring(dot + 2);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/execution/test/runner/GradleUrlProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/execution/test/runner/GradleUrlProvider";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

