/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer.arsc;

import com.android.tools.idea.apk.viewer.BinaryXmlParser;
import com.google.common.collect.ImmutableList;
import com.google.devrel.gmscore.tools.apk.arsc.BinaryResourceIdentifier;
import com.google.devrel.gmscore.tools.apk.arsc.BinaryResourceValue;
import com.google.devrel.gmscore.tools.apk.arsc.PackageChunk;
import com.google.devrel.gmscore.tools.apk.arsc.StringPoolChunk;
import com.google.devrel.gmscore.tools.apk.arsc.TypeChunk;
import com.google.devrel.gmscore.tools.apk.arsc.TypeSpecChunk;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;

public class ResourceTypeTableModel
extends AbstractTableModel {
    private final StringPoolChunk myStringPool;
    private final PackageChunk myPackageChunk;
    private final TypeSpecChunk myTypeSpec;
    private final List<TypeChunk> myTypes;

    public ResourceTypeTableModel(@NotNull StringPoolChunk stringPool, @NotNull PackageChunk packageChunk, @NotNull TypeSpecChunk typeSpec) {
        if (stringPool == null) {
            ResourceTypeTableModel.$$$reportNull$$$0(0);
        }
        if (packageChunk == null) {
            ResourceTypeTableModel.$$$reportNull$$$0(1);
        }
        if (typeSpec == null) {
            ResourceTypeTableModel.$$$reportNull$$$0(2);
        }
        this.myStringPool = stringPool;
        this.myPackageChunk = packageChunk;
        this.myTypeSpec = typeSpec;
        this.myTypes = ImmutableList.copyOf((Collection)packageChunk.getTypeChunks(typeSpec.getId()));
    }

    @Override
    public int getRowCount() {
        return this.myTypeSpec.getResourceCount();
    }

    @Override
    public int getColumnCount() {
        return this.myTypes.size() + 2;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col == 0) {
            BinaryResourceIdentifier id = BinaryResourceIdentifier.create((int)this.myPackageChunk.getId(), (int)this.myTypeSpec.getId(), (int)row);
            return id.toString();
        }
        if (col == 1) {
            String key = "unknown";
            for (TypeChunk type : this.myTypes) {
                TypeChunk.Entry entry = (TypeChunk.Entry)type.getEntries().get(row);
                if (entry == null) continue;
                key = entry.key();
                break;
            }
            return key;
        }
        TypeChunk typeChunk = this.myTypes.get(col - 2);
        if (typeChunk.getEntries().containsKey(row)) {
            TypeChunk.Entry entry = (TypeChunk.Entry)typeChunk.getEntries().get(row);
            BinaryResourceValue value = entry.value();
            if (value != null) {
                return this.formatValue(value);
            }
            Map values = entry.values();
            if (values != null) {
                return values.values().stream().map(this::formatValue).collect(Collectors.joining(", "));
            }
            return "?";
        }
        return "";
    }

    @NotNull
    private String formatValue(@NotNull BinaryResourceValue value) {
        if (value == null) {
            ResourceTypeTableModel.$$$reportNull$$$0(3);
        }
        if (value.type() == BinaryResourceValue.Type.STRING) {
            String string = this.myStringPool.getString(value.data());
            if (string == null) {
                ResourceTypeTableModel.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = BinaryXmlParser.formatValue(value, this.myStringPool);
        if (string == null) {
            ResourceTypeTableModel.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "ID";
        }
        if (column == 1) {
            return "Name";
        }
        TypeChunk typeChunk = this.myTypes.get(column - 2);
        return typeChunk.getConfiguration().toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringPool";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageChunk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSpec";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/viewer/arsc/ResourceTypeTableModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/viewer/arsc/ResourceTypeTableModel";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "formatValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "formatValue";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

