/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.devices.Device;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.avdmanager.DeviceUiAction;
import com.google.common.collect.Lists;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ImportDevicesAction
extends DeviceUiAction {
    public ImportDevicesAction(@NotNull DeviceUiAction.DeviceProvider provider) {
        if (provider == null) {
            ImportDevicesAction.$$$reportNull$$$0(0);
        }
        super(provider, "Import Hardware Profiles");
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, true);
        String homePath = System.getProperty("user.home");
        File parentPath = homePath == null ? new File("/") : new File(homePath);
        VirtualFile parent = LocalFileSystem.getInstance().findFileByIoFile(parentPath);
        VirtualFile[] files = FileChooserFactory.getInstance().createFileChooser(descriptor, null, null).choose(parent, null);
        ArrayList importedDevices = Lists.newArrayList();
        for (VirtualFile vf : files) {
            for (Device d : DeviceManagerConnection.getDevicesFromFile(VfsUtilCore.virtualToIoFile((VirtualFile)vf))) {
                importedDevices.add(d);
            }
        }
        if (!importedDevices.isEmpty()) {
            DeviceManagerConnection.getDefaultDeviceManagerConnection().createDevices(importedDevices);
            this.myProvider.refreshDevices();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/android/tools/idea/avdmanager/ImportDevicesAction", "<init>"));
    }
}

