/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd;

import com.android.ddmlib.IDevice;
import com.android.tools.fd.client.InstantRunBuildInfo;
import com.android.tools.idea.ddms.DevicePropertyUtil;
import com.android.tools.idea.fd.InstantRunBuildProgressListener;
import com.android.tools.idea.fd.LogcatRecorder;
import com.android.tools.idea.logcat.AndroidLogcatService;
import com.android.tools.idea.run.AndroidDevice;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class FlightRecorder {
    private static final String FD_FLR_LOGS = "flr";
    private static final String FN_GRADLE_LOG = "build.log";
    private static final String FN_GRADLE_PROFILE = "profile.log";
    private static final String FN_BUILD_INFO = "build-info.xml";
    private static final int MAX_LOG_ENTRY_COUNT = 10;
    private final Path myBasePath;
    private final LogcatRecorder myLogcatRecorder;
    private LocalDateTime myTimestamp;

    public static FlightRecorder get(@NotNull Project project) {
        if (project == null) {
            FlightRecorder.$$$reportNull$$$0(0);
        }
        return (FlightRecorder)ServiceManager.getService((Project)project, FlightRecorder.class);
    }

    private FlightRecorder(@NotNull Project project) {
        if (project == null) {
            FlightRecorder.$$$reportNull$$$0(1);
        }
        Path logs = Paths.get(PathManager.getLogPath(), new String[0]);
        Path flr = Paths.get(FD_FLR_LOGS, project.getLocationHash());
        this.myBasePath = logs.resolve(flr);
        this.myLogcatRecorder = new LogcatRecorder(AndroidLogcatService.getInstance());
    }

    public void saveBuildOutput(@NotNull String gradleOutput, @NotNull InstantRunBuildProgressListener instantRunProgressListener) {
        if (gradleOutput == null) {
            FlightRecorder.$$$reportNull$$$0(2);
        }
        if (instantRunProgressListener == null) {
            FlightRecorder.$$$reportNull$$$0(3);
        }
        this.myTimestamp = FlightRecorder.now();
        ApplicationManager.getApplication().executeOnPooledThread((Runnable)new BuildOutputRecorderTask(this.myBasePath, this.myTimestamp, gradleOutput, instantRunProgressListener));
    }

    public void saveBuildInfo(@NotNull InstantRunBuildInfo instantRunBuildInfo) {
        if (instantRunBuildInfo == null) {
            FlightRecorder.$$$reportNull$$$0(4);
        }
        if (this.myTimestamp == null) {
            this.myTimestamp = FlightRecorder.now();
        }
        ApplicationManager.getApplication().executeOnPooledThread((Runnable)new BuildInfoRecorderTask(this.myBasePath, this.myTimestamp, instantRunBuildInfo));
    }

    public void setLaunchTarget(@NotNull AndroidDevice device) {
        if (device == null) {
            FlightRecorder.$$$reportNull$$$0(5);
        }
        try {
            Path deviceLog = this.myBasePath.resolve(FlightRecorder.timeStampToFolder(this.myTimestamp)).resolve(FlightRecorder.getDeviceLogFileName(device));
            Files.write(deviceLog, new byte[0], new OpenOption[0]);
        }
        catch (IOException e) {
            Logger.getInstance(FlightRecorder.class).info("Unable to record deployment device info", (Throwable)e);
        }
        if (device.getLaunchedDevice().isDone()) {
            try {
                IDevice d = (IDevice)device.getLaunchedDevice().get();
                this.myLogcatRecorder.startMonitoring(d, this.myTimestamp);
            }
            catch (InterruptedException | ExecutionException e) {
                Logger.getInstance(FlightRecorder.class).info("Unable to start recording logcat", (Throwable)e);
            }
        }
    }

    private static String getDeviceLogFileName(@NotNull AndroidDevice device) {
        IDevice d;
        if (device == null) {
            FlightRecorder.$$$reportNull$$$0(6);
        }
        if (device.isVirtual()) {
            return "TARGET-AVD";
        }
        ListenableFuture<IDevice> launchedDevice = device.getLaunchedDevice();
        if (!launchedDevice.isDone()) {
            return "OFFLINE";
        }
        try {
            d = (IDevice)launchedDevice.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return "OFFLINE";
        }
        return DevicePropertyUtil.getManufacturer(d, "unknown").replace(' ', '.') + '-' + DevicePropertyUtil.getModel(d, "unknown").replace(' ', '.');
    }

    @NotNull
    private static LocalDateTime now() {
        LocalDateTime localDateTime = LocalDateTime.now().truncatedTo(ChronoUnit.SECONDS);
        if (localDateTime == null) {
            FlightRecorder.$$$reportNull$$$0(7);
        }
        return localDateTime;
    }

    @NotNull
    static String timeStampToFolder(@NotNull LocalDateTime dateTime) {
        if (dateTime == null) {
            FlightRecorder.$$$reportNull$$$0(8);
        }
        String string = dateTime.truncatedTo(ChronoUnit.SECONDS).toString().replace(':', '.');
        if (string == null) {
            FlightRecorder.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    static LocalDateTime folderToTimeStamp(@NotNull Path path) {
        if (path == null) {
            FlightRecorder.$$$reportNull$$$0(10);
        }
        String fileName = path.getFileName().toString();
        LocalDateTime localDateTime = LocalDateTime.parse(fileName.replace('.', ':'));
        if (localDateTime == null) {
            FlightRecorder.$$$reportNull$$$0(11);
        }
        return localDateTime;
    }

    static void trimOldLogs(@NotNull Path root, int count) {
        ArrayList allLogs;
        if (root == null) {
            FlightRecorder.$$$reportNull$$$0(12);
        }
        DirectoryStream.Filter<Path> filter = entry -> {
            if (!Files.isDirectory(entry, new LinkOption[0])) {
                return false;
            }
            try {
                FlightRecorder.folderToTimeStamp(entry);
                return true;
            }
            catch (DateTimeParseException e) {
                return false;
            }
        };
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(root, filter);){
            allLogs = Lists.newArrayList(stream.iterator());
        }
        catch (IOException e) {
            Logger.getInstance(FlightRecorder.class).warn("Unable to cleanup flight recorder logs", (Throwable)e);
            return;
        }
        allLogs.stream().sorted((p1, p2) -> FlightRecorder.folderToTimeStamp(p2).compareTo(FlightRecorder.folderToTimeStamp(p1))).skip(count).forEach(path -> {
            try {
                FileUtils.deleteDirectoryContents((File)path.toFile());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                Files.delete(path);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    @NotNull
    public List<Path> getAllLogs() {
        ArrayList<Path> logs = new ArrayList<Path>();
        Path logsHome = Paths.get(PathManager.getLogPath(), new String[0]);
        if (logsHome == null) {
            ArrayList<Path> arrayList = logs;
            if (arrayList == null) {
                FlightRecorder.$$$reportNull$$$0(13);
            }
            return arrayList;
        }
        logs.addAll(FlightRecorder.getIdeaLogs(logsHome));
        logs.addAll(this.getFlightRecorderLogs());
        Path logcatPath = logsHome.resolve("logcat.txt");
        try {
            Files.write(logcatPath, this.myLogcatRecorder.getLogs(), Charsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            logs.add(logcatPath);
        }
        catch (IOException e) {
            Logger.getInstance(FlightRecorder.class).info("Unexpected error saving logcat", (Throwable)e);
        }
        ArrayList<Path> arrayList = logs;
        if (arrayList == null) {
            FlightRecorder.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    /*
     * Loose catch block
     */
    @NotNull
    private static List<Path> getIdeaLogs(@NotNull Path logsHome) {
        List<Path> list;
        Throwable throwable;
        Stream<Path> stream;
        block17: {
            block18: {
                if (logsHome == null) {
                    FlightRecorder.$$$reportNull$$$0(15);
                }
                stream = Files.list(logsHome);
                throwable = null;
                list = stream.filter(p -> Files.isReadable(p) && p.getFileName().toString().startsWith("idea.log")).sorted((p1, p2) -> Long.compare(p2.toFile().lastModified(), p1.toFile().lastModified())).limit(3L).collect(Collectors.toList());
                if (stream == null) break block17;
                if (throwable == null) break block18;
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                break block17;
            }
            stream.close();
        }
        List<Path> list2 = list;
        if (list2 == null) {
            FlightRecorder.$$$reportNull$$$0(16);
        }
        return list2;
        {
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (stream != null) {
                            if (throwable != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                stream.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (IOException e) {
                    ImmutableList immutableList = ImmutableList.of();
                    if (immutableList == null) {
                        FlightRecorder.$$$reportNull$$$0(17);
                    }
                    return immutableList;
                }
            }
        }
    }

    @NotNull
    private List<Path> getFlightRecorderLogs() {
        ArrayList<Path> arrayList;
        try {
            final ArrayList<Path> list = new ArrayList<Path>(100);
            Files.walkFileTree(this.myBasePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path fileName = file.getFileName();
                    if (fileName != null && fileName.toString().startsWith(".")) {
                        return FileVisitResult.CONTINUE;
                    }
                    list.add(file);
                    return list.size() > 100 ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
                }
            });
            arrayList = list;
        }
        catch (IOException e) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                FlightRecorder.$$$reportNull$$$0(19);
            }
            return immutableList;
        }
        if (arrayList == null) {
            FlightRecorder.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    @NotNull
    public String getPresentablePath(@NotNull Path file) {
        if (file == null) {
            FlightRecorder.$$$reportNull$$$0(20);
        }
        if (file.startsWith(this.myBasePath)) {
            String string = this.myBasePath.relativize(file).toString();
            if (string == null) {
                FlightRecorder.$$$reportNull$$$0(21);
            }
            return string;
        }
        String string = file.getFileName().toString();
        if (string == null) {
            FlightRecorder.$$$reportNull$$$0(22);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleOutput";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instantRunProgressListener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instantRunBuildInfo";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/fd/FlightRecorder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dateTime";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logsHome";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/fd/FlightRecorder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "now";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "timeStampToFolder";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "folderToTimeStamp";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLogs";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeaLogs";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlightRecorderLogs";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentablePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "saveBuildOutput";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "saveBuildInfo";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setLaunchTarget";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDeviceLogFileName";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "timeStampToFolder";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "folderToTimeStamp";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "trimOldLogs";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getIdeaLogs";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPresentablePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class BuildInfoRecorderTask
    implements Runnable {
        private final Path myBasePath;
        private final InstantRunBuildInfo myBuildInfo;

        public BuildInfoRecorderTask(Path logsRoot, LocalDateTime dateTime, InstantRunBuildInfo instantRunBuildInfo) {
            this.myBasePath = logsRoot.resolve(FlightRecorder.timeStampToFolder(dateTime));
            this.myBuildInfo = instantRunBuildInfo;
        }

        @Override
        public void run() {
            try {
                Files.createDirectories(this.myBasePath, new FileAttribute[0]);
                try (BufferedWriter bw = Files.newBufferedWriter(this.myBasePath.resolve(FlightRecorder.FN_BUILD_INFO), Charsets.UTF_8, new OpenOption[0]);){
                    this.myBuildInfo.serializeTo((Writer)bw);
                }
            }
            catch (IOException e) {
                Logger.getInstance(FlightRecorder.class).info("Unable to build info", (Throwable)e);
            }
        }
    }

    private static class BuildOutputRecorderTask
    implements Runnable {
        private final Path myLogsRoot;
        private final Path myCurrentLogPath;
        private final String myGradleOutput;
        private final InstantRunBuildProgressListener myBuildProgressListener;

        private BuildOutputRecorderTask(@NotNull Path logsRoot, @NotNull LocalDateTime dateTime, @NotNull String gradleOuput, @NotNull InstantRunBuildProgressListener buildProgressListener) {
            if (logsRoot == null) {
                BuildOutputRecorderTask.$$$reportNull$$$0(0);
            }
            if (dateTime == null) {
                BuildOutputRecorderTask.$$$reportNull$$$0(1);
            }
            if (gradleOuput == null) {
                BuildOutputRecorderTask.$$$reportNull$$$0(2);
            }
            if (buildProgressListener == null) {
                BuildOutputRecorderTask.$$$reportNull$$$0(3);
            }
            this.myLogsRoot = logsRoot;
            this.myCurrentLogPath = logsRoot.resolve(FlightRecorder.timeStampToFolder(dateTime));
            this.myGradleOutput = gradleOuput;
            this.myBuildProgressListener = buildProgressListener;
        }

        @Override
        public void run() {
            this.saveCurrentLog();
            FlightRecorder.trimOldLogs(this.myLogsRoot, 10);
        }

        private void saveCurrentLog() {
            try {
                Files.createDirectories(this.myCurrentLogPath, new FileAttribute[0]);
                Files.write(this.myCurrentLogPath.resolve(FlightRecorder.FN_GRADLE_LOG), this.myGradleOutput.getBytes(Charsets.UTF_8), new OpenOption[0]);
                try (BufferedWriter bw = Files.newBufferedWriter(this.myCurrentLogPath.resolve(FlightRecorder.FN_GRADLE_PROFILE), Charsets.UTF_8, new OpenOption[0]);){
                    this.myBuildProgressListener.serializeTo(bw);
                }
            }
            catch (IOException e) {
                Logger.getInstance(FlightRecorder.class).info("Unable to save gradle output logs", (Throwable)e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "logsRoot";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dateTime";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "gradleOuput";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "buildProgressListener";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/fd/FlightRecorder$BuildOutputRecorderTask";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

