/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd;

import com.android.builder.model.OptionalCompilationStep;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.sdklib.AndroidVersion;
import com.android.tools.fd.client.AppState;
import com.android.tools.fd.client.InstantRunBuildInfo;
import com.android.tools.fd.client.InstantRunClient;
import com.android.tools.idea.fd.BuildCause;
import com.android.tools.idea.fd.BuildMode;
import com.android.tools.idea.fd.BuildSelection;
import com.android.tools.idea.fd.InstantRunContext;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.fd.InstantRunSettings;
import com.android.tools.idea.fd.InstantRunTasksProvider;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.run.BeforeRunBuilder;
import com.android.tools.idea.gradle.run.GradleTaskRunner;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.run.AndroidRunConfigContext;
import com.android.tools.idea.run.InstalledApkCache;
import com.android.tools.idea.run.InstalledPatchCache;
import com.android.tools.idea.run.util.MultiUserUtils;
import com.android.utils.ILogger;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.hash.HashCode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstantRunBuilder
implements BeforeRunBuilder {
    private static final Logger LOG = Logger.getInstance(InstantRunBuilder.class);
    @Nullable
    private final IDevice myDevice;
    private final InstantRunContext myInstantRunContext;
    private final AndroidRunConfigContext myRunContext;
    private final InstantRunTasksProvider myTasksProvider;
    private final InstalledApkCache myInstalledApkCache;
    private final InstantRunClientDelegate myInstantRunClientDelegate;
    private final boolean myFlightRecorderEnabled;

    public InstantRunBuilder(@Nullable IDevice device, @NotNull InstantRunContext instantRunContext, @NotNull AndroidRunConfigContext runConfigContext, @NotNull InstantRunTasksProvider tasksProvider) {
        if (instantRunContext == null) {
            InstantRunBuilder.$$$reportNull$$$0(0);
        }
        if (runConfigContext == null) {
            InstantRunBuilder.$$$reportNull$$$0(1);
        }
        if (tasksProvider == null) {
            InstantRunBuilder.$$$reportNull$$$0(2);
        }
        this(device, instantRunContext, runConfigContext, tasksProvider, InstantRunSettings.isRecorderEnabled(), (InstalledApkCache)ServiceManager.getService(InstalledApkCache.class), new InstantRunClientDelegate(){});
    }

    InstantRunBuilder(@Nullable IDevice device, @NotNull InstantRunContext instantRunContext, @NotNull AndroidRunConfigContext runConfigContext, @NotNull InstantRunTasksProvider tasksProvider, boolean enableFlightRecorder, @NotNull InstalledApkCache installedApkCache, @NotNull InstantRunClientDelegate delegate) {
        if (instantRunContext == null) {
            InstantRunBuilder.$$$reportNull$$$0(3);
        }
        if (runConfigContext == null) {
            InstantRunBuilder.$$$reportNull$$$0(4);
        }
        if (tasksProvider == null) {
            InstantRunBuilder.$$$reportNull$$$0(5);
        }
        if (installedApkCache == null) {
            InstantRunBuilder.$$$reportNull$$$0(6);
        }
        if (delegate == null) {
            InstantRunBuilder.$$$reportNull$$$0(7);
        }
        this.myDevice = device;
        this.myInstantRunContext = instantRunContext;
        this.myRunContext = runConfigContext;
        this.myTasksProvider = tasksProvider;
        this.myFlightRecorderEnabled = enableFlightRecorder;
        this.myInstalledApkCache = installedApkCache;
        this.myInstantRunClientDelegate = delegate;
    }

    @Override
    public boolean build(@NotNull GradleTaskRunner taskRunner, @NotNull List<String> commandLineArguments) throws InterruptedException, InvocationTargetException {
        if (taskRunner == null) {
            InstantRunBuilder.$$$reportNull$$$0(8);
        }
        if (commandLineArguments == null) {
            InstantRunBuilder.$$$reportNull$$$0(9);
        }
        BuildSelection buildSelection = this.getBuildSelection();
        this.myInstantRunContext.setBuildSelection(buildSelection);
        if (buildSelection.getBuildMode() != BuildMode.HOT) {
            LOG.info(buildSelection.why.toString());
        }
        ArrayList<String> args = new ArrayList<String>(commandLineArguments);
        args.addAll(this.myInstantRunContext.getCustomBuildArguments());
        args.addAll(InstantRunBuilder.getInstantRunArguments(buildSelection.getBuildMode()));
        args.addAll(this.getFlightRecorderArguments());
        ArrayListMultimap tasks = ArrayListMultimap.create();
        if (buildSelection.getBuildMode() == BuildMode.CLEAN) {
            tasks.putAll(this.myTasksProvider.getCleanAndGenerateSourcesTasks());
        }
        tasks.putAll(this.myTasksProvider.getFullBuildTasks());
        return taskRunner.run((ListMultimap<Path, String>)tasks, null, args);
    }

    @NotNull
    private BuildSelection getBuildSelection() {
        BuildCause buildCause = this.computeBuildCause(this.myDevice);
        boolean brokenForSecondaryUser = buildCause != BuildCause.INCREMENTAL_BUILD && InstantRunBuilder.hasMultiUser(this.myDevice);
        BuildSelection buildSelection = new BuildSelection(buildCause, brokenForSecondaryUser);
        if (buildSelection == null) {
            InstantRunBuilder.$$$reportNull$$$0(10);
        }
        return buildSelection;
    }

    private static boolean hasMultiUser(@Nullable IDevice device) {
        return MultiUserUtils.hasMultipleUsers(device, 200L, TimeUnit.MILLISECONDS, false);
    }

    @NotNull
    private BuildCause computeBuildCause(@Nullable IDevice device) {
        if (device == null) {
            BuildCause buildCause = BuildCause.NO_DEVICE;
            if (buildCause == null) {
                InstantRunBuilder.$$$reportNull$$$0(11);
            }
            return buildCause;
        }
        if (this.myRunContext.isCleanRerun()) {
            BuildCause buildCause = BuildCause.USER_REQUESTED_CLEAN_BUILD;
            if (buildCause == null) {
                InstantRunBuilder.$$$reportNull$$$0(12);
            }
            return buildCause;
        }
        int defaultUserId = 0;
        if (!this.isAppInstalledForUser(device, this.myInstantRunContext.getApplicationId(), defaultUserId)) {
            BuildCause buildCause = BuildCause.APP_NOT_INSTALLED;
            if (buildCause == null) {
                InstantRunBuilder.$$$reportNull$$$0(13);
            }
            return buildCause;
        }
        if (!this.buildTimestampsMatch(device, defaultUserId)) {
            BuildCause buildCause = BuildCause.MISMATCHING_TIMESTAMPS;
            if (buildCause == null) {
                InstantRunBuilder.$$$reportNull$$$0(14);
            }
            return buildCause;
        }
        AndroidVersion deviceVersion = device.getVersion();
        if (!InstantRunManager.isInstantRunCapableDeviceVersion(deviceVersion)) {
            BuildCause buildCause = BuildCause.API_TOO_LOW_FOR_INSTANT_RUN;
            if (buildCause == null) {
                InstantRunBuilder.$$$reportNull$$$0(15);
            }
            return buildCause;
        }
        if (!InstantRunManager.hasLocalCacheOfDeviceData(device, this.myInstantRunContext)) {
            BuildCause buildCause = BuildCause.FIRST_INSTALLATION_TO_DEVICE;
            if (buildCause == null) {
                InstantRunBuilder.$$$reportNull$$$0(16);
            }
            return buildCause;
        }
        if (ApplicationManager.getApplication() != null) {
            GradleBuildInvoker.saveAllFilesSafely();
        }
        if (this.manifestResourceChanged(device)) {
            BuildCause buildCause = BuildCause.MANIFEST_RESOURCE_CHANGED;
            if (buildCause == null) {
                InstantRunBuilder.$$$reportNull$$$0(17);
            }
            return buildCause;
        }
        if (!this.isAppRunning(device) && !deviceVersion.isGreaterOrEqualThan(21)) {
            BuildCause buildCause = BuildCause.FREEZE_SWAP_REQUIRES_API21;
            if (buildCause == null) {
                InstantRunBuilder.$$$reportNull$$$0(18);
            }
            return buildCause;
        }
        if (this.myRunContext.isForceColdswap()) {
            BuildCause buildCause = this.myRunContext.couldHaveInvokedHotswap() ? BuildCause.USER_CHOSE_TO_COLDSWAP : BuildCause.USER_REQUESTED_COLDSWAP;
            if (buildCause == null) {
                InstantRunBuilder.$$$reportNull$$$0(19);
            }
            return buildCause;
        }
        if (!this.isAppRunning(device)) {
            BuildCause buildCause = BuildCause.APP_NOT_RUNNING;
            if (buildCause == null) {
                InstantRunBuilder.$$$reportNull$$$0(20);
            }
            return buildCause;
        }
        if (device.supportsFeature(IDevice.HardwareFeature.TV) || StringUtil.notNullize((String)device.getProperty("ro.product.model")).contains("sdk_google_atv_")) {
            BuildCause buildCause = BuildCause.ANDROID_TV_UNSUPPORTED;
            if (buildCause == null) {
                InstantRunBuilder.$$$reportNull$$$0(21);
            }
            return buildCause;
        }
        if (this.myInstantRunContext.usesMultipleProcesses()) {
            BuildCause buildCause = BuildCause.APP_USES_MULTIPLE_PROCESSES;
            if (buildCause == null) {
                InstantRunBuilder.$$$reportNull$$$0(22);
            }
            return buildCause;
        }
        BuildCause buildCause = BuildCause.INCREMENTAL_BUILD;
        if (buildCause == null) {
            InstantRunBuilder.$$$reportNull$$$0(23);
        }
        return buildCause;
    }

    private boolean isAppRunning(@NotNull IDevice device) {
        boolean isAppRunning;
        if (device == null) {
            InstantRunBuilder.$$$reportNull$$$0(24);
        }
        try {
            isAppRunning = this.myInstantRunClientDelegate.isAppInForeground(device, this.myInstantRunContext);
        }
        catch (IOException e) {
            InstantRunManager.LOG.warn("IOException while attempting to determine if app is in foreground, assuming app not alive");
            isAppRunning = false;
            InstantRunManager.LOG.warn("Force killing app");
            try {
                device.executeShellCommand("am force-stop " + this.myInstantRunContext.getApplicationId(), (IShellOutputReceiver)new NullOutputReceiver());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return isAppRunning && this.myRunContext.isSameExecutorAsPreviousSession();
    }

    private static List<String> getInstantRunArguments(@NotNull BuildMode buildMode) {
        if (buildMode == null) {
            InstantRunBuilder.$$$reportNull$$$0(25);
        }
        StringBuilder sb = new StringBuilder(50);
        sb.append("-P");
        sb.append("android.optional.compilation");
        sb.append("=");
        sb.append(OptionalCompilationStep.INSTANT_DEV.name());
        switch (buildMode) {
            case HOT: {
                break;
            }
            case COLD: {
                sb.append(",").append(OptionalCompilationStep.RESTART_ONLY.name());
                break;
            }
            case FULL: 
            case CLEAN: {
                sb.append(",").append(OptionalCompilationStep.FULL_APK.name());
            }
        }
        String compilationSteps = sb.toString();
        String coldSwapMode = AndroidGradleSettings.createProjectProperty((String)"android.injected.coldswap.mode", (String)"MULTIAPK");
        return ImmutableList.of((Object)compilationSteps, (Object)coldSwapMode);
    }

    @NotNull
    private List<String> getFlightRecorderArguments() {
        ImmutableList immutableList = this.myFlightRecorderEnabled ? ImmutableList.of((Object)"--info", (Object)"--full-stacktrace") : ImmutableList.of();
        if (immutableList == null) {
            InstantRunBuilder.$$$reportNull$$$0(26);
        }
        return immutableList;
    }

    private boolean buildTimestampsMatch(@NotNull IDevice device, @Nullable Integer userId) {
        InstantRunBuildInfo instantRunBuildInfo;
        String localTimestamp;
        if (device == null) {
            InstantRunBuilder.$$$reportNull$$$0(27);
        }
        String string = localTimestamp = (instantRunBuildInfo = this.myInstantRunContext.getInstantRunBuildInfo()) == null ? null : instantRunBuildInfo.getTimeStamp();
        if (StringUtil.isEmpty((String)localTimestamp)) {
            InstantRunManager.LOG.info("Local build timestamp is empty!");
            return false;
        }
        if (!this.isAppInstalledForUser(device, this.myInstantRunContext.getApplicationId(), userId)) {
            return false;
        }
        String deviceBuildTimestamp = this.myInstantRunClientDelegate.getDeviceBuildTimestamp(device, this.myInstantRunContext);
        InstantRunManager.LOG.info(String.format("Build timestamps: Local: %1$s, Device: %2$s", localTimestamp, deviceBuildTimestamp));
        return localTimestamp.equals(deviceBuildTimestamp);
    }

    private boolean isAppInstalledForUser(@NotNull IDevice device, @NotNull String pkgName, @Nullable Integer userId) {
        InstalledApkCache.InstallState installState;
        if (device == null) {
            InstantRunBuilder.$$$reportNull$$$0(28);
        }
        if (pkgName == null) {
            InstantRunBuilder.$$$reportNull$$$0(29);
        }
        if ((installState = this.myInstalledApkCache.getInstallState(device, pkgName)) == null) {
            InstantRunManager.LOG.info("Package " + pkgName + " was not detected on the device.");
            return false;
        }
        if (userId != null && !installState.users.isEmpty() && !installState.users.contains(userId)) {
            LOG.info("Package " + pkgName + " was not installed for default user.");
            return false;
        }
        return true;
    }

    public boolean manifestResourceChanged(@NotNull IDevice device) {
        if (device == null) {
            InstantRunBuilder.$$$reportNull$$$0(30);
        }
        InstalledPatchCache cache = this.myInstantRunContext.getInstalledPatchCache();
        HashCode currentHash = this.myInstantRunContext.getManifestResourcesHash();
        HashCode installedHash = cache.getInstalledManifestResourcesHash(device, this.myInstantRunContext.getApplicationId());
        return installedHash != null && !installedHash.equals((Object)currentHash);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instantRunContext";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfigContext";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasksProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installedApkCache";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskRunner";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineArguments";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/fd/InstantRunBuilder";
                break;
            }
            case 24: 
            case 27: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildMode";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkgName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/fd/InstantRunBuilder";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildSelection";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "computeBuildCause";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlightRecorderArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isAppRunning";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getInstantRunArguments";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "buildTimestampsMatch";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isAppInstalledForUser";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "manifestResourceChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface InstantRunClientDelegate {
        default public String getDeviceBuildTimestamp(@NotNull IDevice device, @NotNull InstantRunContext instantRunContext) {
            if (device == null) {
                InstantRunClientDelegate.$$$reportNull$$$0(0);
            }
            if (instantRunContext == null) {
                InstantRunClientDelegate.$$$reportNull$$$0(1);
            }
            return InstantRunClient.getDeviceBuildTimestamp((IDevice)device, (String)instantRunContext.getApplicationId(), (ILogger)InstantRunManager.ILOGGER);
        }

        default public boolean isAppInForeground(@NotNull IDevice device, @NotNull InstantRunContext context) throws IOException {
            if (device == null) {
                InstantRunClientDelegate.$$$reportNull$$$0(2);
            }
            if (context == null) {
                InstantRunClientDelegate.$$$reportNull$$$0(3);
            }
            InstantRunClient instantRunClient = InstantRunManager.getInstantRunClient(context);
            try {
                return instantRunClient != null && instantRunClient.getAppState(device) == AppState.FOREGROUND;
            }
            catch (IOException e) {
                Client client = device.getClient(context.getApplicationId());
                if (client == null) {
                    InstantRunManager.LOG.info("Application not running");
                    return false;
                }
                throw e;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "device";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instantRunContext";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/fd/InstantRunBuilder$InstantRunClientDelegate";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getDeviceBuildTimestamp";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAppInForeground";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

