/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.android;

import com.android.builder.model.Library;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModel;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsDependency;
import com.android.tools.idea.gradle.structure.model.PsLibraryDependency;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidArtifact;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidDependency;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.util.PlatformIcons;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsLibraryAndroidDependency
extends PsAndroidDependency
implements PsLibraryDependency {
    @NotNull
    private final List<PsArtifactDependencySpec> myPomDependencies;
    @NotNull
    private final Set<String> myTransitiveDependencies;
    @NotNull
    private PsArtifactDependencySpec myResolvedSpec;
    @Nullable
    private final Library myResolvedModel;
    @Nullable
    private PsArtifactDependencySpec myDeclaredSpec;

    PsLibraryAndroidDependency(@NotNull PsAndroidModule parent, @NotNull PsArtifactDependencySpec resolvedSpec, @NotNull PsAndroidArtifact container, @Nullable Library resolvedModel, @Nullable ArtifactDependencyModel parsedModel) {
        if (parent == null) {
            PsLibraryAndroidDependency.$$$reportNull$$$0(0);
        }
        if (resolvedSpec == null) {
            PsLibraryAndroidDependency.$$$reportNull$$$0(1);
        }
        if (container == null) {
            PsLibraryAndroidDependency.$$$reportNull$$$0(2);
        }
        super(parent, container, parsedModel);
        this.myPomDependencies = Lists.newArrayList();
        this.myTransitiveDependencies = Sets.newHashSet();
        this.myResolvedSpec = resolvedSpec;
        this.myResolvedModel = resolvedModel;
        if (parsedModel != null) {
            this.setDeclaredSpec(this.createSpec(parsedModel));
        }
    }

    @Nullable
    public Library getResolvedModel() {
        return this.myResolvedModel;
    }

    void addTransitiveDependency(@NotNull String dependency) {
        if (dependency == null) {
            PsLibraryAndroidDependency.$$$reportNull$$$0(3);
        }
        this.myTransitiveDependencies.add(dependency);
    }

    void setDependenciesFromPomFile(@NotNull List<PsArtifactDependencySpec> pomDependencies) {
        if (pomDependencies == null) {
            PsLibraryAndroidDependency.$$$reportNull$$$0(4);
        }
        this.myPomDependencies.clear();
        this.myPomDependencies.addAll(pomDependencies);
    }

    @Override
    @NotNull
    public ImmutableCollection<PsDependency> getTransitiveDependencies() {
        PsLibraryAndroidDependency found;
        PsModule module = this.getParent();
        ImmutableSet.Builder transitive = ImmutableSet.builder();
        for (String string : this.myTransitiveDependencies) {
            found = ((PsAndroidModule)module).findLibraryDependency(string);
            if (found == null) continue;
            transitive.add((Object)found);
        }
        for (PsArtifactDependencySpec psArtifactDependencySpec : this.myPomDependencies) {
            found = ((PsAndroidModule)module).findLibraryDependency(psArtifactDependencySpec);
            if (found == null) continue;
            transitive.add((Object)found);
        }
        ImmutableSet immutableSet = transitive.build();
        if (immutableSet == null) {
            PsLibraryAndroidDependency.$$$reportNull$$$0(5);
        }
        return immutableSet;
    }

    @Override
    public void addParsedModel(@NotNull DependencyModel parsedModel) {
        if (parsedModel == null) {
            PsLibraryAndroidDependency.$$$reportNull$$$0(6);
        }
        assert (parsedModel instanceof ArtifactDependencyModel);
        if (this.getParsedModels().isEmpty()) {
            this.myDeclaredSpec = PsArtifactDependencySpec.create((ArtifactDependencyModel)parsedModel);
        }
        super.addParsedModel(parsedModel);
    }

    @Override
    @Nullable
    public PsArtifactDependencySpec getDeclaredSpec() {
        return this.myDeclaredSpec;
    }

    @Override
    @NotNull
    public PsArtifactDependencySpec getResolvedSpec() {
        PsArtifactDependencySpec psArtifactDependencySpec = this.myResolvedSpec;
        if (psArtifactDependencySpec == null) {
            PsLibraryAndroidDependency.$$$reportNull$$$0(7);
        }
        return psArtifactDependencySpec;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myResolvedSpec.name;
        if (string == null) {
            PsLibraryAndroidDependency.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = PlatformIcons.LIBRARY_ICON;
        if (icon == null) {
            PsLibraryAndroidDependency.$$$reportNull$$$0(9);
        }
        return icon;
    }

    @Override
    @NotNull
    public String toText(@NotNull PsDependency.TextType type) {
        if (type == null) {
            PsLibraryAndroidDependency.$$$reportNull$$$0(10);
        }
        switch (type) {
            case PLAIN_TEXT: {
                String string = this.myResolvedSpec.toString();
                if (string == null) {
                    PsLibraryAndroidDependency.$$$reportNull$$$0(11);
                }
                return string;
            }
            case FOR_NAVIGATION: {
                PsArtifactDependencySpec spec = this.myDeclaredSpec;
                if (spec == null) {
                    spec = this.myResolvedSpec;
                }
                String string = spec.toString();
                if (string == null) {
                    PsLibraryAndroidDependency.$$$reportNull$$$0(12);
                }
                return string;
            }
        }
        if ("" == null) {
            PsLibraryAndroidDependency.$$$reportNull$$$0(13);
        }
        return "";
    }

    @Override
    public boolean hasPromotedVersion() {
        if (this.myResolvedSpec.version != null && this.myDeclaredSpec != null && this.myDeclaredSpec.version != null) {
            GradleVersion declaredVersion = GradleVersion.tryParse((String)this.myDeclaredSpec.version);
            return declaredVersion != null && declaredVersion.compareTo(this.myResolvedSpec.version) < 0;
        }
        return false;
    }

    @Override
    public void setResolvedSpec(@NotNull PsArtifactDependencySpec spec) {
        if (spec == null) {
            PsLibraryAndroidDependency.$$$reportNull$$$0(14);
        }
        this.myResolvedSpec = spec;
    }

    @Override
    public void setDeclaredSpec(@NotNull PsArtifactDependencySpec spec) {
        if (spec == null) {
            PsLibraryAndroidDependency.$$$reportNull$$$0(15);
        }
        this.myDeclaredSpec = spec;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsLibraryAndroidDependency that = (PsLibraryAndroidDependency)o;
        return Objects.equals(this.myResolvedSpec, that.myResolvedSpec);
    }

    public int hashCode() {
        return Objects.hash(this.myDeclaredSpec);
    }

    @Override
    public String toString() {
        return this.toText(PsDependency.TextType.PLAIN_TEXT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedSpec";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pomDependencies";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/model/android/PsLibraryAndroidDependency";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parsedModel";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/model/android/PsLibraryAndroidDependency";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTransitiveDependencies";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedSpec";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "toText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addTransitiveDependency";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setDependenciesFromPomFile";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addParsedModel";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "toText";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setResolvedSpec";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setDeclaredSpec";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

