/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.repositories.search;

import com.android.ide.common.repository.GradleVersion;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class FoundArtifact
implements Comparable<FoundArtifact> {
    @NotNull
    private final String myRepositoryName;
    @NotNull
    private final String myGroupId;
    @NotNull
    private final String myName;
    @NotNull
    private final List<GradleVersion> myVersions;

    FoundArtifact(@NotNull String repositoryName, @NotNull String groupId, @NotNull String name, @NotNull GradleVersion version) {
        if (repositoryName == null) {
            FoundArtifact.$$$reportNull$$$0(0);
        }
        if (groupId == null) {
            FoundArtifact.$$$reportNull$$$0(1);
        }
        if (name == null) {
            FoundArtifact.$$$reportNull$$$0(2);
        }
        if (version == null) {
            FoundArtifact.$$$reportNull$$$0(3);
        }
        this(repositoryName, groupId, name);
        this.myVersions.add(version);
        this.sortVersionsFromNewestToOldest();
    }

    FoundArtifact(@NotNull String repositoryName, @NotNull String groupId, @NotNull String name, @NotNull List<GradleVersion> versions) {
        if (repositoryName == null) {
            FoundArtifact.$$$reportNull$$$0(4);
        }
        if (groupId == null) {
            FoundArtifact.$$$reportNull$$$0(5);
        }
        if (name == null) {
            FoundArtifact.$$$reportNull$$$0(6);
        }
        if (versions == null) {
            FoundArtifact.$$$reportNull$$$0(7);
        }
        this(repositoryName, groupId, name);
        this.myVersions.addAll(versions);
        this.sortVersionsFromNewestToOldest();
    }

    private void sortVersionsFromNewestToOldest() {
        if (this.myVersions.size() > 1) {
            Collections.sort(this.myVersions, Collections.reverseOrder());
        }
    }

    private FoundArtifact(@NotNull String repositoryName, @NotNull String groupId, @NotNull String name) {
        if (repositoryName == null) {
            FoundArtifact.$$$reportNull$$$0(8);
        }
        if (groupId == null) {
            FoundArtifact.$$$reportNull$$$0(9);
        }
        if (name == null) {
            FoundArtifact.$$$reportNull$$$0(10);
        }
        this.myVersions = Lists.newArrayList();
        this.myRepositoryName = repositoryName;
        this.myGroupId = groupId;
        this.myName = name;
    }

    @NotNull
    public String getRepositoryName() {
        String string = this.myRepositoryName;
        if (string == null) {
            FoundArtifact.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public String getGroupId() {
        String string = this.myGroupId;
        if (string == null) {
            FoundArtifact.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            FoundArtifact.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public List<GradleVersion> getVersions() {
        List<GradleVersion> list = this.myVersions;
        if (list == null) {
            FoundArtifact.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Override
    public int compareTo(FoundArtifact other) {
        int compare = FoundArtifact.compareRepositoryNames(this.myRepositoryName, other.myRepositoryName);
        if (compare != 0) {
            return compare;
        }
        compare = FoundArtifact.compareGroupIds(this.myGroupId, other.myGroupId);
        if (compare != 0) {
            return compare;
        }
        return this.myName.compareTo(other.myName);
    }

    private static int compareRepositoryNames(@NotNull String s1, @NotNull String s2) {
        if (s1 == null) {
            FoundArtifact.$$$reportNull$$$0(15);
        }
        if (s2 == null) {
            FoundArtifact.$$$reportNull$$$0(16);
        }
        if (s1.equals(s2)) {
            return 0;
        }
        if (s1.equals("Android Repository")) {
            return -1;
        }
        if (s1.equals("Google Repository") && !s2.equals("Android Repository")) {
            return -1;
        }
        return s1.compareTo(s2);
    }

    private static int compareGroupIds(@NotNull String s1, @NotNull String s2) {
        if (s1 == null) {
            FoundArtifact.$$$reportNull$$$0(17);
        }
        if (s2 == null) {
            FoundArtifact.$$$reportNull$$$0(18);
        }
        if (s1.equals(s2)) {
            return 0;
        }
        String androidPackage = "com.android";
        if (s1.startsWith(androidPackage)) {
            if (s2.startsWith(androidPackage)) {
                return s1.compareTo(s2);
            }
            return -1;
        }
        String googlePackage = "com.google";
        if (s1.startsWith(googlePackage)) {
            if (s2.startsWith(googlePackage)) {
                return s1.compareTo(s2);
            }
            if (!s2.startsWith(androidPackage)) {
                return -1;
            }
        }
        return s1.compareTo(s2);
    }

    @NotNull
    public List<String> getCoordinates() {
        String groupIdAndName = this.myGroupId + ":" + this.myName;
        List<String> list = this.myVersions.stream().map(version -> groupIdAndName + ":" + version).collect(Collectors.toList());
        if (list == null) {
            FoundArtifact.$$$reportNull$$$0(19);
        }
        return list;
    }

    public String toString() {
        return "{repository='" + this.myRepositoryName + '\'' + ", group='" + this.myGroupId + '\'' + ", name='" + this.myName + '\'' + ", versions=" + this.myVersions + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryName";
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versions";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/model/repositories/search/FoundArtifact";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/model/repositories/search/FoundArtifact";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersions";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoordinates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: {
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "compareRepositoryNames";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "compareGroupIds";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

