/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.SdkConstants;
import com.android.tools.idea.gradle.util.PropertiesFiles;
import com.android.tools.idea.templates.TemplateManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GradleWrapper {
    @NonNls
    public static final String GRADLEW_PROPERTIES_PATH = FileUtil.join((String[])new String[]{SdkConstants.FD_GRADLE_WRAPPER, "gradle-wrapper.properties"});
    private static final Pattern GRADLE_DISTRIBUTION_URL_PATTERN = Pattern.compile(".*/gradle-([^-]+)(-[^\\/\\\\]+)?-(bin|all).zip");
    @NotNull
    private final File myPropertiesFilePath;
    @Nullable
    private final Project myProject;

    @Nullable
    public static GradleWrapper find(@NotNull Project project) {
        String basePath;
        if (project == null) {
            GradleWrapper.$$$reportNull$$$0(0);
        }
        if ((basePath = project.getBasePath()) == null) {
            return null;
        }
        File baseDir = new File(basePath);
        File propertiesFilePath = GradleWrapper.getDefaultPropertiesFilePath(baseDir);
        return propertiesFilePath.isFile() ? new GradleWrapper(propertiesFilePath, project) : null;
    }

    @NotNull
    public static GradleWrapper get(@NotNull File propertiesFilePath) {
        if (propertiesFilePath == null) {
            GradleWrapper.$$$reportNull$$$0(1);
        }
        GradleWrapper gradleWrapper = new GradleWrapper(propertiesFilePath, null);
        if (gradleWrapper == null) {
            GradleWrapper.$$$reportNull$$$0(2);
        }
        return gradleWrapper;
    }

    public static GradleWrapper create(@NotNull File projectPath) throws IOException {
        if (projectPath == null) {
            GradleWrapper.$$$reportNull$$$0(3);
        }
        return GradleWrapper.create(projectPath, "3.3");
    }

    public static GradleWrapper create(@NotNull File projectPath, @NotNull String gradleVersion) throws IOException {
        File wrapperFolderPath;
        if (projectPath == null) {
            GradleWrapper.$$$reportNull$$$0(4);
        }
        if (gradleVersion == null) {
            GradleWrapper.$$$reportNull$$$0(5);
        }
        if (!(wrapperFolderPath = new File(projectPath, SdkConstants.FD_GRADLE_WRAPPER)).isDirectory()) {
            File srcFolderPath = new File(TemplateManager.getTemplateRootFolder(), SdkConstants.FD_GRADLE_WRAPPER);
            if (!srcFolderPath.exists()) {
                File root;
                Iterator<File> iterator = TemplateManager.getExtraTemplateRootFolders().iterator();
                while (iterator.hasNext() && !(srcFolderPath = new File(root = iterator.next(), SdkConstants.FD_GRADLE_WRAPPER)).exists()) {
                    srcFolderPath = null;
                }
            }
            if (srcFolderPath == null) {
                return null;
            }
            FileUtil.copyDirContent((File)srcFolderPath, (File)projectPath);
        }
        File propertiesFilePath = GradleWrapper.getDefaultPropertiesFilePath(projectPath);
        GradleWrapper gradleWrapper = GradleWrapper.get(propertiesFilePath);
        gradleWrapper.updateDistributionUrl(gradleVersion);
        return gradleWrapper;
    }

    private GradleWrapper(@NotNull File propertiesFilePath, @Nullable Project project) {
        if (propertiesFilePath == null) {
            GradleWrapper.$$$reportNull$$$0(6);
        }
        this.myProject = project;
        this.myPropertiesFilePath = propertiesFilePath;
    }

    @NotNull
    public File getPropertiesFilePath() {
        File file = this.myPropertiesFilePath;
        if (file == null) {
            GradleWrapper.$$$reportNull$$$0(7);
        }
        return file;
    }

    @Nullable
    public VirtualFile getPropertiesFile() {
        return VfsUtil.findFileByIoFile((File)this.myPropertiesFilePath, (boolean)true);
    }

    @NotNull
    public static File getDefaultPropertiesFilePath(@NotNull File projectPath) {
        if (projectPath == null) {
            GradleWrapper.$$$reportNull$$$0(8);
        }
        File file = new File(projectPath, GRADLEW_PROPERTIES_PATH);
        if (file == null) {
            GradleWrapper.$$$reportNull$$$0(9);
        }
        return file;
    }

    public boolean updateDistributionUrlAndDisplayFailure(@NotNull String gradleVersion) {
        if (gradleVersion == null) {
            GradleWrapper.$$$reportNull$$$0(10);
        }
        try {
            boolean updated = this.updateDistributionUrl(gradleVersion);
            if (updated) {
                VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)this.myPropertiesFilePath, (boolean)true);
                if (virtualFile != null) {
                    virtualFile.refresh(false, false);
                }
                return true;
            }
        }
        catch (IOException e) {
            String msg = String.format("Unable to update Gradle wrapper to use Gradle %1$s\n", gradleVersion);
            msg = msg + e.getMessage();
            Messages.showErrorDialog((Project)this.myProject, (String)msg, (String)"Unexpected Error");
        }
        return false;
    }

    public boolean updateDistributionUrl(@NotNull String gradleVersion) throws IOException {
        if (gradleVersion == null) {
            GradleWrapper.$$$reportNull$$$0(11);
        }
        Properties properties = this.getProperties();
        String distributionUrl = GradleWrapper.getDistributionUrl(gradleVersion, false);
        String property = properties.getProperty("distributionUrl");
        if (property != null && (property.equals(distributionUrl) || property.equals(GradleWrapper.getDistributionUrl(gradleVersion, true)))) {
            return false;
        }
        properties.setProperty("distributionUrl", distributionUrl);
        PropertiesFiles.savePropertiesToFile(properties, this.myPropertiesFilePath, null);
        return true;
    }

    public void updateDistributionUrl(@NotNull File gradleDistribution) throws IOException {
        String path;
        if (gradleDistribution == null) {
            GradleWrapper.$$$reportNull$$$0(12);
        }
        if (!FileUtilRt.extensionEquals((String)(path = gradleDistribution.getPath()), (String)"zip")) {
            throw new IllegalArgumentException("'" + path + "' should be a zip file");
        }
        Properties properties = this.getProperties();
        properties.setProperty("distributionUrl", gradleDistribution.toURI().toURL().toString());
        PropertiesFiles.savePropertiesToFile(properties, this.myPropertiesFilePath, null);
    }

    @NotNull
    public Properties getProperties() throws IOException {
        Properties properties = PropertiesFiles.getProperties(this.myPropertiesFilePath);
        if (properties == null) {
            GradleWrapper.$$$reportNull$$$0(13);
        }
        return properties;
    }

    @Nullable
    public String getGradleVersion() throws IOException {
        Matcher m;
        String url = this.getProperties().getProperty("distributionUrl");
        if (url != null && (m = GRADLE_DISTRIBUTION_URL_PATTERN.matcher(url)).matches()) {
            return m.group(1);
        }
        return null;
    }

    @NotNull
    private static String getDistributionUrl(@NotNull String gradleVersion, boolean binOnly) {
        if (gradleVersion == null) {
            GradleWrapper.$$$reportNull$$$0(14);
        }
        String suffix = binOnly ? "bin" : "all";
        String string = String.format("https://services.gradle.org/distributions/gradle-%1$s-" + suffix + ".zip", gradleVersion);
        if (string == null) {
            GradleWrapper.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesFilePath";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/util/GradleWrapper";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 5: 
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleVersion";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleDistribution";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/util/GradleWrapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertiesFilePath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPropertiesFilePath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDistributionUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 13: 
            case 15: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPropertiesFilePath";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateDistributionUrlAndDisplayFailure";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateDistributionUrl";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDistributionUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

