/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.RegEx;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ReplaceStringQuickFix
implements AndroidLintQuickFix {
    private final String myName;
    @RegEx
    private final String myRegexp;
    private final String myNewValue;

    ReplaceStringQuickFix(@Nullable String name, @RegEx @Nullable String regexp, @NotNull String newValue) {
        if (newValue == null) {
            ReplaceStringQuickFix.$$$reportNull$$$0(0);
        }
        this.myName = name;
        this.myNewValue = newValue;
        if (regexp != null && regexp.indexOf(40) == -1) {
            regexp = "(" + Pattern.quote(regexp) + ")";
        }
        this.myRegexp = regexp;
    }

    @Override
    @NotNull
    public String getName() {
        if (this.myName == null) {
            String string = "Replace with " + this.myNewValue;
            if (string == null) {
                ReplaceStringQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = this.myName;
        if (string == null) {
            ReplaceStringQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    protected String getNewValue() {
        return this.myNewValue;
    }

    protected void editBefore(@NotNull Document document) {
        if (document == null) {
            ReplaceStringQuickFix.$$$reportNull$$$0(3);
        }
    }

    protected void editAfter(@NotNull Document document) {
        if (document == null) {
            ReplaceStringQuickFix.$$$reportNull$$$0(4);
        }
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        if (startElement == null) {
            ReplaceStringQuickFix.$$$reportNull$$$0(5);
        }
        if (endElement == null) {
            ReplaceStringQuickFix.$$$reportNull$$$0(6);
        }
        if (context == null) {
            ReplaceStringQuickFix.$$$reportNull$$$0(7);
        }
        Document document = FileDocumentManager.getInstance().getDocument(startElement.getContainingFile().getVirtualFile());
        String newValue = this.getNewValue();
        if (document != null && newValue != null) {
            this.editBefore(document);
            TextRange range = this.getRange(startElement, endElement);
            if (range != null) {
                document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)newValue);
                this.editAfter(document);
            }
        }
    }

    @Nullable
    private TextRange getRange(PsiElement startElement, PsiElement endElement) {
        int end;
        int start;
        block5: {
            if (!startElement.isValid() || !endElement.isValid()) {
                return null;
            }
            start = startElement.getTextOffset();
            end = endElement.getTextOffset() + endElement.getTextLength();
            if (this.myRegexp != null) {
                try {
                    Pattern pattern = Pattern.compile(this.myRegexp, 8);
                    String text = startElement.getContainingFile().getText();
                    String sequence = text.substring(start, end);
                    Matcher matcher = pattern.matcher(sequence);
                    if (matcher.find()) {
                        end = start + matcher.end(1);
                        start += matcher.start(1);
                        break block5;
                    }
                    return null;
                }
                catch (Exception e) {
                    Logger.getInstance(ReplaceStringQuickFix.class).warn("Invalid regular expression " + this.myRegexp);
                    return null;
                }
            }
        }
        return new TextRange(start, end);
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        if (startElement == null) {
            ReplaceStringQuickFix.$$$reportNull$$$0(8);
        }
        if (endElement == null) {
            ReplaceStringQuickFix.$$$reportNull$$$0(9);
        }
        if (contextType == null) {
            ReplaceStringQuickFix.$$$reportNull$$$0(10);
        }
        return this.getRange(startElement, endElement) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/lint/ReplaceStringQuickFix";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/lint/ReplaceStringQuickFix";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "editBefore";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "editAfter";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

