/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.memory.model;

import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryInfoTreeNode
extends DefaultMutableTreeNode {
    @Nullable
    protected MemoryInfoTreeNode myParent;
    @Nullable
    private Comparator<MemoryInfoTreeNode> myComparator = null;
    @NotNull
    private Vector<MemoryInfoTreeNode> myChildren = new Vector();
    private String mName;
    int mCount;

    public MemoryInfoTreeNode(String name) {
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    public void setCount(int count) {
        this.mCount = count;
    }

    public int getCount() {
        return this.mCount;
    }

    @Override
    public TreeNode getChildAt(int i) {
        this.ensureOrder();
        return this.myChildren.get(i);
    }

    @Override
    public int getChildCount() {
        return this.myChildren.size();
    }

    @Override
    public TreeNode getParent() {
        return this.myParent;
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        assert (treeNode instanceof MemoryInfoTreeNode);
        return this.myChildren.indexOf(treeNode);
    }

    @Override
    public boolean isLeaf() {
        return this.myChildren.size() == 0;
    }

    public Enumeration children() {
        this.ensureOrder();
        return Collections.enumeration(this.myChildren);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public void insert(MutableTreeNode newChild, int childIndex) {
        MemoryInfoTreeNode child = (MemoryInfoTreeNode)newChild;
        assert (child != null);
        child.myParent = this;
        this.myChildren.add(childIndex, child);
    }

    @Override
    public void remove(int childIndex) {
        MemoryInfoTreeNode child = this.myChildren.get(childIndex);
        assert (child != null);
        child.myParent = null;
        this.myChildren.remove(childIndex);
    }

    private void ensureOrder() {
        if (this.myParent != null && this.myParent.myComparator != this.myComparator || this.myParent == null && this.myComparator != null) {
            this.myComparator = this.myParent != null ? this.myParent.myComparator : this.myComparator;
            Collections.sort(this.myChildren, this.myComparator);
        }
    }

    public void sort(@NotNull Comparator<MemoryInfoTreeNode> comparator) {
        if (comparator == null) {
            MemoryInfoTreeNode.$$$reportNull$$$0(0);
        }
        assert (this.myParent == null);
        this.myComparator = comparator;
        this.ensureOrder();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/android/tools/idea/monitor/ui/memory/model/MemoryInfoTreeNode", "sort"));
    }
}

