/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.memory.view;

import com.android.tools.adtui.LegendRenderData;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.common.formatter.BaseAxisFormatter;
import com.android.tools.adtui.common.formatter.MemoryAxisFormatter;
import com.android.tools.adtui.common.formatter.SingleUnitAxisFormatter;
import com.android.tools.adtui.model.Range;
import com.android.tools.datastore.SeriesDataStore;
import com.android.tools.datastore.SeriesDataType;
import com.android.tools.idea.monitor.tool.ProfilerEventListener;
import com.android.tools.idea.monitor.ui.BaseLineChartSegment;
import com.android.tools.idea.monitor.ui.BaseProfilerUiManager;
import com.intellij.ui.JBColor;
import com.intellij.util.EventDispatcher;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public class MemorySegment
extends BaseLineChartSegment {
    private static final String SEGMENT_NAME = "Memory";
    private static final BaseAxisFormatter MEMORY_AXIS_FORMATTER_L1 = new MemoryAxisFormatter(1, 5, 5);
    private static final BaseAxisFormatter COUNT_AXIS_FORMATTER = new SingleUnitAxisFormatter(1, 10, 1, "");
    private static final Color MEMORY_TOTAL_COLOR = new JBColor(new Color(123, 170, 214), new Color(123, 170, 214));
    private static final Color MEMORY_NATIVE_COLOR = new JBColor(new Color(132, 209, 199), new Color(132, 209, 199));
    private static final Color MEMORY_GRAPHICS_COLOR = new JBColor(new Color(219, 191, 141), new Color(219, 191, 141));
    private static final Color MEMORY_CODE_COLOR = new JBColor(new Color(125, 206, 132), new Color(125, 206, 132));
    private static final Color MEMORY_OTHER_COLOR = new JBColor(new Color(78, 147, 187), new Color(78, 147, 187));
    private static final Color MEMORY_OBJECT_COUNT_COLOR = new JBColor(new Color(160, 160, 31), new Color(160, 160, 31));
    private static final Color MEMORY_HEAP_DUMP_COLOR = JBColor.DARK_GRAY;
    private static final String JAVA_OBJECTS_COUNT = "Objects";
    private static final String TOTAL_MEM_USAGE = "Total";
    private static final String UNCLASSIFIED_MEM = "Other";
    private static final String CODE_MEM = "Code";
    private static final String GRAPHICS_MEM = "Graphics";
    private static final String NATIVE_MEM = "Native";
    private static final String JAVA_MEM = "Java";

    public MemorySegment(@NotNull Range timeCurrentRangeUs, @NotNull SeriesDataStore dataStore, @NotNull EventDispatcher<ProfilerEventListener> dispatcher) {
        if (timeCurrentRangeUs == null) {
            MemorySegment.$$$reportNull$$$0(0);
        }
        if (dataStore == null) {
            MemorySegment.$$$reportNull$$$0(1);
        }
        if (dispatcher == null) {
            MemorySegment.$$$reportNull$$$0(2);
        }
        super(SEGMENT_NAME, timeCurrentRangeUs, dataStore, MEMORY_AXIS_FORMATTER_L1, (BaseAxisFormatter)MemoryAxisFormatter.DEFAULT, COUNT_AXIS_FORMATTER, dispatcher);
    }

    @Override
    public BaseProfilerUiManager.ProfilerType getProfilerType() {
        return BaseProfilerUiManager.ProfilerType.MEMORY;
    }

    @Override
    protected void updateChartLines(boolean isExpanded) {
        if (isExpanded) {
            this.addLeftAxisLine(SeriesDataType.MEMORY_TOTAL, TOTAL_MEM_USAGE, new LineConfig(MEMORY_TOTAL_COLOR).setLegendIconType(LegendRenderData.IconType.NONE));
            this.addMemoryLevelLine(SeriesDataType.MEMORY_JAVA, JAVA_MEM, MEMORY_TOTAL_COLOR);
            this.addMemoryLevelLine(SeriesDataType.MEMORY_NATIVE, NATIVE_MEM, MEMORY_NATIVE_COLOR);
            this.addMemoryLevelLine(SeriesDataType.MEMORY_GRAPHICS, GRAPHICS_MEM, MEMORY_GRAPHICS_COLOR);
            this.addMemoryLevelLine(SeriesDataType.MEMORY_CODE, CODE_MEM, MEMORY_CODE_COLOR);
            this.addMemoryLevelLine(SeriesDataType.MEMORY_OTHERS, UNCLASSIFIED_MEM, MEMORY_OTHER_COLOR);
            this.addRightAxisLine(SeriesDataType.MEMORY_OBJECT_COUNT, JAVA_OBJECTS_COUNT, new LineConfig(MEMORY_OBJECT_COUNT_COLOR));
        } else {
            this.addMemoryLevelLine(SeriesDataType.MEMORY_TOTAL, TOTAL_MEM_USAGE, MEMORY_TOTAL_COLOR);
        }
    }

    private void addMemoryLevelLine(SeriesDataType type, String title, Color color) {
        this.addLeftAxisLine(type, title, new LineConfig(color).setFilled(true).setStacked(true));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "timeCurrentRangeUs";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "dataStore";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "dispatcher";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/monitor/ui/memory/view/MemorySegment";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

