/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.ClassField;
import com.android.builder.model.Variant;
import com.android.ide.common.res2.ResourceItem;
import com.android.resources.ResourceType;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.variant.view.BuildVariantView;
import com.android.tools.idea.res.DynamicResourceValueItem;
import com.android.tools.idea.res.LocalResourceRepository;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicResourceValueRepository
extends LocalResourceRepository
implements GradleSyncListener,
BuildVariantView.BuildVariantSelectionChangeListener {
    private final AndroidFacet myFacet;
    private final Map<ResourceType, ListMultimap<String, ResourceItem>> mItems;

    private DynamicResourceValueRepository(@NotNull AndroidFacet facet) {
        if (facet == null) {
            DynamicResourceValueRepository.$$$reportNull$$$0(0);
        }
        super("Gradle Dynamic");
        this.mItems = Maps.newEnumMap(ResourceType.class);
        this.myFacet = facet;
        assert (facet.requiresAndroidModel());
        Disposer.register((Disposable)this, (Disposable)facet.addListener(this));
        BuildVariantView.getInstance(this.myFacet.getModule().getProject()).addListener(this);
    }

    @Override
    public void dispose() {
        super.dispose();
        Project project = this.myFacet.getModule().getProject();
        if (!project.isDisposed()) {
            BuildVariantView.getInstance(project).removeListener(this);
        }
    }

    @NotNull
    public static DynamicResourceValueRepository create(@NotNull AndroidFacet facet) {
        if (facet == null) {
            DynamicResourceValueRepository.$$$reportNull$$$0(1);
        }
        DynamicResourceValueRepository dynamicResourceValueRepository = new DynamicResourceValueRepository(facet);
        if (dynamicResourceValueRepository == null) {
            DynamicResourceValueRepository.$$$reportNull$$$0(2);
        }
        return dynamicResourceValueRepository;
    }

    @NotNull
    @VisibleForTesting
    public static DynamicResourceValueRepository createForTest(@NotNull AndroidFacet facet, @NotNull Map<String, ClassField> values) {
        if (facet == null) {
            DynamicResourceValueRepository.$$$reportNull$$$0(3);
        }
        if (values == null) {
            DynamicResourceValueRepository.$$$reportNull$$$0(4);
        }
        DynamicResourceValueRepository repository = new DynamicResourceValueRepository(facet);
        repository.addValues(values);
        DynamicResourceValueRepository dynamicResourceValueRepository = repository;
        if (dynamicResourceValueRepository == null) {
            DynamicResourceValueRepository.$$$reportNull$$$0(5);
        }
        return dynamicResourceValueRepository;
    }

    protected Map<ResourceType, ListMultimap<String, ResourceItem>> getMap() {
        if (this.mItems.isEmpty()) {
            AndroidModuleModel androidModel = AndroidModuleModel.get(this.myFacet);
            if (androidModel == null) {
                return this.mItems;
            }
            Variant selectedVariant = androidModel.getSelectedVariant();
            BuildTypeContainer buildType = androidModel.findBuildType(selectedVariant.getBuildType());
            if (buildType != null) {
                this.addValues(buildType.getBuildType().getResValues());
            }
            this.addValues(selectedVariant.getMergedFlavor().getResValues());
        }
        return this.mItems;
    }

    private void notifyGradleSynced() {
        this.mItems.clear();
        super.invalidateItemCaches(new ResourceType[0]);
    }

    private void addValues(Map<String, ClassField> resValues) {
        for (Map.Entry<String, ClassField> entry : resValues.entrySet()) {
            ClassField field = entry.getValue();
            String name = field.getName();
            assert (entry.getKey().equals(name)) : entry.getKey() + " vs " + name;
            ResourceType type = ResourceType.getEnum((String)field.getType());
            if (type == null) {
                LOG.warn("Ignoring field " + name + "(" + field + "): unknown type " + field.getType());
                continue;
            }
            ArrayListMultimap map = this.mItems.get(type);
            if (map == null) {
                map = ArrayListMultimap.create();
                this.mItems.put(type, (ListMultimap<String, ResourceItem>)map);
            } else if (map.containsKey((Object)name)) continue;
            DynamicResourceValueItem item = new DynamicResourceValueItem(type, field);
            map.put((Object)name, (Object)item);
        }
    }

    @Nullable
    protected ListMultimap<String, ResourceItem> getMap(ResourceType type, boolean create) {
        ArrayListMultimap multimap;
        if (this.mItems.isEmpty()) {
            this.getMap();
        }
        if ((multimap = this.mItems.get(type)) == null && create) {
            multimap = ArrayListMultimap.create();
            this.mItems.put(type, (ListMultimap<String, ResourceItem>)multimap);
        }
        return multimap;
    }

    @Override
    public void syncStarted(@NotNull Project project) {
        if (project == null) {
            DynamicResourceValueRepository.$$$reportNull$$$0(6);
        }
    }

    @Override
    public void setupStarted(@NotNull Project project) {
        if (project == null) {
            DynamicResourceValueRepository.$$$reportNull$$$0(7);
        }
    }

    @Override
    public void syncSucceeded(@NotNull Project project) {
        if (project == null) {
            DynamicResourceValueRepository.$$$reportNull$$$0(8);
        }
        this.notifyGradleSynced();
    }

    @Override
    public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
        if (project == null) {
            DynamicResourceValueRepository.$$$reportNull$$$0(9);
        }
        if (errorMessage == null) {
            DynamicResourceValueRepository.$$$reportNull$$$0(10);
        }
    }

    @Override
    public void syncSkipped(@NotNull Project project) {
        if (project == null) {
            DynamicResourceValueRepository.$$$reportNull$$$0(11);
        }
    }

    @Override
    public void buildVariantsConfigChanged() {
        this.notifyGradleSynced();
    }

    @Override
    @NotNull
    protected Set<VirtualFile> computeResourceDirs() {
        ImmutableSet immutableSet = ImmutableSet.of();
        if (immutableSet == null) {
            DynamicResourceValueRepository.$$$reportNull$$$0(12);
        }
        return immutableSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/DynamicResourceValueRepository";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/DynamicResourceValueRepository";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createForTest";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "computeResourceDirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 5: 
            case 12: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createForTest";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "syncStarted";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setupStarted";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "syncSucceeded";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "syncFailed";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "syncSkipped";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

