/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.res2.AbstractResourceRepository;
import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.DataBindingInfo;
import com.android.tools.idea.res.MultiResourceRepository;
import com.android.tools.idea.res.PsiResourceFile;
import com.android.tools.idea.res.PsiResourceItem;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.lint.detector.api.LintUtils;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LocalResourceRepository
extends AbstractResourceRepository
implements Disposable,
ModificationTracker {
    protected static final Logger LOG = Logger.getInstance(LocalResourceRepository.class);
    protected static final AtomicLong ourModificationCounter = new AtomicLong();
    private final String myDisplayName;
    @Nullable
    private List<MultiResourceRepository> myParents;
    protected long myGeneration;
    private final Object RESOURCE_DIRS_LOCK;
    @Nullable
    private Set<VirtualFile> myResourceDirs;

    protected LocalResourceRepository(@NotNull String displayName) {
        if (displayName == null) {
            LocalResourceRepository.$$$reportNull$$$0(0);
        }
        super(false);
        this.RESOURCE_DIRS_LOCK = new Object();
        this.myDisplayName = displayName;
        this.myGeneration = ourModificationCounter.incrementAndGet();
    }

    @NotNull
    public String getDisplayName() {
        String string = this.myDisplayName;
        if (string == null) {
            LocalResourceRepository.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void dispose() {
    }

    public final boolean isFramework() {
        return false;
    }

    public void addParent(MultiResourceRepository parent) {
        if (this.myParents == null) {
            this.myParents = Lists.newArrayListWithExpectedSize((int)2);
        }
        this.myParents.add(parent);
    }

    public void removeParent(MultiResourceRepository parent) {
        if (this.myParents != null) {
            this.myParents.remove((Object)parent);
        }
    }

    protected void invalidateItemCaches(ResourceType ... types) {
        if (this.myParents != null) {
            for (MultiResourceRepository parent : this.myParents) {
                parent.invalidateCache(this, types);
            }
        }
    }

    protected final void merge(@NotNull Set<LocalResourceRepository> visited, @NotNull ResourceType type, @NotNull SetMultimap<String, String> seenQualifiers, @NotNull ListMultimap<String, ResourceItem> result) {
        if (visited == null) {
            LocalResourceRepository.$$$reportNull$$$0(2);
        }
        if (type == null) {
            LocalResourceRepository.$$$reportNull$$$0(3);
        }
        if (seenQualifiers == null) {
            LocalResourceRepository.$$$reportNull$$$0(4);
        }
        if (result == null) {
            LocalResourceRepository.$$$reportNull$$$0(5);
        }
        if (visited.contains((Object)this)) {
            return;
        }
        visited.add(this);
        this.doMerge(visited, type, seenQualifiers, result);
    }

    protected void doMerge(@NotNull Set<LocalResourceRepository> visited, @NotNull ResourceType type, @NotNull SetMultimap<String, String> seenQualifiers, @NotNull ListMultimap<String, ResourceItem> result) {
        ListMultimap items;
        if (visited == null) {
            LocalResourceRepository.$$$reportNull$$$0(6);
        }
        if (type == null) {
            LocalResourceRepository.$$$reportNull$$$0(7);
        }
        if (seenQualifiers == null) {
            LocalResourceRepository.$$$reportNull$$$0(8);
        }
        if (result == null) {
            LocalResourceRepository.$$$reportNull$$$0(9);
        }
        if ((items = this.getMap(type, false)) == null) {
            return;
        }
        for (ResourceItem item : items.values()) {
            String name = item.getName();
            String qualifiers = item.getQualifiers();
            if (result.containsKey((Object)name) && type != ResourceType.ID && seenQualifiers.containsEntry((Object)name, (Object)qualifiers)) continue;
            result.put((Object)name, (Object)item);
            seenQualifiers.put((Object)name, (Object)qualifiers);
        }
    }

    protected boolean computeHasResourcesOfType(@NotNull ResourceType type, @NotNull Set<LocalResourceRepository> visited) {
        if (type == null) {
            LocalResourceRepository.$$$reportNull$$$0(10);
        }
        if (visited == null) {
            LocalResourceRepository.$$$reportNull$$$0(11);
        }
        if (!visited.add(this)) {
            return false;
        }
        return this.hasResourcesOfType(type);
    }

    public long getModificationCount() {
        return this.myGeneration;
    }

    @Nullable
    public VirtualFile getMatchingFile(VirtualFile file, ResourceType type, FolderConfiguration config) {
        List<VirtualFile> matches = this.getMatchingFiles(file, type, config);
        return matches.isEmpty() ? null : matches.get(0);
    }

    public List<VirtualFile> getMatchingFiles(VirtualFile file, ResourceType type, FolderConfiguration config) {
        List matches = super.getMatchingFiles(ResourceHelper.getResourceName(file), type, config);
        ArrayList<VirtualFile> matchesFiles = new ArrayList<VirtualFile>(matches.size());
        for (ResourceFile match : matches) {
            if (match == null) continue;
            if (match instanceof PsiResourceFile) {
                matchesFiles.add(((PsiResourceFile)match).getPsiFile().getVirtualFile());
                continue;
            }
            matchesFiles.add(LocalFileSystem.getInstance().findFileByIoFile(match.getFile()));
        }
        return matchesFiles;
    }

    @Deprecated
    @Nullable
    public ResourceFile getMatchingFile(String name, ResourceType type, FolderConfiguration config) {
        assert (name.indexOf(46) == -1) : name;
        return super.getMatchingFile(name, type, config);
    }

    @Nullable
    public DataBindingInfo getDataBindingInfoForLayout(String layoutName) {
        return null;
    }

    @Nullable
    public Map<String, DataBindingInfo> getDataBindingResourceFiles() {
        return null;
    }

    public boolean isScanPending(PsiFile psiFile) {
        return false;
    }

    @Nullable
    public static PsiFile getItemPsiFile(Project project, ResourceItem item) {
        if (project.isDisposed()) {
            return null;
        }
        if (item instanceof PsiResourceItem) {
            PsiResourceItem psiResourceItem = (PsiResourceItem)item;
            return psiResourceItem.getPsiFile();
        }
        ResourceFile source = (ResourceFile)item.getSource();
        if (source == null) {
            return null;
        }
        if (source instanceof PsiResourceFile) {
            PsiResourceFile prf = (PsiResourceFile)source;
            return prf.getPsiFile();
        }
        File file = source.getFile();
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(file);
        if (virtualFile != null) {
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            return psiManager.findFile(virtualFile);
        }
        return null;
    }

    @Nullable
    public static XmlTag getItemTag(Project project, ResourceItem item) {
        if (item instanceof PsiResourceItem) {
            PsiResourceItem psiResourceItem = (PsiResourceItem)item;
            return psiResourceItem.getTag();
        }
        PsiFile psiFile = LocalResourceRepository.getItemPsiFile(project, item);
        if (psiFile instanceof XmlFile) {
            String resourceName = item.getName();
            XmlFile xmlFile = (XmlFile)psiFile;
            ApplicationManager.getApplication().assertReadAccessAllowed();
            XmlTag rootTag = xmlFile.getRootTag();
            if (rootTag != null && rootTag.isValid()) {
                XmlTag[] subTags;
                for (XmlTag tag : subTags = rootTag.getSubTags()) {
                    if (!tag.isValid() || !resourceName.equals(tag.getAttributeValue("name"))) continue;
                    return tag;
                }
            }
            assert (FolderTypeRelationship.getRelatedFolders((ResourceType)item.getType()).contains(ResourceFolderType.VALUES)) : item.getType();
        }
        return null;
    }

    @Nullable
    public String getViewTag(ResourceItem item) {
        if (item instanceof PsiResourceItem) {
            XmlFile xmlFile;
            XmlTag rootTag;
            PsiResourceItem psiItem = (PsiResourceItem)item;
            XmlTag tag = psiItem.getTag();
            String id = item.getName();
            if (tag != null && tag.isValid() && id.equals(LintUtils.stripIdPrefix((String)tag.getAttributeValue("id", "http://schemas.android.com/apk/res/android")))) {
                return tag.getName();
            }
            PsiFile file = psiItem.getPsiFile();
            if (file.isValid() && file instanceof XmlFile && (rootTag = (xmlFile = (XmlFile)file).getRootTag()) != null && rootTag.isValid()) {
                return LocalResourceRepository.findViewTag(rootTag, id);
            }
        }
        return null;
    }

    @Nullable
    private static String findViewTag(XmlTag tag, String target) {
        String id = tag.getAttributeValue("id", "http://schemas.android.com/apk/res/android");
        if (id != null && id.endsWith(target) && target.equals(LintUtils.stripIdPrefix((String)id))) {
            return tag.getName();
        }
        for (XmlTag sub : tag.getSubTags()) {
            String found;
            if (!sub.isValid() || (found = LocalResourceRepository.findViewTag(sub, target)) == null) continue;
            return found;
        }
        return null;
    }

    public void sync() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public final Set<VirtualFile> getResourceDirs() {
        Object object = this.RESOURCE_DIRS_LOCK;
        // MONITORENTER : object
        if (this.myResourceDirs != null) {
            Set<VirtualFile> set = this.myResourceDirs;
            // MONITOREXIT : object
            if (set != null) return set;
            LocalResourceRepository.$$$reportNull$$$0(12);
            return set;
        }
        Set<VirtualFile> set = this.myResourceDirs = this.computeResourceDirs();
        // MONITOREXIT : object
        if (set != null) return set;
        LocalResourceRepository.$$$reportNull$$$0(13);
        return set;
    }

    @NotNull
    protected abstract Set<VirtualFile> computeResourceDirs();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invalidateResourceDirs() {
        Iterator<MultiResourceRepository> iterator = this.RESOURCE_DIRS_LOCK;
        synchronized (iterator) {
            this.myResourceDirs = null;
        }
        if (this.myParents != null) {
            for (LocalResourceRepository localResourceRepository : this.myParents) {
                localResourceRepository.invalidateResourceDirs();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 1: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/LocalResourceRepository";
                break;
            }
            case 2: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seenQualifiers";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/LocalResourceRepository";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceDirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 12: 
            case 13: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doMerge";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "computeHasResourcesOfType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

