/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.activity;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.run.activity.ActivityLocator;
import com.android.tools.idea.run.activity.ActivityLocatorUtils;
import com.android.tools.idea.run.activity.DefaultActivityLocator;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;

public class SpecificActivityLocator
extends ActivityLocator {
    @NotNull
    private final AndroidFacet myFacet;
    @Nullable
    private final String myActivityName;

    public SpecificActivityLocator(@NotNull AndroidFacet facet, @Nullable String activityName) {
        if (facet == null) {
            SpecificActivityLocator.$$$reportNull$$$0(0);
        }
        this.myFacet = facet;
        this.myActivityName = activityName;
    }

    @Override
    @NotNull
    public String getQualifiedActivityName(@NotNull IDevice device) {
        if (device == null) {
            SpecificActivityLocator.$$$reportNull$$$0(1);
        }
        assert (this.myActivityName != null);
        String string = this.myActivityName;
        if (string == null) {
            SpecificActivityLocator.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public void validate() throws ActivityLocator.ActivityLocatorException {
        DefaultActivityLocator.ActivityWrapper activity;
        Boolean exported;
        Element element;
        if (this.myActivityName == null || this.myActivityName.length() == 0) {
            throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("activity.class.not.specified.error", new Object[0]));
        }
        if (SpecificActivityLocator.doesPackageContainMavenProperty(this.myFacet)) {
            return;
        }
        Module module = this.myFacet.getModule();
        Project project = module.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiClass activityClass = facade.findClass("android.app.Activity", ProjectScope.getAllScope((Project)project));
        if (activityClass == null) {
            throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("cant.find.activity.class.error", new Object[0]));
        }
        PsiClass c = JavaExecutionUtil.findMainClass((Project)project, (String)this.myActivityName, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project));
        if (c == null || !c.isInheritor(activityClass, true)) {
            element = MergedManifest.get(module).findActivityAlias(this.myActivityName);
            if (element == null) {
                throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("not.activity.subclass.error", this.myActivityName));
            }
        } else {
            element = MergedManifest.get(module).findActivity(ActivityLocatorUtils.getQualifiedActivityName(c));
            if (element == null) {
                throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("activity.not.declared.in.manifest", c.getName()));
            }
        }
        if (!Boolean.TRUE.equals(exported = (activity = DefaultActivityLocator.ActivityWrapper.get(element)).getExported()) && !activity.hasIntentFilter()) {
            throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("specific.activity.not.launchable.error", new Object[0]));
        }
    }

    private static boolean doesPackageContainMavenProperty(@NotNull AndroidFacet facet) {
        Manifest manifest;
        if (facet == null) {
            SpecificActivityLocator.$$$reportNull$$$0(3);
        }
        if ((manifest = facet.getManifest()) == null) {
            return false;
        }
        String aPackage = manifest.getPackage().getStringValue();
        return aPackage != null && aPackage.contains("${");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/activity/SpecificActivityLocator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/activity/SpecificActivityLocator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedActivityName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedActivityName";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doesPackageContainMavenProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

