/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.draw;

import android.support.constraint.solver.widgets.Animator;
import com.android.tools.idea.uibuilder.scene.SceneContext;
import com.android.tools.idea.uibuilder.scene.draw.DisplayList;
import com.android.tools.idea.uibuilder.scene.draw.DrawRegion;
import com.android.tools.sherpa.drawing.ColorSet;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import org.jetbrains.annotations.NotNull;

public class DrawAnchor
extends DrawRegion {
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_BASELINE = 1;
    public static final int NORMAL = 0;
    public static final int OVER = 1;
    int myMode;
    boolean myIsConnected;
    int myType = 0;

    public DrawAnchor(String s) {
        String[] sp = s.split(",");
        int c = 0;
        c = super.parse(sp, c);
        this.myMode = Integer.parseInt(sp[c++]);
        this.myIsConnected = Boolean.parseBoolean(sp[c++]);
    }

    public DrawAnchor(int x, int y, int width, int height, int type, boolean isConnected, int mode) {
        super(x, y, width, height);
        this.myMode = mode;
        this.myIsConnected = isConnected;
        this.myType = type;
    }

    private int getPulseAlpha(int deltaT) {
        int v = (int)Animator.EaseInOutinterpolator((double)((double)(deltaT % 1000) / 1000.0), (double)0.0, (double)255.0);
        return v;
    }

    @Override
    public int getLevel() {
        return 30;
    }

    @Override
    public void paint(Graphics2D g, SceneContext sceneContext) {
        int delta2;
        int delta;
        if (this.myType == 1) {
            this.paintBaseline(g, sceneContext);
            return;
        }
        ColorSet colorSet = sceneContext.getColorSet();
        Color background = colorSet.getComponentObligatoryBackground();
        Color color = colorSet.getFrames();
        if (this.myMode == 1) {
            if (this.myIsConnected) {
                g.setColor(colorSet.getAnchorDisconnectionCircle());
            } else {
                g.setColor(colorSet.getAnchorConnectionCircle());
            }
            delta = this.width / 3;
            delta2 = delta * 2;
            g.fillRoundRect(this.x - delta, this.y - delta, this.width + delta2, this.height + delta2, this.width + delta2, this.height + delta2);
            g.drawRoundRect(this.x - delta, this.y - delta, this.width + delta2, this.height + delta2, this.width + delta2, this.height + delta2);
        }
        g.setColor(background);
        g.fillRoundRect(this.x, this.y, this.width, this.height, this.width, this.height);
        g.setColor(color);
        g.drawRoundRect(this.x, this.y, this.width, this.height, this.width, this.height);
        delta = this.width / 4;
        delta2 = delta * 2;
        if (this.myIsConnected) {
            g.fillRoundRect(this.x + delta, this.y + delta, this.width - delta2, this.height - delta2, this.width - delta2, this.height - delta2);
            g.drawRoundRect(this.x + delta, this.y + delta, this.width - delta2, this.height - delta2, this.width - delta2, this.height - delta2);
        }
        if (this.myMode == 1) {
            int alpha = this.getPulseAlpha((int)(sceneContext.getTime() % 1000L));
            Composite comp = g.getComposite();
            g.setComposite(AlphaComposite.getInstance(3, (float)alpha / 255.0f));
            if (this.myIsConnected) {
                g.setColor(colorSet.getAnchorDisconnectionCircle());
            } else {
                g.setColor(colorSet.getAnchorConnectionCircle());
            }
            g.fillRoundRect(this.x, this.y, this.width, this.height, this.width, this.height);
            sceneContext.repaint();
            g.setComposite(comp);
        }
    }

    public void paintBaseline(Graphics2D g, SceneContext sceneContext) {
        int inset = this.width / 10;
        ColorSet colorSet = sceneContext.getColorSet();
        Color background = colorSet.getComponentObligatoryBackground();
        Color color = colorSet.getFrames();
        g.setColor(color);
        g.fillRect(this.x, this.y + this.height / 2, this.width, 1);
        int ovalX = this.x + inset;
        int ovalW = this.width - 2 * inset;
        g.setColor(background);
        g.fillRoundRect(ovalX, this.y, ovalW, this.height, this.height, this.height);
        g.setColor(color);
        g.drawRoundRect(ovalX, this.y, ovalW, this.height, this.height, this.height);
        int delta = 3;
        int delta2 = delta * 2;
        if (this.myIsConnected) {
            g.fillRoundRect(ovalX + delta, this.y + delta, ovalW - delta2, this.height - delta2, this.height - delta2, this.height - delta2);
            g.drawRoundRect(ovalX + delta, this.y + delta, ovalW - delta2, this.height - delta2, this.height - delta2, this.height - delta2);
        }
        if (this.myMode == 1) {
            int alpha = this.getPulseAlpha((int)(sceneContext.getTime() % 1000L));
            Composite comp = g.getComposite();
            g.setComposite(AlphaComposite.getInstance(3, (float)alpha / 255.0f));
            if (this.myIsConnected) {
                g.setColor(colorSet.getAnchorDisconnectionCircle());
            } else {
                g.setColor(colorSet.getAnchorConnectionCircle());
            }
            g.fillRoundRect(ovalX, this.y, ovalW, this.height, this.height, this.height);
            g.drawRoundRect(ovalX, this.y, ovalW, this.height, this.height, this.height);
            sceneContext.repaint();
            g.setComposite(comp);
        }
    }

    @Override
    public String serialize() {
        return this.getClass().getSimpleName() + "," + this.x + "," + this.y + "," + this.width + "," + this.height + "," + this.myMode;
    }

    public static void add(@NotNull DisplayList list, @NotNull SceneContext transform, float left, float top, float right, float bottom, int type, boolean isConnected, int mode) {
        if (list == null) {
            DrawAnchor.$$$reportNull$$$0(0);
        }
        if (transform == null) {
            DrawAnchor.$$$reportNull$$$0(1);
        }
        int l = transform.getSwingX(left);
        int t = transform.getSwingY(top);
        int w = transform.getSwingDimension(right - left);
        int h = transform.getSwingDimension(bottom - top);
        list.add(new DrawAnchor(l, t, w, h, type, isConnected, mode));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "list";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "transform";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/uibuilder/scene/draw/DrawAnchor";
        objectArray[2] = "add";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

