/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.draw;

import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;

public class DrawConnectionUtils {
    static final int ZIGZAG = 2;
    static final int CENTER_ZIGZAG = 3;
    public static final int MARGIN_SPACING = 3;
    private static final boolean DEBUG = false;
    private static Polygon sLeftArrow;
    private static Polygon sTopArrow;
    private static Polygon sRightArrow;
    private static Polygon sBottomArrow;
    static Font sFont;
    static Font sFontReference;
    private static Font sSmallFont;
    public static Stroke sSpreadDashedStroke;
    public static Stroke sDashedStroke;
    public static final int ARROW_SIDE = 6;
    public static final int CONNECTION_ARROW_SIZE = 5;

    public static void drawCircledText(Graphics2D g, Font font, String text, int x, int y) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setFont(font);
        FontMetrics fm = g2.getFontMetrics();
        int padding = 4;
        Rectangle2D bounds = fm.getStringBounds(text, g2);
        double th = bounds.getHeight();
        double tw = bounds.getWidth();
        float radius = (float)(Math.max(th, tw) / 2.0 + (double)padding);
        Ellipse2D.Float circle = new Ellipse2D.Float((float)x - radius, (float)y - radius, 2.0f * radius + 1.0f, 2.0f * radius + 1.0f);
        g2.fill(circle);
        g2.setColor(Color.BLACK);
        g2.drawString(text, (int)((double)x - tw / 2.0), y + fm.getAscent() / 2);
        g2.dispose();
    }

    public static void drawRoundRectText(Graphics2D g, Font font, Color textColor, String text, int x, int y) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setFont(font);
        FontMetrics fm = g2.getFontMetrics();
        int padding = 4;
        Rectangle2D bounds = fm.getStringBounds(text, g2);
        double th = bounds.getHeight() + (double)(padding * 2);
        double tw = bounds.getWidth() + (double)(padding * 2);
        int radius = (int)(Math.min(th, tw) / 3.0);
        g2.fillRoundRect((int)((double)x - tw / 2.0), (int)((double)y - th / 2.0), (int)tw, (int)th, radius, radius);
        g2.setColor(textColor);
        g2.drawString(text, (int)((double)x - tw / 2.0 + (double)padding), (int)((double)y - th / 2.0 + (double)fm.getAscent() + (double)padding));
        g2.dispose();
    }

    public static void drawCircledText(Graphics2D g, String text, int x, int y) {
        DrawConnectionUtils.drawCircledText(g, sSmallFont, text, x, y);
    }

    public static void drawHorizontalMarginIndicator(Graphics2D g, String text, boolean isMarginReference, int x1, int x2, int y) {
        if (x1 > x2) {
            int temp = x1;
            x1 = x2;
            x2 = temp;
        }
        if (text == null) {
            g.drawLine(x1, y, x2, y);
            g.drawLine(x1, y, x1 + 5, y - 5);
            g.drawLine(x1, y, x1 + 5, y + 5);
            g.drawLine(x2, y, x2 - 5, y - 5);
            g.drawLine(x2, y, x2 - 5, y + 5);
            return;
        }
        Canvas c = new Canvas();
        Font previousFont = g.getFont();
        Font font = isMarginReference ? sFontReference : sFont;
        FontMetrics fm = c.getFontMetrics(font);
        g.setFont(font);
        int padding = 4;
        Rectangle2D bounds = fm.getStringBounds(text, g);
        int th = (int)bounds.getHeight();
        int tw = (int)bounds.getWidth();
        int offset = 15;
        int w = (x2 - x1 - (tw + 2 * padding)) / 2;
        if (w <= padding) {
            g.drawLine(x1, y, x2, y);
            g.drawString(text, x1 + w + padding, y + offset);
            g.drawLine(x1, y - 5, x1, y + 5);
            g.drawLine(x2, y - 5, x2, y + 5);
        } else {
            g.drawLine(x1, y, x1 + w, y);
            g.drawLine(x2 - w, y, x2, y);
            g.drawString(text, x1 + w + padding, (int)((double)y + bounds.getHeight() / 2.0));
            g.drawLine(x1, y, x1 + 5, y - 5);
            g.drawLine(x1, y, x1 + 5, y + 5);
            g.drawLine(x2, y, x2 - 5, y - 5);
            g.drawLine(x2, y, x2 - 5, y + 5);
        }
        g.setFont(previousFont);
    }

    public static void drawVerticalMarginIndicator(Graphics2D g, String text, boolean isMarginReference, int x, int y1, int y2) {
        if (y1 > y2) {
            int temp = y1;
            y1 = y2;
            y2 = temp;
        }
        if (text == null) {
            g.drawLine(x, y1, x, y2);
            g.drawLine(x, y1, x - 5, y1 + 5);
            g.drawLine(x, y1, x + 5, y1 + 5);
            g.drawLine(x, y2, x - 5, y2 - 5);
            g.drawLine(x, y2, x + 5, y2 - 5);
            return;
        }
        Canvas c = new Canvas();
        Font previousFont = g.getFont();
        Font font = isMarginReference ? sFontReference : sFont;
        FontMetrics fm = c.getFontMetrics(font);
        g.setFont(font);
        int padding = 4;
        Rectangle2D bounds = fm.getStringBounds(text, g);
        int th = (int)bounds.getHeight();
        int offset = 15;
        int h = (y2 - y1 - (th + 2 * padding)) / 2;
        if (h <= padding) {
            g.drawLine(x, y1, x, y2);
            g.drawString(text, (int)((double)x - bounds.getWidth() / 2.0) + offset, y2 - h - padding);
            g.drawLine(x - 5, y1, x + 5, y1);
            g.drawLine(x - 5, y2, x + 5, y2);
        } else {
            g.drawLine(x, y1, x, y1 + h);
            g.drawLine(x, y2 - h, x, y2);
            g.drawString(text, (int)((double)x - bounds.getWidth() / 2.0), y2 - h - padding);
            g.drawLine(x, y1, x - 5, y1 + 5);
            g.drawLine(x, y1, x + 5, y1 + 5);
            g.drawLine(x, y2, x - 5, y2 - 5);
            g.drawLine(x, y2, x + 5, y2 - 5);
        }
        g.setFont(previousFont);
    }

    public static void drawArrow(Graphics2D g, Polygon arrow, int x, int y) {
        arrow.translate(x, y);
        g.draw(arrow);
        g.fill(arrow);
        arrow.translate(-x, -y);
    }

    public static void getArrow(int direction, int x, int y, int[] xPoints, int[] yPoints) {
        xPoints[0] = x;
        yPoints[0] = y;
        switch (direction) {
            case 3: {
                xPoints[1] = x - 5;
                xPoints[2] = x + 5;
                yPoints[1] = y + 6;
                yPoints[2] = y + 6;
                break;
            }
            case 2: {
                xPoints[1] = x - 5;
                xPoints[2] = x + 5;
                yPoints[1] = y - 6;
                yPoints[2] = y - 6;
                break;
            }
            case 0: {
                xPoints[1] = x - 6;
                xPoints[2] = x - 6;
                yPoints[1] = y - 5;
                yPoints[2] = y + 5;
                break;
            }
            case 1: {
                xPoints[1] = x + 6;
                xPoints[2] = x + 6;
                yPoints[1] = y - 5;
                yPoints[2] = y + 5;
            }
        }
    }

    static void drawLines(GeneralPath path, int[] xPoints, int[] yPoints, int length, int archLen) {
        for (int i = 1; i < length; ++i) {
            path.lineTo(xPoints[i], yPoints[i]);
        }
    }

    static void drawRound(GeneralPath path, int[] xPoints, int[] yPoints, int length, int archLen) {
        int p;
        int lastx = xPoints[0];
        int lasty = yPoints[0];
        for (p = 1; p < length - 1; ++p) {
            int dir0;
            int d0x = xPoints[p] - lastx;
            int d0y = yPoints[p] - lasty;
            int d1x = xPoints[p + 1] - xPoints[p];
            int d1y = yPoints[p + 1] - yPoints[p];
            int len0 = Math.abs(d0x) + Math.abs(d0y);
            int len1 = Math.abs(d1x) + Math.abs(d1y);
            int d0xs = Integer.signum(d0x);
            int d0ys = Integer.signum(d0y);
            int d1xs = Integer.signum(d1x);
            int d1ys = Integer.signum(d1y);
            int useArch = Math.min(len0 - 2, Math.min(len1 / 2 - 2, archLen));
            if (useArch < 2) {
                path.lineTo(xPoints[p], yPoints[p]);
                lastx = xPoints[p];
                lasty = yPoints[p];
                continue;
            }
            path.lineTo(xPoints[p] - useArch * d0xs, yPoints[p] - useArch * d0ys);
            lastx = xPoints[p] + useArch * d1xs;
            lasty = yPoints[p] + useArch * d1ys;
            int n = d0xs == 0 ? (d0ys < 1 ? 0 : 2) : (dir0 = d0xs > 0 ? 1 : 3);
            int dir1 = d1xs == 0 ? (d1ys < 1 ? 0 : 2) : (d1xs > 0 ? 1 : 3);
            int rot = (4 + dir1 - dir0) % 4;
            boolean dir = rot == 1;
            DrawConnectionUtils.drawArc(path, xPoints[p] - useArch * d0xs, yPoints[p] - useArch * d0ys, lastx, lasty, useArch, useArch, 0.0f, false, dir);
            path.lineTo(lastx, lasty);
        }
        path.lineTo(xPoints[p], yPoints[p]);
    }

    private static void drawArc(Path2D p, float x0, float y0, float x1, float y1, float a, float b, float theta, boolean isMoreThanHalf, boolean isPositiveArc) {
        double cy;
        double cx;
        double thetaD = (double)theta * Math.PI / 180.0;
        double cosTheta = Math.cos(thetaD);
        double sinTheta = Math.sin(thetaD);
        double x0p = ((double)x0 * cosTheta + (double)y0 * sinTheta) / (double)a;
        double y0p = ((double)(-x0) * sinTheta + (double)y0 * cosTheta) / (double)b;
        double x1p = ((double)x1 * cosTheta + (double)y1 * sinTheta) / (double)a;
        double y1p = ((double)(-x1) * sinTheta + (double)y1 * cosTheta) / (double)b;
        double dx = x0p - x1p;
        double dy = y0p - y1p;
        double xm = (x0p + x1p) / 2.0;
        double ym = (y0p + y1p) / 2.0;
        double dsq = dx * dx + dy * dy;
        if (dsq == 0.0) {
            return;
        }
        double disc = 1.0 / dsq - 0.25;
        if (disc < 0.0) {
            float adjust = (float)(Math.sqrt(dsq) / 1.99999);
            DrawConnectionUtils.drawArc(p, x0, y0, x1, y1, a * adjust, b * adjust, theta, isMoreThanHalf, isPositiveArc);
            return;
        }
        double s = Math.sqrt(disc);
        double sdx = s * dx;
        double sdy = s * dy;
        if (isMoreThanHalf == isPositiveArc) {
            cx = xm - sdy;
            cy = ym + sdx;
        } else {
            cx = xm + sdy;
            cy = ym - sdx;
        }
        double eta0 = Math.atan2(y0p - cy, x0p - cx);
        double eta1 = Math.atan2(y1p - cy, x1p - cx);
        double sweep = eta1 - eta0;
        if (isPositiveArc != sweep >= 0.0) {
            sweep = sweep > 0.0 ? (sweep -= Math.PI * 2) : (sweep += Math.PI * 2);
        }
        double tcx = cx *= (double)a;
        cx = cx * cosTheta - (cy *= (double)b) * sinTheta;
        cy = tcx * sinTheta + cy * cosTheta;
        DrawConnectionUtils.arcToBezier(p, cx, cy, a, b, x0, y0, thetaD, eta0, sweep);
    }

    private static void arcToBezier(Path2D p, double cx, double cy, double a, double b, double e1x, double e1y, double theta, double start, double sweep) {
        int numSegments = Math.abs((int)Math.ceil(sweep * 4.0 / Math.PI));
        double eta1 = start;
        double cosTheta = Math.cos(theta);
        double sinTheta = Math.sin(theta);
        double cosEta1 = Math.cos(eta1);
        double sinEta1 = Math.sin(eta1);
        double ep1x = -a * cosTheta * sinEta1 - b * sinTheta * cosEta1;
        double ep1y = -a * sinTheta * sinEta1 + b * cosTheta * cosEta1;
        double anglePerSegment = sweep / (double)numSegments;
        for (int i = 0; i < numSegments; ++i) {
            double eta2 = eta1 + anglePerSegment;
            double sinEta2 = Math.sin(eta2);
            double cosEta2 = Math.cos(eta2);
            double e2x = cx + a * cosTheta * cosEta2 - b * sinTheta * sinEta2;
            double e2y = cy + a * sinTheta * cosEta2 + b * cosTheta * sinEta2;
            double ep2x = -a * cosTheta * sinEta2 - b * sinTheta * cosEta2;
            double ep2y = -a * sinTheta * sinEta2 + b * cosTheta * cosEta2;
            double tanDiff2 = Math.tan((eta2 - eta1) / 2.0);
            double alpha = Math.sin(eta2 - eta1) * (Math.sqrt(4.0 + 3.0 * tanDiff2 * tanDiff2) - 1.0) / 3.0;
            double q1x = e1x + alpha * ep1x;
            double q1y = e1y + alpha * ep1y;
            double q2x = e2x - alpha * ep2x;
            double q2y = e2y - alpha * ep2y;
            p.curveTo((float)q1x, (float)q1y, (float)q2x, (float)q2y, (float)e2x, (float)e2y);
            eta1 = eta2;
            e1x = e2x;
            e1y = e2y;
            ep1x = ep2x;
            ep1y = ep2y;
        }
    }

    public static void addVerticalSmallSpring(Path2D.Float path, int x0, int y1, int y2) {
        int springHeight = 2;
        int springWidth = 2;
        int distance = Math.abs(y2 - y1);
        int numSprings = distance / springHeight;
        int leftOver = (distance - numSprings * springHeight) / 2;
        path.lineTo(x0, y1);
        path.lineTo(x0, y1 - leftOver);
        int count = 0;
        if (y1 > y2) {
            for (int y = y1 - leftOver; y > y2 + leftOver; y -= springHeight) {
                int x = count % 2 == 0 ? x0 - springWidth : x0 + springWidth;
                path.lineTo(x, y);
                ++count;
            }
        } else {
            for (int y = y1 + leftOver; y < y2 - leftOver; y += springHeight) {
                int x = count % 2 == 0 ? x0 - springWidth : x0 + springWidth;
                path.lineTo(x, y);
                ++count;
            }
        }
        path.lineTo(x0, y2 + leftOver);
        path.lineTo(x0, y2);
    }

    public static void addHorizontalSmallSpring(Path2D.Float path, int y0, int x1, int x2) {
        int springHeight = 2;
        int springWidth = 2;
        int distance = Math.abs(x2 - x1);
        int numSprings = distance / springHeight;
        int leftOver = (distance - numSprings * springHeight) / 2;
        path.lineTo(x1, y0);
        path.lineTo(x1 - leftOver, y0 - leftOver);
        int count = 0;
        if (x1 > x2) {
            for (int x = x1 - leftOver; x > x2 + leftOver; x -= springHeight) {
                int y = count % 2 == 0 ? y0 - springWidth : y0 + springWidth;
                path.lineTo(x, y);
                ++count;
            }
        } else {
            for (int x = x1 + leftOver; x < x2 - leftOver; x += springHeight) {
                int y = count % 2 == 0 ? y0 - springWidth : y0 + springWidth;
                path.lineTo(x, y);
                ++count;
            }
        }
        path.lineTo(x2 + leftOver, y0);
        path.lineTo(x2, y0);
    }

    public static void drawHorizontalZigZagLine(Path2D.Float path, int x1, int x2, int y) {
        DrawConnectionUtils.drawHorizontalZigZagLine(path, x1, x2, y, 3, 3);
    }

    static void drawHorizontalZigZagLine(Path2D.Float path, int x1, int x2, int y, int dY1, int dY2) {
        if (x2 < x1) {
            int temp = x1;
            x1 = x2;
            x2 = temp;
        }
        int distance = x2 - x1;
        int step = 4 + (dY2 > 0 ? 2 : 0);
        int count = distance / step - 2;
        int remainings = distance - count * step;
        int x = x1 + remainings / 2;
        path.moveTo(x1, y);
        path.lineTo(x, y);
        for (int i = 0; i < count; ++i) {
            path.lineTo(x + 2, y + dY1);
            path.lineTo(x + 4, y - dY2);
            if (dY2 != 0) {
                path.lineTo(x + 6, y);
            }
            x += step;
        }
        path.lineTo(x2, y);
    }

    public static void drawVerticalZigZagLine(Path2D.Float path, int x, int y1, int y2) {
        DrawConnectionUtils.drawVerticalZigZagLine(path, x, y1, y2, 3, 3);
    }

    static void drawVerticalZigZagLine(Path2D.Float path, int x, int y1, int y2, int dX1, int dX2) {
        if (y2 < y1) {
            int temp = y1;
            y1 = y2;
            y2 = temp;
        }
        int distance = y2 - y1;
        int step = 4 + (dX2 > 0 ? 2 : 0);
        int count = distance / step - 2;
        int remainings = distance - count * step;
        int y = y1 + remainings / 2;
        path.moveTo(x, y1);
        path.lineTo(x, y);
        for (int i = 0; i < count; ++i) {
            path.lineTo(x + dX1, y + 2);
            path.lineTo(x - dX2, y + 4);
            if (dX2 != 0) {
                path.lineTo(x, y + 6);
            }
            y += step;
        }
        path.lineTo(x, y2);
    }

    public static int getVerticalMarginGap(Graphics2D g) {
        return g.getFontMetrics().getHeight() + 6;
    }

    public static int getHorizontalMarginGap(Graphics2D g, String string) {
        return (int)(g.getFontMetrics().getStringBounds(string, g).getWidth() + 6.0);
    }

    public static void drawHorizontalMargin(Graphics2D g, String string, boolean isReference, int x1, int x2, int y) {
        Font previousFont = g.getFont();
        FontMetrics metrics = g.getFontMetrics();
        Rectangle2D rect = metrics.getStringBounds(string, g);
        float sx = (float)((double)((x1 + x2) / 2) - rect.getWidth() / 2.0);
        float sy = y - 3 - metrics.getDescent();
        if (isReference) {
            g.setFont(sFontReference);
        }
        g.drawString(string, sx, sy);
        g.drawLine(x1, y, x2, y);
        g.setFont(previousFont);
    }

    public static void drawVerticalMargin(Graphics2D g, String string, boolean isReference, int x, int y1, int y2) {
        Font previousFont = g.getFont();
        FontMetrics metrics = g.getFontMetrics();
        Rectangle2D rect = metrics.getStringBounds(string, g);
        g.drawLine(x, y1, x, y2);
        float sx = x + 3;
        float sy = (float)((double)((y2 + y1) / 2) + rect.getHeight() / 2.0 - (double)metrics.getDescent());
        if (isReference) {
            g.setFont(sFontReference);
        }
        g.drawString(string, sx, sy);
        g.setFont(previousFont);
    }

    static {
        sFont = new Font("Helvetica", 0, 12);
        sFontReference = new Font("Helvetica", 3, 12);
        sSmallFont = new Font("Helvetica", 0, 8);
        sSpreadDashedStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{1.0f, 4.0f}, 0.0f);
        sDashedStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{2.0f}, 0.0f);
    }
}

