/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.lint;

import com.android.tools.lint.checks.BuiltinIssueRegistry;
import com.android.tools.lint.detector.api.Issue;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IssueIdConverter
extends ResolvingConverter<Issue> {
    private static ImmutableMap<String, Issue> ourIssues = null;

    @NotNull
    public static ImmutableMap<String, Issue> getIdSet() {
        if (ourIssues == null) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Issue issue : new BuiltinIssueRegistry().getIssues()) {
                builder.put((Object)issue.getId(), (Object)issue);
            }
            ourIssues = builder.build();
        }
        ImmutableMap<String, Issue> immutableMap = ourIssues;
        if (immutableMap == null) {
            IssueIdConverter.$$$reportNull$$$0(0);
        }
        return immutableMap;
    }

    @NotNull
    public Collection<Issue> getVariants(ConvertContext context) {
        ImmutableCollection immutableCollection = IssueIdConverter.getIdSet().values();
        if (immutableCollection == null) {
            IssueIdConverter.$$$reportNull$$$0(1);
        }
        return immutableCollection;
    }

    @Nullable
    public Issue fromString(@Nullable @NonNls String s, ConvertContext context) {
        return (Issue)IssueIdConverter.getIdSet().get((Object)s);
    }

    @Nullable
    public String toString(@Nullable Issue issue, ConvertContext context) {
        return issue == null ? null : issue.getId();
    }

    @Nullable
    public LookupElement createLookupElement(Issue issue) {
        return LookupElementBuilder.create((Object)issue, (String)issue.getId());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/android/dom/lint/IssueIdConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdSet";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

