/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.spring.data.commons.inspections.SpringDataRepositoriesInspection;
import com.intellij.spring.data.commons.util.SpringDataUtil;
import com.intellij.spring.data.commons.util.parser.Part;
import com.intellij.spring.data.commons.util.parser.PartTree;
import com.intellij.spring.data.commons.util.parser.SpringDataParserUtil;
import com.intellij.spring.data.commons.util.parser.domain.OrderBySource;
import com.intellij.spring.data.commons.util.parser.domain.PropertyPath;
import com.intellij.spring.data.commons.util.parser.domain.Sort;
import com.intellij.spring.data.utils.SpringDataBundle;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringDataMethodInconsistencyInspection
extends SpringDataRepositoriesInspection {
    @Override
    protected void checkRepositoryMethod(@NotNull ProblemsHolder holder, PsiClass repositoryClass, @NotNull PsiMethod psiMethod, @NotNull Module module, @NotNull Pair<PsiClass, ? extends PsiType> typePair) {
        if (holder == null) {
            SpringDataMethodInconsistencyInspection.$$$reportNull$$$0(0);
        }
        if (psiMethod == null) {
            SpringDataMethodInconsistencyInspection.$$$reportNull$$$0(1);
        }
        if (module == null) {
            SpringDataMethodInconsistencyInspection.$$$reportNull$$$0(2);
        }
        if (typePair == null) {
            SpringDataMethodInconsistencyInspection.$$$reportNull$$$0(3);
        }
        if (!SpringDataUtil.hasQueryAnnotation(psiMethod)) {
            SpringDataMethodInconsistencyInspection.checkMethodName(holder, psiMethod, module, typePair);
        }
    }

    private static void checkMethodName(@NotNull ProblemsHolder holder, @NotNull PsiMethod psiMethod, @NotNull Module module, @NotNull Pair<PsiClass, ? extends PsiType> typePair) {
        if (holder == null) {
            SpringDataMethodInconsistencyInspection.$$$reportNull$$$0(4);
        }
        if (psiMethod == null) {
            SpringDataMethodInconsistencyInspection.$$$reportNull$$$0(5);
        }
        if (module == null) {
            SpringDataMethodInconsistencyInspection.$$$reportNull$$$0(6);
        }
        if (typePair == null) {
            SpringDataMethodInconsistencyInspection.$$$reportNull$$$0(7);
        }
        String methodName = psiMethod.getName();
        PsiClass domainClass = (PsiClass)typePair.getFirst();
        PartTree partTree = new PartTree(methodName, domainClass);
        SpringDataMethodInconsistencyInspection.checkParts(holder, psiMethod, partTree);
        SpringDataMethodInconsistencyInspection.checkOrderBy(holder, psiMethod, domainClass, partTree);
    }

    private static void checkParts(@NotNull ProblemsHolder holder, @NotNull PsiMethod psiMethod, @NotNull PartTree partTree) {
        List<Part> parts;
        if (holder == null) {
            SpringDataMethodInconsistencyInspection.$$$reportNull$$$0(8);
        }
        if (psiMethod == null) {
            SpringDataMethodInconsistencyInspection.$$$reportNull$$$0(9);
        }
        if (partTree == null) {
            SpringDataMethodInconsistencyInspection.$$$reportNull$$$0(10);
        }
        if ((parts = partTree.getParts()).size() == 1 && StringUtil.isEmptyOrSpaces((String)parts.get(0).getSource())) {
            return;
        }
        for (Part part : parts) {
            for (PropertyPath property : part.getProperty()) {
                PsiIdentifier psiIdentifier;
                PsiType type = property.getType();
                if (type != null || (psiIdentifier = psiMethod.getNameIdentifier()) == null) continue;
                String propertyName = property.getSegment();
                if (StringUtil.isEmptyOrSpaces((String)propertyName)) {
                    SpringDataMethodInconsistencyInspection.addEmptyPropertyProblem(holder, psiMethod.getName(), partTree, part, psiIdentifier);
                    continue;
                }
                TextRange range = SpringDataMethodInconsistencyInspection.getTextRange(partTree, property);
                if (range == null) continue;
                holder.registerProblem((PsiElement)psiIdentifier, range, SpringDataBundle.message("cannot.resolve.property", propertyName), new LocalQuickFix[0]);
            }
        }
    }

    private static void checkOrderBy(@NotNull ProblemsHolder holder, @NotNull PsiMethod psiMethod, PsiClass domainClass, PartTree partTree) {
        PsiIdentifier identifier;
        OrderBySource source;
        if (holder == null) {
            SpringDataMethodInconsistencyInspection.$$$reportNull$$$0(11);
        }
        if (psiMethod == null) {
            SpringDataMethodInconsistencyInspection.$$$reportNull$$$0(12);
        }
        if ((source = partTree.getOrderBySource()) != null && (identifier = psiMethod.getNameIdentifier()) != null) {
            for (Map.Entry<Sort.Order, TextRange> entry : SpringDataParserUtil.getSortTextRanges(partTree).entrySet()) {
                Sort.Order order = entry.getKey();
                for (PropertyPath property : order.getPropertyPath()) {
                    PsiType type = property.getType();
                    if (type != null) continue;
                    String propertyName = property.getSegment();
                    if (StringUtil.isEmptyOrSpaces((String)propertyName)) {
                        String msg = SpringDataMethodInconsistencyInspection.getEmptyPropertyMessage(psiMethod.getName(), entry.getValue());
                        holder.registerProblem((PsiElement)identifier, SpringDataBundle.message("empty.property.with.empty.text.range", msg), new LocalQuickFix[0]);
                        continue;
                    }
                    TextRange range = SpringDataMethodInconsistencyInspection.getOrderByRange(partTree, property);
                    if (range == null) continue;
                    holder.registerProblem((PsiElement)psiMethod.getNameIdentifier(), range, SpringDataBundle.message("cannot.resolve.property", propertyName), new LocalQuickFix[0]);
                }
            }
        }
    }

    private static void addEmptyPropertyProblem(@NotNull ProblemsHolder holder, String methodName, PartTree partTree, Part part, PsiIdentifier psiIdentifier) {
        if (holder == null) {
            SpringDataMethodInconsistencyInspection.$$$reportNull$$$0(13);
        }
        if (methodName.equals(partTree.getSubject().getExpression())) {
            return;
        }
        Map<Part, TextRange> textRanges = SpringDataParserUtil.getPartTextRanges(partTree);
        TextRange range = textRanges.get(part);
        if (range != null) {
            if (range.getStartOffset() == range.getEndOffset()) {
                String msg = SpringDataMethodInconsistencyInspection.getEmptyPropertyMessage(methodName, range);
                holder.registerProblem((PsiElement)psiIdentifier, SpringDataBundle.message("empty.property.with.empty.text.range", msg), new LocalQuickFix[0]);
            } else {
                holder.registerProblem((PsiElement)psiIdentifier, range, SpringDataBundle.message("empty.property", new Object[0]), new LocalQuickFix[0]);
            }
        }
    }

    @NotNull
    private static String getEmptyPropertyMessage(String methodName, TextRange range) {
        String string = methodName.substring(0, range.getStartOffset()) + "<EMPTY_PROPERTY>" + methodName.substring(range.getEndOffset());
        if (string == null) {
            SpringDataMethodInconsistencyInspection.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Nullable
    private static TextRange getTextRange(@NotNull PartTree partTree, @NotNull PropertyPath property) {
        if (partTree == null) {
            SpringDataMethodInconsistencyInspection.$$$reportNull$$$0(15);
        }
        if (property == null) {
            SpringDataMethodInconsistencyInspection.$$$reportNull$$$0(16);
        }
        String methodName = partTree.getSource();
        String propertyName = property.getSegment();
        Map<Part, TextRange> textRanges = SpringDataParserUtil.getPartTextRanges(partTree);
        for (Map.Entry<Part, TextRange> entry : textRanges.entrySet()) {
            for (PropertyPath path : entry.getKey().getProperty()) {
                int startOffset;
                if (!path.equals(property) || (startOffset = methodName.indexOf(StringUtil.capitalize((String)propertyName), entry.getValue().getStartOffset())) < 0) continue;
                return TextRange.create((int)startOffset, (int)(startOffset + propertyName.length()));
            }
        }
        return null;
    }

    @Nullable
    private static TextRange getOrderByRange(@NotNull PartTree partTree, @NotNull PropertyPath property) {
        if (partTree == null) {
            SpringDataMethodInconsistencyInspection.$$$reportNull$$$0(17);
        }
        if (property == null) {
            SpringDataMethodInconsistencyInspection.$$$reportNull$$$0(18);
        }
        String methodName = partTree.getSource();
        String propertyName = property.getSegment();
        Map<Sort.Order, TextRange> textRanges = SpringDataParserUtil.getSortTextRanges(partTree);
        for (Map.Entry<Sort.Order, TextRange> entry : textRanges.entrySet()) {
            for (PropertyPath path : entry.getKey().getPropertyPath()) {
                if (!path.equals(property)) continue;
                int startOffset = methodName.indexOf(StringUtil.capitalize((String)propertyName), entry.getValue().getStartOffset());
                return TextRange.create((int)startOffset, (int)(startOffset + propertyName.length()));
            }
        }
        return null;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("SpringDataMethodInconsistencyInspection" == null) {
            SpringDataMethodInconsistencyInspection.$$$reportNull$$$0(19);
        }
        return "SpringDataMethodInconsistencyInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typePair";
                break;
            }
            case 10: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partTree";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/data/commons/inspections/SpringDataMethodInconsistencyInspection";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/data/commons/inspections/SpringDataMethodInconsistencyInspection";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyPropertyMessage";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkRepositoryMethod";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkMethodName";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkParts";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkOrderBy";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addEmptyPropertyProblem";
                break;
            }
            case 14: 
            case 19: {
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getTextRange";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getOrderByRange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

