/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.util.nodes;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.data.commons.util.nodes.PropertyNode;
import com.intellij.spring.data.commons.util.nodes.PropertyParametersType;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class SelectPropertyNode
extends PropertyNode {
    private static final Pattern IGNORE_CASE = Pattern.compile("Ignor(ing|e)Case");
    private String myPropertyName;
    private PropertyParametersType myType;
    private boolean ignoreCase;

    public SelectPropertyNode(@NotNull String expression) {
        if (expression == null) {
            SelectPropertyNode.$$$reportNull$$$0(0);
        }
        super(expression);
        this.myType = PropertyParametersType.SIMPLE_PROPERTY;
        this.ignoreCase = false;
        String expressionCaseProcessed = this.detectAndSetIgnoreCase(expression);
        this.myPropertyName = StringUtil.decapitalize((String)expressionCaseProcessed);
        Processor processor = type -> {
            for (String keyword : type.getKeywords()) {
                if (!expressionCaseProcessed.endsWith(keyword)) continue;
                this.myType = type;
                this.myPropertyName = StringUtil.decapitalize((String)expressionCaseProcessed.substring(0, expressionCaseProcessed.indexOf(keyword)));
                return false;
            }
            return true;
        };
        for (PropertyParametersType type2 : PropertyParametersType.ALL) {
            if (!processor.process((Object)type2)) break;
        }
    }

    @Override
    public String getPropertyName() {
        return this.myPropertyName;
    }

    @Override
    public boolean isDefaultKeyword() {
        return this.myType == PropertyParametersType.SIMPLE_PROPERTY;
    }

    public PropertyParametersType getType() {
        return this.myType;
    }

    @Override
    public Set<String> getPropertyKeywords() {
        HashSet strings = new HashSet();
        for (PropertyParametersType type : PropertyParametersType.ALL) {
            for (String propertyKeyword : type.getKeywords()) {
                strings.add((Object)propertyKeyword);
            }
        }
        return strings;
    }

    @Override
    @NotNull
    public String getKeyword() {
        String string = this.getExpression().substring(this.myPropertyName.length());
        if (string == null) {
            SelectPropertyNode.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    private String detectAndSetIgnoreCase(@NotNull String expression) {
        if (expression == null) {
            SelectPropertyNode.$$$reportNull$$$0(2);
        }
        Matcher matcher = IGNORE_CASE.matcher(expression);
        String result = expression;
        if (matcher.find()) {
            this.ignoreCase = true;
            result = expression.substring(0, matcher.start()) + expression.substring(matcher.end(), expression.length());
        }
        String string = result;
        if (string == null) {
            SelectPropertyNode.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/data/commons/util/nodes/SelectPropertyNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/data/commons/util/nodes/SelectPropertyNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyword";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "detectAndSetIgnoreCase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "detectAndSetIgnoreCase";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

