/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.jest;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import com.intellij.execution.ExecutionException;
import com.intellij.ide.DataManager;
import com.intellij.javascript.HelperFilesLocator;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.webcore.util.JsonUtil;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.commons.lang.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JestConfig {
    private static final String ROOT_DIR = "rootDir";
    private static final String TRANSFORM_IGNORE_PATTERNS = "transformIgnorePatterns";
    private static final String UNMOCKED_MODULE_PATH_PATTERNS = "unmockedModulePathPatterns";
    private static final String SETUP_TEST_FRAMEWORK_SCRIPT_FILE = "setupTestFrameworkScriptFile";
    private final JsonObject myConfig;

    public JestConfig(@NotNull JsonObject config2, @Nullable File configParentDir) {
        String preset;
        if (config2 == null) {
            JestConfig.$$$reportNull$$$0(0);
        }
        String rootDir = null;
        if (configParentDir != null) {
            String oldRootDir = JsonUtil.getChildAsString((JsonObject)config2, (String)ROOT_DIR);
            String newRootDir = JestConfig.calcNewRootDir(configParentDir, oldRootDir);
            config2.addProperty(ROOT_DIR, newRootDir);
            rootDir = newRootDir;
        }
        JsonObject presetConfig = (preset = JsonUtil.getChildAsString((JsonObject)config2, (String)"preset")) != null && rootDir != null ? JestConfig.loadPresetConfig(preset, rootDir) : null;
        JestConfig.addTransformIgnorePattern(config2, presetConfig);
        JestConfig.addUnmockedModulePathPattern(config2, presetConfig);
        this.myConfig = config2;
    }

    @Nullable
    private static JsonObject loadPresetConfig(@NotNull String preset, @NotNull String rootDir) {
        ResolvedModuleInfo info;
        File presetFile;
        String rootDirName;
        if (preset == null) {
            JestConfig.$$$reportNull$$$0(1);
        }
        if (rootDir == null) {
            JestConfig.$$$reportNull$$$0(2);
        }
        if (!preset.endsWith(".json")) {
            preset = preset + File.separator + "jest-preset.json";
        }
        if (preset.startsWith(rootDirName = "<rootDir>")) {
            preset = new File(rootDir, "./" + preset.substring(rootDirName.length())).getAbsolutePath();
        }
        if (preset.startsWith("./")) {
            preset = new File(rootDir, preset).getAbsolutePath();
        }
        if (!(presetFile = new File(preset)).isAbsolute() && (info = NodeModuleSearchUtil.resolveModule(preset, LocalFileSystem.getInstance().findFileByIoFile(new File(rootDir)), null, Collections.emptyList(), false, null)) != null) {
            presetFile = new File(info.getModuleMainFile().getPath());
        }
        if (presetFile.isAbsolute() && presetFile.isFile()) {
            try {
                String content = FileUtil.loadFile((File)presetFile, (Charset)StandardCharsets.UTF_8);
                return JsonUtil.parseJsonObject((String)content);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static void addTransformIgnorePattern(@NotNull JsonObject config2, @Nullable JsonObject presetConfig) {
        JsonArray array;
        if (config2 == null) {
            JestConfig.$$$reportNull$$$0(3);
        }
        if ((array = JsonUtil.getChildAsArray((JsonObject)config2, (String)TRANSFORM_IGNORE_PATTERNS)) == null) {
            array = new JsonArray();
            JsonArray presetPatterns = JsonUtil.getChildAsArray((JsonObject)presetConfig, (String)TRANSFORM_IGNORE_PATTERNS);
            if (presetPatterns != null) {
                array.addAll(presetPatterns);
            } else {
                array.add("/node_modules/");
            }
            config2.add(TRANSFORM_IGNORE_PATTERNS, (JsonElement)array);
        }
        array.add("^" + HelperFilesLocator.getBundledHelpersDir().getAbsolutePath());
    }

    private static void addUnmockedModulePathPattern(@NotNull JsonObject config2, @Nullable JsonObject presetConfig) {
        JsonArray array;
        if (config2 == null) {
            JestConfig.$$$reportNull$$$0(4);
        }
        if ((array = JsonUtil.getChildAsArray((JsonObject)config2, (String)UNMOCKED_MODULE_PATH_PATTERNS)) == null) {
            array = new JsonArray();
            JsonArray presetPatterns = JsonUtil.getChildAsArray((JsonObject)presetConfig, (String)UNMOCKED_MODULE_PATH_PATTERNS);
            if (presetPatterns != null) {
                array.addAll(presetPatterns);
            }
            config2.add(UNMOCKED_MODULE_PATH_PATTERNS, (JsonElement)array);
        }
        array.add("^" + HelperFilesLocator.getBundledHelpersDir().getAbsolutePath());
    }

    @NotNull
    public String stringifyConfig() throws ExecutionException {
        StringWriter writer = new StringWriter();
        try {
            Streams.write((JsonElement)this.myConfig, (JsonWriter)new JsonWriter((Writer)writer));
        }
        catch (IOException e) {
            throw new ExecutionException("Cannot serialize jest config", (Throwable)e);
        }
        String string = writer.toString();
        if (string == null) {
            JestConfig.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public String getSetupTestFrameworkScriptFile() {
        String setupFile = JsonUtil.getChildAsString((JsonObject)this.myConfig, (String)SETUP_TEST_FRAMEWORK_SCRIPT_FILE);
        String rootDir = this.getRootDir();
        if (setupFile != null && rootDir != null && !FileUtil.isAbsolute((String)(setupFile = setupFile.replace("<rootDir>", rootDir)))) {
            setupFile = new File(rootDir, setupFile).getAbsolutePath();
        }
        return setupFile;
    }

    @Nullable
    public String getRootDir() {
        return JsonUtil.getChildAsString((JsonObject)this.myConfig, (String)ROOT_DIR);
    }

    @NotNull
    public static JestConfig create(@NotNull String jestConfigFilePath, @NotNull String workingDirectory) throws ExecutionException {
        if (jestConfigFilePath == null) {
            JestConfig.$$$reportNull$$$0(6);
        }
        if (workingDirectory == null) {
            JestConfig.$$$reportNull$$$0(7);
        }
        if (!StringUtil.isEmptyOrSpaces((String)jestConfigFilePath)) {
            JestConfig jestConfig;
            block11: {
                File configFile = new File(jestConfigFilePath);
                if (!configFile.isAbsolute() || !configFile.isFile()) {
                    throw new ExecutionException("Failed to read Jest config " + jestConfigFilePath + ": no such file");
                }
                try {
                    String content = FileUtil.loadFile((File)configFile, (Charset)StandardCharsets.UTF_8);
                    JsonObject config2 = JsonUtil.parseJsonObject((String)content);
                    jestConfig = new JestConfig(config2, configFile.getParentFile());
                    if (jestConfig != null) break block11;
                }
                catch (Exception e) {
                    throw new JestConfigFileExecutionException("Failed to parse Jest config <a href='" + StringEscapeUtils.escapeXml((String)jestConfigFilePath) + "'>" + jestConfigFilePath + "</a>: malformed JSON", e);
                }
                JestConfig.$$$reportNull$$$0(8);
            }
            return jestConfig;
        }
        File packageJson = JestConfig.findPackageJson(workingDirectory);
        if (packageJson != null) {
            JestConfig jestConfig;
            block12: {
                try {
                    String content = FileUtil.loadFile((File)packageJson, (Charset)StandardCharsets.UTF_8);
                    JsonObject packageJsonObject = JsonUtil.parseJsonObject((String)content);
                    JsonObject jestObject = JsonUtil.getChildAsObject((JsonObject)packageJsonObject, (String)"jest");
                    if (jestObject == null) {
                        jestObject = new JsonObject();
                    }
                    if ((jestConfig = new JestConfig(jestObject, packageJson.getParentFile())) != null) break block12;
                }
                catch (Exception e) {
                    throw new JestConfigFileExecutionException("Failed to parse <a href='" + StringEscapeUtils.escapeXml((String)packageJson.getAbsolutePath()) + "'>" + packageJson.getAbsolutePath() + "</a>: malformed JSON", e);
                }
                JestConfig.$$$reportNull$$$0(9);
            }
            return jestConfig;
        }
        JestConfig jestConfig = new JestConfig(new JsonObject(), null);
        if (jestConfig == null) {
            JestConfig.$$$reportNull$$$0(10);
        }
        return jestConfig;
    }

    @NotNull
    private static String calcNewRootDir(@NotNull File configParentDir, @Nullable String rootDir) {
        if (configParentDir == null) {
            JestConfig.$$$reportNull$$$0(11);
        }
        if (rootDir != null && FileUtil.isAbsolute((String)rootDir)) {
            String string = rootDir;
            if (string == null) {
                JestConfig.$$$reportNull$$$0(12);
            }
            return string;
        }
        if (rootDir == null) {
            String string = configParentDir.getAbsolutePath();
            if (string == null) {
                JestConfig.$$$reportNull$$$0(13);
            }
            return string;
        }
        String string = new File(configParentDir, rootDir).getAbsolutePath();
        if (string == null) {
            JestConfig.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Nullable
    public static File findPackageJson(@NotNull String workingDirectory) {
        if (workingDirectory == null) {
            JestConfig.$$$reportNull$$$0(15);
        }
        for (File dir = new File(workingDirectory); dir != null; dir = dir.getParentFile()) {
            File packageJson = new File(dir, "package.json");
            if (!packageJson.isFile()) continue;
            return packageJson;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preset";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = ROOT_DIR;
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/jest/JestConfig";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jestConfigFilePath";
                break;
            }
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configParentDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/jest/JestConfig";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "stringifyConfig";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "calcNewRootDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadPresetConfig";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addTransformIgnorePattern";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addUnmockedModulePathPattern";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "calcNewRootDir";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findPackageJson";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JestConfigFileExecutionException
    extends ExecutionException
    implements HyperlinkListener {
        public JestConfigFileExecutionException(@NotNull String message, @NotNull Throwable cause) {
            if (message == null) {
                JestConfigFileExecutionException.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                JestConfigFileExecutionException.$$$reportNull$$$0(1);
            }
            super(message, cause);
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            VirtualFile file;
            if (e != null && e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (file = LocalFileSystem.getInstance().findFileByIoFile(new File(e.getDescription()))) != null) {
                FileEditorManager fileManager;
                Component component = (Component)ObjectUtils.tryCast((Object)e.getSource(), Component.class);
                Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(component));
                if (project != null && (fileManager = FileEditorManager.getInstance((Project)project)) != null) {
                    fileManager.openFile(file, true);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "message";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "cause";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/jest/JestConfig$JestConfigFileExecutionException";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

