/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.NodeJSRemoteInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeDetectionUtil {
    private static final Logger LOG = Logger.getInstance(NodeDetectionUtil.class);
    private static final String NODE_INTERPRETER_BASE_NAME = SystemInfo.isWindows ? "node.exe" : "node";
    private static final FileFilter NODE_FILTER = pathname -> {
        String path;
        if (SystemInfo.isWindows && (path = pathname.getAbsolutePath()).contains("Microsoft HPC Pack")) {
            return false;
        }
        return !SystemInfo.isUnix || !"/usr/sbin/node".equals(path = pathname.getAbsolutePath());
    };

    private NodeDetectionUtil() {
    }

    @Nullable
    public static File findInterpreterInPath() {
        return NodeJsLocalInterpreterUtil.findInterpreterInPath();
    }

    @NotNull
    public static List<File> listAllPossibleNodeInterpreters() {
        List<File> list = NodeDetectionUtil.listAllPossibleNodeInterpreters(true);
        if (list == null) {
            NodeDetectionUtil.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public static List<String> listAllPossibleNodeInterpretersWithRemote() {
        List<String> strings = NodeDetectionUtil.listAllPossibleNodeInterpretersPaths();
        NodeJSRemoteInterpreterManager remote = NodeJSRemoteInterpreterManager.getInstance();
        if (remote != null) {
            strings.addAll(remote.getRemoteInterpreters());
        }
        List<String> list = strings;
        if (list == null) {
            NodeDetectionUtil.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public static List<String> listAllPossibleNodeInterpretersPaths() {
        List<File> files = NodeDetectionUtil.listAllPossibleNodeInterpreters(true);
        List list = files.isEmpty() ? new ArrayList() : ContainerUtil.map(files, (Function)((NotNullFunction)dom -> dom.getAbsolutePath()));
        if (list == null) {
            NodeDetectionUtil.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public static List<File> listAllPossibleNodeInterpreters(boolean withPreviouslyUsedNodeInterpreters) {
        List fromPath = PathEnvironmentVariableUtil.findAllExeFilesInPath((String)NODE_INTERPRETER_BASE_NAME, (FileFilter)NODE_FILTER);
        NodeInterpreters interpreters = new NodeInterpreters();
        for (File interpreterFile : fromPath) {
            interpreters.add(interpreterFile, null);
        }
        NodeDetectionUtil.addNodeInterpretersFromNvm(interpreters);
        NodeDetectionUtil.listNodeInterpretersFromHomeBrew(interpreters);
        NodeDetectionUtil.listNodeInterpretersFromNodist(interpreters);
        List<File> list = interpreters.getSortedInterpreters();
        if (list == null) {
            NodeDetectionUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static void listNodeInterpretersFromNodist(@NotNull NodeInterpreters interpreters) {
        File versionsDir;
        String nodistPrefix;
        if (interpreters == null) {
            NodeDetectionUtil.$$$reportNull$$$0(4);
        }
        if (SystemInfo.isWindows && !StringUtil.isEmpty((String)(nodistPrefix = EnvironmentUtil.getValue((String)"NODIST_PREFIX"))) && (versionsDir = new File(nodistPrefix, "v")).isAbsolute() && versionsDir.isDirectory()) {
            NodeDetectionUtil.addNodeInterpretersFromVersionDir(interpreters, versionsDir, false);
        }
    }

    private static void addNodeInterpretersFromNvm(@NotNull NodeInterpreters interpreters) {
        File nvmDir;
        String nvmDirPath;
        if (interpreters == null) {
            NodeDetectionUtil.$$$reportNull$$$0(5);
        }
        if (StringUtil.isEmpty((String)(nvmDirPath = EnvironmentUtil.getValue((String)"NVM_DIR")))) {
            if (SystemInfo.isUnix) {
                nvmDirPath = SystemProperties.getUserHome() + "/.nvm";
            } else {
                return;
            }
        }
        if (!(nvmDir = new File(nvmDirPath)).isAbsolute()) {
            return;
        }
        NodeDetectionUtil.addNodeInterpretersFromVersionDir(interpreters, nvmDir, true);
        File versionsDir = new File(nvmDir, "versions");
        if (versionsDir.isDirectory()) {
            NodeDetectionUtil.addNodeInterpretersFromVersionDir(interpreters, new File(versionsDir, "node"), true);
            NodeDetectionUtil.addNodeInterpretersFromVersionDir(interpreters, new File(versionsDir, "io.js"), true);
        }
    }

    private static void listNodeInterpretersFromHomeBrew(@NotNull NodeInterpreters interpreters) {
        if (interpreters == null) {
            NodeDetectionUtil.$$$reportNull$$$0(6);
        }
        NodeDetectionUtil.addNodeInterpretersFromVersionDir(interpreters, new File("/usr/local/Cellar/node"), true);
    }

    private static void addNodeInterpretersFromVersionDir(@NotNull NodeInterpreters interpreters, @NotNull File parentDir, boolean insideBinDir) {
        if (interpreters == null) {
            NodeDetectionUtil.$$$reportNull$$$0(7);
        }
        if (parentDir == null) {
            NodeDetectionUtil.$$$reportNull$$$0(8);
        }
        if (!parentDir.isDirectory()) {
            return;
        }
        File[] dirs = parentDir.listFiles();
        if (dirs == null) {
            return;
        }
        for (File dir : dirs) {
            String relativePath;
            File interpreter;
            SemVer semVer = NodeDetectionUtil.parseSemVer(dir.getName());
            if (semVer == null || !(interpreter = new File(dir, relativePath = insideBinDir ? "bin" + File.separator + NODE_INTERPRETER_BASE_NAME : NODE_INTERPRETER_BASE_NAME)).isFile() || !interpreter.canExecute()) continue;
            interpreters.add(interpreter, semVer);
        }
    }

    @Nullable
    private static SemVer parseSemVer(@NotNull String name) {
        if (name == null) {
            NodeDetectionUtil.$$$reportNull$$$0(9);
        }
        name = StringUtil.trimStart((String)name, (String)"v");
        return SemVer.parseFromText((String)name);
    }

    @Nullable
    public static SemVer fetchInterpreterVersion(@NotNull String nodeInterpreterPath) {
        ProcessOutput output;
        if (nodeInterpreterPath == null) {
            NodeDetectionUtil.$$$reportNull$$$0(10);
        }
        if (nodeInterpreterPath.endsWith("/Contents/MacOS/Electron")) {
            return SemVer.parseFromText((String)"0.0.0");
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(nodeInterpreterPath);
        commandLine.addParameter("-v");
        try {
            output = NodeCommandLineUtil.execute(commandLine, 5000L);
        }
        catch (ExecutionException e) {
            LOG.warn("Cannot fetch node version, $ " + commandLine.getCommandLineString(), (Throwable)e);
            return null;
        }
        if (output.isTimeout()) {
            LOG.warn("Cannot fetch node version: timed out, $ " + commandLine.getCommandLineString());
            return null;
        }
        if (output.getExitCode() != 0) {
            LOG.warn("Cannot fetch node version: non-zero exit code " + output.getExitCode() + ", $ " + commandLine.getCommandLineString());
            return null;
        }
        List stdout = output.getStdoutLines(true);
        if (stdout.size() != 1) {
            LOG.warn("Cannot parse node version: single line was expected, actual line count: " + stdout.size() + ", stdout:" + stdout);
            return null;
        }
        return NodeDetectionUtil.parseSemVer((String)stdout.get(0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/NodeDetectionUtil";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreters";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDir";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeInterpreterPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "listAllPossibleNodeInterpreters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "listAllPossibleNodeInterpretersWithRemote";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "listAllPossibleNodeInterpretersPaths";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/NodeDetectionUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "listNodeInterpretersFromNodist";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addNodeInterpretersFromNvm";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "listNodeInterpretersFromHomeBrew";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addNodeInterpretersFromVersionDir";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseSemVer";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fetchInterpreterVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NodeInterpreter {
        private final File myInterpreter;
        private final SemVer mySemVer;

        public NodeInterpreter(@NotNull File interpreter, @Nullable SemVer semVer) {
            if (interpreter == null) {
                NodeInterpreter.$$$reportNull$$$0(0);
            }
            this.myInterpreter = interpreter;
            this.mySemVer = semVer;
        }

        @NotNull
        public File getInterpreter() {
            File file = this.myInterpreter;
            if (file == null) {
                NodeInterpreter.$$$reportNull$$$0(1);
            }
            return file;
        }

        @Nullable
        public SemVer getSemVer() {
            return this.mySemVer;
        }

        public String toString() {
            return this.myInterpreter.getAbsolutePath() + (this.mySemVer != null ? ", " + this.mySemVer : "");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interpreter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/NodeDetectionUtil$NodeInterpreter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/NodeDetectionUtil$NodeInterpreter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInterpreter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class NodeInterpreters {
        private final List<NodeInterpreter> myInterpreters = ContainerUtil.newArrayList();

        private NodeInterpreters() {
        }

        public void add(@NotNull File interpreterFile, @Nullable SemVer semVer) {
            if (interpreterFile == null) {
                NodeInterpreters.$$$reportNull$$$0(0);
            }
            this.myInterpreters.add(new NodeInterpreter(interpreterFile, semVer));
        }

        @NotNull
        public List<File> getSortedInterpreters() {
            Collections.sort(this.myInterpreters, (interpreter1, interpreter2) -> {
                SemVer semVer1 = interpreter1.getSemVer();
                SemVer semVer2 = interpreter2.getSemVer();
                if (semVer1 != null && semVer2 != null) {
                    int res = semVer2.compareTo(semVer1);
                    if (res == 0) {
                        res = interpreter1.getInterpreter().getAbsolutePath().compareTo(interpreter2.getInterpreter().getAbsolutePath());
                    }
                    return res;
                }
                if (semVer1 == null && semVer2 == null) {
                    return interpreter1.getInterpreter().getAbsolutePath().compareTo(interpreter2.getInterpreter().getAbsolutePath());
                }
                return semVer1 == null ? -1 : 1;
            });
            LinkedHashSet<File> result = new LinkedHashSet<File>(this.myInterpreters.size());
            for (NodeInterpreter interpreter : this.myInterpreters) {
                if (result.contains(interpreter.getInterpreter())) {
                    result.remove(interpreter.getInterpreter());
                }
                result.add(interpreter.getInterpreter());
            }
            ArrayList arrayList = ContainerUtil.newArrayList(result);
            if (arrayList == null) {
                NodeInterpreters.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interpreterFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/NodeDetectionUtil$NodeInterpreters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/NodeDetectionUtil$NodeInterpreters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSortedInterpreters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

