/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.javascript.nodejs.NodeSettings;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.library.NodeModulesDirectoryManager;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.PlatformUtils;
import com.intellij.util.Processor;
import com.intellij.webcore.resourceRoots.WebResourcesPathsConfiguration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class NodeModuleSearchUtil {
    private static final String NODE_MODULES = "node_modules";
    public static final String[] FILE_EXTENSIONS_IN_ORDER = new String[]{".coffee", ".d.ts", ".ts", ".tsx", ".js", ".jsx", ".json", ".node"};
    private static final Key<Pair<String, Long>> REDIRECT_PATHS_CACHE = Key.create((String)"Node.JS.Module.Redirect.Path");

    private NodeModuleSearchUtil() {
    }

    public static void findModulesWithName(@NotNull List<CompletionModuleInfo> modules, @NotNull String moduleName, @Nullable VirtualFile requester, @Nullable NodeSettings nodeSettings, boolean includeGloballyInstalled) {
        if (modules == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(0);
        }
        if (moduleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(1);
        }
        if (requester != null) {
            NodeModuleSearchUtil.findModulesWithNameFromNodeModulesDir(modules, requester, moduleName);
        }
        if (nodeSettings != null) {
            VirtualFile globalNodeModulesDir;
            NodeModuleSearchUtil.findModulesWithNameInGlobalFolders(modules, moduleName, nodeSettings.getGlobalFolders());
            if (includeGloballyInstalled && (globalNodeModulesDir = nodeSettings.getGlobalNodeModulesVirtualDir()) != null) {
                NodeModuleSearchUtil.findModuleWithNameInDirectory(modules, globalNodeModulesDir, ModuleType.GLOBAL_FOLDER, moduleName);
            }
        }
    }

    public static void findModulesWithName(@NotNull List<CompletionModuleInfo> modules, @NotNull String moduleName, @Nullable VirtualFile requester, boolean includeGloballyInstalled, @Nullable NodeJsInterpreter interpreter) {
        VirtualFile globalNodeModulesDir;
        NodeJsLocalInterpreter local;
        if (modules == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(2);
        }
        if (moduleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(3);
        }
        if (requester != null) {
            NodeModuleSearchUtil.findModulesWithNameFromNodeModulesDir(modules, requester, moduleName);
        }
        if ((local = NodeJsLocalInterpreter.tryCast(interpreter)) != null && includeGloballyInstalled && (globalNodeModulesDir = local.getGlobalNodeModulesVirtualDir()) != null) {
            NodeModuleSearchUtil.findModuleWithNameInDirectory(modules, globalNodeModulesDir, ModuleType.GLOBAL_FOLDER, moduleName);
        }
    }

    public static void findModulesByNameInContentRoots(@NotNull List<CompletionModuleInfo> modules, @NotNull String moduleName, @NotNull Project project, boolean includeNodeModulesOfSecondLevel, @Nullable NodeJsInterpreter interpreter) {
        if (modules == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(4);
        }
        if (moduleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(5);
        }
        if (project == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(6);
        }
        ReadAction.run(() -> {
            VirtualFile globalNodeModulesDir;
            if (project == null) {
                NodeModuleSearchUtil.$$$reportNull$$$0(77);
            }
            if (modules == null) {
                NodeModuleSearchUtil.$$$reportNull$$$0(78);
            }
            if (moduleName == null) {
                NodeModuleSearchUtil.$$$reportNull$$$0(79);
            }
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                for (VirtualFile contentRoot : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                    VirtualFile nodeModulesDir = contentRoot.findChild(NODE_MODULES);
                    if (!NodeModuleSearchUtil.isDirectory(nodeModulesDir)) continue;
                    if (includeNodeModulesOfSecondLevel) {
                        NodeModuleSearchUtil.findModulesByNameInNodeModulesOfFirstAndSecondsLevels(modules, nodeModulesDir, moduleName);
                        continue;
                    }
                    NodeModuleSearchUtil.findModuleWithNameInDirectory(modules, nodeModulesDir, ModuleType.NODE_MODULES_DIR, moduleName);
                }
            }
            NodeJsLocalInterpreter local = NodeJsLocalInterpreter.tryCast(interpreter);
            if (local != null && (globalNodeModulesDir = local.getGlobalNodeModulesVirtualDir()) != null) {
                NodeModuleSearchUtil.findModuleWithNameInDirectory(modules, globalNodeModulesDir, ModuleType.GLOBAL_FOLDER, moduleName);
            }
        });
    }

    private static void findModulesWithNameFromNodeModulesDir(@NotNull List<CompletionModuleInfo> modules, @NotNull VirtualFile requester, @NotNull String moduleName) {
        if (modules == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(7);
        }
        if (requester == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(8);
        }
        if (moduleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(9);
        }
        NodeModuleSearchUtil.processUpNodeModulesDirs(null, requester, (Processor<VirtualFile>)((Processor)nodeModulesDir -> {
            if (modules == null) {
                NodeModuleSearchUtil.$$$reportNull$$$0(75);
            }
            if (moduleName == null) {
                NodeModuleSearchUtil.$$$reportNull$$$0(76);
            }
            NodeModuleSearchUtil.findModuleWithNameInDirectory(modules, nodeModulesDir, ModuleType.NODE_MODULES_DIR, moduleName);
            return true;
        }));
    }

    private static void findModulesWithNameInGlobalFolders(@NotNull List<CompletionModuleInfo> modules, @NotNull String moduleName, @NotNull List<VirtualFile> globalFolders) {
        if (modules == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(10);
        }
        if (moduleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(11);
        }
        if (globalFolders == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(12);
        }
        for (VirtualFile dir : globalFolders) {
            if (!dir.isValid() || !dir.isDirectory()) continue;
            NodeModuleSearchUtil.findModuleWithNameInDirectory(modules, dir, ModuleType.GLOBAL_FOLDER, moduleName);
        }
    }

    private static void findModulesByNameInNodeModulesOfFirstAndSecondsLevels(@NotNull List<CompletionModuleInfo> modules, @NotNull VirtualFile firstLevelNodeModulesDir, @NotNull String moduleName) {
        if (modules == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(13);
        }
        if (firstLevelNodeModulesDir == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(14);
        }
        if (moduleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(15);
        }
        for (VirtualFile moduleDir : firstLevelNodeModulesDir.getChildren()) {
            VirtualFile secondLevelModuleDir;
            VirtualFile secondLevelNodeModulesDir;
            if (!moduleDir.isDirectory()) continue;
            String name = moduleDir.getName();
            if (moduleName.equals(name) && NodeModuleSearchUtil.canLoadDirectory(moduleDir)) {
                modules.add(new CompletionModuleInfo(name, moduleDir, ModuleType.NODE_MODULES_DIR));
            }
            if (!NodeModuleSearchUtil.isDirectory(secondLevelNodeModulesDir = moduleDir.findChild(NODE_MODULES)) || !NodeModuleSearchUtil.isDirectory(secondLevelModuleDir = secondLevelNodeModulesDir.findChild(moduleName)) || !NodeModuleSearchUtil.canLoadDirectory(secondLevelModuleDir)) continue;
            modules.add(new CompletionModuleInfo(name, secondLevelModuleDir, ModuleType.NODE_MODULES_DIR));
        }
    }

    public static boolean findModuleWithNameInDirectory(@NotNull List<CompletionModuleInfo> modules, @NotNull VirtualFile dir, @NotNull ModuleType moduleType, @NotNull String moduleName) {
        boolean ok;
        VirtualFile child;
        if (modules == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(16);
        }
        if (dir == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(17);
        }
        if (moduleType == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(18);
        }
        if (moduleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(19);
        }
        if ((child = dir.findFileByRelativePath(moduleName)) == null && dir instanceof NewVirtualFile && ApplicationManager.getApplication().isDispatchThread()) {
            child = ((NewVirtualFile)dir).refreshAndFindChild(moduleName);
        }
        if (child != null && (ok = NodeModuleSearchUtil.canLoad(child))) {
            String name = child.isDirectory() ? child.getName() : child.getNameWithoutExtension();
            modules.add(new CompletionModuleInfo(name, child, moduleType));
            return true;
        }
        return false;
    }

    @NotNull
    public static Collection<CompletionModuleInfo> collectVisibleNodeModules(@NotNull Map<String, CompletionModuleInfo> modules, @NotNull Project project, @Nullable VirtualFile requester, @Nullable NodeSettings nodeSettings) {
        if (modules == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(20);
        }
        if (project == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(21);
        }
        if (requester != null) {
            NodeModuleSearchUtil.collectModulesFromNodeModulesDir(modules, project, requester);
        }
        if (requester != null) {
            NodeModuleSearchUtil.collectModulesFromResourceRoots(modules, project, requester);
        }
        if (nodeSettings != null) {
            NodeModuleSearchUtil.collectModulesFromGlobalFolders(modules, nodeSettings.getGlobalFolders());
        }
        Collection<CompletionModuleInfo> collection = modules.values();
        if (collection == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(22);
        }
        return collection;
    }

    private static void collectModulesFromResourceRoots(@NotNull Map<String, CompletionModuleInfo> modules, @NotNull Project project, @Nullable VirtualFile requester) {
        WebResourcesPathsConfiguration pathsConfiguration;
        if (modules == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(23);
        }
        if (project == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(24);
        }
        if ((pathsConfiguration = WebResourcesPathsConfiguration.getInstance((Project)project)) != null) {
            List directories = pathsConfiguration.getResourceDirectories();
            NodeModuleSearchUtil.collectModulesInDirectories(directories, modules, ModuleType.RESOURCE_ROOT);
        }
        if (requester != null) {
            List<VirtualFile> resourceRoots = NodeModuleSearchUtil.getJavaResourceRoots(project, requester);
            NodeModuleSearchUtil.collectModulesInDirectories(resourceRoots, modules, ModuleType.RESOURCE_ROOT);
        }
    }

    private static void collectModulesFromNodeModulesDir(@NotNull Map<String, CompletionModuleInfo> modules, @NotNull Project project, @NotNull VirtualFile requester) {
        if (modules == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(25);
        }
        if (project == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(26);
        }
        if (requester == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(27);
        }
        NodeModuleSearchUtil.processUpNodeModulesDirs(project, requester, (Processor<VirtualFile>)((Processor)nodeModulesDir -> {
            if (modules == null) {
                NodeModuleSearchUtil.$$$reportNull$$$0(74);
            }
            NodeModuleSearchUtil.collectModulesInDirectory(nodeModulesDir, modules, ModuleType.NODE_MODULES_DIR);
            return true;
        }));
    }

    private static void collectModulesFromGlobalFolders(@NotNull Map<String, CompletionModuleInfo> modules, @NotNull List<VirtualFile> globalFolders) {
        if (modules == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(28);
        }
        if (globalFolders == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(29);
        }
        for (VirtualFile dir : globalFolders) {
            if (!dir.isValid() || !dir.isDirectory()) continue;
            NodeModuleSearchUtil.collectModulesInDirectory(dir, modules, ModuleType.GLOBAL_FOLDER);
        }
    }

    private static void collectModulesInDirectories(@NotNull List<VirtualFile> directories, @NotNull Map<String, CompletionModuleInfo> modules, @NotNull ModuleType moduleType) {
        if (directories == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(30);
        }
        if (modules == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(31);
        }
        if (moduleType == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(32);
        }
        for (VirtualFile directory : directories) {
            if (!directory.isDirectory() || !directory.isValid()) continue;
            NodeModuleSearchUtil.collectModulesInDirectory(directory, modules, moduleType);
        }
    }

    private static void collectModulesInDirectory(@NotNull VirtualFile dir, @NotNull Map<String, CompletionModuleInfo> modules, @NotNull ModuleType moduleType) {
        VirtualFile[] children;
        PackageJsonData data;
        Set<String> dependencies;
        VirtualFile packageJson;
        if (dir == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(33);
        }
        if (modules == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(34);
        }
        if (moduleType == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(35);
        }
        if (NodeModulesDirectoryManager.isNodeModulesDir(dir) && (packageJson = NodeModuleUtil.findPackageJsonByNodeModules(dir)) != null && packageJson.isValid() && !(dependencies = (data = PackageJsonUtil.getOrCreateData(packageJson)).getAllDependencies()).isEmpty()) {
            for (String dependency : dependencies) {
                VirtualFile moduleDir = dir.findFileByRelativePath(dependency);
                if (moduleDir == null || !moduleDir.isDirectory() || !moduleDir.isValid() || modules.containsKey(dependency)) continue;
                modules.put(dependency, new CompletionModuleInfo(dependency, moduleDir, moduleType));
            }
            return;
        }
        for (VirtualFile child : children = VfsUtil.getChildren((VirtualFile)dir)) {
            String moduleName;
            String childName = child.getName();
            if (NodeModuleSearchUtil.isScopeName(child)) {
                for (VirtualFile grandChild : child.getChildren()) {
                    String moduleName2;
                    if (!NodeModuleSearchUtil.canLoad(grandChild) || modules.containsKey(moduleName2 = childName + "/" + NodeModuleSearchUtil.getModuleName(grandChild))) continue;
                    modules.put(moduleName2, new CompletionModuleInfo(moduleName2, grandChild, moduleType));
                }
                continue;
            }
            if (!NodeModuleSearchUtil.canLoad(child) || modules.containsKey(moduleName = NodeModuleSearchUtil.getModuleName(child))) continue;
            modules.put(moduleName, new CompletionModuleInfo(moduleName, child, moduleType));
        }
    }

    private static String getModuleName(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(36);
        }
        return fileOrDir.isDirectory() ? fileOrDir.getName() : fileOrDir.getNameWithoutExtension();
    }

    private static boolean canLoad(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(37);
        }
        if (fileOrDir.isDirectory()) {
            return NodeModuleSearchUtil.canLoadDirectory(fileOrDir);
        }
        return NodeModuleSearchUtil.canLoadFile(fileOrDir);
    }

    public static boolean canLoadFile(@NotNull VirtualFile file) {
        String ext;
        if (file == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(38);
        }
        if ((ext = file.getExtension()) == null) {
            return false;
        }
        for (String expectedExt : FILE_EXTENSIONS_IN_ORDER) {
            if (!expectedExt.endsWith(ext) || ext.length() + 1 != expectedExt.length()) continue;
            return true;
        }
        return false;
    }

    public static boolean canLoadDirectory(@NotNull VirtualFile dir) {
        VirtualFile packageJson;
        if (dir == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(39);
        }
        if (NodeModuleSearchUtil.isFile(packageJson = dir.findChild("package.json"))) {
            return true;
        }
        for (String ext : FILE_EXTENSIONS_IN_ORDER) {
            VirtualFile child = dir.findChild("index" + ext);
            if (!NodeModuleSearchUtil.isFile(child)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static ResolvedModuleInfo resolveModule(@NotNull String requiredModuleName, @Nullable VirtualFile requester, @Nullable NodeSettings nodeSettings, @NotNull List<VirtualFile> nodePathFolders, boolean respectResourceRoots, @Nullable Project project) {
        if (requiredModuleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(40);
        }
        if (nodePathFolders == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(41);
        }
        ResolvedModuleInfo info = null;
        if (requester != null) {
            info = NodeModuleSearchUtil.resolveModuleFromNodeModulesDir(requester, requiredModuleName, NodeModuleDirectorySearchProcessor.PROCESSOR);
        }
        if (info == null && respectResourceRoots && project != null) {
            info = NodeModuleSearchUtil.resolveModuleFromResourceRoots(project, requiredModuleName, requester);
        }
        if (info == null) {
            info = NodeModuleSearchUtil.resolveModuleFromGlobalFolders(requiredModuleName, nodePathFolders);
        }
        if (info == null && nodeSettings != null) {
            info = NodeModuleSearchUtil.resolveModuleFromGlobalFolders(requiredModuleName, nodeSettings.getGlobalFolders());
        }
        return info;
    }

    @Nullable
    public static ResolvedModuleInfo resolveModuleFromNodeModulesDir(@NotNull VirtualFile requester, @NotNull String requiredModuleName, @NotNull NodeModuleDirectorySearchProcessor processor) {
        if (requester == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(42);
        }
        if (requiredModuleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(43);
        }
        if (processor == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(44);
        }
        Ref resolveRef = Ref.create();
        NodeModuleSearchUtil.processUpNodeModulesDirs(null, requester, (Processor<VirtualFile>)((Processor)nodeModulesDir -> {
            ResolvedModuleInfo info;
            if (processor == null) {
                NodeModuleSearchUtil.$$$reportNull$$$0(72);
            }
            if (requiredModuleName == null) {
                NodeModuleSearchUtil.$$$reportNull$$$0(73);
            }
            if ((info = processor.doResolveModule(null, ModuleType.NODE_MODULES_DIR, (VirtualFile)nodeModulesDir, requiredModuleName, true, true)) != null) {
                resolveRef.set((Object)info);
                return false;
            }
            return true;
        }));
        return (ResolvedModuleInfo)resolveRef.get();
    }

    @Nullable
    private static ResolvedModuleInfo resolveModuleFromResourceRoots(@NotNull Project project, @NotNull String requiredModuleName, @Nullable VirtualFile requester) {
        if (project == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(45);
        }
        if (requiredModuleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(46);
        }
        WebResourcesPathsConfiguration pathsConfiguration = WebResourcesPathsConfiguration.getInstance((Project)project);
        ResolvedModuleInfo info = null;
        if (pathsConfiguration != null) {
            List directories = pathsConfiguration.getResourceDirectories();
            info = NodeModuleSearchUtil.resolveModuleInResourceRoots(requiredModuleName, directories);
        }
        if (info == null && requester != null) {
            List<VirtualFile> resourceRoots = NodeModuleSearchUtil.getJavaResourceRoots(project, requester);
            info = NodeModuleSearchUtil.resolveModuleInResourceRoots(requiredModuleName, resourceRoots);
        }
        return info;
    }

    @NotNull
    private static List<VirtualFile> getJavaResourceRoots(@NotNull Project project, @NotNull VirtualFile requester) {
        if (project == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(47);
        }
        if (requester == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(48);
        }
        if (!PlatformUtils.isIdeaUltimate()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                NodeModuleSearchUtil.$$$reportNull$$$0(49);
            }
            return list;
        }
        ProjectFileIndex index = ProjectFileIndex.getInstance((Project)project);
        Module module = index.getModuleForFile(requester, false);
        if (module == null) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                NodeModuleSearchUtil.$$$reportNull$$$0(50);
            }
            return list;
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        List list = moduleRootManager.getSourceRoots((JpsModuleSourceRootType)JavaResourceRootType.RESOURCE);
        if (list == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(51);
        }
        return list;
    }

    @Nullable
    private static ResolvedModuleInfo resolveModuleInResourceRoots(@NotNull String requiredModuleName, @NotNull List<VirtualFile> resourceRoots) {
        if (requiredModuleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(52);
        }
        if (resourceRoots == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(53);
        }
        if (resourceRoots.isEmpty()) {
            return null;
        }
        for (VirtualFile rootDir : resourceRoots) {
            ResolvedModuleInfo info = NodeModuleSearchUtil.doResolveModule(null, ModuleType.RESOURCE_ROOT, rootDir, requiredModuleName, true, true);
            if (info == null) continue;
            return info;
        }
        return null;
    }

    private static void processUpNodeModulesDirs(@Nullable Project project, @NotNull VirtualFile requester, @NotNull Processor<VirtualFile> nodeModulesDirProcessor) {
        boolean continueIteration;
        VirtualFile nodeModulesDir;
        ProjectFileIndex index;
        VirtualFile dir;
        if (requester == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(54);
        }
        if (nodeModulesDirProcessor == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(55);
        }
        if (!(dir = requester).isDirectory()) {
            dir = requester.getParent();
        }
        ProjectFileIndex projectFileIndex = index = project == null ? null : ProjectFileIndex.getInstance((Project)project);
        while (!(dir == null || index != null && index.getContentRootForFile(dir, false) == null || (nodeModulesDir = dir.findChild(NODE_MODULES)) != null && nodeModulesDir.isDirectory() && nodeModulesDir.isValid() && !(continueIteration = nodeModulesDirProcessor.process((Object)nodeModulesDir)))) {
            dir = dir.getParent();
        }
    }

    @Nullable
    private static ResolvedModuleInfo resolveModuleFromGlobalFolders(@NotNull String requiredModuleName, @NotNull List<VirtualFile> globalFolders) {
        if (requiredModuleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(56);
        }
        if (globalFolders == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(57);
        }
        for (VirtualFile dir : globalFolders) {
            ResolvedModuleInfo info;
            if (!dir.isValid() || !dir.isDirectory() || (info = NodeModuleSearchUtil.doResolveModule(null, ModuleType.GLOBAL_FOLDER, dir, requiredModuleName, true, true)) == null) continue;
            return info;
        }
        return null;
    }

    @Nullable
    public static ResolvedModuleInfo resolveModuleByExactPath(@NotNull VirtualFile baseDir, @NotNull String requiredModuleName) {
        if (baseDir == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(58);
        }
        if (requiredModuleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(59);
        }
        return NodeModuleSearchUtil.doResolveModule(null, ModuleType.EXACT_PATH, baseDir, requiredModuleName, true, true);
    }

    @Nullable
    private static ResolvedModuleInfo doResolveModule(@Nullable VirtualFile moduleSourceRoot, @NotNull ModuleType type, @NotNull VirtualFile baseDir, @NotNull String requiredModuleName, boolean resolveDirectory, boolean respectPackageJson) {
        if (type == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(60);
        }
        if (baseDir == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(61);
        }
        if (requiredModuleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(62);
        }
        return NodeModuleDirectorySearchProcessor.PROCESSOR.doResolveModule(moduleSourceRoot, type, baseDir, requiredModuleName, resolveDirectory, respectPackageJson);
    }

    @NotNull
    public static Pair<Boolean, ModuleMainFiles> findMainModuleInPackage(@NotNull VirtualFile dir) {
        VirtualFile candidate;
        VirtualFile packageJson;
        if (dir == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(63);
        }
        if ((packageJson = PackageJsonUtil.findChildPackageJsonFile(dir)) != null) {
            PackageJsonData data = PackageJsonUtil.getOrCreateData(packageJson);
            VirtualFile mainModule = NodeModuleSearchUtil.findMainModuleByPath(dir, data.getMain());
            VirtualFile mainJsNextModule = NodeModuleSearchUtil.findMainModuleByPath(dir, data.getJsNextMain());
            if (mainModule != null || mainJsNextModule != null) {
                Pair pair = Pair.create((Object)true, (Object)new ModuleMainFiles(mainModule, mainJsNextModule));
                if (pair == null) {
                    NodeModuleSearchUtil.$$$reportNull$$$0(64);
                }
                return pair;
            }
        }
        if ((candidate = dir.findChild("index.js")) == null) {
            candidate = dir.findChild("index.node");
        }
        Pair pair = Pair.create((Object)false, (Object)new ModuleMainFiles(candidate, candidate));
        if (pair == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(65);
        }
        return pair;
    }

    @Nullable
    public static VirtualFile findMainModuleByPath(@NotNull VirtualFile dir, @Nullable String main) {
        if (dir == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(66);
        }
        if (main != null) {
            String[] parts = (main = main.startsWith("./") ? main.substring(2) : main).split("/");
            VirtualFile file = VfsUtil.findRelativeFile((VirtualFile)dir, (String[])parts);
            if (file == null && parts.length > 0 && !parts[parts.length - 1].contains(".")) {
                String withoutExtension = parts[parts.length - 1];
                parts[parts.length - 1] = withoutExtension + ".js";
                file = VfsUtil.findRelativeFile((VirtualFile)dir, (String[])parts);
                if (file == null) {
                    parts[parts.length - 1] = withoutExtension + ".node";
                    file = VfsUtil.findRelativeFile((VirtualFile)dir, (String[])parts);
                }
            }
            return file;
        }
        return null;
    }

    public static String getRedirectPathForModule(@NotNull Project project, @NotNull VirtualFile mainModule) {
        Pair value;
        if (project == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(67);
        }
        if (mainModule == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(68);
        }
        if ((value = (Pair)mainModule.getUserData(REDIRECT_PATHS_CACHE)) != null && ((Long)value.second).longValue() != mainModule.getModificationCount()) {
            value = null;
        }
        if (value == null) {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(mainModule);
            if (psiFile == null) {
                return null;
            }
            String path = CommonJSUtil.getNodeJsRedirectPath(psiFile);
            value = Pair.create((Object)path, (Object)mainModule.getModificationCount());
            mainModule.putUserData(REDIRECT_PATHS_CACHE, (Object)value);
        }
        return (String)value.first;
    }

    @Contract(value="null -> false", pure=true)
    static boolean isFile(@Nullable VirtualFile file) {
        return file != null && file.isValid() && !file.isDirectory();
    }

    @Contract(value="null -> false", pure=true)
    private static boolean isDirectory(@Nullable VirtualFile dir) {
        return dir != null && dir.isValid() && dir.isDirectory();
    }

    @Nullable
    public static VirtualFile findAncestorNodeModulesDir(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(69);
        }
        for (VirtualFile f = fileOrDir.getParent(); f != null; f = f.getParent()) {
            if (!StringUtil.equals((CharSequence)NODE_MODULES, (CharSequence)f.getNameSequence())) continue;
            return f;
        }
        return null;
    }

    @Nullable
    public static VirtualFile findDependencyRoot(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(70);
        }
        VirtualFile scope = fileOrDir;
        VirtualFile pkg = fileOrDir;
        while (scope != null) {
            VirtualFile parent = scope.getParent();
            if (parent != null && parent.isDirectory() && StringUtil.equals((CharSequence)NODE_MODULES, (CharSequence)parent.getNameSequence())) {
                return NodeModuleSearchUtil.isScopeName(scope) ? pkg : scope;
            }
            pkg = scope;
            scope = parent;
        }
        return null;
    }

    public static boolean isScopeName(@Nullable VirtualFile dir) {
        return dir != null && StringUtil.startsWith((CharSequence)dir.getNameSequence(), (CharSequence)"@");
    }

    public static boolean isFileModuleRequired(@NotNull String requiredModuleName) {
        if (requiredModuleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(71);
        }
        return requiredModuleName.startsWith("/") || requiredModuleName.startsWith("./") || requiredModuleName.startsWith("../");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 22: 
            case 49: 
            case 50: 
            case 51: 
            case 64: 
            case 65: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 22: 
            case 49: 
            case 50: 
            case 51: 
            case 64: 
            case 65: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: 
            case 11: 
            case 15: 
            case 19: 
            case 76: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 6: 
            case 21: 
            case 24: 
            case 26: 
            case 45: 
            case 47: 
            case 67: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 27: 
            case 42: 
            case 48: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requester";
                break;
            }
            case 12: 
            case 29: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalFolders";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstLevelNodeModulesDir";
                break;
            }
            case 17: 
            case 33: 
            case 39: 
            case 63: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 18: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleType";
                break;
            }
            case 22: 
            case 49: 
            case 50: 
            case 51: 
            case 64: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/NodeModuleSearchUtil";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directories";
                break;
            }
            case 36: 
            case 37: 
            case 69: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 40: 
            case 43: 
            case 46: 
            case 52: 
            case 56: 
            case 59: 
            case 62: 
            case 71: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredModuleName";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodePathFolders";
                break;
            }
            case 44: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceRoots";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeModulesDirProcessor";
                break;
            }
            case 58: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/NodeModuleSearchUtil";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "collectVisibleNodeModules";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaResourceRoots";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "findMainModuleInPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findModulesWithName";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findModulesByNameInContentRoots";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findModulesWithNameFromNodeModulesDir";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findModulesWithNameInGlobalFolders";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findModulesByNameInNodeModulesOfFirstAndSecondsLevels";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findModuleWithNameInDirectory";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "collectVisibleNodeModules";
                break;
            }
            case 22: 
            case 49: 
            case 50: 
            case 51: 
            case 64: 
            case 65: {
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "collectModulesFromResourceRoots";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "collectModulesFromNodeModulesDir";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "collectModulesFromGlobalFolders";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "collectModulesInDirectories";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "collectModulesInDirectory";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getModuleName";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "canLoad";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "canLoadFile";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "canLoadDirectory";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "resolveModule";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "resolveModuleFromNodeModulesDir";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "resolveModuleFromResourceRoots";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getJavaResourceRoots";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "resolveModuleInResourceRoots";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "processUpNodeModulesDirs";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "resolveModuleFromGlobalFolders";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "resolveModuleByExactPath";
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "doResolveModule";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "findMainModuleInPackage";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "findMainModuleByPath";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getRedirectPathForModule";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "findAncestorNodeModulesDir";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "findDependencyRoot";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "isFileModuleRequired";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resolveModuleFromNodeModulesDir$3";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "lambda$collectModulesFromNodeModulesDir$2";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findModulesWithNameFromNodeModulesDir$1";
                break;
            }
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findModulesByNameInContentRoots$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 22: 
            case 49: 
            case 50: 
            case 51: 
            case 64: 
            case 65: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ModuleMainFiles {
        @Nullable
        private final VirtualFile myMain;
        @Nullable
        private final VirtualFile myJsNextMain;

        public ModuleMainFiles(@Nullable VirtualFile jsNextMain, @Nullable VirtualFile main) {
            this.myMain = main;
            this.myJsNextMain = jsNextMain;
        }

        @Nullable
        public VirtualFile getMain() {
            return this.myMain;
        }

        @Nullable
        public VirtualFile getJsNextMain() {
            return this.myJsNextMain;
        }

        public boolean isEmpty() {
            return this.myMain == null && this.myJsNextMain == null;
        }
    }
}

