/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.ScriptingFrameworkDescriptor;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class NodeJsCoreLibraryUtil {
    private static final Logger LOG = Logger.getInstance(NodeJsCoreLibraryUtil.class);
    private static final AtomicNotNullLazyValue<Set<VirtualFile>> GLOBAL_STUB_FILES = new AtomicNotNullLazyValue<Set<VirtualFile>>(){

        @NotNull
        protected Set<VirtualFile> compute() {
            ImmutableSet immutableSet = ImmutableSet.copyOf((Collection)NodeJsCoreLibraryUtil.listNodeGlobalStubFiles());
            if (immutableSet == null) {
                1.$$$reportNull$$$0(0);
            }
            return immutableSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeJsCoreLibraryUtil$1", "compute"));
        }
    };
    private static final String[] GLOBAL_STUB_NAMES = new String[]{"node-globals-stub.js", "node-buffer-stub.js", "node-console-stub.js", "node-timers-stub.js"};
    private static final String OLD_NODE_CORE_MODULE_FRAMEWORK_NAME = "Node.js Core Modules";
    private static final AtomicBoolean REFRESHED = new AtomicBoolean(false);

    private NodeJsCoreLibraryUtil() {
    }

    @NotNull
    public static Set<VirtualFile> getNodeGlobalStubFiles() {
        Set set = (Set)GLOBAL_STUB_FILES.getValue();
        if (set == null) {
            NodeJsCoreLibraryUtil.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    private static List<VirtualFile> listNodeGlobalStubFiles() {
        ArrayList files = ContainerUtil.newArrayListWithCapacity((int)GLOBAL_STUB_NAMES.length);
        List toRefresh = ContainerUtil.newSmartList();
        for (String name : GLOBAL_STUB_NAMES) {
            URL url = NodeJsCoreLibraryUtil.class.getResource(name);
            if (url == null) {
                LOG.error("NodeJS plugin installation is possibly broken. Cannot find " + name);
                continue;
            }
            VirtualFile file = VfsUtil.findFileByURL((URL)url);
            if (file == null || !file.isValid()) {
                LOG.warn("NodeJS plugin installation is possibly broken. Cannot find virtual file for " + name + ", url: " + url.toExternalForm());
                toRefresh.add(url);
                continue;
            }
            files.add(file);
        }
        if (!toRefresh.isEmpty() && REFRESHED.compareAndSet(false, true)) {
            NodeJsCoreLibraryUtil.refreshAll(toRefresh);
        }
        ImmutableList immutableList = ImmutableList.copyOf((Collection)files);
        if (immutableList == null) {
            NodeJsCoreLibraryUtil.$$$reportNull$$$0(1);
        }
        return immutableList;
    }

    private static void refreshAll(@NotNull List<URL> toRefresh) {
        if (toRefresh == null) {
            NodeJsCoreLibraryUtil.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (toRefresh == null) {
                NodeJsCoreLibraryUtil.$$$reportNull$$$0(9);
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (toRefresh == null) {
                    NodeJsCoreLibraryUtil.$$$reportNull$$$0(10);
                }
                for (URL url : toRefresh) {
                    NodeJsCoreLibraryUtil.refresh(url);
                }
            });
        }, ModalityState.any());
    }

    private static void refresh(@NotNull URL url) {
        if (url == null) {
            NodeJsCoreLibraryUtil.$$$reportNull$$$0(3);
        }
        LOG.info("Refreshing " + url);
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        String vfUrl = VfsUtilCore.convertFromUrl((URL)url);
        VirtualFile file = virtualFileManager.findFileByUrl(vfUrl);
        if (file == null || !file.isValid()) {
            file = virtualFileManager.refreshAndFindFileByUrl(vfUrl);
        }
        if (file == null || !file.isValid()) {
            LOG.error("NodeJS plugin installation is possibly broken. Cannot find virtual file by url: " + url.toExternalForm() + ", file: " + file);
        }
    }

    private static boolean isOldCoreModulesLibrary(@NotNull ScriptingLibraryModel model) {
        ScriptingFrameworkDescriptor descriptor2;
        if (model == null) {
            NodeJsCoreLibraryUtil.$$$reportNull$$$0(4);
        }
        return (descriptor2 = model.getFrameworkDescriptor()) != null && !model.isPredefined() && OLD_NODE_CORE_MODULE_FRAMEWORK_NAME.equals(descriptor2.getFrameworkName());
    }

    public static boolean isOldLibraryOrderEntry(@NotNull OrderEntry orderEntry) {
        LibraryOrderEntry libraryOrderEntry;
        String libraryName;
        if (orderEntry == null) {
            NodeJsCoreLibraryUtil.$$$reportNull$$$0(5);
        }
        if (!orderEntry.isValid() && orderEntry instanceof LibraryOrderEntry && (libraryName = (libraryOrderEntry = (LibraryOrderEntry)orderEntry).getLibraryName()) != null && "application".equals(libraryOrderEntry.getLibraryLevel())) {
            String prefix = "Node.js ";
            String suffix = " Core Modules";
            if (libraryName.startsWith(prefix) && libraryName.endsWith(suffix)) {
                libraryName = StringUtil.trimStart((String)libraryName, (String)prefix);
                return SemVer.parseFromText((String)StringUtil.trimStart((String)(libraryName = StringUtil.trimEnd((String)libraryName, (String)suffix)), (String)"v")) != null;
            }
        }
        return false;
    }

    @NotNull
    public static List<ScriptingLibraryModel> listOldLibraries(@NotNull Project project) {
        if (project == null) {
            NodeJsCoreLibraryUtil.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
        List list = ContainerUtil.filter((Object[])libraryManager.getAllLibraries(), libraryModel -> NodeJsCoreLibraryUtil.isOldCoreModulesLibrary(libraryModel));
        if (list == null) {
            NodeJsCoreLibraryUtil.$$$reportNull$$$0(7);
        }
        return list;
    }

    public static boolean removeOldLibraries(@NotNull Project project) {
        if (project == null) {
            NodeJsCoreLibraryUtil.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
        JSLibraryMappings libraryMappings = JSLibraryMappings.getInstance(project);
        List<ScriptingLibraryModel> oldCoreLibraries = NodeJsCoreLibraryUtil.listOldLibraries(project);
        if (oldCoreLibraries.isEmpty()) {
            return false;
        }
        for (ScriptingLibraryModel oldLibrary : oldCoreLibraries) {
            LOG.info("Removing old Node.js library: " + oldLibrary.getName());
            List files = libraryMappings.getMappingsByLibraryName(oldLibrary.getName());
            for (VirtualFile file : files) {
                libraryMappings.disassociate(file, oldLibrary.getName());
            }
            libraryManager.removeLibrary(oldLibrary);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/NodeJsCoreLibraryUtil";
                break;
            }
            case 2: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRefresh";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntry";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeGlobalStubFiles";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "listNodeGlobalStubFiles";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/NodeJsCoreLibraryUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "listOldLibraries";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "refreshAll";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "refresh";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isOldCoreModulesLibrary";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isOldLibraryOrderEntry";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "listOldLibraries";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeOldLibraries";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$refreshAll$1";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

