/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library;

import com.intellij.ProjectTopics;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.NodeModulesLibrariesSnapshot;
import com.intellij.javascript.nodejs.library.NodeModulesLibraryDirectory;
import com.intellij.javascript.nodejs.library.NodeModulesRequestMerger;
import com.intellij.javascript.nodejs.packageJson.PackageJsonUpdateNotifier;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.ScriptingFrameworkDescriptor;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="NodeModulesDirectoryManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class NodeModulesDirectoryManager
implements PersistentStateComponent<Element> {
    public static final String TYPES_SCOPE_NAME = "@types";
    private static final Logger LOG = Logger.getInstance(NodeModulesDirectoryManager.class);
    private static final String HANDLED_PATH = "handled-path";
    private final Project myProject;
    private final ConcurrentMap<VirtualFile, Boolean> myHandledNodeModulesDirs;
    private final CachedValue<Set<VirtualFile>> myProjectModelExcludedDirsCache;
    private final AtomicReference<NodeModulesLibrariesSnapshot> mySnapshotRef;
    private final Map<VirtualFile, PackageJsonData> myDataByPackageJsonMap;
    private final NodeModulesRequestMerger myLibrariesUpdater;
    private final ProjectFileIndex myFileIndex;
    private final RecursionGuard myRecursionGuard;
    private final PackageJsonUpdateNotifier myPackageJsonUpdateNotifier;
    @Nullable
    private JSLibraryMappings myLibraryMappings;

    public NodeModulesDirectoryManager(@NotNull Project project, @NotNull ProjectFileIndex fileIndex, @NotNull PackageJsonUpdateNotifier packageJsonUpdateNotifier) {
        if (project == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(0);
        }
        if (fileIndex == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(1);
        }
        if (packageJsonUpdateNotifier == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(2);
        }
        this.myHandledNodeModulesDirs = ContainerUtil.newConcurrentMap();
        this.mySnapshotRef = new AtomicReference();
        this.myDataByPackageJsonMap = ContainerUtil.newConcurrentMap();
        this.myRecursionGuard = RecursionManager.createGuard((String)this.getClass().getName());
        this.myProject = project;
        this.myFileIndex = fileIndex;
        this.myLibrariesUpdater = new NodeModulesRequestMerger(project, Alarm.ThreadToUse.SWING_THREAD, 300L, () -> {
            if (project == null) {
                NodeModulesDirectoryManager.$$$reportNull$$$0(39);
            }
            WriteAction.run(() -> {
                if (project == null) {
                    NodeModulesDirectoryManager.$$$reportNull$$$0(40);
                }
                if (!project.isDisposed()) {
                    JSLibraryManager.getInstance(project).commitChanges();
                }
            });
        });
        this.myProjectModelExcludedDirsCache = NodeModulesDirectoryManager.createProjectModelExcludedDirsCache(project);
        final NodeModulesRequestMerger rootsChangedMerger = new NodeModulesRequestMerger(project, Alarm.ThreadToUse.POOLED_THREAD, 100L, () -> this.rootsChanged());
        this.myProject.getMessageBus().connect((Disposable)project).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                rootsChangedMerger.request();
            }
        });
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new PackageJsonListener(), (Disposable)project);
        this.myPackageJsonUpdateNotifier = packageJsonUpdateNotifier;
    }

    @NotNull
    private static CachedValue<Set<VirtualFile>> createProjectModelExcludedDirsCache(@NotNull Project project) {
        if (project == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(3);
        }
        CachedValue cachedValue = CachedValuesManager.getManager((Project)project).createCachedValue(() -> {
            if (project == null) {
                NodeModulesDirectoryManager.$$$reportNull$$$0(37);
            }
            Set excluded = (Set)ReadAction.compute(() -> {
                if (project == null) {
                    NodeModulesDirectoryManager.$$$reportNull$$$0(38);
                }
                if (project.isDisposed()) {
                    return Collections.emptySet();
                }
                HashSet dirs = ContainerUtil.newHashSet();
                for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                    ContainerUtil.addAll((Collection)dirs, (Object[])ModuleRootManager.getInstance((Module)module).getExcludeRoots());
                }
                return dirs;
            });
            return CachedValueProvider.Result.create((Object)excluded, (Object[])new Object[]{ProjectRootManager.getInstance((Project)project)});
        }, false);
        if (cachedValue == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(4);
        }
        return cachedValue;
    }

    protected void rootsChanged() {
        ReadAction.run(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            Set excluded = (Set)this.myProjectModelExcludedDirsCache.getValue();
            SmartList toRemove = new SmartList();
            for (VirtualFile dir : this.myHandledNodeModulesDirs.keySet()) {
                if (!dir.isValid()) {
                    toRemove.add(Pair.create((Object)dir, (Object)"invalid directory"));
                    continue;
                }
                if (this.myFileIndex.getContentRootForFile(dir, false) == null) {
                    toRemove.add(Pair.create((Object)dir, (Object)"out of content roots"));
                    continue;
                }
                if (!VfsUtilCore.isUnder((VirtualFile)dir, (Set)excluded)) continue;
                toRemove.add(Pair.create((Object)dir, (Object)"under excluded roots"));
            }
            if (!toRemove.isEmpty()) {
                for (Pair info : toRemove) {
                    this.myHandledNodeModulesDirs.remove(info.first);
                    LOG.info("Removed " + ((VirtualFile)info.first).getPath() + ": " + (String)info.second);
                }
                this.mySnapshotRef.set(null);
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    ApplicationManager.getApplication().invokeLater(() -> this.myLibrariesUpdater.request());
                } else {
                    this.myLibrariesUpdater.request();
                }
            }
        });
    }

    @Nullable
    public <T> T computeFileIndexExtensionPreventingRecursion(@NotNull Computable<T> computation) {
        Object result;
        if (computation == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(5);
        }
        if ((result = this.myRecursionGuard.doPreventingRecursion((Object)this, false, computation)) == null) {
            LOG.error(new Throwable("Recursion prevented when computing FileIndex extension"));
        }
        return (T)result;
    }

    @NotNull
    public static NodeModulesDirectoryManager getInstance(@NotNull Project project) {
        if (project == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(6);
        }
        NodeModulesDirectoryManager nodeModulesDirectoryManager = (NodeModulesDirectoryManager)ServiceManager.getService((Project)project, NodeModulesDirectoryManager.class);
        if (nodeModulesDirectoryManager == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(7);
        }
        return nodeModulesDirectoryManager;
    }

    @Nullable
    public Element getState() {
        Element root = new Element("x");
        ArrayList paths = ContainerUtil.newArrayList();
        for (VirtualFile file : this.myHandledNodeModulesDirs.keySet()) {
            if (!file.isValid()) continue;
            paths.add(file.getPath());
        }
        Collections.sort(paths);
        JDOMExternalizerUtil.addChildrenWithValueAttribute((Element)root, (String)HANDLED_PATH, (List)paths);
        return root;
    }

    public void loadState(Element state) {
        List paths = JDOMExternalizerUtil.getChildrenValueAttributes((Element)state, (String)HANDLED_PATH);
        paths = ContainerUtil.newArrayList((Iterable)paths);
        NodeModulesDirectoryManager.removeNestedNodeModulesPaths(paths);
        this.myHandledNodeModulesDirs.clear();
        for (String path : paths) {
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
            if (file == null || !file.isValid() || !NodeModulesDirectoryManager.isNodeModulesDir(file)) continue;
            this.myHandledNodeModulesDirs.put(file, true);
        }
    }

    private static void removeNestedNodeModulesPaths(@NotNull List<String> paths) {
        if (paths == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(8);
        }
        Collections.sort(paths);
        String prevPath = null;
        Iterator<String> i = paths.iterator();
        while (i.hasNext()) {
            String path = i.next();
            if (prevPath != null && path.startsWith(prevPath)) {
                LOG.warn("Removing descendant " + path);
                i.remove();
                continue;
            }
            prevPath = path;
        }
    }

    @NotNull
    public List<NodeModulesLibraryDirectory> getNodeModulesDirectories() {
        List<NodeModulesLibraryDirectory> list = this.getOrCreateSnapshot().getLibraryDirs();
        if (list == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(9);
        }
        return list;
    }

    public boolean isNodeModulesLibraryDirWithMappings(@NotNull VirtualFile nodeModulesDir) {
        NodeModulesLibraryDirectory dir;
        if (nodeModulesDir == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(10);
        }
        return (dir = this.getOrCreateSnapshot().findLibraryDir(nodeModulesDir)) != null && !dir.isForApplicationSourceCode() && this.isLibraryWithMappings(dir);
    }

    public boolean isLibraryWithMappings(@NotNull NodeModulesLibraryDirectory libraryDirectory) {
        JSLibraryMappings mappings;
        if (libraryDirectory == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(11);
        }
        return !(mappings = this.getLibraryMappings()).getMappingsByLibraryName(libraryDirectory.getLibraryName()).isEmpty();
    }

    @NotNull
    private JSLibraryMappings getLibraryMappings() {
        JSLibraryMappings libraryMappings = this.myLibraryMappings;
        if (libraryMappings == null) {
            this.myLibraryMappings = libraryMappings = JSLibraryMappings.getInstance(this.myProject);
        }
        JSLibraryMappings jSLibraryMappings = libraryMappings;
        if (jSLibraryMappings == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(12);
        }
        return jSLibraryMappings;
    }

    public static boolean isNodeModulesDir(@NotNull VirtualFile dir) {
        if (dir == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(13);
        }
        return dir.isDirectory() && StringUtil.equals((CharSequence)"node_modules", (CharSequence)dir.getNameSequence());
    }

    public static boolean isForApplicationSourceCode(@NotNull VirtualFile nodeModulesDir) {
        VirtualFile packageJson;
        if (nodeModulesDir == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(14);
        }
        return (packageJson = NodeModuleUtil.findPackageJsonByNodeModules(nodeModulesDir)) == null || packageJson.isValid() && packageJson.isDirectory();
    }

    public void onProjectOpened() {
        NodeModulesDirsCollector collector = new NodeModulesDirsCollector();
        this.removeOldLibraries(collector, () -> {
            this.detectNodeModulesInContentRoots(collector);
            this.tryAddLibraries(collector.getTopLevelNodeModulesDirInfos());
            DumbService.getInstance((Project)this.myProject).runWhenSmart(() -> ApplicationManager.getApplication().executeOnPooledThread(() -> this.tryAddLibraries(this.findAllNodeModules(collector).getTopLevelNodeModulesDirInfos())));
        });
    }

    @NotNull
    private NodeModulesDirsCollector findAllNodeModules(@NotNull NodeModulesDirsCollector alreadyProcessed) {
        if (alreadyProcessed == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(15);
        }
        NodeModulesDirsCollector collector = new NodeModulesDirsCollector();
        ReadAction.run(() -> {
            if (alreadyProcessed == null) {
                NodeModulesDirectoryManager.$$$reportNull$$$0(36);
            }
            try {
                Collection foundDirs = FilenameIndex.getVirtualFilesByName((Project)this.myProject, (String)"node_modules", (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject));
                for (VirtualFile dir : foundDirs) {
                    if (alreadyProcessed.myInfos.containsKey(dir)) continue;
                    collector.add(dir);
                }
            }
            catch (ProcessCanceledException e) {
                LOG.info("Failed to locate all node_modules/ in project");
            }
        });
        NodeModulesDirsCollector nodeModulesDirsCollector = collector;
        if (nodeModulesDirsCollector == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(16);
        }
        return nodeModulesDirsCollector;
    }

    private void detectNodeModulesInContentRoots(@NotNull NodeModulesDirsCollector collector) {
        if (collector == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(17);
        }
        ReadAction.run(() -> {
            if (collector == null) {
                NodeModulesDirectoryManager.$$$reportNull$$$0(35);
            }
            if (this.myProject.isDisposed()) {
                return;
            }
            for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                for (VirtualFile contentRoot : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                    VirtualFile nodeModulesDir = contentRoot.findChild("node_modules");
                    if (nodeModulesDir == null || !nodeModulesDir.isValid() || !nodeModulesDir.isDirectory()) continue;
                    collector.add(nodeModulesDir);
                }
            }
        });
    }

    @Nullable
    private VirtualFile findTopLevelNodeModulesDirInsideContentRoots(@Nullable VirtualFile nodeModulesDir) {
        VirtualFile result = null;
        while (nodeModulesDir != null && this.myFileIndex.getContentRootForFile(nodeModulesDir, false) != null) {
            result = nodeModulesDir;
            nodeModulesDir = NodeModuleSearchUtil.findAncestorNodeModulesDir(nodeModulesDir);
        }
        return result;
    }

    private void removeOldLibraries(@NotNull NodeModulesDirsCollector collector, @NotNull Runnable onDone) {
        List<ScriptingLibraryModel> libraries;
        if (collector == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(18);
        }
        if (onDone == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(19);
        }
        if ((libraries = this.listOldLibraries(collector)).isEmpty()) {
            onDone.run();
        } else {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (onDone == null) {
                    NodeModulesDirectoryManager.$$$reportNull$$$0(33);
                }
                WriteAction.run(() -> {
                    if (onDone == null) {
                        NodeModulesDirectoryManager.$$$reportNull$$$0(34);
                    }
                    JSLibraryManager libraryManager = JSLibraryManager.getInstance(this.myProject);
                    JSLibraryMappings libraryMappings = this.getLibraryMappings();
                    for (ScriptingLibraryModel library : libraries) {
                        List files = libraryMappings.getMappingsByLibraryName(library.getName());
                        for (VirtualFile file : files) {
                            libraryMappings.disassociate(file, library.getName());
                        }
                        libraryManager.removeLibrary(library);
                        LOG.info("Removed library '" + library.getName() + "'");
                    }
                    libraryManager.commitChanges();
                    ApplicationManager.getApplication().executeOnPooledThread(onDone);
                });
            }, ModalityState.NON_MODAL, this.myProject.getDisposed());
        }
    }

    @NotNull
    private List<ScriptingLibraryModel> listOldLibraries(@NotNull NodeModulesDirsCollector collector) {
        if (collector == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(20);
        }
        List list = (List)ReadAction.compute(() -> {
            ScriptingLibraryModel[] libraries;
            if (collector == null) {
                NodeModulesDirectoryManager.$$$reportNull$$$0(32);
            }
            ArrayList result = ContainerUtil.newArrayList();
            JSLibraryManager libraryManager = JSLibraryManager.getInstance(this.myProject);
            for (ScriptingLibraryModel library : libraries = libraryManager.getLibraries(ScriptingLibraryModel.LibraryLevel.PROJECT)) {
                boolean matches;
                ScriptingFrameworkDescriptor descriptor2 = library.getFrameworkDescriptor();
                boolean bl = matches = descriptor2 != null && "node_modules".equals(descriptor2.getFrameworkName()) && library.getName().endsWith(" node_modules");
                if (!matches && library.getName().startsWith("Node.js Dependencies for ")) {
                    matches = library.getSourceFiles().stream().allMatch(file -> !file.isValid() || NodeModulesDirectoryManager.isNodeModulesDir(file));
                }
                if (!matches) continue;
                result.add(library);
                List mappings = this.getLibraryMappings().getMappingsByLibraryName(library.getName());
                for (VirtualFile file2 : library.getSourceFiles()) {
                    collector.add(file2, mappings);
                }
            }
            return result;
        });
        if (list == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(21);
        }
        return list;
    }

    private void tryAddLibraries(@NotNull Collection<DirInfo> infos) {
        if (infos == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(22);
        }
        List infosToProcess = ContainerUtil.newSmartList();
        for (DirInfo info : infos) {
            boolean added;
            boolean bl = added = this.myHandledNodeModulesDirs.putIfAbsent(info.myNodeModulesDir, true) == null;
            if (!added && !info.myForceAddMappings || NodeModulesDirectoryManager.isForApplicationSourceCode(info.myNodeModulesDir)) continue;
            infosToProcess.add(info);
        }
        if (infosToProcess.isEmpty()) {
            return;
        }
        this.mySnapshotRef.set(null);
        NodeModulesLibrariesSnapshot snapshot = this.getOrCreateSnapshot();
        Runnable task = () -> WriteAction.run(() -> {
            JSLibraryManager libraryManager = JSLibraryManager.getInstance(this.myProject);
            libraryManager.commitChanges();
            for (DirInfo info : infosToProcess) {
                VirtualFile nodeModulesDir = info.myNodeModulesDir;
                String libraryName = snapshot.findLibraryName(nodeModulesDir);
                if (libraryName == null) {
                    LOG.warn("No library name calculated for " + nodeModulesDir.getPath());
                    continue;
                }
                List mappings = info.myMappings;
                if (!mappings.isEmpty()) {
                    if (libraryManager.getLibraryByName(libraryName) == null) {
                        LOG.warn("Cannot find library by name " + libraryName + ", " + nodeModulesDir.getPath());
                        continue;
                    }
                    for (VirtualFile mapping : mappings) {
                        libraryManager.getLibraryMappings().associate(mapping, libraryName, true);
                    }
                }
                LOG.info("Associate " + libraryName + " with " + mappings);
            }
            libraryManager.commitChanges();
        });
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().invokeAndWait(task);
        } else {
            TransactionGuard.submitTransaction((Disposable)this.myProject, (Runnable)task);
        }
    }

    @NotNull
    private NodeModulesLibrariesSnapshot getOrCreateSnapshot() {
        NodeModulesLibrariesSnapshot snapshot = this.mySnapshotRef.get();
        while (snapshot == null) {
            snapshot = new NodeModulesLibrariesSnapshot(this.myProject, this.myHandledNodeModulesDirs.keySet());
            this.mySnapshotRef.compareAndSet(null, snapshot);
            snapshot = this.mySnapshotRef.get();
        }
        NodeModulesLibrariesSnapshot nodeModulesLibrariesSnapshot = snapshot;
        if (nodeModulesLibrariesSnapshot == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(23);
        }
        return nodeModulesLibrariesSnapshot;
    }

    public void setProvidedPackageJsonRoots(@NotNull VirtualFile packageJson, @NotNull PackageJsonData data) {
        if (packageJson == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(24);
        }
        if (data == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(25);
        }
        this.myDataByPackageJsonMap.put(packageJson, data);
    }

    private void handleAddingPackageJson(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(26);
        }
        if (PackageJsonUtil.isPackageJsonFile(packageJson)) {
            this.myPackageJsonUpdateNotifier.onPackageJsonAdded(packageJson);
            VirtualFile nodeModulesDir = NodeModuleUtil.findNodeModulesByPackageJson(packageJson);
            if (nodeModulesDir != null && nodeModulesDir.isValid()) {
                this.handleAddingNodeModulesDir(nodeModulesDir);
            }
        }
    }

    private void handleRemovingPackageJson(@NotNull VirtualFile packageJson) {
        VirtualFile nodeModulesDir;
        if (packageJson == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(27);
        }
        if (PackageJsonUtil.isPackageJsonFile(packageJson) && this.myDataByPackageJsonMap.remove(packageJson) != null && (nodeModulesDir = NodeModuleUtil.findNodeModulesByPackageJson(packageJson)) != null && nodeModulesDir.isValid()) {
            LOG.info("Removing node_modules library as " + packageJson.getPath() + " removed");
            this.myHandledNodeModulesDirs.remove(nodeModulesDir);
            this.myLibrariesUpdater.request();
            this.mySnapshotRef.set(null);
        }
    }

    private void handlePackageJsonContentChanged(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(28);
        }
        if (PackageJsonUtil.isPackageJsonFile(packageJson) && !this.myProject.isDisposed()) {
            PackageJsonData newData;
            PackageJsonData oldData;
            this.myPackageJsonUpdateNotifier.onPackageJsonContentChanged(packageJson);
            NodeModulesLibrariesSnapshot snapshot = this.mySnapshotRef.get();
            if (snapshot != null) {
                snapshot.onPackageJsonFileChanged(packageJson);
            }
            if ((oldData = this.myDataByPackageJsonMap.get(packageJson)) != null && !(newData = PackageJsonUtil.getOrCreateData(packageJson)).getAllDependencies().equals(oldData.getAllDependencies())) {
                LOG.info("Updating node_modules library as " + packageJson.getPath() + " changed");
                this.myDataByPackageJsonMap.put(packageJson, newData);
                this.myLibrariesUpdater.request();
            }
        }
    }

    private void handleAddingNodeModulesDir(@NotNull VirtualFile file) {
        VirtualFile topLevelNodeModulesDir;
        if (file == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(29);
        }
        if (NodeModulesDirectoryManager.isNodeModulesDir(file) && !this.myProject.isDisposed() && (topLevelNodeModulesDir = this.findTopLevelNodeModulesDirInsideContentRoots(file)) != null && this.myFileIndex.isInContent(topLevelNodeModulesDir) && !this.myFileIndex.isInLibrary(topLevelNodeModulesDir)) {
            this.tryAddLibraries(Collections.singletonList(new DirInfo(topLevelNodeModulesDir, true)));
        }
    }

    private void handleRemovingNodeModulesDir(@NotNull VirtualFile file) {
        if (file == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(30);
        }
        if (NodeModulesDirectoryManager.isNodeModulesDir(file) && this.myHandledNodeModulesDirs.remove(file) != null) {
            this.mySnapshotRef.set(null);
            this.myLibrariesUpdater.request();
        }
    }

    private void onFileCreatedOrDeleted(@NotNull VirtualFile file) {
        NodeModulesLibrariesSnapshot snapshot;
        if (file == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(31);
        }
        if ((snapshot = this.mySnapshotRef.get()) != null) {
            snapshot.onFileCreatedOrDeleted(file);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 16: 
            case 21: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 16: 
            case 21: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIndex";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonUpdateNotifier";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 16: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeModulesDir";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryDirectory";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 15: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alreadyProcessed";
                break;
            }
            case 17: 
            case 18: 
            case 20: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 19: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onDone";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 24: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createProjectModelExcludedDirsCache";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeModulesDirectories";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryMappings";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllNodeModules";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "listOldLibraries";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateSnapshot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createProjectModelExcludedDirsCache";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 16: 
            case 21: 
            case 23: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computeFileIndexExtensionPreventingRecursion";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeNestedNodeModulesPaths";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isNodeModulesLibraryDirWithMappings";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isLibraryWithMappings";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isNodeModulesDir";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isForApplicationSourceCode";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findAllNodeModules";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "detectNodeModulesInContentRoots";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeOldLibraries";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "listOldLibraries";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "tryAddLibraries";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setProvidedPackageJsonRoots";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "handleAddingPackageJson";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "handleRemovingPackageJson";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "handlePackageJsonContentChanged";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "handleAddingNodeModulesDir";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "handleRemovingNodeModulesDir";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "onFileCreatedOrDeleted";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$listOldLibraries$15";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$removeOldLibraries$13";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$12";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$detectNodeModulesInContentRoots$11";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findAllNodeModules$10";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createProjectModelExcludedDirsCache$4";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$3";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$1";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 16: 
            case 21: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DirInfo {
        private final VirtualFile myNodeModulesDir;
        private final List<VirtualFile> myMappings;
        private final boolean myForceAddMappings;

        public DirInfo(@NotNull VirtualFile nodeModulesDir, @NotNull List<VirtualFile> mappings, boolean forceAddMappings) {
            if (nodeModulesDir == null) {
                DirInfo.$$$reportNull$$$0(0);
            }
            if (mappings == null) {
                DirInfo.$$$reportNull$$$0(1);
            }
            this.myNodeModulesDir = nodeModulesDir;
            this.myMappings = mappings;
            this.myForceAddMappings = forceAddMappings;
        }

        public DirInfo(@NotNull VirtualFile nodeModulesDir, boolean forceAddMappings) {
            if (nodeModulesDir == null) {
                DirInfo.$$$reportNull$$$0(2);
            }
            this.myNodeModulesDir = nodeModulesDir;
            this.myMappings = ContainerUtil.createMaybeSingletonList((Object)nodeModulesDir.getParent());
            this.myForceAddMappings = forceAddMappings;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "nodeModulesDir";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mappings";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager$DirInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class NodeModulesDirsCollector {
        private final Map<VirtualFile, DirInfo> myInfos = ContainerUtil.newHashMap();

        private NodeModulesDirsCollector() {
        }

        public void add(@NotNull VirtualFile nodeModulesDir, @NotNull List<VirtualFile> mappings) {
            if (nodeModulesDir == null) {
                NodeModulesDirsCollector.$$$reportNull$$$0(0);
            }
            if (mappings == null) {
                NodeModulesDirsCollector.$$$reportNull$$$0(1);
            }
            this.add(new DirInfo(nodeModulesDir, mappings, false));
        }

        public void add(@NotNull VirtualFile nodeModulesDir) {
            if (nodeModulesDir == null) {
                NodeModulesDirsCollector.$$$reportNull$$$0(2);
            }
            this.add(new DirInfo(nodeModulesDir, false));
        }

        private void add(@NotNull DirInfo nodeModulesInfo) {
            VirtualFile nodeModulesDir;
            if (nodeModulesInfo == null) {
                NodeModulesDirsCollector.$$$reportNull$$$0(3);
            }
            if (NodeModulesDirectoryManager.isNodeModulesDir(nodeModulesDir = nodeModulesInfo.myNodeModulesDir) && !this.myInfos.containsKey(nodeModulesDir)) {
                this.myInfos.put(nodeModulesDir, nodeModulesInfo);
            }
        }

        public Collection<DirInfo> getTopLevelNodeModulesDirInfos() {
            HashSet topLevelNodeModulesDirs = ContainerUtil.newHashSet();
            HashSet libraryDirsToWarn = ContainerUtil.newHashSet();
            for (DirInfo info : this.myInfos.values()) {
                VirtualFile nodeModulesDir = info.myNodeModulesDir;
                VirtualFile topLevelNodeModulesDir = NodeModulesDirectoryManager.this.findTopLevelNodeModulesDirInsideContentRoots(nodeModulesDir);
                if (topLevelNodeModulesDir == null || !NodeModulesDirectoryManager.this.myFileIndex.isInContent(topLevelNodeModulesDir)) continue;
                topLevelNodeModulesDirs.add(topLevelNodeModulesDir);
                if (!NodeModulesDirectoryManager.this.myFileIndex.isInLibrary(topLevelNodeModulesDir)) continue;
                libraryDirsToWarn.add(topLevelNodeModulesDir);
            }
            for (VirtualFile libraryDir : libraryDirsToWarn) {
                LOG.info("A library contains " + libraryDir);
            }
            return ContainerUtil.map2List((Collection)topLevelNodeModulesDirs, dir -> {
                DirInfo info = this.myInfos.get(dir);
                return info != null ? info : new DirInfo((VirtualFile)dir, false);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "nodeModulesDir";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mappings";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "nodeModulesInfo";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager$NodeModulesDirsCollector";
            objectArray[2] = "add";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class PackageJsonListener
    implements VirtualFileListener {
        private PackageJsonListener() {
        }

        public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                PackageJsonListener.$$$reportNull$$$0(0);
            }
            if ("name".equals(event.getPropertyName())) {
                NodeModulesDirectoryManager.this.handleRemovingPackageJson(event.getFile());
                NodeModulesDirectoryManager.this.handleRemovingNodeModulesDir(event.getFile());
            }
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                PackageJsonListener.$$$reportNull$$$0(1);
            }
            if ("name".equals(event.getPropertyName())) {
                NodeModulesDirectoryManager.this.handleAddingPackageJson(event.getFile());
                NodeModulesDirectoryManager.this.handleAddingNodeModulesDir(event.getFile());
            }
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            if (event == null) {
                PackageJsonListener.$$$reportNull$$$0(2);
            }
            NodeModulesDirectoryManager.this.handlePackageJsonContentChanged(event.getFile());
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            VirtualFile nodeModulesDir;
            if (event == null) {
                PackageJsonListener.$$$reportNull$$$0(3);
            }
            VirtualFile file = event.getFile();
            NodeModulesDirectoryManager.this.onFileCreatedOrDeleted(file);
            NodeModulesDirectoryManager.this.handleAddingPackageJson(file);
            if (file.isDirectory() && StringUtil.equals((CharSequence)NodeModulesDirectoryManager.TYPES_SCOPE_NAME, (CharSequence)file.getNameSequence())) {
                NodeModulesDirectoryManager.this.myLibrariesUpdater.request();
            }
            NodeModulesDirectoryManager.this.handleAddingNodeModulesDir(file);
            if (ApplicationManager.getApplication().isUnitTestMode() && (nodeModulesDir = NodeModuleSearchUtil.findAncestorNodeModulesDir(file)) != null && NodeModulesDirectoryManager.this.getOrCreateSnapshot().findLibraryName(nodeModulesDir) != null) {
                NodeModulesDirectoryManager.this.myLibrariesUpdater.request();
            }
        }

        public void fileDeleted(@NotNull VirtualFileEvent event) {
            if (event == null) {
                PackageJsonListener.$$$reportNull$$$0(4);
            }
            NodeModulesDirectoryManager.this.onFileCreatedOrDeleted(event.getFile());
            NodeModulesDirectoryManager.this.handleRemovingPackageJson(event.getFile());
            NodeModulesDirectoryManager.this.handleRemovingNodeModulesDir(event.getFile());
        }

        public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                PackageJsonListener.$$$reportNull$$$0(5);
            }
            NodeModulesDirectoryManager.this.handleRemovingPackageJson(event.getFile());
            NodeModulesDirectoryManager.this.handleRemovingNodeModulesDir(event.getFile());
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                PackageJsonListener.$$$reportNull$$$0(6);
            }
            NodeModulesDirectoryManager.this.handleAddingPackageJson(event.getFile());
            NodeModulesDirectoryManager.this.handleAddingNodeModulesDir(event.getFile());
        }

        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            if (event == null) {
                PackageJsonListener.$$$reportNull$$$0(7);
            }
            NodeModulesDirectoryManager.this.handleAddingPackageJson(event.getFile());
            NodeModulesDirectoryManager.this.handleAddingNodeModulesDir(event.getFile());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager$PackageJsonListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforePropertyChange";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "propertyChanged";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentsChanged";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCreated";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileDeleted";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeFileMovement";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileMoved";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCopied";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

