/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.util;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRenderer;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.nodejs.util.NodePackageEditor;
import com.intellij.javascript.nodejs.util.NodePackageRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.LocalFileFinder;

public class NodePackageField
extends ComponentWithBrowseButton<ComboBox<Object>> {
    private static final Object SELECT_PACKAGE = new Object();
    private final Project myProject;
    private final NodePackageDescriptor myDescriptor;
    private final KeyEventAwareComboBox<Object> myComboBox;
    private final SortedComboBoxModel<Object> myModel;
    private final NodePackageEditor myEditor;
    private final List<Consumer<NodePackage>> itemSelectedListeners;

    public NodePackageField(@NotNull Project project, @NotNull String packageName, @Nullable Supplier<NodeJsInterpreter> interpreterSupplier) {
        if (project == null) {
            NodePackageField.$$$reportNull$$$0(0);
        }
        if (packageName == null) {
            NodePackageField.$$$reportNull$$$0(1);
        }
        this(project, Collections.singletonList(packageName), interpreterSupplier);
    }

    public NodePackageField(@NotNull Project project, @NotNull List<String> packageNames, @Nullable Supplier<NodeJsInterpreter> interpreterSupplier) {
        if (project == null) {
            NodePackageField.$$$reportNull$$$0(2);
        }
        if (packageNames == null) {
            NodePackageField.$$$reportNull$$$0(3);
        }
        this(project, new NodePackageDescriptor(packageNames), interpreterSupplier, null);
    }

    public NodePackageField(@NotNull NodeJsInterpreterField interpreterField, @NotNull NodePackageDescriptor descriptor2, @Nullable Supplier<VirtualFile> contextFileOrDirectorySupplier) {
        if (interpreterField == null) {
            NodePackageField.$$$reportNull$$$0(4);
        }
        if (descriptor2 == null) {
            NodePackageField.$$$reportNull$$$0(5);
        }
        this(interpreterField.getProject(), descriptor2, interpreterField::getInterpreter, contextFileOrDirectorySupplier);
    }

    public NodePackageField(@NotNull Project project, @NotNull NodePackageDescriptor descriptor2, @Nullable Supplier<NodeJsInterpreter> interpreterSupplier, @Nullable Supplier<VirtualFile> contextFileOrDirectorySupplier) {
        if (project == null) {
            NodePackageField.$$$reportNull$$$0(6);
        }
        if (descriptor2 == null) {
            NodePackageField.$$$reportNull$$$0(7);
        }
        super(new KeyEventAwareComboBox(), null);
        this.itemSelectedListeners = ContainerUtil.newArrayList();
        this.myProject = project;
        this.myDescriptor = descriptor2;
        this.myComboBox = (KeyEventAwareComboBox)((Object)this.getChildComponent());
        this.myModel = NodePackageField.createModel();
        this.myComboBox.setModel((ComboBoxModel)this.myModel);
        this.myComboBox.setRenderer(new DelegatingListCellRenderer());
        this.myComboBox.setEditable(true);
        this.myEditor = new NodePackageEditor(this.myModel, descriptor2);
        this.myComboBox.setEditor(this.myEditor);
        this.myEditor.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                NodePackageField.this.triggerItemSelectedListeners();
            }
        });
        this.installFileCompletionAndBrowserFolderListener(this.myEditor.getTextField());
        this.myComboBox.setMinimumAndPreferredWidth(0);
        this.installListeners(interpreterSupplier, contextFileOrDirectorySupplier);
    }

    @NotNull
    public JComponent getEditorComponent() {
        JTextField jTextField = this.myEditor.getTextField();
        if (jTextField == null) {
            NodePackageField.$$$reportNull$$$0(8);
        }
        return jTextField;
    }

    private void installListeners(final @Nullable Supplier<NodeJsInterpreter> interpreterSupplier, final @Nullable Supplier<VirtualFile> contextFileOrDirectorySupplier) {
        final ItemListener itemListener = new ItemListener(){
            private Object myLastSelectedItem;

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Object selectedItem = NodePackageField.this.myComboBox.getSelectedItem();
                    if (selectedItem == SELECT_PACKAGE) {
                        NodePackageField.this.myComboBox.setSelectedItem(this.myLastSelectedItem);
                        if (!((KeyEventAwareComboBox)NodePackageField.this.myComboBox).myKeyEventProcessing) {
                            ApplicationManager.getApplication().invokeLater(() -> NodePackageField.this.performSelection((NodePackage)ObjectUtils.tryCast((Object)this.myLastSelectedItem, NodePackage.class)), ModalityState.defaultModalityState());
                        }
                    } else {
                        this.myLastSelectedItem = selectedItem;
                    }
                    NodePackageField.this.triggerItemSelectedListeners();
                }
            }
        };
        this.myComboBox.addItemListener(itemListener);
        this.myComboBox.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                NodePackageField.this.myComboBox.removeItemListener(itemListener);
                NodeJsInterpreter interpreter = interpreterSupplier != null ? (NodeJsInterpreter)interpreterSupplier.get() : null;
                VirtualFile contextFileOrDirectory = contextFileOrDirectorySupplier != null ? (VirtualFile)contextFileOrDirectorySupplier.get() : null;
                List<NodePackage> packages = NodePackageField.this.myDescriptor.listAvailable(NodePackageField.this.myProject, interpreter, contextFileOrDirectory);
                NodePackage prevSelected = (NodePackage)ObjectUtils.tryCast((Object)NodePackageField.this.myModel.getSelectedItem(), NodePackage.class);
                List all = ContainerUtil.concat(packages, Collections.singletonList(SELECT_PACKAGE));
                NodePackageField.this.myModel.setAll((Collection)all);
                NodePackageField.this.addIfMissingAndSelect(prevSelected);
                NodePackageField.this.myComboBox.addItemListener(itemListener);
            }
        });
    }

    private void triggerItemSelectedListeners() {
        NodePackage selected = this.getSelected();
        this.itemSelectedListeners.forEach(consumer -> consumer.consume((Object)selected));
    }

    private void performSelection(@Nullable NodePackage initial) {
        VirtualFile initialFile = initial != null ? LocalFileFinder.findFile((String)initial.getSystemIndependentPath()) : null;
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor().withShowHiddenFiles(SystemInfo.isUnix);
        VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)descriptor2, (Project)this.myProject, (VirtualFile)initialFile);
        if (file != null) {
            this.addIfMissingAndSelect(this.myDescriptor.createPackage(file.getPath()));
        }
    }

    void addIfMissingAndSelect(@Nullable NodePackage pkg) {
        int i = this.myModel.indexOf((Object)pkg);
        if (i >= 0) {
            this.myModel.setSelectedItem(this.myModel.get(i));
        } else if (pkg == null) {
            this.myModel.setSelectedItem(null);
        } else {
            this.myModel.add((Object)pkg);
            this.myModel.setSelectedItem((Object)pkg);
        }
    }

    public void addSelectionListener(@NotNull Consumer<NodePackage> listener2) {
        if (listener2 == null) {
            NodePackageField.$$$reportNull$$$0(9);
        }
        this.itemSelectedListeners.add(listener2);
    }

    public void setSelected(@NotNull NodePackage pkg) {
        if (pkg == null) {
            NodePackageField.$$$reportNull$$$0(10);
        }
        this.addIfMissingAndSelect(pkg);
    }

    @NotNull
    public NodePackage getSelected() {
        NodePackage nodePackage = this.myEditor.getItem();
        if (nodePackage == null) {
            NodePackageField.$$$reportNull$$$0(11);
        }
        return nodePackage;
    }

    public void setPreferredWidthToFitText() {
        Object item = this.myComboBox.getSelectedItem();
        if (item instanceof NodePackage) {
            this.myComboBox.setMinimumAndPreferredWidth(-1);
            Object prevPrototype = this.myComboBox.getPrototypeDisplayValue();
            this.myComboBox.setPrototypeDisplayValue(item);
            Dimension size = this.getPreferredSize();
            this.setPreferredSize(size);
            this.myComboBox.setMinimumAndPreferredWidth(0);
            this.myComboBox.setPrototypeDisplayValue(prevPrototype);
        }
    }

    @NotNull
    private static SortedComboBoxModel<Object> createModel() {
        SortedComboBoxModel sortedComboBoxModel = new SortedComboBoxModel((o1, o2) -> {
            if (o1 instanceof NodePackage) {
                if (o2 instanceof NodePackage) {
                    return ((NodePackage)o1).getSystemDependentPath().compareTo(((NodePackage)o2).getSystemDependentPath());
                }
                return o2 == null ? 1 : -1;
            }
            if (o1 == null) {
                return o2 == null ? 0 : -1;
            }
            if (o1 == SELECT_PACKAGE) {
                return o2 == SELECT_PACKAGE ? 0 : 1;
            }
            throw new IllegalArgumentException("Unexpected " + o1.getClass());
        });
        if (sortedComboBoxModel == null) {
            NodePackageField.$$$reportNull$$$0(12);
        }
        return sortedComboBoxModel;
    }

    private void installFileCompletionAndBrowserFolderListener(@NotNull JTextField textField) {
        if (textField == null) {
            NodePackageField.$$$reportNull$$$0(13);
        }
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor().withShowHiddenFiles(SystemInfo.isUnix);
        FileChooserFactory.getInstance().installFileCompletion(textField, descriptor2, true, (Disposable)this.myProject);
        this.addBrowseFolderListener("Select " + StringUtil.join(this.myDescriptor.getPackageNames(), (String)"/") + " Package Directory", null, this.myProject, descriptor2, this.myEditor.getTextComponentAccessor());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageNames";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterField";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/util/NodePackageField";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/util/NodePackageField";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorComponent";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelected";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 11: 
            case 12: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addSelectionListener";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "installFileCompletionAndBrowserFolderListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class DelegatingListCellRenderer
    implements ListCellRenderer<Object> {
        private final SpecialValueRenderer mySpecialValueRenderer = new SpecialValueRenderer();
        private final NodePackageRenderer myPackageRenderer = new NodePackageRenderer();

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Object renderer = value instanceof NodePackage ? this.myPackageRenderer : this.mySpecialValueRenderer;
            list.setEnabled(NodePackageField.this.isEnabled());
            return renderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }

    private static class SpecialValueRenderer
    extends ColoredListCellRenderer<Object> {
        public SpecialValueRenderer() {
            this.setIpad((Insets)JBUI.insets((int)0, (int)2, (int)0, (int)0));
            NodeJsInterpreterRenderer.adjustBorderHeight((SimpleColoredComponent)this);
        }

        protected void customizeCellRenderer(@NotNull JList<?> list, Object value, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                SpecialValueRenderer.$$$reportNull$$$0(0);
            }
            if (value == null) {
                this.append("No package", new SimpleTextAttributes(0, (Color)JBColor.RED));
            } else if (value == SELECT_PACKAGE) {
                this.append(" Select...", new SimpleTextAttributes(0, (Color)JBColor.darkGray));
            } else {
                this.append("Unexpected value", new SimpleTextAttributes(0, (Color)JBColor.RED));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/javascript/nodejs/util/NodePackageField$SpecialValueRenderer", "customizeCellRenderer"));
        }
    }

    private static class KeyEventAwareComboBox<T>
    extends ComboBox<T> {
        private boolean myKeyEventProcessing = false;

        private KeyEventAwareComboBox() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            try {
                this.myKeyEventProcessing = true;
                boolean bl = super.processKeyBinding(ks, e, condition, pressed);
                return bl;
            }
            finally {
                this.myKeyEventProcessing = false;
            }
        }
    }
}

