/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.editor;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedExportedDefaultBinding;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.refactoring.ES6ReferenceExpressionsInfo;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6CopyPasteProcessor
extends CopyPastePostProcessor<ES6ImportsTransferableData> {
    private static final DataFlavor ES6_IMPORTS_FLAVOR = new DataFlavor(ES6ImportsTransferableData.class, "es6 imports");
    public static final Logger LOGGER = Logger.getInstance(ES6CopyPasteProcessor.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public List<ES6ImportsTransferableData> collectTransferableData(PsiFile file, Editor editor, int[] startOffsets, int[] endOffsets) {
        if (!this.checkFile(file)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                ES6CopyPasteProcessor.$$$reportNull$$$0(0);
            }
            return list;
        }
        try {
            ArrayList referenceExpressions = ContainerUtil.newArrayList();
            int j = 0;
            while (true) {
                Iterator iterator;
                if (j < startOffsets.length) {
                    iterator = CollectHighlightsUtil.getElementsInRange((PsiElement)file, (int)startOffsets[j], (int)endOffsets[j]).iterator();
                } else {
                    if (referenceExpressions.isEmpty()) {
                        List list = ContainerUtil.emptyList();
                        if (list == null) {
                            ES6CopyPasteProcessor.$$$reportNull$$$0(2);
                        }
                        return list;
                    }
                    HashSet elements = ContainerUtil.newHashSet();
                    for (JSReferenceExpression expression : referenceExpressions) {
                        ES6CopyPasteProcessor.addElement(expression, elements);
                    }
                    List list = elements.isEmpty() ? ContainerUtil.emptyList() : ContainerUtil.createMaybeSingletonList((Object)new ES6ImportsTransferableData(ContainerUtil.newArrayList((Iterable)elements)));
                    if (list == null) {
                        ES6CopyPasteProcessor.$$$reportNull$$$0(3);
                    }
                    return list;
                }
                while (iterator.hasNext()) {
                    PsiElement element = (PsiElement)iterator.next();
                    if (element instanceof JSReferenceExpression) {
                        referenceExpressions.add((JSReferenceExpression)element);
                    }
                    if (!(element instanceof ES6ImportDeclaration) && !(element instanceof ES6ImportExportDeclarationPart)) continue;
                    List list = ContainerUtil.emptyList();
                    if (list == null) {
                        ES6CopyPasteProcessor.$$$reportNull$$$0(1);
                    }
                    return list;
                }
                ++j;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            List list = ContainerUtil.emptyList();
            if (list == null) {
                ES6CopyPasteProcessor.$$$reportNull$$$0(4);
            }
            return list;
        }
    }

    @Contract(value="null -> false")
    public boolean checkFile(@Nullable PsiFile file) {
        if (!(file instanceof JSFile)) {
            return false;
        }
        if (DumbService.isDumb((Project)file.getProject())) {
            return false;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)file);
        if (holder == null || !holder.hasFeature(JSLanguageFeature.IMPORT_DECLARATIONS)) {
            return false;
        }
        if (holder.isECMA6) {
            return JSApplicationSettings.getInstance().isShowJavaScriptAutoImport();
        }
        if (holder.isTypeScript) {
            return JSApplicationSettings.getInstance().isShowTypeScriptAutoImport();
        }
        return false;
    }

    private static void addElement(@NotNull JSReferenceExpression element, @NotNull Collection<ImportedElement> elements) {
        ResolveResult[] results;
        if (element == null) {
            ES6CopyPasteProcessor.$$$reportNull$$$0(5);
        }
        if (elements == null) {
            ES6CopyPasteProcessor.$$$reportNull$$$0(6);
        }
        if (element.getQualifier() != null) {
            return;
        }
        String name = element.getReferenceName();
        if (StringUtil.isEmpty((String)name)) {
            return;
        }
        for (ResolveResult result : results = element.multiResolve(false)) {
            Pair<PsiElement, ES6ImportPsiUtil.CreateImportExportInfo> info;
            VirtualFile virtualFile;
            if (!(result instanceof JSResolveResult) || !result.isValidResult() || (virtualFile = ES6CopyPasteProcessor.getFile((JSResolveResult)result)) == null || (info = ES6ReferenceExpressionsInfo.getImportInfo(name, (JSResolveResult)result, null)) == null) continue;
            elements.add(new ImportedElement(virtualFile.getPath(), (ES6ImportPsiUtil.CreateImportExportInfo)info.second));
        }
    }

    @Nullable
    private static VirtualFile getFile(@NotNull JSResolveResult jsResolveResult) {
        ES6ImportExportDeclarationPart importDeclarationPart;
        if (jsResolveResult == null) {
            ES6CopyPasteProcessor.$$$reportNull$$$0(7);
        }
        if ((importDeclarationPart = jsResolveResult.getES6Import()) == null) {
            PsiElement element = jsResolveResult.getElement();
            if (element instanceof ES6ImportSpecifierAlias) {
                importDeclarationPart = ((ES6ImportSpecifierAlias)element).findSpecifierElement();
            } else if (element instanceof ES6ImportedExportedDefaultBinding) {
                importDeclarationPart = (ES6ImportedExportedDefaultBinding)element;
            }
        }
        if (importDeclarationPart != null) {
            return ES6CopyPasteProcessor.getFileFromDeclaration(importDeclarationPart.getDeclaration());
        }
        return null;
    }

    @Nullable
    private static VirtualFile getFileFromDeclaration(@Nullable ES6ImportExportDeclaration declaration) {
        if (declaration == null) {
            return null;
        }
        ES6FromClause clause = declaration.getFromClause();
        if (clause == null) {
            return null;
        }
        Collection psiElements = clause.resolveReferencedElements();
        if (psiElements.size() != 1) {
            return null;
        }
        PsiElement fileCandidate = (PsiElement)ContainerUtil.getFirstItem((Collection)psiElements);
        if (!(fileCandidate instanceof PsiFile)) {
            return null;
        }
        return ((PsiFile)fileCandidate).getVirtualFile();
    }

    @NotNull
    public List<ES6ImportsTransferableData> extractTransferableData(Transferable content) {
        block9: {
            List list;
            Object data;
            block8: {
                if (!content.isDataFlavorSupported(ES6_IMPORTS_FLAVOR)) {
                    List list2 = ContainerUtil.emptyList();
                    if (list2 == null) {
                        ES6CopyPasteProcessor.$$$reportNull$$$0(8);
                    }
                    return list2;
                }
                data = content.getTransferData(ES6_IMPORTS_FLAVOR);
                if (!(data instanceof ES6ImportsTransferableData)) break block8;
                List<ES6ImportsTransferableData> list3 = Collections.singletonList((ES6ImportsTransferableData)data);
                if (list3 == null) {
                    ES6CopyPasteProcessor.$$$reportNull$$$0(9);
                }
                return list3;
            }
            try {
                if (!(data instanceof List)) break block9;
                list = (List)data;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (list == null) {
                ES6CopyPasteProcessor.$$$reportNull$$$0(10);
            }
            return list;
        }
        List list = super.extractTransferableData(content);
        if (list == null) {
            ES6CopyPasteProcessor.$$$reportNull$$$0(11);
        }
        return list;
    }

    public void processTransferableData(Project project, Editor editor, RangeMarker bounds, int caretOffset, Ref<Boolean> indented, List<ES6ImportsTransferableData> values) {
        if (DumbService.getInstance((Project)project).isDumb()) {
            return;
        }
        Document document = editor.getDocument();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (!this.checkFile(file)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiManager manager = file.getManager();
        GlobalSearchScope scope = JSResolveUtil.getResolveScope((PsiElement)file);
        for (ES6ImportsTransferableData value : values) {
            List<ImportedElement> elements = value.getImportedElements();
            for (ImportedElement element : elements) {
                PsiFile targetFile;
                VirtualFile candidateFile;
                List<PsiElement> results;
                String filePath = element.myPath;
                ES6ImportPsiUtil.CreateImportExportInfo createInfo = element.myInfo;
                String exportedName = createInfo.getExportedName();
                String importedName = createInfo.getImportedName();
                String actualExportedName = (String)ObjectUtils.coalesce((Object)exportedName, (Object)importedName);
                String actualImportedName = (String)ObjectUtils.coalesce((Object)importedName, (Object)exportedName);
                if (actualExportedName == null || (results = JSStubBasedPsiTreeUtil.resolveLocallyWithMergedResults(actualImportedName, (PsiElement)file)).size() > 0 || (candidateFile = file.getVirtualFile().getFileSystem().findFileByPath(filePath)) == null || !scope.accept(candidateFile) || (targetFile = manager.findFile(candidateFile)) == null || targetFile.equals(file)) continue;
                WriteAction.run(() -> ES6ImportPsiUtil.insertJSImport((PsiElement)file, createInfo, (PsiElement)targetFile, editor));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/editor/ES6CopyPasteProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsResolveResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTransferableData";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/editor/ES6CopyPasteProcessor";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "extractTransferableData";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ES6ImportsTransferableData
    implements TextBlockTransferableData {
        @NotNull
        private final ArrayList<ImportedElement> myList;

        public ES6ImportsTransferableData(@NotNull ArrayList<ImportedElement> list) {
            if (list == null) {
                ES6ImportsTransferableData.$$$reportNull$$$0(0);
            }
            this.myList = list;
        }

        @NotNull
        public List<ImportedElement> getImportedElements() {
            ArrayList<ImportedElement> arrayList = this.myList;
            if (arrayList == null) {
                ES6ImportsTransferableData.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        public DataFlavor getFlavor() {
            return ES6_IMPORTS_FLAVOR;
        }

        public int getOffsetCount() {
            return 0;
        }

        public int getOffsets(int[] offsets, int index) {
            return index;
        }

        public int setOffsets(int[] offsets, int index) {
            return index;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ecmascript6/editor/ES6CopyPasteProcessor$ES6ImportsTransferableData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ecmascript6/editor/ES6CopyPasteProcessor$ES6ImportsTransferableData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getImportedElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ImportedElement
    implements Serializable {
        @NotNull
        private final String myPath;
        @NotNull
        private final ES6ImportPsiUtil.CreateImportExportInfo myInfo;

        public ImportedElement(@NotNull String filePath, @NotNull ES6ImportPsiUtil.CreateImportExportInfo info) {
            if (filePath == null) {
                ImportedElement.$$$reportNull$$$0(0);
            }
            if (info == null) {
                ImportedElement.$$$reportNull$$$0(1);
            }
            this.myPath = filePath;
            this.myInfo = info;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImportedElement element = (ImportedElement)o;
            if (!this.myPath.equals(element.myPath)) {
                return false;
            }
            return this.myInfo.equals(element.myInfo);
        }

        public int hashCode() {
            int result = this.myPath.hashCode();
            result = 31 * result + this.myInfo.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filePath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "info";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/ecmascript6/editor/ES6CopyPasteProcessor$ImportedElement";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

