/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.javascript.nodejs.ForRequireModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.lang.ecmascript6.psi.impl.JSImportPathBuilder;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.javascript.modules.NodeJSModulesSearcher;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSModuleImportPathBuilder
extends JSImportPathBuilder {
    @Nullable
    private final VirtualFile myRoot;

    public JSModuleImportPathBuilder(@NotNull PsiElement place, @Nullable PsiElement elementToImport, @NotNull VirtualFile fileToImport, @Nullable VirtualFile moduleRoot) {
        if (place == null) {
            JSModuleImportPathBuilder.$$$reportNull$$$0(0);
        }
        if (fileToImport == null) {
            JSModuleImportPathBuilder.$$$reportNull$$$0(1);
        }
        super(place, elementToImport, fileToImport);
        this.myRoot = moduleRoot;
    }

    public JSModuleImportPathBuilder(@NotNull PsiElement place, @Nullable PsiElement elementToImport, @NotNull VirtualFile fileToImport) {
        if (place == null) {
            JSModuleImportPathBuilder.$$$reportNull$$$0(2);
        }
        if (fileToImport == null) {
            JSModuleImportPathBuilder.$$$reportNull$$$0(3);
        }
        this(place, elementToImport, fileToImport, NodeModuleUtil.findMainModuleRoot(place.getProject(), PsiUtilCore.getVirtualFile((PsiElement)place)));
    }

    @Override
    public void processModuleNames(@NotNull Processor<JSModuleNameInfo> processor) {
        ForRequireModuleInfo required;
        boolean isCoreLibraryFile;
        if (processor == null) {
            JSModuleImportPathBuilder.$$$reportNull$$$0(4);
        }
        if ((isCoreLibraryFile = NodeJSModulesSearcher.isCoreModuleFile(this.myPlace, this.myFileToImport)) && !processor.process((Object)new JSModuleNameInfo(this.myFileToImport.getName(), this.myFileToImport, this.myPlace))) {
            return;
        }
        if (this.myRoot != null && (required = NodeModuleUtil.getRequireModuleInfo(this.myProject, this.myRoot, this.myFileToImport)) != null && !this.processForExactModule(processor, required)) {
            return;
        }
        super.processModuleNames(processor);
    }

    private boolean processForExactModule(@NotNull Processor<JSModuleNameInfo> processor, @NotNull ForRequireModuleInfo module) {
        ModuleType type;
        if (processor == null) {
            JSModuleImportPathBuilder.$$$reportNull$$$0(5);
        }
        if (module == null) {
            JSModuleImportPathBuilder.$$$reportNull$$$0(6);
        }
        if (ModuleType.NODE_MODULES_DIR.equals((Object)(type = module.getType()))) {
            if (module.getModuleSourceRoot() != null) {
                String moduleName;
                String string = moduleName = module.getModuleSourceRoot().isDirectory() ? module.getModuleSourceRoot().getName() : module.getModuleSourceRoot().getNameWithoutExtension();
                if (module.isMainFile()) {
                    return processor.process((Object)new JSModuleNameInfo(moduleName, module.getModuleSourceRoot(), this.myPlace));
                }
                String redirectPath = JSModuleImportPathBuilder.computeRedirectPath(this.myPlace, module);
                String relPath = FileUtil.getRelativePath((String)module.getModuleSourceRoot().getPath(), (String)module.getModuleFile().getPath(), (char)'/');
                if (JSModuleImportPathBuilder.relPathsSame(relPath, redirectPath, StringUtil.notNullize((String)module.getModuleFile().getExtension()))) {
                    return processor.process((Object)new JSModuleNameInfo(moduleName, module.getModuleFile(), this.myPlace));
                }
                if (relPath != null && !relPath.startsWith("../")) {
                    relPath = relPath.startsWith("./") ? relPath.substring(1) : relPath;
                    relPath = moduleName + (relPath.startsWith("/") ? relPath : "/" + relPath);
                    return processor.process((Object)new JSModuleNameInfo(relPath, module.getModuleFile(), this.myPlace));
                }
            }
        } else if (ModuleType.EXACT_PATH.equals((Object)type)) {
            return true;
        }
        return false;
    }

    @Nullable
    private static String computeRedirectPath(@NotNull PsiElement node, ForRequireModuleInfo module) {
        if (node == null) {
            JSModuleImportPathBuilder.$$$reportNull$$$0(7);
        }
        if (module.getMainFile() != null) {
            String redirectPath;
            VirtualFile main = module.getMainFile().getJsNextMain();
            if (main != null && (redirectPath = JSModuleImportPathBuilder.getRedirectFileByRedirectPath(module, NodeModuleSearchUtil.getRedirectPathForModule(node.getProject(), main))) != null) {
                return redirectPath;
            }
            main = module.getMainFile().getMain();
            if (main != null) {
                return JSModuleImportPathBuilder.getRedirectFileByRedirectPath(module, NodeModuleSearchUtil.getRedirectPathForModule(node.getProject(), main));
            }
        }
        return null;
    }

    @Nullable
    private static String getRedirectFileByRedirectPath(ForRequireModuleInfo module, @Nullable String redirectPath) {
        if (redirectPath == null) {
            return null;
        }
        redirectPath = redirectPath.startsWith("./") ? redirectPath.substring(2) : redirectPath;
        redirectPath = redirectPath.endsWith("/") ? redirectPath.substring(0, redirectPath.length() - 1) : redirectPath;
        VirtualFile virtualFile = VfsUtil.findRelativeFile((VirtualFile)module.getModuleSourceRoot(), (String[])new String[]{redirectPath});
        if (virtualFile != null && virtualFile.isDirectory()) {
            if (virtualFile.findChild("index.js") != null) {
                redirectPath = redirectPath + (redirectPath.endsWith("/") ? "" : "/") + "index.js";
            } else if (virtualFile.findChild("index.node") != null) {
                redirectPath = redirectPath + (redirectPath.endsWith("/") ? "" : "/") + "index.node";
            }
        }
        return redirectPath;
    }

    private static boolean relPathsSame(@Nullable String path1, @Nullable String path2, @NotNull String ext2) {
        if (ext2 == null) {
            JSModuleImportPathBuilder.$$$reportNull$$$0(8);
        }
        if (path1 == null || path2 == null) {
            return false;
        }
        return (path1 = JSModuleImportPathBuilder.normalizePath(path1)).equals(path2 = JSModuleImportPathBuilder.normalizePath(path2)) || path1.equals(path2 + "." + ext2);
    }

    private static String normalizePath(@NotNull String path) {
        if (path == null) {
            JSModuleImportPathBuilder.$$$reportNull$$$0(9);
        }
        return StringUtil.trimStart((String)StringUtil.trimStart((String)path, (String)"."), (String)"/");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToImport";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ext2";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/ecmascript6/psi/impl/JSModuleImportPathBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processModuleNames";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processForExactModule";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "computeRedirectPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "relPathsSame";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "normalizePath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

