/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.arrangement;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.arrangement.JSArrangementEntry;
import com.intellij.lang.javascript.arrangement.JSElementArrangementEntry;
import com.intellij.lang.javascript.arrangement.JSRearrangerBase;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettingsSerializer;
import com.intellij.psi.codeStyle.arrangement.DefaultArrangementSettingsSerializer;
import com.intellij.psi.codeStyle.arrangement.group.ArrangementGroupingRule;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.CompositeArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6Rearranger
extends JSRearrangerBase {
    private static final Comparator<JSRearrangerBase.OverrideInfo> NAME_COMPARATOR = Comparator.comparing(info1 -> info1.member.getName());
    private static final Set<ArrangementSettingsToken> SUPPORTED_TYPES = ContainerUtil.newLinkedHashSet((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.EntryType.CONSTRUCTOR, StdArrangementTokens.EntryType.METHOD, StdArrangementTokens.EntryType.FIELD, StdArrangementTokens.EntryType.PROPERTY});
    private final Set<ArrangementSettingsToken> mySupportedModifiers;
    private final Set<ArrangementSettingsToken> myVisibilityModifiers;
    private final StdArrangementSettings myDefaultSettings;
    private final DefaultArrangementSettingsSerializer mySettingsSerializer;
    private final JSLanguageDialect myDialect;

    public ES6Rearranger() {
        this(JavaScriptSupportLoader.ECMA_SCRIPT_6, ContainerUtil.newLinkedHashSet(), ContainerUtil.newLinkedHashSet((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Modifier.STATIC}));
    }

    public ES6Rearranger(JSLanguageDialect dialect, Set<ArrangementSettingsToken> visibilityModifiers, Set<ArrangementSettingsToken> additionalModifiers) {
        List<ArrangementGroupingRule> groupingRules = Collections.singletonList(new ArrangementGroupingRule(StdArrangementTokens.Grouping.GROUP_PROPERTY_FIELD_WITH_GETTER_SETTER));
        List<StdArrangementMatchRule> matchRules = ES6Rearranger.getDefaultMatchRules(visibilityModifiers);
        this.myDefaultSettings = StdArrangementSettings.createByMatchRules(groupingRules, matchRules);
        this.mySettingsSerializer = new DefaultArrangementSettingsSerializer(this.myDefaultSettings);
        this.myVisibilityModifiers = visibilityModifiers;
        this.mySupportedModifiers = ContainerUtil.newLinkedHashSet(visibilityModifiers);
        this.mySupportedModifiers.addAll(additionalModifiers);
        this.mySupportedModifiers.add(StdArrangementTokens.Modifier.OVERRIDDEN);
        this.myDialect = dialect;
    }

    @Nullable
    public StdArrangementSettings getDefaultSettings() {
        return this.myDefaultSettings;
    }

    @Override
    @Nullable
    public List<CompositeArrangementSettingsToken> getSupportedGroupingTokens() {
        return ContainerUtil.list((Object[])new CompositeArrangementSettingsToken[]{new CompositeArrangementSettingsToken(StdArrangementTokens.Grouping.GROUP_PROPERTY_FIELD_WITH_GETTER_SETTER), new CompositeArrangementSettingsToken(StdArrangementTokens.Grouping.OVERRIDDEN_METHODS, (Collection)ContainerUtil.set((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Order.KEEP, StdArrangementTokens.Order.BY_NAME}))});
    }

    @Override
    protected void postprocessClassMembers(@NotNull JSClass jsClass, @NotNull JSRearrangerBase.ClassArrangementInfo classArrangementInfo, @NotNull JSRearrangerBase.ArrangementInfo arrangementInfo) {
        if (jsClass == null) {
            ES6Rearranger.$$$reportNull$$$0(0);
        }
        if (classArrangementInfo == null) {
            ES6Rearranger.$$$reportNull$$$0(1);
        }
        if (arrangementInfo == null) {
            ES6Rearranger.$$$reportNull$$$0(2);
        }
        super.postprocessClassMembers(jsClass, classArrangementInfo, arrangementInfo);
        List fieldStatements = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)jsClass, JSVarStatement.class);
        ArrangementGroupingRule groupingRule = ES6Rearranger.findGroupingRule(arrangementInfo.getSettings(), StdArrangementTokens.Grouping.OVERRIDDEN_METHODS);
        if (groupingRule != null) {
            ArrangementSettingsToken orderType = groupingRule.getOrderType();
            ES6Rearranger.processOverriddenMembers(classArrangementInfo.getEntries(), classArrangementInfo.overrides, orderType);
        }
        Map<JSVariable, JSElementArrangementEntry> fieldToEntry = classArrangementInfo.fieldToEntry;
        ES6Rearranger.processDependantFields(fieldStatements, fieldToEntry, (Condition<JSField>)((Condition)field -> !ES6Rearranger.isStatic(field)), (Condition<JSExpression>)((Condition)qualifier -> qualifier instanceof JSThisExpression));
        ES6Rearranger.processDependantFields(fieldStatements, fieldToEntry, (Condition<JSField>)((Condition)ES6Rearranger::isStatic), (Condition<JSExpression>)((Condition)qualifier -> {
            if (jsClass == null) {
                ES6Rearranger.$$$reportNull$$$0(33);
            }
            return qualifier instanceof JSThisExpression || qualifier instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)qualifier, jsClass.getName());
        }));
    }

    private static void processOverriddenMembers(@NotNull Map<? extends JSQualifiedNamedElement, JSElementArrangementEntry> membersMap, @NotNull MultiMap<JSClass, JSRearrangerBase.OverrideInfo> overrides, @NotNull ArrangementSettingsToken ordering) {
        if (membersMap == null) {
            ES6Rearranger.$$$reportNull$$$0(3);
        }
        if (overrides == null) {
            ES6Rearranger.$$$reportNull$$$0(4);
        }
        if (ordering == null) {
            ES6Rearranger.$$$reportNull$$$0(5);
        }
        for (Map.Entry entry : overrides.entrySet()) {
            TObjectIntHashMap superMemberIndexes = new TObjectIntHashMap();
            int index = 0;
            for (JSElement o2 : ((JSClass)entry.getKey()).getMembers()) {
                superMemberIndexes.put((Object)o2, index++);
            }
            Comparator<JSRearrangerBase.OverrideInfo> comparator = ordering == StdArrangementTokens.Order.BY_NAME ? NAME_COMPARATOR : Comparator.comparing(o -> superMemberIndexes.get((Object)o.superMember));
            List<JSElementArrangementEntry> ordered = ((Collection)entry.getValue()).stream().sorted(comparator).map(arrangementInfo -> {
                if (membersMap == null) {
                    ES6Rearranger.$$$reportNull$$$0(32);
                }
                return (JSElementArrangementEntry)membersMap.get(arrangementInfo.member);
            }).filter(c -> c != null).collect(Collectors.toList());
            ES6Rearranger.setupDependenciesForOrder(ordered);
        }
    }

    private static void setupDependenciesForOrder(Collection<JSElementArrangementEntry> entries) {
        JSElementArrangementEntry previous = null;
        for (JSElementArrangementEntry entry : entries) {
            if (previous != null) {
                entry.addDependency(previous);
            }
            previous = entry;
        }
    }

    private static void processDependantFields(@NotNull List<JSVarStatement> fieldStatements, @NotNull Map<JSVariable, JSElementArrangementEntry> fieldToEntry, @NotNull Condition<JSField> fieldFilter, @NotNull Condition<JSExpression> isAcceptableQualifier) {
        if (fieldStatements == null) {
            ES6Rearranger.$$$reportNull$$$0(6);
        }
        if (fieldToEntry == null) {
            ES6Rearranger.$$$reportNull$$$0(7);
        }
        if (fieldFilter == null) {
            ES6Rearranger.$$$reportNull$$$0(8);
        }
        if (isAcceptableQualifier == null) {
            ES6Rearranger.$$$reportNull$$$0(9);
        }
        List filteredFields = ContainerUtil.mapNotNull(fieldStatements, fieldStatement -> {
            JSVariable variable;
            if (fieldFilter == null) {
                ES6Rearranger.$$$reportNull$$$0(31);
            }
            JSField field = (variable = (JSVariable)ArrayUtil.getFirstElement((Object[])fieldStatement.getVariables())) instanceof JSField ? (JSField)variable : null;
            return field != null && fieldFilter.value((Object)field) ? variable : null;
        });
        Map fieldsByName = filteredFields.stream().collect(Collectors.toMap(NavigationItem::getName, Function.identity(), (var1, var2) -> var2));
        for (JSVariable field : fieldsByName.values()) {
            JSExpression initializer = JSUtils.unparenthesize(field.getInitializer());
            if (initializer == null || initializer instanceof JSFunction || initializer instanceof JSClass) continue;
            PsiTreeUtil.processElements((PsiElement)initializer, element -> {
                JSReferenceExpression referenceExpression;
                if (isAcceptableQualifier == null) {
                    ES6Rearranger.$$$reportNull$$$0(29);
                }
                if (fieldToEntry == null) {
                    ES6Rearranger.$$$reportNull$$$0(30);
                }
                JSReferenceExpression jSReferenceExpression = referenceExpression = element instanceof JSReferenceExpression ? (JSReferenceExpression)element : null;
                if (referenceExpression != null && isAcceptableQualifier.value((Object)referenceExpression.getQualifier())) {
                    JSElementArrangementEntry dependencyEntry;
                    JSVariable accessedField = (JSVariable)fieldsByName.get(referenceExpression.getReferenceName());
                    JSElementArrangementEntry entry = (JSElementArrangementEntry)fieldToEntry.get(field);
                    if (field != accessedField && accessedField != null && entry != null && (dependencyEntry = (JSElementArrangementEntry)fieldToEntry.get(accessedField)) != null) {
                        entry.addDependency(dependencyEntry);
                    }
                }
                return true;
            });
        }
    }

    private static boolean isStatic(@NotNull JSField field) {
        if (field == null) {
            ES6Rearranger.$$$reportNull$$$0(10);
        }
        return field.getAttributeList() != null && field.getAttributeList().hasModifier(JSAttributeList.ModifierType.STATIC);
    }

    @Override
    protected boolean isModifierEnabled(@NotNull ArrangementSettingsToken modifier, @NotNull ArrangementSettingsToken entryType, @NotNull Set<ArrangementSettingsToken> existingModifiers) {
        if (modifier == null) {
            ES6Rearranger.$$$reportNull$$$0(11);
        }
        if (entryType == null) {
            ES6Rearranger.$$$reportNull$$$0(12);
        }
        if (existingModifiers == null) {
            ES6Rearranger.$$$reportNull$$$0(13);
        }
        return (entryType == StdArrangementTokens.EntryType.METHOD || entryType == StdArrangementTokens.EntryType.FIELD || entryType == StdArrangementTokens.EntryType.PROPERTY) && modifier == StdArrangementTokens.Modifier.STATIC;
    }

    public int getBlankLines(@NotNull CodeStyleSettings settings, @Nullable JSArrangementEntry parent, @Nullable JSArrangementEntry previous, @NotNull JSArrangementEntry target) {
        if (settings == null) {
            ES6Rearranger.$$$reportNull$$$0(14);
        }
        if (target == null) {
            ES6Rearranger.$$$reportNull$$$0(15);
        }
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings((Language)this.myDialect);
        JSElementArrangementEntry targetElement = (JSElementArrangementEntry)ObjectUtils.tryCast((Object)target, JSElementArrangementEntry.class);
        JSElementArrangementEntry previousElement = (JSElementArrangementEntry)ObjectUtils.tryCast((Object)previous, JSElementArrangementEntry.class);
        JSElementArrangementEntry parentElement = (JSElementArrangementEntry)ObjectUtils.tryCast((Object)parent, JSElementArrangementEntry.class);
        if (targetElement != null && previousElement != null) {
            return Math.max(this.getBlankLines(commonSettings, targetElement.getType(), parentElement), this.getBlankLines(commonSettings, previousElement.getType(), parentElement));
        }
        return -1;
    }

    protected int getBlankLines(@NotNull CommonCodeStyleSettings commonSettings, @Nullable ArrangementSettingsToken type, @Nullable JSElementArrangementEntry parent) {
        if (commonSettings == null) {
            ES6Rearranger.$$$reportNull$$$0(16);
        }
        return type == StdArrangementTokens.EntryType.FIELD ? commonSettings.BLANK_LINES_AROUND_FIELD : commonSettings.BLANK_LINES_AROUND_METHOD;
    }

    @NotNull
    public final ArrangementSettingsSerializer getSerializer() {
        DefaultArrangementSettingsSerializer defaultArrangementSettingsSerializer = this.mySettingsSerializer;
        if (defaultArrangementSettingsSerializer == null) {
            ES6Rearranger.$$$reportNull$$$0(17);
        }
        return defaultArrangementSettingsSerializer;
    }

    @Override
    @NotNull
    protected final Set<ArrangementSettingsToken> getSupportedTypes() {
        Set<ArrangementSettingsToken> set = SUPPORTED_TYPES;
        if (set == null) {
            ES6Rearranger.$$$reportNull$$$0(18);
        }
        return set;
    }

    @Override
    @NotNull
    protected final Set<ArrangementSettingsToken> getVisibilityModifiers() {
        Set<ArrangementSettingsToken> set = this.myVisibilityModifiers;
        if (set == null) {
            ES6Rearranger.$$$reportNull$$$0(19);
        }
        return set;
    }

    @Override
    @NotNull
    protected final Set<ArrangementSettingsToken> getSupportedModifiers() {
        Set<ArrangementSettingsToken> set = this.mySupportedModifiers;
        if (set == null) {
            ES6Rearranger.$$$reportNull$$$0(20);
        }
        return set;
    }

    @Override
    @NotNull
    protected Set<ArrangementSettingsToken> detectModifiers(@NotNull JSAttributeListOwner fieldOrMethod) {
        HashSet result;
        JSAttributeList attributes;
        block12: {
            block11: {
                if (fieldOrMethod == null) {
                    ES6Rearranger.$$$reportNull$$$0(21);
                }
                if ((attributes = fieldOrMethod.getAttributeList()) == null) {
                    HashSet hashSet = ContainerUtil.newHashSet((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Modifier.PUBLIC});
                    if (hashSet == null) {
                        ES6Rearranger.$$$reportNull$$$0(22);
                    }
                    return hashSet;
                }
                result = ContainerUtil.newHashSet();
                JSAttributeList.AccessType accessType = attributes.getExplicitAccessType();
                if (accessType == null) break block11;
                switch (accessType) {
                    case PUBLIC: {
                        result.add(StdArrangementTokens.Modifier.PUBLIC);
                        break block12;
                    }
                    case PROTECTED: {
                        result.add(StdArrangementTokens.Modifier.PROTECTED);
                        break block12;
                    }
                    case PRIVATE: {
                        result.add(StdArrangementTokens.Modifier.PRIVATE);
                        break block12;
                    }
                    default: {
                        throw new RuntimeException("Unknown accessType " + accessType);
                    }
                }
            }
            result.add(StdArrangementTokens.Modifier.PUBLIC);
        }
        if (attributes.hasModifier(JSAttributeList.ModifierType.STATIC)) {
            result.add(StdArrangementTokens.Modifier.STATIC);
        }
        if (attributes.hasModifier(JSAttributeList.ModifierType.READONLY)) {
            result.add(StdArrangementTokens.Modifier.READONLY);
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            ES6Rearranger.$$$reportNull$$$0(23);
        }
        return hashSet;
    }

    @Override
    protected List<JSRearrangerBase.OverrideInfo> detectOverrides(@NotNull JSQualifiedNamedElement member) {
        if (member == null) {
            ES6Rearranger.$$$reportNull$$$0(24);
        }
        ArrayList superMembers = ContainerUtil.newArrayList(JSInheritanceUtil.findImplementedMembers(member));
        JSInheritanceUtil.iterateOverriddenMembersUp((JSPsiElementBase)member, true, (overridden, superType) -> {
            superMembers.addAll(overridden);
            return true;
        }, false);
        return ContainerUtil.map((Collection)superMembers, superMember -> {
            if (member == null) {
                ES6Rearranger.$$$reportNull$$$0(28);
            }
            return new JSRearrangerBase.OverrideInfo(member, (JSPsiElementBase)superMember);
        });
    }

    public List<StdArrangementMatchRule> getDefaultMatchRules() {
        return ES6Rearranger.getDefaultMatchRules(this.myVisibilityModifiers);
    }

    private static List<StdArrangementMatchRule> getDefaultMatchRules(Set<ArrangementSettingsToken> visibilityModifiers) {
        ArrayList matchRules = ContainerUtil.newArrayList();
        ES6Rearranger.addRules(matchRules, StdArrangementTokens.EntryType.FIELD, visibilityModifiers);
        ES6Rearranger.addRule(matchRules, StdArrangementTokens.EntryType.CONSTRUCTOR);
        ES6Rearranger.addRules(matchRules, StdArrangementTokens.EntryType.PROPERTY, visibilityModifiers);
        ES6Rearranger.addRules(matchRules, StdArrangementTokens.EntryType.METHOD, visibilityModifiers);
        return matchRules;
    }

    private static void addRules(@NotNull ArrayList<StdArrangementMatchRule> matchRules, @NotNull ArrangementSettingsToken type, @NotNull Set<ArrangementSettingsToken> visibilityModifiers) {
        if (matchRules == null) {
            ES6Rearranger.$$$reportNull$$$0(25);
        }
        if (type == null) {
            ES6Rearranger.$$$reportNull$$$0(26);
        }
        if (visibilityModifiers == null) {
            ES6Rearranger.$$$reportNull$$$0(27);
        }
        if (visibilityModifiers.isEmpty()) {
            ES6Rearranger.addRule(matchRules, type, StdArrangementTokens.Modifier.STATIC);
            ES6Rearranger.addRule(matchRules, type);
        } else {
            for (ArrangementSettingsToken modifier : visibilityModifiers) {
                ES6Rearranger.addRule(matchRules, type, modifier, StdArrangementTokens.Modifier.STATIC);
            }
            for (ArrangementSettingsToken modifier : visibilityModifiers) {
                ES6Rearranger.addRule(matchRules, type, modifier);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classArrangementInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrangementInfo";
                break;
            }
            case 3: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "membersMap";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overrides";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ordering";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldStatements";
                break;
            }
            case 7: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldToEntry";
                break;
            }
            case 8: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldFilter";
                break;
            }
            case 9: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isAcceptableQualifier";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingModifiers";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/arrangement/ES6Rearranger";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldOrMethod";
                break;
            }
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchRules";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibilityModifiers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/arrangement/ES6Rearranger";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSerializer";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedTypes";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibilityModifiers";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedModifiers";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "detectModifiers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "postprocessClassMembers";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processOverriddenMembers";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processDependantFields";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isStatic";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isModifierEnabled";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getBlankLines";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "detectModifiers";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "detectOverrides";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addRules";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$detectOverrides$11";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processDependantFields$9";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processDependantFields$7";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processOverriddenMembers$5";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$postprocessClassMembers$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

