/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionConfidence;
import com.intellij.codeInsight.completion.HtmlTextCompletionConfidence;
import com.intellij.javascript.JavaScriptReferenceContributor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.e4x.impl.JSXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSAutoCompletionPopupPolicy
extends CompletionConfidence {
    @NotNull
    public ThreeState shouldSkipAutopopup(@NotNull PsiElement contextElement, @NotNull PsiFile psiFile, int offset) {
        boolean isIdentifier;
        IElementType nodeType;
        PsiElement prevContextElement;
        ASTNode node;
        PsiElement commentOrLiteral;
        if (contextElement == null) {
            JSAutoCompletionPopupPolicy.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            JSAutoCompletionPopupPolicy.$$$reportNull$$$0(1);
        }
        if ((commentOrLiteral = PsiTreeUtil.getNonStrictParentOfType((PsiElement)contextElement, (Class[])new Class[]{PsiComment.class, JSExpression.class})) instanceof JSLiteralExpression) {
            if (JSAutoCompletionPopupPolicy.shouldSkipAutopopupInLiteral((JSLiteralExpression)commentOrLiteral)) {
                ThreeState threeState = ThreeState.YES;
                if (threeState == null) {
                    JSAutoCompletionPopupPolicy.$$$reportNull$$$0(2);
                }
                return threeState;
            }
        } else if (commentOrLiteral instanceof PsiComment && contextElement.getNode().getElementType() != JSDocTokenTypes.DOC_TAG_NAME) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                JSAutoCompletionPopupPolicy.$$$reportNull$$$0(3);
            }
            return threeState;
        }
        if ((node = (prevContextElement = contextElement).getNode()) != null && ((nodeType = node.getElementType()) == JSTokenTypes.DOT || nodeType == JSTokenTypes.DOT_DOT || nodeType == JSTokenTypes.DOT_DOT_DOT)) {
            prevContextElement = PsiTreeUtil.prevLeaf((PsiElement)prevContextElement);
        }
        if (prevContextElement != null && prevContextElement.getParent() instanceof JSParameterList || prevContextElement instanceof PsiErrorElement) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                JSAutoCompletionPopupPolicy.$$$reportNull$$$0(4);
            }
            return threeState;
        }
        PsiElement parent = contextElement.getParent();
        boolean bl = isIdentifier = node != null && JSKeywordSets.IDENTIFIER_NAMES.contains(node.getElementType());
        if (parent instanceof JSProperty && !isIdentifier || (parent instanceof JSProperty || JSAutoCompletionPopupPolicy.isShorthandedProperty(parent)) && !JSAutoCompletionPopupPolicy.isES6OrTypeScript(psiFile) || parent instanceof TypeScriptPropertySignature) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                JSAutoCompletionPopupPolicy.$$$reportNull$$$0(5);
            }
            return threeState;
        }
        if (HtmlTextCompletionConfidence.shouldSkipAutopopupInHtml((PsiElement)contextElement, (int)offset)) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                JSAutoCompletionPopupPolicy.$$$reportNull$$$0(6);
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            JSAutoCompletionPopupPolicy.$$$reportNull$$$0(7);
        }
        return threeState;
    }

    private static boolean isES6OrTypeScript(@NotNull PsiFile psiFile) {
        DialectOptionHolder holder;
        if (psiFile == null) {
            JSAutoCompletionPopupPolicy.$$$reportNull$$$0(8);
        }
        return (holder = DialectDetector.dialectOfElement((PsiElement)psiFile)) != null && (holder.isTypeScript || holder.isECMA6);
    }

    private static boolean isShorthandedProperty(@Nullable PsiElement parent) {
        return parent instanceof JSReferenceExpression && parent.getParent() instanceof ES6Property && ((ES6Property)parent.getParent()).isShorthanded();
    }

    private static boolean shouldSkipAutopopupInLiteral(@NotNull JSLiteralExpression literal) {
        if (literal == null) {
            JSAutoCompletionPopupPolicy.$$$reportNull$$$0(9);
        }
        if (literal instanceof JSXmlLiteralExpressionImpl) {
            return false;
        }
        return !JavaScriptReferenceContributor.REQUIRE_ARG_PLACE.accepts((Object)literal);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/completion/JSAutoCompletionPopupPolicy";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/completion/JSAutoCompletionPopupPolicy";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "shouldSkipAutopopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "shouldSkipAutopopup";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isES6OrTypeScript";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "shouldSkipAutopopupInLiteral";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

