/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.javascript.ecmascript6.TypeScriptQualifiedItemProcessor;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCompileTimeType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSParenthesizedExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptResolveProcessor<T extends ResultSink>
extends TypeScriptQualifiedItemProcessor<T> {
    private final NullableLazyValue<List<JSType>> myArgumentTypesValue;
    private final boolean myStrictTypeContext;
    private final boolean myIncompleteCode;
    private final boolean myStrictTypeContainerContext;
    @Nullable
    private final JSCallExpression myCallExpression;
    private final NullableLazyValue<JSType> myQualifierTypeValue;

    public TypeScriptResolveProcessor(ResultSink sink, PsiFile containingFile, PsiElement _place, boolean incompleteCode) {
        super(sink, containingFile);
        PsiElement parent;
        JSReferenceExpression topRefExpression;
        this.myStrictTypeContext = _place instanceof JSReferenceExpression && JSResolveUtil.isExprInStrictTypeContext((JSReferenceExpression)_place);
        this.myIncompleteCode = incompleteCode;
        this.myStrictTypeContainerContext = !this.myStrictTypeContext ? (topRefExpression = TypeScriptResolveProcessor.getTopRefExpression(_place)) != null && JSResolveUtil.isExprInStrictTypeContext(topRefExpression) : false;
        PsiElement psiElement = parent = this.place instanceof PsiFile ? this.place : this.place.getParent();
        while (parent instanceof JSParenthesizedExpressionImpl) {
            parent = parent.getParent();
        }
        this.myCallExpression = parent instanceof JSCallExpression ? (JSCallExpression)parent : null;
        this.myArgumentTypesValue = NullableLazyValue.createValue(() -> {
            if (this.myCallExpression == null) {
                return null;
            }
            return TypeScriptGenericTypesEvaluator.getArgumentTypesForSignatureChecking(this.myCallExpression);
        });
        this.myQualifierTypeValue = NullableLazyValue.createValue(() -> {
            if (this.myCallExpression == null) {
                return null;
            }
            JSExpression expression = this.myCallExpression.getMethodExpression();
            if (!(expression instanceof JSReferenceExpression)) {
                return null;
            }
            JSExpression qualifier = ((JSReferenceExpression)expression).getQualifier();
            return qualifier == null ? null : JSResolveUtil.getExpressionJSType(qualifier);
        });
    }

    public TypeScriptResolveProcessor(String referenceName, PsiFile containingFile, JSExpression _place, boolean incompleteCode) {
        this(new ResolveResultSink((PsiElement)_place, referenceName), containingFile, (PsiElement)_place, incompleteCode);
    }

    @Nullable
    private static JSReferenceExpression getTopRefExpression(@Nullable PsiElement _place) {
        JSReferenceExpression result = null;
        while (_place instanceof JSReferenceExpression) {
            result = (JSReferenceExpression)_place;
            _place = _place.getParent();
        }
        return result;
    }

    @Override
    protected boolean needProcessTypeMembers(PsiElement element, PsiElement clazz) {
        if (clazz instanceof TypeScriptModule) {
            String moduleName = ((TypeScriptModule)clazz).getName();
            String elementName = null;
            if (element instanceof PsiNamedElement) {
                elementName = ((PsiNamedElement)element).getName();
            } else if (element instanceof JSReferenceExpression) {
                elementName = ((JSReferenceExpression)element).getReferenceName();
            }
            if (Comparing.equal((String)elementName, (String)moduleName)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isSpecifierAcceptable(ES6ImportExportSpecifier specifier) {
        if (this.myStrictTypeContext || this.myStrictTypeContainerContext) {
            return TypeScriptPsiUtil.referencesNamedTypeContainer(specifier);
        }
        return super.isSpecifierAcceptable(specifier);
    }

    @Nullable
    private JSResolveResult checkParameterTypes(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            TypeScriptResolveProcessor.$$$reportNull$$$0(0);
        }
        if (state == null) {
            TypeScriptResolveProcessor.$$$reportNull$$$0(1);
        }
        if (this.myIncompleteCode || this.myCallExpression == null) {
            return new JSResolveResult(element);
        }
        JSTypeSubstitutor genericArguments = TypeScriptGenericTypesEvaluator.addExplicitGenericArgumentsFromCall(element, (PsiElement)this.myCallExpression, (JSTypeSubstitutor)state.get(TYPESCRIPT_GENERICS));
        JSType qualifierType = (JSType)this.myQualifierTypeValue.getValue();
        JSResolveResult resolveResult = TypeScriptSignatureChooser.checkParameterTypes(element, (List<JSType>)((List)this.myArgumentTypesValue.getValue()), qualifierType, genericArguments, this.myCallExpression instanceof JSNewExpression);
        ES6ImportExportDeclarationPart usedImport = resolveResult.getES6Import();
        if (usedImport != null) {
            state.put(JSResolveResult.IMPORT_KEY, (Object)usedImport);
        }
        if (!resolveResult.isValidResult()) {
            PsiElement elementToResolve = element;
            if (TypeScriptSignatureChooser.isOverloadImplementation(element)) {
                elementToResolve = resolveResult.getElement();
            }
            this.addPossibleCandidateResult(elementToResolve, resolveResult.getResolveProblemKey());
            return null;
        }
        return resolveResult;
    }

    @Override
    public ResolveResult[] getResultsAsResolveResults() {
        ResolveResult[] results = super.getResultsAsResolveResults();
        if (this.myIncompleteCode) {
            return results;
        }
        if (TypeScriptResolveProcessor.isTypeMismatchResult(results)) {
            results[0] = new JSResolveResult(results[0].getElement());
            return results;
        }
        if (results.length > 0 && this.myCallExpression != null) {
            return TypeScriptPsiUtil.chooseOverloads(results);
        }
        return results;
    }

    private static boolean isTypeMismatchResult(ResolveResult[] results) {
        return results.length == 1 && !results[0].isValidResult() && results[0] instanceof JSResolveResult && ((JSResolveResult)results[0]).getResolveProblemKey() == "javascript.argument.types.mismatch";
    }

    @Override
    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            TypeScriptResolveProcessor.$$$reportNull$$$0(2);
        }
        if (state == null) {
            TypeScriptResolveProcessor.$$$reportNull$$$0(3);
        }
        if (this.myStrictTypeContext && !TypeScriptPsiUtil.isNamedTypeDefinition(element)) {
            return true;
        }
        if (this.myStrictTypeContainerContext && !TypeScriptPsiUtil.isNamedTypeContainerDefinition(element)) {
            return true;
        }
        if (!(this.myStrictTypeContext || !(this.place instanceof JSReferenceExpression) || !(element instanceof TypeScriptCompileTimeType) || this.place instanceof TypeScriptModule || this.place instanceof TypeScriptEntityName || this.place instanceof TypeScriptImportStatement || this.place.getParent() instanceof JSExportAssignment)) {
            return true;
        }
        return super.execute(element, state);
    }

    public boolean isCallExpression() {
        return this.myCallExpression != null;
    }

    @Override
    protected boolean executeAcceptedElement(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            TypeScriptResolveProcessor.$$$reportNull$$$0(4);
        }
        if (state == null) {
            TypeScriptResolveProcessor.$$$reportNull$$$0(5);
        }
        if (element instanceof TypeScriptFunction && ((TypeScriptFunction)element).isOverloadDeclaration()) {
            return true;
        }
        if (this.myCallExpression != null) {
            JSResolveResult resolveResult = this.checkParameterTypes(element, state);
            if (resolveResult == null) {
                return false;
            }
            element = resolveResult.getElement();
            ES6ImportExportDeclarationPart es6Import = resolveResult.getES6Import();
            if (es6Import != null) {
                state = state.put(JSResolveResult.IMPORT_KEY, (Object)es6Import);
            }
        }
        if (element instanceof TypeScriptIndexSignature && this.myName != null && ((TypeScriptIndexSignature)element).getIndexSignatureKind() == JSRecordType.IndexSignatureKind.STRING) {
            return ((ResultSink)this.getResultSink()).addResult(element, state, this);
        }
        return super.executeAcceptedElement(element, state);
    }

    @Override
    @Nullable
    protected PsiElement getConstructor(@NotNull PsiElement element) {
        if (element == null) {
            TypeScriptResolveProcessor.$$$reportNull$$$0(6);
        }
        PsiElement constructor = null;
        ResolveResult[] results = JSClassUtils.resolveES6Constructor((JSClass)element, (JSExpression)this.place);
        PsiElement validElement = null;
        boolean addedPossibleCandidate = false;
        for (ResolveResult resolveResult : results) {
            if (resolveResult.isValidResult()) {
                validElement = resolveResult.getElement();
                continue;
            }
            if (!this.myIncompleteCode && addedPossibleCandidate) continue;
            this.addPossibleCandidateResult(resolveResult.getElement(), "javascript.argument.types.mismatch");
            addedPossibleCandidate = true;
        }
        if (validElement == null) {
            return null;
        }
        PsiElement constrOrClass = validElement;
        if (constrOrClass instanceof JSFunction && JSUtils.getMemberContainingClass(constrOrClass) == element) {
            constructor = constrOrClass;
        }
        return constructor == null ? element : constructor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkParameterTypes";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "executeAcceptedElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getConstructor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

