/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCompileTimeType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCacheService;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptSignatureChooser {
    private static final Comparator<PsiElement> FUNCTIONS_FIRST = Comparator.comparing(el -> el instanceof JSFunction ? -1 : 0).thenComparing(el -> el instanceof JSVariable ? -1 : 0).thenComparing(el -> el instanceof TypeScriptCompileTimeType ? 1 : -1);

    @NotNull
    public static JSResolveResult checkParameterTypes(@NotNull PsiElement candidate, @Nullable List<JSType> argumentTypes, @Nullable JSType qualifierType, @Nullable JSTypeSubstitutor genericArguments, boolean isNewExpression) {
        if (candidate == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(0);
        }
        JSResolveResult jSResolveResult = TypeScriptSignatureChooser.checkParameterTypes(candidate, argumentTypes, qualifierType, genericArguments, isNewExpression, null);
        if (jSResolveResult == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(1);
        }
        return jSResolveResult;
    }

    @NotNull
    private static JSResolveResult checkParameterTypes(@NotNull PsiElement candidate, @Nullable List<JSType> argumentTypes, @Nullable JSType qualifierType, @Nullable JSTypeSubstitutor genericArguments, boolean isNewExpression, @Nullable Collection<PsiElement> visited) {
        JSResolveResult overloadResult;
        if (candidate == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(2);
        }
        if (candidate instanceof ES6ImportSpecifier) {
            ResolveResult[] results = ((ES6ImportSpecifier)candidate).multiResolve(false);
            ArrayList elements = ContainerUtil.newArrayList(JSResolveResult.toElements(results, true));
            if (elements.isEmpty()) {
                JSResolveResult jSResolveResult = new JSResolveResult(candidate);
                if (jSResolveResult == null) {
                    TypeScriptSignatureChooser.$$$reportNull$$$0(3);
                }
                return jSResolveResult;
            }
            if (visited == null) {
                visited = ContainerUtil.newHashSet();
            }
            if (!visited.add(candidate)) {
                JSResolveResult jSResolveResult = new JSResolveResult(candidate);
                if (jSResolveResult == null) {
                    TypeScriptSignatureChooser.$$$reportNull$$$0(4);
                }
                return jSResolveResult;
            }
            ContainerUtil.sort((List)elements, FUNCTIONS_FIRST);
            for (PsiElement element : elements) {
                JSResolveResult result = TypeScriptSignatureChooser.checkParameterTypes(element, argumentTypes, qualifierType, genericArguments, isNewExpression, visited);
                if (!result.isValidResult()) continue;
                JSResolveResult jSResolveResult = new JSResolveResult(result.getElement(), (JSElement)((ES6ImportSpecifier)candidate), result.getResolveProblemKey());
                if (jSResolveResult == null) {
                    TypeScriptSignatureChooser.$$$reportNull$$$0(5);
                }
                return jSResolveResult;
            }
        }
        if (!(candidate instanceof JSFunction)) {
            JSResolveResult jSResolveResult = new JSResolveResult(candidate);
            if (jSResolveResult == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(6);
            }
            return jSResolveResult;
        }
        if (candidate instanceof TypeScriptFunction && (overloadResult = TypeScriptSignatureChooser.getOverloadResultSignature(candidate, argumentTypes, qualifierType, genericArguments, isNewExpression)) != null) {
            JSResolveResult jSResolveResult = overloadResult;
            if (jSResolveResult == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(7);
            }
            return jSResolveResult;
        }
        JSFunction jsFunction = (JSFunction)candidate;
        JSParameterList parameterList = jsFunction.isConstructor() == isNewExpression ? jsFunction.getParameterList() : null;
        JSResolveResult jSResolveResult = new JSResolveResult(candidate, null, TypeScriptSignatureChooser.checkParameterTypes(candidate, argumentTypes, qualifierType, genericArguments, parameterList));
        if (jSResolveResult == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(8);
        }
        return jSResolveResult;
    }

    @Nullable
    private static JSResolveResult getOverloadResultSignature(@NotNull PsiElement functionCandidate, @Nullable List<JSType> argumentTypes, @Nullable JSType qualifierType, @Nullable JSTypeSubstitutor genericArguments, boolean isNewExpression) {
        if (functionCandidate == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(9);
        }
        List overloads = ((TypeScriptFunction)functionCandidate).getOverloadDeclarations();
        String firstError = null;
        TypeScriptFunction firstOverload = null;
        for (TypeScriptFunction overload : overloads) {
            if (overload.isConstructor() != isNewExpression) continue;
            String latestError = TypeScriptSignatureChooser.checkParameterTypes(functionCandidate, argumentTypes, qualifierType, genericArguments, overload.getParameterList());
            if (latestError == null) {
                return new JSResolveResult((PsiElement)overload);
            }
            if (firstError != null) continue;
            firstError = latestError;
            firstOverload = overload;
        }
        if (TypeScriptSignatureChooser.isOverloadImplementation(functionCandidate)) {
            PsiElement resultFunction = functionCandidate;
            if (firstError != null) {
                resultFunction = firstOverload;
            }
            return new JSResolveResult(resultFunction, null, firstError);
        }
        return null;
    }

    public static boolean isOverloadImplementation(@Nullable PsiElement function) {
        return function instanceof TypeScriptFunction && ((TypeScriptFunction)function).isOverloadImplementation();
    }

    @NotNull
    private static List<JSParameterTypeDecorator> getTypeDecoratorsWithAppliedGenerics(@NotNull JSParameterItem[] parameters, @Nullable JSTypeSubstitutor genericArguments) {
        if (parameters == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(10);
        }
        ArrayList<JSParameterTypeDecorator> parameterTypes = new ArrayList<JSParameterTypeDecorator>();
        for (JSParameterItem p : parameters) {
            JSType parameterType = p.getType();
            if (parameterType != null) {
                parameterType = JSTypeUtils.applyGenericArguments(parameterType, (Map<String, JSType>)genericArguments);
            }
            JSParameterTypeDecoratorImpl typeDecorator = new JSParameterTypeDecoratorImpl(parameterType, p.isOptional(), p.isRest(), p.getTypeDecorator().isExplicitlyDeclared());
            parameterTypes.add(typeDecorator);
        }
        ArrayList<JSParameterTypeDecorator> arrayList = parameterTypes;
        if (arrayList == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @Nullable
    public static String checkParameterTypes(@NotNull PsiElement context, @Nullable List<JSType> argumentTypes, @Nullable JSType qualifierType, @Nullable JSTypeSubstitutor genericArguments, @Nullable JSParameterList parameterList) {
        if (context == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(12);
        }
        if (parameterList == null) {
            return null;
        }
        List<JSParameterTypeDecorator> functionParameters = TypeScriptSignatureChooser.getTypeDecoratorsWithAppliedGenerics((JSParameterItem[])parameterList.getParameters(), genericArguments);
        return TypeScriptSignatureChooser.checkParameterTypes(context, ContainerUtil.notNullize(argumentTypes), qualifierType, functionParameters);
    }

    @Nullable
    private static String checkParameterTypes(@NotNull PsiElement elementContext, @NotNull List<JSType> argumentTypes, @Nullable JSType qualifierType, @NotNull List<JSParameterTypeDecorator> functionParameters) {
        if (elementContext == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(13);
        }
        if (argumentTypes == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(14);
        }
        if (functionParameters == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(15);
        }
        ProcessingContext context = JSTypeComparingCacheService.getProcessingContextWithCache(elementContext);
        context.put(JSGenericParameterImpl.CALL_ENV_KEY, (Object)true);
        List<JSParameterTypeDecorator> arguments = JSTypeUtils.getParameterTypeDecorators(argumentTypes);
        if (JSTypeUtils.areArgumentsAssignable(functionParameters, arguments, context, false, false, true)) {
            if (elementContext instanceof TypeScriptFunction && qualifierType != null) {
                JSType thisType = ((TypeScriptFunction)elementContext).getExplicitThisType();
                if (thisType == null) {
                    return null;
                }
                return thisType.isDirectlyAssignableType(qualifierType, context) ? null : "javascript.argument.types.mismatch";
            }
            return null;
        }
        return "javascript.argument.types.mismatch";
    }

    @Nullable
    public static JSFunction getFunctionWithParameters(@NotNull JSCallExpression expression, @NotNull Collection<JSFunction> functions) {
        if (expression == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(16);
        }
        if (functions == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(17);
        }
        return TypeScriptSignatureChooser.getFunctionWithParameters(expression, functions, null);
    }

    @Nullable
    public static <T extends JSFunctionItem> T getFunctionWithParameters(@NotNull JSCallExpression expression, @NotNull Collection<T> functions, @Nullable JSTypeSubstitutor substitutor) {
        if (expression == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(18);
        }
        if (functions == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(19);
        }
        List<JSType> argumentTypes = JSTypeUtils.getArgumentTypes(expression.getArgumentList());
        for (JSFunctionItem constructor : functions) {
            List<JSParameterTypeDecorator> parameters = TypeScriptSignatureChooser.getTypeDecoratorsWithAppliedGenerics(constructor.getParameters(), substitutor);
            if (TypeScriptSignatureChooser.checkParameterTypes((PsiElement)expression, argumentTypes, null, parameters) != null) continue;
            return (T)constructor;
        }
        return null;
    }

    @NotNull
    public static List<JSFunctionWithSubstitutor> getFunctionElementsWithCheckParameterTypes(@NotNull PsiElement referenceExpression) {
        if (referenceExpression == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(20);
        }
        if (referenceExpression instanceof JSReferenceExpression && referenceExpression.getParent() instanceof JSCallExpression) {
            PsiElement functionCandidate;
            List<JSFunctionItem> resolveElements;
            JSCallExpression callExpression = (JSCallExpression)referenceExpression.getParent();
            JSReferenceExpression element = (JSReferenceExpression)referenceExpression;
            ResolveResult[] resolveResults = element.multiResolve(false);
            Collection<PsiElement> elements = JSResolveResult.toElements(resolveResults);
            if (callExpression instanceof JSNewExpression && (resolveElements = TypeScriptSignatureChooser.getConstructorsForResolveElements((JSExpression)referenceExpression, elements)).size() > 0) {
                List<JSFunctionWithSubstitutor> list = resolveElements.stream().map(JSPsiImplUtils.TO_FUNCTION_WITH_SUBSTITUTOR).collect(Collectors.toList());
                if (list == null) {
                    TypeScriptSignatureChooser.$$$reportNull$$$0(21);
                }
                return list;
            }
            if (elements.size() == 1 && (functionCandidate = (PsiElement)ContainerUtil.getFirstItem(elements)) != null && !(functionCandidate instanceof JSFunction) && DialectDetector.isTypeScript(functionCandidate)) {
                List<JSFunctionWithSubstitutor> list = TypeScriptSignatureChooser.getCallSignatures(functionCandidate, callExpression);
                if (list == null) {
                    TypeScriptSignatureChooser.$$$reportNull$$$0(22);
                }
                return list;
            }
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(23);
        }
        return list;
    }

    @NotNull
    private static List<JSFunctionItem> getConstructorsForResolveElements(@NotNull JSExpression parent, @NotNull Collection<PsiElement> elements) {
        if (parent == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(24);
        }
        if (elements == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(25);
        }
        if (!elements.isEmpty()) {
            List result = ContainerUtil.newSmartList();
            for (PsiElement psiElement : elements) {
                ResolveResult[] results;
                Collection<PsiElement> resolvedElements;
                if (!(psiElement instanceof JSClass) || (resolvedElements = JSResolveResult.toElements(results = JSClassUtils.resolveES6Constructor((JSClass)psiElement, parent))).isEmpty()) continue;
                result.addAll(resolvedElements);
            }
            if (result.size() > 0) {
                List list = ContainerUtil.mapNotNull((Collection)result, el -> el instanceof JSFunctionItem ? (JSFunctionItem)el : null);
                if (list == null) {
                    TypeScriptSignatureChooser.$$$reportNull$$$0(26);
                }
                return list;
            }
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(27);
        }
        return list;
    }

    @NotNull
    private static List<JSFunctionWithSubstitutor> getCallSignatures(@NotNull PsiElement functionCandidate, @NotNull JSCallExpression callExpression) {
        if (functionCandidate == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(28);
        }
        if (callExpression == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(29);
        }
        JSTypeSubstitutor substitutor = TypeScriptGenericTypesEvaluator.addExplicitGenericArgumentsFromCall(functionCandidate, (PsiElement)callExpression, null);
        Collection<JSFunctionWithSubstitutor> functionWithSubstitutors = JSPsiImplUtils.calculatePossibleFunctions(functionCandidate, (PsiElement)callExpression);
        List functionItems = functionWithSubstitutors.stream().map(el -> el.myFunctionItem).collect(Collectors.toList());
        Object functionItem = TypeScriptSignatureChooser.getFunctionWithParameters(callExpression, functionItems, substitutor);
        if (functionItem != null) {
            for (JSFunctionWithSubstitutor withSubstitutor : functionWithSubstitutors) {
                if (withSubstitutor.myFunctionItem != functionItem) continue;
                List list = ContainerUtil.createMaybeSingletonList((Object)withSubstitutor);
                if (list == null) {
                    TypeScriptSignatureChooser.$$$reportNull$$$0(30);
                }
                return list;
            }
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(31);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 30: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptSignatureChooser";
                break;
            }
            case 9: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionCandidate";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementContext";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentTypes";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionParameters";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functions";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptSignatureChooser";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "checkParameterTypes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeDecoratorsWithAppliedGenerics";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionElementsWithCheckParameterTypes";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructorsForResolveElements";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallSignatures";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkParameterTypes";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 30: 
            case 31: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getOverloadResultSignature";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTypeDecoratorsWithAppliedGenerics";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionWithParameters";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionElementsWithCheckParameterTypes";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getConstructorsForResolveElements";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getCallSignatures";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

