/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6TypeEvaluator;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.e4x.impl.JSXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCastExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGlobalModuleExportDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterfaceClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptNotNullExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyCallElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyContextElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyInstanceContextElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSSpecialNamedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTupleTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCacheService;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptIndexedAccessJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptTypeEvaluator
extends ES6TypeEvaluator {
    private static final Condition<PsiElement> HAS_DECLARATIONS = element -> TypeScriptTypeEvaluator.hasInnerDeclarations(element);

    public TypeScriptTypeEvaluator(JSEvaluateContext context, JSTypeProcessor processor) {
        super(context, processor);
    }

    @Override
    protected boolean addTypeFromDialectSpecificElements(PsiElement resolveResult) {
        if (resolveResult instanceof TypeScriptPropertySignature) {
            TypeScriptPropertySignature propertySignature = (TypeScriptPropertySignature)resolveResult;
            JSTypeDeclaration propertyType = propertySignature.getTypeDeclaration();
            if (propertyType instanceof JSFunction) {
                this.processFunction((JSFunction)propertyType);
            } else if (propertyType != null) {
                JSType jsType = propertySignature.getType();
                this.addType(jsType, resolveResult);
            }
            return true;
        }
        if (resolveResult instanceof TypeScriptModule) {
            this.addTypeFromModule((TypeScriptModule)resolveResult);
            return true;
        }
        if (resolveResult instanceof TypeScriptImportStatement) {
            this.addTypeFromImportStatement((TypeScriptImportStatement)resolveResult);
            return true;
        }
        if (resolveResult instanceof TypeScriptIndexSignature) {
            JSReferenceExpression expression = this.myContext.getProcessedExpression();
            if (expression != null) {
                JSType type = ((TypeScriptIndexSignature)resolveResult).getMemberType();
                this.addType(type, resolveResult);
                return true;
            }
        } else {
            if (resolveResult instanceof TypeScriptCallSignature) {
                JSApplyContextElement peek = this.myContext.peekJSElementToApply();
                TypeScriptCallSignature callSignature = (TypeScriptCallSignature)resolveResult;
                if (callSignature.hasNew() ? peek instanceof JSApplyInstanceContextElement && ((JSApplyInstanceContextElement)peek).getNewExpression() != null : peek instanceof JSApplyCallElement) {
                    this.myContext.processWithoutTopJSElementToApply(() -> this.addType(callSignature.getReturnType(), resolveResult));
                }
                return true;
            }
            if (resolveResult instanceof TypeScriptGlobalModuleExportDeclaration) {
                for (PsiElement element : ((TypeScriptGlobalModuleExportDeclaration)resolveResult).getModules()) {
                    this.addTypeFromExternalModuleReferenceResolveResult(element);
                }
                return true;
            }
        }
        return super.addTypeFromDialectSpecificElements(resolveResult);
    }

    private void addTypeFromModule(TypeScriptModule resolveResult) {
        boolean isJavaScriptContext;
        JSReferenceExpression expression = this.myContext.getProcessedExpression();
        if (expression == null) {
            return;
        }
        if (resolveResult.isShorthandAmbientModule()) {
            this.addType(JSAnyType.get((PsiElement)resolveResult, true), (PsiElement)resolveResult);
            return;
        }
        boolean hasType = false;
        String name = resolveResult.getName();
        if (name != null && this.myTypeProcessor instanceof PsiScopeProcessor) {
            Collection<? extends PsiElement> elements = TypeScriptImportHandler.getInstance().resolveName(name, (PsiElement)expression).getElements();
            for (PsiElement psiElement : elements) {
                if (psiElement.isEquivalentTo((PsiElement)resolveResult)) continue;
                if (TypeScriptTypeEvaluator.hasInnerDeclarations(psiElement)) {
                    hasType = true;
                    continue;
                }
                this.addTypeFromResolveResult(psiElement, false);
            }
        }
        if (this.shouldAddLocalModule(hasType, isJavaScriptContext = DialectDetector.isJavaScript((PsiElement)expression))) {
            this.addTypeFromLocalModule((JSQualifiedNamedElement)resolveResult, isJavaScriptContext);
        }
    }

    private boolean shouldAddLocalModule(boolean hasType, boolean isJavaScriptContext) {
        return !(this.myTypeProcessor instanceof PsiScopeProcessor) || isJavaScriptContext || hasType || this.myContext.isJSElementsToApplyEmpty();
    }

    private void addTypeFromLocalModule(@NotNull JSQualifiedNamedElement resolveResult, boolean isJavaScriptContext) {
        String name;
        if (resolveResult == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(0);
        }
        if (!StringUtil.isEmpty((String)(name = resolveResult.getQualifiedName()))) {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource(resolveResult.getParent(), true);
            JSType jsType = JSNamedType.createType(name, source, isJavaScriptContext ? JSContext.UNKNOWN : JSContext.STATIC);
            this.addType(jsType, (PsiElement)resolveResult);
        }
    }

    private void addTypeFromImportStatement(TypeScriptImportStatement resolveResult) {
        this.processItem(resolveResult, JSEvaluateContext.JSEvaluationPlace.DEFAULT, importStatement -> {
            TypeScriptEntityName internalModuleReference = importStatement.getInternalModuleReference();
            TypeScriptExternalModuleReference externalModuleReference = importStatement.getExternalModuleReference();
            if (internalModuleReference != null) {
                Collection<PsiElement> elements = JSResolveResult.toElements(internalModuleReference.multiResolve(false));
                this.addTypeFromInternalModules(elements);
            } else if (externalModuleReference != null) {
                Collection elements = externalModuleReference.multiResolve();
                for (PsiElement element : elements) {
                    this.addTypeFromExternalModuleReferenceResolveResult(element);
                }
            }
        });
    }

    private void addTypeFromInternalModules(Collection<PsiElement> elements) {
        boolean isJavaScriptContext;
        boolean hasType;
        if (elements.size() == 0) {
            return;
        }
        if (elements.size() == 1) {
            PsiElement item = (PsiElement)ContainerUtil.getFirstItem(elements);
            assert (item != null);
            this.addTypeFromResolveResult(item, false);
            return;
        }
        JSReferenceExpression expression = this.myContext.getProcessedExpression();
        if (expression == null) {
            return;
        }
        List modules = ContainerUtil.filter(elements, TypeScriptPsiUtil.IS_TS_MODULE);
        if (modules.size() > 0 && this.shouldAddLocalModule(hasType = ContainerUtil.filter(elements, HAS_DECLARATIONS).size() > 0, isJavaScriptContext = DialectDetector.isJavaScript((PsiElement)expression))) {
            JSQualifiedNamedElement module = (JSQualifiedNamedElement)ContainerUtil.getFirstItem((List)modules);
            assert (module != null);
            this.addTypeFromLocalModule(module, isJavaScriptContext);
        }
        for (PsiElement element : elements) {
            if (element instanceof TypeScriptModule) continue;
            this.addTypeFromResolveResult(element, false);
        }
    }

    @Override
    protected JSType modifyTypeForEnumType(@NotNull JSResolvableType type, @NotNull JSFieldVariable jsVariable) {
        if (type == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(1);
        }
        if (jsVariable == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(2);
        }
        if (jsVariable instanceof TypeScriptField) {
            return ((JSTypeImpl)JSNamedType.createType(type.getTypeText() + "." + jsVariable.getName(), type.getSource(), JSTypeContext.INSTANCE, false)).copyWithStrictness(false);
        }
        return type;
    }

    @Override
    protected void addTypeFromVariableResolveResult(@NotNull JSFieldVariable jsVariable) {
        if (jsVariable == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(3);
        }
        super.addTypeFromVariableResolveResult(jsVariable);
        if (this.shouldProcessVariableWithInitializer((PsiElement)jsVariable) && jsVariable instanceof JSVariable) {
            this.processRequireCallInitializer((JSVariable)jsVariable);
        }
    }

    @Override
    protected void processThisQualifierExpression(@NotNull JSThisExpression rawqualifier, @NotNull JSClass jsClass, @NotNull JSContext staticOrInstance) {
        TypeScriptTypeParameter[] parametersForOwner;
        String name;
        if (rawqualifier == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(4);
        }
        if (jsClass == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(5);
        }
        if (staticOrInstance == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(6);
        }
        if ((name = jsClass.getQualifiedName()) != null && (parametersForOwner = TypeScriptPsiUtil.getTypeParametersForOwner((PsiElement)jsClass)).length > 0 && staticOrInstance == JSContext.INSTANCE) {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true);
            JSTypeSource classNameSource = JSTypeSourceFactory.createTypeSource((PsiElement)jsClass, true);
            List<JSType> types = TypeScriptGenericTypesEvaluator.buildGenericParameters(parametersForOwner);
            this.addType(new JSGenericTypeImpl(source, this.createTypeForThisExpression(JSContext.INSTANCE, name, classNameSource, DialectDetector.isTypeScript((PsiElement)rawqualifier)), types), (PsiElement)jsClass);
            return;
        }
        super.processThisQualifierExpression(rawqualifier, jsClass, staticOrInstance);
    }

    @Override
    @NotNull
    protected JSType createTypeForThisExpression(@NotNull JSContext staticOrInstance, @NotNull String name, @NotNull JSTypeSource typeSource, boolean isTypeScript) {
        if (staticOrInstance == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(7);
        }
        if (name == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(8);
        }
        if (typeSource == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(9);
        }
        if (!isTypeScript) {
            JSType jSType = super.createTypeForThisExpression(staticOrInstance, name, typeSource, false);
            if (jSType == null) {
                TypeScriptTypeEvaluator.$$$reportNull$$$0(10);
            }
            return jSType;
        }
        TypeScriptGenericThisTypeImpl typeScriptGenericThisTypeImpl = new TypeScriptGenericThisTypeImpl(typeSource, JSNamedType.createType(name, typeSource, staticOrInstance));
        if (typeScriptGenericThisTypeImpl == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(11);
        }
        return typeScriptGenericThisTypeImpl;
    }

    private void processRequireCallInitializer(@NotNull JSVariable jsVariable) {
        JSCallExpression callExpression;
        JSExpression methodExpression;
        JSExpression initializer;
        if (jsVariable == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(12);
        }
        if ((initializer = jsVariable.getInitializerOrStub()) instanceof JSCallExpression && (methodExpression = (callExpression = (JSCallExpression)initializer).getMethodExpression()) instanceof JSReferenceExpression) {
            this.processRequireMethodCall((JSCallExpression)initializer, (JSReferenceExpression)methodExpression, DialectDetector.isTypeScript((PsiElement)jsVariable));
        }
    }

    private boolean shouldProcessVariableWithInitializer(@NotNull PsiElement context) {
        if (context == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(13);
        }
        return this.isFromCurrentFile(context) && this.myTypeProcessor instanceof QualifiedItemProcessor && ((QualifiedItemProcessor)this.myTypeProcessor).resolved != QualifiedItemProcessor.TypeResolveState.Resolved;
    }

    @Override
    protected void addTypeFromExternalModuleReferenceResolveResult(@Nullable PsiElement resolve) {
        if (resolve != null && DialectDetector.isTypeScript(resolve)) {
            PsiFile file = resolve.getContainingFile();
            if (file == null) {
                return;
            }
            TypeScriptExportAssignment exportAssignment = TypeScriptPsiUtil.findExportAssignment(resolve);
            if (resolve instanceof JSFile) {
                if (exportAssignment == null) {
                    this.myTypeProcessor.processResolvedElement(resolve, this.myContext);
                }
            } else if (resolve instanceof TypeScriptModule && exportAssignment == null) {
                this.addTypeFromResolveResult(resolve, true);
            }
            if (exportAssignment != null) {
                this.evaluateExportAssignment((JSExportAssignment)exportAssignment);
            }
        } else {
            super.addTypeFromExternalModuleReferenceResolveResult(resolve);
        }
    }

    @Override
    protected void evaluateExportAssignment(JSExportAssignment assignment) {
        String reference;
        if (assignment instanceof TypeScriptExportAssignment && (reference = assignment.getInitializerReference()) != null) {
            List<PsiElement> elements = JSStubBasedPsiTreeUtil.resolveLocallyWithMergedResults(reference, (PsiElement)assignment);
            for (PsiElement element : elements) {
                this.addTypeFromResolveResult(element, false);
            }
            if (!elements.isEmpty()) {
                return;
            }
        }
        super.evaluateExportAssignment(assignment);
    }

    @Override
    protected boolean evaluateDialectSpecificTypes(JSExpression rawQualifier) {
        if (rawQualifier instanceof TypeScriptCastExpression) {
            TypeScriptType typeScriptType = ((TypeScriptCastExpression)rawQualifier).getType();
            if (typeScriptType != null) {
                JSType type = TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)typeScriptType);
                this.addType(type, (PsiElement)rawQualifier);
                return true;
            }
        } else if (rawQualifier instanceof TypeScriptNotNullExpression) {
            this.evaluateTypes(((TypeScriptNotNullExpression)rawQualifier).getExpression());
            return true;
        }
        return super.evaluateDialectSpecificTypes(rawQualifier);
    }

    @Override
    protected void addTypeFromClassExpression(@NotNull JSClass aClass) {
        if (aClass == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(14);
        }
        if (DialectDetector.isTypeScript((PsiElement)aClass)) {
            this.addTypeFromClass((PsiElement)aClass, null);
            return;
        }
        super.addTypeFromClassExpression(aClass);
    }

    @Override
    protected void addTypeFromClass(@NotNull PsiElement resolveResult, @Nullable PsiElement constructor) {
        if (resolveResult == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(15);
        }
        if (!DialectDetector.isTypeScript(resolveResult)) {
            super.addTypeFromClass(resolveResult, constructor);
            return;
        }
        JSReferenceExpression processedExpression = this.myContext.getProcessedExpression();
        if (resolveResult instanceof TypeScriptInterface && processedExpression != null) {
            this.processAllIdenticallyNamedElements((PsiElement)processedExpression, resolveResult);
        } else if (resolveResult instanceof JSClass) {
            JSRecordType type;
            JSClass jsClass = (JSClass)resolveResult;
            String qName = jsClass.getQualifiedName();
            JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(resolveResult, true);
            if (qName == null) {
                type = TypeScriptTypeParser.buildTypeFromClass(jsClass, true);
            } else {
                JSContext staticOrInstance = this.isPrototypeOrNewExpression() ? JSContext.INSTANCE : JSContext.STATIC;
                type = JSNamedType.createType(qName, typeSource, staticOrInstance);
            }
            PsiElement source = this.getSourceForTypeContext(resolveResult, processedExpression);
            this.addType((JSType)type, source);
        } else if (resolveResult instanceof JSFunction) {
            JSType returnType;
            if (resolveResult.getParent() instanceof TypeScriptInterface && (returnType = ((JSFunction)resolveResult).getReturnType()) != null) {
                this.addType(returnType, resolveResult);
            } else {
                this.addTypeFromClass(resolveResult.getParent(), resolveResult);
            }
        }
    }

    private PsiElement getSourceForTypeContext(PsiElement resolveResult, JSReferenceExpression processedExpression) {
        return processedExpression != null && resolveResult.getContainingFile().isEquivalentTo((PsiElement)this.myContext.targetFile) ? processedExpression : resolveResult;
    }

    private void processAllIdenticallyNamedElements(@NotNull PsiElement expression, @NotNull PsiElement resolveResult) {
        if (expression == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(16);
        }
        if (resolveResult == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(17);
        }
        if (!(this.myTypeProcessor instanceof PsiScopeProcessor)) {
            return;
        }
        if (this.myTypeProcessor instanceof ResolveProcessor) {
            ((ResolveProcessor)((Object)this.myTypeProcessor)).prefixResolved();
        }
        boolean result = true;
        if (!this.skipCallContextIfModule(resolveResult) && TypeScriptTypeEvaluator.hasInnerDeclarations(resolveResult)) {
            result = JSResolveUtil.processDeclarationsInScope((JSElement)((JSQualifiedNamedElement)resolveResult), (PsiScopeProcessor)this.myTypeProcessor, ResolveState.initial(), resolveResult, expression);
        }
        if (result && resolveResult.getContainingFile() == expression.getContainingFile()) {
            String name = ((JSQualifiedNamedElement)resolveResult).getQualifiedName();
            if (name == null) {
                return;
            }
            this.addIdenticalNameElements(expression, resolveResult, name);
        }
    }

    private void addIdenticalNameElements(@NotNull PsiElement expression, @Nullable PsiElement resolveResult, String name) {
        if (expression == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(18);
        }
        Collection<? extends PsiElement> elements = TypeScriptImportHandler.getInstance().resolveName(name, expression).getElements();
        for (PsiElement psiElement : elements) {
            if (!(psiElement instanceof JSQualifiedNamedElement) || psiElement.equals(resolveResult) || this.skipCallContextIfModule(psiElement)) continue;
            if (!TypeScriptTypeEvaluator.hasInnerDeclarations(psiElement)) {
                this.addTypeFromResolveResult(psiElement, false);
                continue;
            }
            if (!(this.myTypeProcessor instanceof PsiScopeProcessor) || psiElement.processDeclarations((PsiScopeProcessor)this.myTypeProcessor, ResolveState.initial(), psiElement, expression)) continue;
            break;
        }
    }

    private static boolean hasInnerDeclarations(PsiElement element) {
        return !(element instanceof JSVariable) && !(element instanceof JSFunction);
    }

    private boolean skipCallContextIfModule(PsiElement resolveResult) {
        return resolveResult instanceof TypeScriptModule && !this.myContext.isJSElementsToApplyEmpty() && !(this.myContext.peekJSElementToApply() instanceof JSApplyInstanceContextElement);
    }

    @Override
    protected void addTypeFromResolvedImport(PsiElement referencedElement) {
        if (referencedElement instanceof TypeScriptModule) {
            this.addTypeFromLocalModule((JSQualifiedNamedElement)((TypeScriptModule)referencedElement), false);
        } else if (referencedElement instanceof ES6ExportDefaultAssignment) {
            JSElement element = ((ES6ExportDefaultAssignment)referencedElement).getStubSafeElement();
            if (element instanceof TypeScriptInterfaceClass) {
                this.addTypeFromResolveResult((PsiElement)element, false);
            } else {
                super.addTypeFromResolvedImport(referencedElement);
            }
        } else {
            super.addTypeFromResolvedImport(referencedElement);
        }
    }

    @Override
    @NotNull
    public List<JSType> getComponentTypeFromProcessor(@Nullable JSExpression rawqualifier, @Nullable JSType type) {
        Object value;
        if (type instanceof JSTypeImpl) {
            JSType typedef = ((JSTypeImpl)type).getTypedef();
            JSType jSType = type = typedef != null ? typedef : type;
        }
        if ((type = JSTypeUtils.getValuableType(type)) instanceof JSArrayType || type == null || type instanceof JSCompositeTypeImpl && !JSTypeCastUtil.isStrictTypeScriptUnionType((JSCompositeTypeImpl)type)) {
            List<JSType> list = super.getComponentTypeFromProcessor(rawqualifier, type);
            if (list == null) {
                TypeScriptTypeEvaluator.$$$reportNull$$$0(19);
            }
            return list;
        }
        if (!(rawqualifier instanceof JSIndexedPropertyAccessExpression)) {
            List<JSType> list = super.getComponentTypeFromProcessor(rawqualifier, type);
            if (list == null) {
                TypeScriptTypeEvaluator.$$$reportNull$$$0(20);
            }
            return list;
        }
        JSRecordType recordType = type.asRecordType();
        if (recordType.getTypeMembers().isEmpty()) {
            List<JSType> list = super.getComponentTypeFromProcessor(rawqualifier, type);
            if (list == null) {
                TypeScriptTypeEvaluator.$$$reportNull$$$0(21);
            }
            return list;
        }
        JSExpression indexExpression = ((JSIndexedPropertyAccessExpression)rawqualifier).getIndexExpression();
        String propertyName = null;
        if (indexExpression instanceof JSLiteralExpression && (value = ((JSLiteralExpression)indexExpression).getValue()) instanceof String) {
            propertyName = (String)value;
        }
        if (JSPsiImplUtils.isSymbolRef(indexExpression)) {
            propertyName = "[" + indexExpression.getText() + "]";
        }
        ArrayList indexSignatures = ContainerUtil.newArrayList();
        ArrayList memberCandidates = ContainerUtil.newArrayList();
        for (JSRecordType.TypeMember member : recordType.getTypeMembers()) {
            if (propertyName != null && member instanceof JSRecordType.PropertySignature && propertyName.equals(((JSRecordType.PropertySignature)member).getMemberName())) {
                memberCandidates.add((JSRecordType.PropertySignature)member);
            }
            if (!(member instanceof JSRecordType.IndexSignature)) continue;
            indexSignatures.add((JSRecordType.IndexSignature)member);
        }
        JSAnyType result = null;
        if (DialectDetector.isTypeScript((PsiElement)rawqualifier) && memberCandidates.size() > 0) {
            ArrayList candidateTypes = ContainerUtil.newArrayList();
            for (JSRecordType.PropertySignature member : memberCandidates) {
                candidateTypes.add(member.getType());
            }
            ArrayList arrayList = candidateTypes;
            if (arrayList == null) {
                TypeScriptTypeEvaluator.$$$reportNull$$$0(22);
            }
            return arrayList;
        }
        if (indexSignatures.size() > 0) {
            JSType expressionTypeType;
            JSTypeEvaluationResult expressionTypeResult;
            JSTypeEvaluationResult jSTypeEvaluationResult = expressionTypeResult = indexExpression != null ? JSTypeEvaluator.getExpressionType(indexExpression) : null;
            if (expressionTypeResult != null && (expressionTypeType = expressionTypeResult.getType()) != null) {
                ProcessingContext processingContext = JSTypeComparingCacheService.getProcessingContextWithCache((PsiElement)indexExpression);
                for (JSRecordType.IndexSignature signature : indexSignatures) {
                    if (!JSResolveUtil.isAssignableJSType(signature.getMemberParameterType(), expressionTypeType, processingContext)) continue;
                    result = signature.getMemberType();
                    break;
                }
            }
        }
        if (result == null) {
            result = JSAnyType.get((PsiElement)rawqualifier, false);
        }
        List<Object> list = Collections.singletonList(result);
        if (list == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(23);
        }
        return list;
    }

    @Override
    protected void addTypeFromLiteralExpression(@NotNull JSExpression rawqualifier) {
        if (rawqualifier == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(24);
        }
        if (DialectDetector.isTypeScript((PsiElement)rawqualifier) && rawqualifier instanceof JSXmlLiteralExpressionImpl) {
            this.addType(JSAnyType.get((PsiElement)rawqualifier, true), (PsiElement)rawqualifier);
            return;
        }
        super.addTypeFromLiteralExpression(rawqualifier);
    }

    @Override
    protected JSType getIndexedPropertyAccessType(@NotNull JSIndexedPropertyAccessExpression rawqualifier) {
        JSTypeEvaluationResult indexExpressionType;
        if (rawqualifier == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(25);
        }
        if (!DialectDetector.isTypeScript((PsiElement)rawqualifier)) {
            return super.getIndexedPropertyAccessType(rawqualifier);
        }
        JSExpression qualifier = rawqualifier.getQualifier();
        JSTypeEvaluationResult qualifierType = qualifier == null ? null : TypeScriptTypeEvaluator.getExpressionType(qualifier);
        JSExpression indexExpression = rawqualifier.getIndexExpression();
        JSTypeEvaluationResult jSTypeEvaluationResult = indexExpressionType = indexExpression == null ? null : TypeScriptTypeEvaluator.getExpressionType(indexExpression);
        if (qualifierType == null || indexExpressionType == null) {
            return super.getIndexedPropertyAccessType(rawqualifier);
        }
        JSType qualifierTypeType = qualifierType.getType();
        JSType indexExpressionTypeType = indexExpressionType.getType();
        if (qualifierTypeType == null || indexExpressionTypeType == null) {
            return super.getIndexedPropertyAccessType(rawqualifier);
        }
        return new TypeScriptIndexedAccessJSTypeImpl(qualifierTypeType, indexExpressionTypeType, JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier));
    }

    @Override
    @NotNull
    protected ResolveResult[] getResolveResultsFromQualifier(@NotNull JSReferenceExpression qualifier) {
        if (qualifier == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(26);
        }
        ResolveResult[] resolveResult = super.getResolveResultsFromQualifier(qualifier);
        boolean hasModules = false;
        for (ResolveResult result : resolveResult) {
            if (!(result.getElement() instanceof TypeScriptModule)) continue;
            hasModules = true;
            break;
        }
        if (!hasModules || resolveResult.length <= 1) {
            if (resolveResult == null) {
                TypeScriptTypeEvaluator.$$$reportNull$$$0(27);
            }
            return resolveResult;
        }
        ArrayList newResults = ContainerUtil.newArrayListWithCapacity((int)resolveResult.length);
        HashSet visitedQualifiers = ContainerUtil.newHashSet();
        for (ResolveResult result : resolveResult) {
            PsiElement element = result.getElement();
            if (!(element instanceof TypeScriptModule)) {
                newResults.add(result);
                continue;
            }
            TypeScriptModule module = (TypeScriptModule)element;
            if (module.isAugmentation() || !visitedQualifiers.add(module.getQualifiedName())) continue;
            newResults.add(result);
        }
        ResolveResult[] resolveResultArray = newResults.size() == resolveResult.length ? resolveResult : (ResolveResult[])ContainerUtil.toArray((List)newResults, (Object[])new ResolveResult[newResults.size()]);
        if (resolveResultArray == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(28);
        }
        return resolveResultArray;
    }

    @Contract(value="null, _ -> false")
    private static boolean isTupleLikeType(@Nullable JSType type, boolean isTypeScript) {
        if (type == null) {
            return false;
        }
        if (type instanceof JSTupleTypeImpl) {
            return true;
        }
        if (!isTypeScript || type instanceof JSSpecialNamedTypeImpl) {
            return false;
        }
        Ref isTuple = Ref.create((Object)false);
        RecursionManager.doPreventingRecursion((Object)JSTypeCastUtil.getTypeIdForComparison(type), (boolean)false, () -> {
            isTuple.set((Object)type.asRecordType().hasProperty("0"));
            return true;
        });
        return (Boolean)isTuple.get();
    }

    @Override
    @NotNull
    protected JSType getArrayTypeFromExpressions(JSExpression rawQualifier, JSExpression[] expressions) {
        ArrayList types = ContainerUtil.newArrayListWithCapacity((int)expressions.length);
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)rawQualifier);
        for (JSExpression expression : expressions) {
            JSType expressionType = this.getExpressionTypeForArrayLiteral(rawQualifier, expression, holder);
            if (expressionType == null) {
                expressionType = this.createNullType(rawQualifier);
            }
            types.add(expressionType);
        }
        JSTupleTypeImpl type = new JSTupleTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)rawQualifier, true), types, false);
        if (JSDestructuringUtil.arrayLiteralCorrespondsToDestructuringArray(rawQualifier)) {
            JSTupleTypeImpl jSTupleTypeImpl = type;
            if (jSTupleTypeImpl == null) {
                TypeScriptTypeEvaluator.$$$reportNull$$$0(29);
            }
            return jSTupleTypeImpl;
        }
        Ref contextual = Ref.create(null);
        if (JSTypeEvaluator.canEvaluateTypeOfType((PsiElement)rawQualifier)) {
            TypeScriptTypeEvaluator.processWithEvaluationGuard(rawQualifier, JSEvaluateContext.JSEvaluationPlace.TS_ARRAY_TYPE, e -> contextual.set((Object)JSDialectSpecificHandlersFactory.findExpectedType(e, JSExpectedTypeKind.CONTEXTUAL)));
        }
        JSTupleTypeImpl jSTupleTypeImpl = TypeScriptTypeEvaluator.isTupleLikeType((JSType)contextual.get(), DialectDetector.isTypeScript((PsiElement)rawQualifier)) ? type : type.toArrayType(true);
        if (jSTupleTypeImpl == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(30);
        }
        return jSTupleTypeImpl;
    }

    @Override
    @Nullable
    protected JSType widenExpressionTypeByContextualType(JSExpression expression, boolean isTypeScript, JSType exprType) {
        return TypeScriptTypeEvaluator.widenLiteralTypesIfNeeded(exprType, expression, isTypeScript);
    }

    @Nullable
    private static JSType widenLiteralTypesIfNeeded(@Nullable JSType exprType, @Nullable JSExpression expression, boolean isTypeScript) {
        if (exprType == null) {
            return null;
        }
        if (expression == null || !isTypeScript) {
            return exprType;
        }
        if (JSTypeEvaluator.canProcessWithEvaluationGuard((PsiElement)expression, JSEvaluateContext.JSEvaluationPlace.TS_WIDENED_LITERAL) && JSTypeEvaluator.canEvaluateTypeOfType((PsiElement)expression)) {
            Ref expectedRef = Ref.create(null);
            if (!JSTypeUtils.isLiteralOrCompositeWithLiteralType(exprType)) {
                return exprType;
            }
            JSTypeEvaluator.processWithEvaluationGuard(expression, JSEvaluateContext.JSEvaluationPlace.TS_WIDENED_LITERAL, t -> expectedRef.set((Object)JSDialectSpecificHandlersFactory.findExpectedType(t, JSExpectedTypeKind.CONTEXTUAL)));
            JSType expectedType = (JSType)expectedRef.get();
            if (!JSTypeUtils.containsLiteralTypes(expectedType)) {
                exprType = JSTypeUtils.expandEnumLiteralIfNeeded(JSTypeUtils.widenLiteralTypes(exprType));
            }
        }
        return exprType;
    }

    @Override
    protected boolean addTypeFromAmdModuleReference(@NotNull JSParameter parameter) {
        if (parameter == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(31);
        }
        return !DialectDetector.isTypeScript((PsiElement)parameter) && super.addTypeFromAmdModuleReference(parameter);
    }

    @Override
    protected void addModuleFromRequire(PsiElement module, JSCallExpression callExpression) {
        if (DialectDetector.isTypeScript((PsiElement)callExpression) && !DialectDetector.isTypeScript(module)) {
            return;
        }
        super.addModuleFromRequire(module, callExpression);
    }

    @Override
    protected void processThisQualifierInExecutionScope(@NotNull JSThisExpression thisQualifier, PsiElement thisScope) {
        if (thisQualifier == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(32);
        }
        if (thisScope instanceof TypeScriptFunction) {
            JSType type;
            PsiElement context = thisScope;
            if (thisScope instanceof JSFunctionExpression) {
                context = JSContextResolver.findContextElement(thisQualifier);
            }
            if (context instanceof TypeScriptFunction && (type = ((TypeScriptFunction)context).getExplicitThisType()) != null) {
                this.addType(type, (PsiElement)thisQualifier);
                return;
            }
        }
        super.processThisQualifierInExecutionScope(thisQualifier, thisScope);
    }

    @Override
    @Nullable
    protected JSFunction getClassConstructor(@NotNull JSClass resolveResult) {
        ResolveResult[] results;
        JSReferenceExpression expression;
        if (resolveResult == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(33);
        }
        if ((expression = this.myContext.getProcessedExpression()) != null && (results = JSClassUtils.resolveES6Constructor(resolveResult, (JSExpression)expression)).length > 0) {
            for (ResolveResult result : results) {
                PsiElement element = result.getElement();
                if (!result.isValidResult() || element == null) continue;
                return element instanceof JSFunction ? (JSFunction)element : super.getClassConstructor(resolveResult);
            }
            ResolveResult result = results[0];
            PsiElement element = result.getElement();
            return element instanceof JSFunction ? (JSFunction)element : super.getClassConstructor(resolveResult);
        }
        return super.getClassConstructor(resolveResult);
    }

    @Override
    protected JSType substituteThisType(JSType type, JSFieldVariable jsVariable) {
        JSType parentType;
        if (!JSTypeUtils.hasThisGenericType(type)) {
            return type;
        }
        JSClass context = JSResolveUtil.getClassOfContext((PsiElement)jsVariable);
        JSTypeSource source = type.getSource();
        if (context == null) {
            return type;
        }
        String name = context.getQualifiedName();
        JSType jSType = parentType = name == null ? null : JSNamedType.createType(name, source, JSContext.INSTANCE);
        if (parentType == null) {
            return type;
        }
        return type.transformTypeHierarchy(jsType -> {
            JSTypeSource currentSource;
            if (jsType instanceof TypeScriptGenericThisTypeImpl && (currentSource = jsType.getSource()).getSourceElement() != context) {
                JSTypeSource newSource = JSTypeSourceFactory.copyTypeSource(currentSource, (PsiElement)context);
                return new TypeScriptGenericThisTypeImpl(newSource, parentType);
            }
            return jsType;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsVariable";
                break;
            }
            case 4: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawqualifier";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staticOrInstance";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 10: 
            case 11: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisQualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeForThisExpression";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentTypeFromProcessor";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveResultsFromQualifier";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayTypeFromExpressions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromLocalModule";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "modifyTypeForEnumType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromVariableResolveResult";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processThisQualifierExpression";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createTypeForThisExpression";
                break;
            }
            case 10: 
            case 11: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processRequireCallInitializer";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "shouldProcessVariableWithInitializer";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromClassExpression";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromClass";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processAllIdenticallyNamedElements";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addIdenticalNameElements";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromLiteralExpression";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getIndexedPropertyAccessType";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getResolveResultsFromQualifier";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromAmdModuleReference";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "processThisQualifierInExecutionScope";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getClassConstructor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

