/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow.protocol;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.lang.javascript.flow.FlowJSSettingsManager;
import com.intellij.lang.javascript.flow.ResendingOSProcessHandler;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfig;
import com.intellij.lang.javascript.flow.protocol.commands.FlowJSCommandWithArgument;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswerConsumer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSStandardOutputProtocol
implements JSLanguageServiceProtocol {
    private static final Logger LOGGER = Logger.getInstance((String)"#com.intellij.lang.javascript.flow.protocol.FlowJSStandardOutputProtocol");
    private static final String SERVER_IS_READY = "Server is READY";
    @NotNull
    protected final Project myProject;
    @NotNull
    private final FlowJSConfig myConfig;

    public FlowJSStandardOutputProtocol(@NotNull Project project, @NotNull FlowJSConfig config2) {
        if (project == null) {
            FlowJSStandardOutputProtocol.$$$reportNull$$$0(0);
        }
        if (config2 == null) {
            FlowJSStandardOutputProtocol.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myConfig = config2;
    }

    @Override
    @Nullable
    public ProcessHandler connect() throws Exception {
        GeneralCommandLine line = new GeneralCommandLine().withWorkDirectory(this.myProject.getBasePath());
        String path = this.getServicePath();
        if (StringUtil.isEmpty((String)path)) {
            return null;
        }
        line.setExePath(path);
        line.addParameter("server");
        line.addParameter(this.myConfig.getConfigDirectory().getPath());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("OUT: " + line.toString());
        }
        ResendingOSProcessHandler handler = new ResendingOSProcessHandler(line);
        handler.startNotify();
        return handler;
    }

    @Override
    public boolean awaitReadyNotification(final @NotNull ProcessHandler processHandler) throws Exception {
        if (processHandler == null) {
            FlowJSStandardOutputProtocol.$$$reportNull$$$0(2);
        }
        final CountDownLatch latch = new CountDownLatch(1);
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                String text;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((text = event.getText()) != null && text.contains(FlowJSStandardOutputProtocol.SERVER_IS_READY)) {
                    LOGGER.debug("IN: awaitReady received");
                    latch.countDown();
                    processHandler.removeProcessListener((ProcessListener)this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/flow/protocol/FlowJSStandardOutputProtocol$1";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return latch.await(3L, TimeUnit.MINUTES);
    }

    @Override
    public Object sendCommand(@NotNull JSLanguageServiceCommand command, @NotNull JSLanguageServiceObject data, @Nullable JSLanguageServiceAnswerConsumer resultConsumer) throws Exception {
        if (command == null) {
            FlowJSStandardOutputProtocol.$$$reportNull$$$0(3);
        }
        if (data == null) {
            FlowJSStandardOutputProtocol.$$$reportNull$$$0(4);
        }
        FlowJSCommandWithArgument commandWithArgument = (FlowJSCommandWithArgument)command;
        OSProcessHandler handler = this.write(commandWithArgument, resultConsumer);
        if (commandWithArgument.getInputStreamData() != null) {
            handler.getProcessInput().write(commandWithArgument.getInputStreamData().getBytes(CharsetToolkit.UTF8_CHARSET));
            handler.getProcessInput().close();
        }
        handler.startNotify();
        return handler;
    }

    @Override
    public void cancelCommand(@Nullable Object cancellationToken) {
        if (cancellationToken != null) {
            this.killProcess(cancellationToken);
        }
    }

    protected void killProcess(@NotNull Object handler) {
        if (handler == null) {
            FlowJSStandardOutputProtocol.$$$reportNull$$$0(5);
        }
        OSProcessHandler myHandler = (OSProcessHandler)handler;
        myHandler.destroyProcess();
    }

    @Override
    @Nullable
    public String getInitializeError() {
        return null;
    }

    public void dispose() {
        String path = this.getServicePath();
        if (StringUtil.isEmpty((String)path)) {
            return;
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(path);
        commandLine.withWorkDirectory(this.myProject.getBasePath());
        commandLine.addParameter("stop");
        try {
            commandLine.createProcess();
        }
        catch (ExecutionException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
    }

    private OSProcessHandler write(final @NotNull FlowJSCommandWithArgument commandWithArgument, final @Nullable JSLanguageServiceAnswerConsumer resultConsumer) throws Exception {
        String path;
        if (commandWithArgument == null) {
            FlowJSStandardOutputProtocol.$$$reportNull$$$0(6);
        }
        if (StringUtil.isEmpty((String)(path = this.getServicePath()))) {
            return null;
        }
        GeneralCommandLine line = new GeneralCommandLine();
        line.setExePath(path);
        line.setWorkDirectory(commandWithArgument.getWorkingDirectory());
        line.addParameter(commandWithArgument.getCommand());
        commandWithArgument.getArguments().forEach(arg_0 -> ((GeneralCommandLine)line).addParameter(arg_0));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("OUT: " + line.toString());
        }
        OSProcessHandler handler = new OSProcessHandler(line);
        final StringBuilder resultJson = new StringBuilder();
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (outputType == ProcessOutputTypes.STDOUT) {
                    JsonElement element;
                    String text = event.getText();
                    resultJson.append(text);
                    if (resultConsumer != null && (element = FlowJSStandardOutputProtocol.parseJsonSafe(resultJson.toString())) != null) {
                        resultConsumer.consume(new JSLanguageServiceAnswer(element));
                    }
                } else if (outputType == ProcessOutputTypes.STDERR) {
                    int end;
                    int start;
                    String text = event.getText();
                    for (start = 0; start < text.length() && Character.isWhitespace(text.charAt(start)); ++start) {
                    }
                    for (end = text.length(); end > 0 && Character.isWhitespace(end - 1); --end) {
                    }
                    if (start < end) {
                        LOGGER.warn("Error output from " + commandWithArgument.getCommand() + ": " + text.substring(start, end));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/flow/protocol/FlowJSStandardOutputProtocol$2";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return handler;
    }

    @Nullable
    public static JsonElement parseJsonSafe(@NotNull String string) {
        if (string == null) {
            FlowJSStandardOutputProtocol.$$$reportNull$$$0(7);
        }
        try {
            return new JsonParser().parse(string);
        }
        catch (JsonSyntaxException e) {
            return null;
        }
    }

    @NotNull
    private String getServicePath() {
        String string = FlowJSSettingsManager.getInstance(this.myProject).getRawSettings().getFlowExecutablePath();
        if (string == null) {
            FlowJSStandardOutputProtocol.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandWithArgument";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flow/protocol/FlowJSStandardOutputProtocol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flow/protocol/FlowJSStandardOutputProtocol";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getServicePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "awaitReadyNotification";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sendCommand";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "killProcess";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseJsonSafe";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

