/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSHandlersFactory;
import com.intellij.lang.javascript.formatter.ECMA4CodeStyleSettings;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.lang.typescript.formatter.TypeScriptCodeStyleSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSCodeStyleSettings
extends CustomCodeStyleSettings {
    public int INDENT_PACKAGE_CHILDREN = 0;
    public boolean USE_SEMICOLON_AFTER_STATEMENT = true;
    public boolean FORCE_SEMICOLON_STYLE = false;
    public boolean SPACE_BEFORE_TYPE_COLON = false;
    public boolean SPACE_AFTER_TYPE_COLON = true;
    public boolean SPACE_BEFORE_GENERATOR_MULT = false;
    public boolean SPACE_AFTER_GENERATOR_MULT = true;
    public static final String OLD_SPACES_NEAR_TYPE_FIELD = "SPACES_NEAR_TYPE";
    public static final String OLD_ALIGN_MULTIPLE_VARS_FIELD = "ALIGN_MULTILINE_VAR_DECLARATION";
    public static final String OLD_ALIGN_MULTIPLE_ASSIGNMENTS_FIELD = "ALIGN_MULTIPLE_ASSIGNMENTS";
    public static final int OLD_BOTH_SPACES = 1;
    public static final int OLD_SPACE_BEFORE_TYPE = 2;
    public static final int OLD_SPACE_BEFORE_TYPE_COLON = 3;
    public String FIELD_PREFIX = "_";
    public String PROPERTY_PREFIX = "";
    public static final int DO_NOT_INDENT = 0;
    public static final int INDENT = 1;
    public boolean SPACE_BEFORE_PROPERTY_COLON = false;
    public boolean SPACE_AFTER_PROPERTY_COLON = true;
    public int ALIGN_OBJECT_PROPERTIES = 0;
    public static final int DO_NOT_ALIGN = 0;
    public static final int ALIGN_ON_VALUE = 1;
    public static final int ALIGN_ON_COLON = 2;
    public int ALIGN_VAR_STATEMENTS = 0;
    public static final int ALIGN_MULTIPLE_VARS = 1;
    public static final int ALIGN_MULTIPLE_ASSIGNMENTS = 2;
    public boolean SPACE_AFTER_DOTS_IN_REST_PARAMETER = false;
    public boolean SPACE_BEFORE_FUNCTION_LEFT_PARENTH = true;
    public boolean SPACE_BEFORE_CLASS_LBRACE = true;
    public boolean REFORMAT_C_STYLE_COMMENTS = false;
    public boolean USE_PUBLIC_MODIFIER = false;
    public boolean USE_DOUBLE_QUOTES = true;
    public boolean FORCE_QUOTE_STYlE = false;
    public boolean COMMA_ON_NEW_LINE = false;
    public TrailingCommaOption ENFORCE_TRAILING_COMMA = TrailingCommaOption.Keep;
    public int VAR_DECLARATION_WRAP = 1;
    public int OBJECT_LITERAL_WRAP = 5;
    public int IMPORTS_WRAP = 5;
    public int UNION_TYPES_WRAP = 5;
    public boolean SPACES_WITHIN_OBJECT_LITERAL_BRACES = false;
    public boolean SPACES_WITHIN_IMPORTS = false;
    public boolean ALIGN_IMPORTS = false;
    public boolean SPACES_WITHIN_UNION_TYPES = true;
    public boolean INDENT_CHAINED_CALLS = true;
    public boolean USE_CHAINED_CALLS_GROUP_INDENTS = false;
    public boolean CHAINED_CALL_DOT_ON_NEW_LINE = true;
    public boolean SPACE_AROUND_ARROW_FUNCTION_OPERATOR = true;
    public boolean SPACE_BEFORE_ASYNC_ARROW_LPAREN = true;
    public boolean SPACES_WITHIN_OBJECT_TYPE_BRACES = true;
    public int BLANK_LINES_AROUND_FUNCTION = 1;
    public boolean SPACES_WITHIN_INTERPOLATION_EXPRESSIONS = false;
    public boolean IMPORT_SORT_MEMBERS = true;
    public boolean IMPORT_SORT_MODULE_NAME = false;
    @CommonCodeStyleSettings.BraceStyleConstant
    public int FUNCTION_EXPRESSION_BRACE_STYLE = 1;
    public String BLACKLIST_IMPORTS = "";
    public BooleanWithGlobalOption IMPORT_MERGE_MEMBERS = BooleanWithGlobalOption.GLOBAL;
    public BooleanWithGlobalOption IMPORT_PREFER_ABSOLUTE_PATH = BooleanWithGlobalOption.GLOBAL;
    public BooleanWithGlobalOption IMPORT_USE_NODE_RESOLUTION = BooleanWithGlobalOption.TRUE;

    protected JSCodeStyleSettings(CodeStyleSettings container) {
        super("JSCodeStyleSettings", container);
    }

    protected JSCodeStyleSettings(String tagName, CodeStyleSettings container) {
        super(tagName, container);
    }

    public static String getSemicolon(@NotNull PsiFile file) {
        if (file == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(0);
        }
        return JSCodeStyleSettings.getSettings((PsiFile)file, (Project)file.getProject()).USE_SEMICOLON_AFTER_STATEMENT ? ";" : "";
    }

    public static JSCodeStyleSettings getSettings(@NotNull PsiElement element) {
        if (element == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(1);
        }
        PsiFile file = element.getContainingFile();
        return JSCodeStyleSettings.getSettings(file, file.getProject());
    }

    public static JSCodeStyleSettings getSettings(@Nullable PsiFile file, Project project) {
        Class<JSCodeStyleSettings> codeStyleSettingsClass = JSCodeStyleSettings.class;
        if (file instanceof JSFile) {
            codeStyleSettingsClass = JSHandlersFactory.forElement((PsiElement)file).getCodeStyleSettingsClass();
        }
        return (JSCodeStyleSettings)CodeStyleSettingsManager.getInstance((Project)project).getCurrentSettings().getCustomSettings(codeStyleSettingsClass);
    }

    @NotNull
    public static CommonCodeStyleSettings getCommonSettings(@NotNull PsiElement element) {
        if (element == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(2);
        }
        Project project = element.getProject();
        Language language = DialectDetector.languageOfElement(element);
        CommonCodeStyleSettings commonCodeStyleSettings = CodeStyleSettingsManager.getInstance((Project)project).getCurrentSettings().getCommonSettings(language);
        if (commonCodeStyleSettings == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(3);
        }
        return commonCodeStyleSettings;
    }

    public static Class<? extends JSCodeStyleSettings> getSettingsClass(@Nullable Language dialect) {
        Class<JSCodeStyleSettings> codeStyleSettingsClass = JSCodeStyleSettings.class;
        if (dialect != null) {
            if (JavaScriptSupportLoader.ECMA_SCRIPT_L4.is(dialect)) {
                codeStyleSettingsClass = ECMA4CodeStyleSettings.class;
            }
            if (dialect.isKindOf((Language)JavaScriptSupportLoader.TYPESCRIPT)) {
                codeStyleSettingsClass = TypeScriptCodeStyleSettings.class;
            }
        }
        return codeStyleSettingsClass;
    }

    public void readExternal(Element parentElement) throws InvalidDataException {
        super.readExternal(parentElement);
        parentElement = parentElement.getChild(this.getTagName());
        if (parentElement == null) {
            return;
        }
        List options = parentElement.getChildren("option");
        Element oldSpacesElement = JSCodeStyleSettings.findOptionElementByName(options, OLD_SPACES_NEAR_TYPE_FIELD);
        if (oldSpacesElement != null && JSCodeStyleSettings.findOptionElementByName(options, "SPACE_BEFORE_TYPE_COLON") == null && JSCodeStyleSettings.findOptionElementByName(options, "SPACE_AFTER_TYPE_COLON") == null) {
            String value = oldSpacesElement.getAttributeValue("value");
            int spacesNearTypeValue = Integer.parseInt(value);
            this.SPACE_BEFORE_TYPE_COLON = spacesNearTypeValue == 1 || spacesNearTypeValue == 3;
            this.SPACE_AFTER_TYPE_COLON = spacesNearTypeValue == 1 || spacesNearTypeValue == 2;
        }
        Element oldAlignVarsElement = JSCodeStyleSettings.findOptionElementByName(options, OLD_ALIGN_MULTIPLE_VARS_FIELD);
        Element oldAlignAssignmentsElement = JSCodeStyleSettings.findOptionElementByName(options, OLD_ALIGN_MULTIPLE_ASSIGNMENTS_FIELD);
        if ((oldAlignVarsElement != null || oldAlignAssignmentsElement != null) && JSCodeStyleSettings.findOptionElementByName(options, "ALIGN_VAR_STATEMENTS") == null) {
            boolean alignAssignments;
            boolean alignVars = oldAlignVarsElement != null && Boolean.parseBoolean(oldAlignVarsElement.getAttributeValue("value"));
            boolean bl = alignAssignments = oldAlignAssignmentsElement != null && Boolean.parseBoolean(oldAlignAssignmentsElement.getAttributeValue("value"));
            if (alignAssignments) {
                this.ALIGN_VAR_STATEMENTS = 2;
            } else if (alignVars) {
                this.ALIGN_VAR_STATEMENTS = 1;
            }
        }
    }

    @Nullable
    private static Element findOptionElementByName(List<Element> options, @NotNull String name) {
        if (name == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(4);
        }
        return (Element)ContainerUtil.find(options, child -> {
            if (name == null) {
                JSCodeStyleSettings.$$$reportNull$$$0(12);
            }
            return name.equals(child.getAttributeValue("name"));
        });
    }

    public static String getQuote(@NotNull PsiElement context) {
        if (context == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(5);
        }
        JSCodeStyleSettings settings = JSCodeStyleSettings.getSettings(context);
        return settings.USE_DOUBLE_QUOTES ? "\"" : "'";
    }

    public static char getQuoteChar(@NotNull PsiElement context) {
        if (context == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(6);
        }
        JSCodeStyleSettings settings = JSCodeStyleSettings.getSettings(context);
        return settings.USE_DOUBLE_QUOTES ? (char)'\"' : '\'';
    }

    @NotNull
    public static String getLineCommentPrefix(@NotNull PsiElement context) {
        if (context == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(7);
        }
        CommonCodeStyleSettings settings = JSCodeStyleSettings.getCommonSettings(context);
        String string = settings.LINE_COMMENT_ADD_SPACE ? " " : "";
        if (string == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(8);
        }
        return string;
    }

    public void setMergeImports(boolean value) {
        this.IMPORT_MERGE_MEMBERS = value ? BooleanWithGlobalOption.TRUE : BooleanWithGlobalOption.FALSE;
    }

    public static boolean isMergeImports(@NotNull PsiElement context) {
        if (context == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(9);
        }
        JSCodeStyleSettings settings = JSCodeStyleSettings.getSettings(context);
        BooleanWithGlobalOption setting = settings.IMPORT_MERGE_MEMBERS;
        if (setting == BooleanWithGlobalOption.GLOBAL) {
            return JSApplicationSettings.getInstance().isMergeImports();
        }
        return setting.toBoolean();
    }

    public void setUseAbsolutePath(boolean value) {
        this.IMPORT_PREFER_ABSOLUTE_PATH = value ? BooleanWithGlobalOption.TRUE : BooleanWithGlobalOption.FALSE;
    }

    public static boolean isUseAbsolutePath(@NotNull PsiElement context) {
        if (context == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(10);
        }
        JSCodeStyleSettings settings = JSCodeStyleSettings.getSettings(context);
        BooleanWithGlobalOption setting = settings.IMPORT_PREFER_ABSOLUTE_PATH;
        return setting == BooleanWithGlobalOption.GLOBAL ? JSApplicationSettings.getInstance().isUseAbsoluteConfigPath() : setting.toBoolean().booleanValue();
    }

    public void setNodeResolution(boolean value) {
        this.IMPORT_USE_NODE_RESOLUTION = value ? BooleanWithGlobalOption.TRUE : BooleanWithGlobalOption.FALSE;
    }

    public static boolean isUseNodeResolution(@NotNull PsiElement context) {
        if (context == null) {
            JSCodeStyleSettings.$$$reportNull$$$0(11);
        }
        JSCodeStyleSettings settings = JSCodeStyleSettings.getSettings(context);
        BooleanWithGlobalOption setting = settings.IMPORT_USE_NODE_RESOLUTION;
        return setting == BooleanWithGlobalOption.GLOBAL ? JSApplicationSettings.getInstance().isUseNodeModulesResolutionImports() : setting.toBoolean().booleanValue();
    }

    public String[] getBlacklistImports() {
        return StringUtil.isEmpty((String)this.BLACKLIST_IMPORTS) ? ArrayUtil.EMPTY_STRING_ARRAY : this.BLACKLIST_IMPORTS.split(",");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/formatter/JSCodeStyleSettings";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/formatter/JSCodeStyleSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonSettings";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineCommentPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSemicolon";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSettings";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCommonSettings";
                break;
            }
            case 3: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findOptionElementByName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getQuote";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getQuoteChar";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLineCommentPrefix";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isMergeImports";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isUseAbsolutePath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isUseNodeResolution";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findOptionElementByName$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum TrailingCommaOption {
        Keep(0),
        Remove(1),
        WhenMultiline(2);

        public final int value;

        private TrailingCommaOption(int value) {
            this.value = value;
        }
    }

    public static enum BooleanWithGlobalOption {
        GLOBAL{

            @Override
            public Boolean toBoolean() {
                return null;
            }
        }
        ,
        TRUE{

            @Override
            public Boolean toBoolean() {
                return true;
            }
        }
        ,
        FALSE{

            @Override
            public Boolean toBoolean() {
                return false;
            }
        };


        public abstract Boolean toBoolean();
    }
}

